/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.eclipse.emf.cdo.internal.server.Transaction;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

public class CommitManager
extends Lifecycle {
    private IRepository repository;
    @ReflectUtil.ExcludeFromDump
    private transient ExecutorService executors;
    private boolean shutdownExecutorService = false;
    @ReflectUtil.ExcludeFromDump
    private transient Map<Transaction, TransactionCommitContextEntry> contextEntries = new ConcurrentHashMap<Transaction, TransactionCommitContextEntry>();

    public IRepository getRepository() {
        return this.repository;
    }

    public void setRepository(IRepository repository) {
        this.repository = repository;
    }

    public synchronized ExecutorService getExecutors() {
        if (this.executors == null) {
            this.shutdownExecutorService = true;
            this.executors = Executors.newFixedThreadPool(10);
        }
        return this.executors;
    }

    public synchronized void setExecutors(ExecutorService executors) {
        if (this.shutdownExecutorService) {
            this.executors.shutdown();
            this.shutdownExecutorService = false;
        }
        this.executors = executors;
    }

    protected void doDeactivate() throws Exception {
        super.doDeactivate();
        this.setExecutors(null);
    }

    public void preCommit(Transaction.InternalCommitContext commitContext, OMMonitor monitor) {
        TransactionCommitContextEntry contextEntry = new TransactionCommitContextEntry(monitor);
        contextEntry.setContext(commitContext);
        Future<Object> future = this.getExecutors().submit(contextEntry.createCallable());
        contextEntry.setFuture(future);
        this.contextEntries.put(commitContext.getTransaction(), contextEntry);
    }

    public void remove(Transaction.InternalCommitContext commitContext) {
        this.contextEntries.remove(commitContext.getTransaction());
    }

    public void rollback(Transaction.InternalCommitContext commitContext) {
        TransactionCommitContextEntry contextEntry = this.contextEntries.get(commitContext.getTransaction());
        if (contextEntry != null) {
            contextEntry.getFuture().cancel(true);
            commitContext.rollback("Remote rollback");
            commitContext.postCommit(false);
        }
    }

    public void waitForTermination(Transaction transaction) throws InterruptedException, ExecutionException {
        TransactionCommitContextEntry contextEntry = this.contextEntries.get(transaction);
        contextEntry.getFuture().get();
    }

    public Transaction.InternalCommitContext get(Transaction transaction) {
        TransactionCommitContextEntry contextEntry = this.contextEntries.get(transaction);
        if (contextEntry != null) {
            return contextEntry.getContext();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TransactionCommitContextEntry {
        private Transaction.InternalCommitContext context;
        private Future<Object> future;
        private OMMonitor monitor;

        public TransactionCommitContextEntry(OMMonitor monitor) {
            this.monitor = monitor;
        }

        public Callable<Object> createCallable() {
            return new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    TransactionCommitContextEntry.this.context.write(TransactionCommitContextEntry.this.monitor);
                    return null;
                }
            };
        }

        public Transaction.InternalCommitContext getContext() {
            return this.context;
        }

        public void setContext(Transaction.InternalCommitContext context) {
            this.context = context;
        }

        public Future<Object> getFuture() {
            return this.future;
        }

        public void setFuture(Future<Object> future) {
            this.future = future;
        }
    }
}

