/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.filters;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.CDOState;
import org.eclipse.emf.cdo.internal.ui.filters.CDOObjectFilter;
import org.eclipse.emf.cdo.internal.ui.messages.Messages;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;

public class CDOStateFilter
extends CDOObjectFilter {
    private static final String STATE_CONFLICT = Messages.getString("CDOStateFilter.0");
    private static final String STATE_TRANSIENT = Messages.getString("CDOStateFilter.1");
    private static final String STATE_NEW = Messages.getString("CDOStateFilter.2");
    private static final String STATE_CLEAN = Messages.getString("CDOStateFilter.3");
    private static final String STATE_DIRTY = Messages.getString("CDOStateFilter.4");
    private CDOState stateFilter;

    public CDOStateFilter(StructuredViewer viewer) {
        super(viewer);
    }

    protected void parsePattern(String pattern) {
        this.stateFilter = pattern.compareToIgnoreCase(STATE_DIRTY) == 0 ? CDOState.DIRTY : (pattern.compareToIgnoreCase(STATE_CLEAN) == 0 ? CDOState.CLEAN : (pattern.compareToIgnoreCase(STATE_NEW) == 0 ? CDOState.NEW : (pattern.compareToIgnoreCase(STATE_TRANSIENT) == 0 ? CDOState.TRANSIENT : (pattern.compareToIgnoreCase(STATE_CONFLICT) == 0 ? CDOState.CONFLICT : null))));
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.stateFilter != null) {
            return ((CDOObject)element).cdoState() == this.stateFilter;
        }
        return true;
    }

    public String getDescription() {
        return MessageFormat.format(Messages.getString("CDOStateFilter.5"), STATE_DIRTY, STATE_CLEAN, STATE_TRANSIENT, STATE_NEW, STATE_CONFLICT);
    }

    public String getTitle() {
        return Messages.getString("CDOStateFilter.6");
    }
}

