/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.internal.service.impl.tests;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.internal.service.AbstractGetConstraintsOperation;
import org.eclipse.emf.validation.internal.service.impl.tests.ConstraintDescriptorTest;
import org.eclipse.emf.validation.internal.util.XmlConstraintDescriptor;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.ConstraintExistsException;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.emf.validation.service.IModelConstraintProvider;
import org.eclipse.emf.validation.tests.TestBase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractGetConstraintsOperationTest
extends TestBase {
    protected static final IModelConstraint BATCH_TOKEN = AbstractGetConstraintsOperationTest.newConstraint(EvaluationMode.BATCH);
    protected static final IModelConstraint LIVE_TOKEN = AbstractGetConstraintsOperationTest.newConstraint(EvaluationMode.LIVE);
    private AbstractGetConstraintsOperation fixture;

    public AbstractGetConstraintsOperationTest(String name) {
        super(name);
    }

    protected final AbstractGetConstraintsOperation getFixture() {
        return this.fixture;
    }

    protected final void setFixture(AbstractGetConstraintsOperation fixture) {
        this.fixture = fixture;
    }

    private static TestConstraint newConstraint(EvaluationMode<?> mode) {
        ConstraintDescriptorTest.FixtureElement config = ConstraintDescriptorTest.newFixtureConfig();
        config.putAttribute("id", "aGetConOpTest@" + System.identityHashCode(config)).putAttribute("mode", mode.getName());
        try {
            return new TestConstraint((IConstraintDescriptor)new XmlConstraintDescriptor((IConfigurationElement)config));
        }
        catch (ConstraintExistsException constraintExistsException) {
            throw new RuntimeException();
        }
    }

    protected static class TestConstraint
    implements IModelConstraint {
        private final IConstraintDescriptor descriptor;

        TestConstraint(IConstraintDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        public IStatus validate(IValidationContext ctx) {
            return null;
        }

        public IConstraintDescriptor getDescriptor() {
            return this.descriptor;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class TestProvider
    implements IModelConstraintProvider {
        protected TestProvider() {
        }

        public Collection<IModelConstraint> getBatchConstraints(EObject eObject, Collection<IModelConstraint> constraints) {
            return this.appendTo(constraints, BATCH_TOKEN);
        }

        public Collection<IModelConstraint> getLiveConstraints(Notification notification, Collection<IModelConstraint> constraints) {
            return this.appendTo(constraints, LIVE_TOKEN);
        }

        private Collection<IModelConstraint> appendTo(Collection<IModelConstraint> c, IModelConstraint constraint) {
            if (c == null) {
                c = new ArrayList<IModelConstraint>(1);
            }
            c.add(constraint);
            return c;
        }
    }
}

