/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant;

import java.io.IOException;
import java.util.Enumeration;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.RuntimeConfigurable;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.UnknownElement;

public abstract class Task
extends ProjectComponent {
    protected Target target;
    protected String description;
    protected Location location = Location.UNKNOWN_LOCATION;
    protected String taskName;
    protected String taskType;
    protected RuntimeConfigurable wrapper;
    private boolean invalid;
    private UnknownElement replacement;

    public void setOwningTarget(Target target) {
        this.target = target;
    }

    public Target getOwningTarget() {
        return this.target;
    }

    public void setTaskName(String name) {
        this.taskName = name;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public void setTaskType(String type) {
        this.taskType = type;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public String getDescription() {
        return this.description;
    }

    public void init() throws BuildException {
    }

    public void execute() throws BuildException {
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public RuntimeConfigurable getRuntimeConfigurableWrapper() {
        if (this.wrapper == null) {
            this.wrapper = new RuntimeConfigurable(this, this.getTaskName());
        }
        return this.wrapper;
    }

    public void setRuntimeConfigurableWrapper(RuntimeConfigurable wrapper) {
        this.wrapper = wrapper;
    }

    public void maybeConfigure() throws BuildException {
        if (!this.invalid) {
            if (this.wrapper != null) {
                this.wrapper.maybeConfigure(this.getProject());
            }
        } else {
            this.getReplacement();
        }
    }

    public void reconfigure() {
        if (this.wrapper != null) {
            this.wrapper.reconfigure(this.getProject());
        }
    }

    protected void handleOutput(String output) {
        this.log(output, 2);
    }

    protected void handleFlush(String output) {
        this.handleOutput(output);
    }

    protected int handleInput(byte[] buffer, int offset, int length) throws IOException {
        return this.getProject().defaultInput(buffer, offset, length);
    }

    protected void handleErrorOutput(String output) {
        this.log(output, 1);
    }

    protected void handleErrorFlush(String output) {
        this.handleErrorOutput(output);
    }

    public void log(String msg) {
        this.log(msg, 2);
    }

    public void log(String msg, int msgLevel) {
        this.getProject().log(this, msg, msgLevel);
    }

    public final void perform() {
        if (!this.invalid) {
            try {
                this.getProject().fireTaskStarted(this);
                this.maybeConfigure();
                this.execute();
                this.getProject().fireTaskFinished(this, null);
            }
            catch (RuntimeException exc) {
                BuildException be;
                if (exc instanceof BuildException && (be = (BuildException)exc).getLocation() == Location.UNKNOWN_LOCATION) {
                    be.setLocation(this.getLocation());
                }
                this.getProject().fireTaskFinished(this, exc);
                throw exc;
            }
        } else {
            UnknownElement ue = this.getReplacement();
            Task task = ue.getTask();
            task.perform();
        }
    }

    final void markInvalid() {
        this.invalid = true;
    }

    protected final boolean isInvalid() {
        return this.invalid;
    }

    private UnknownElement getReplacement() {
        if (this.replacement == null) {
            this.replacement = new UnknownElement(this.taskType);
            this.replacement.setProject(this.getProject());
            this.replacement.setTaskType(this.taskType);
            this.replacement.setTaskName(this.taskName);
            this.replacement.setLocation(this.location);
            this.replacement.setOwningTarget(this.target);
            this.replacement.setRuntimeConfigurableWrapper(this.wrapper);
            this.wrapper.setProxy(this.replacement);
            this.replaceChildren(this.wrapper, this.replacement);
            this.target.replaceChild(this, this.replacement);
            this.replacement.maybeConfigure();
        }
        return this.replacement;
    }

    private void replaceChildren(RuntimeConfigurable wrapper, UnknownElement parentElement) {
        Enumeration e = wrapper.getChildren();
        while (e.hasMoreElements()) {
            RuntimeConfigurable childWrapper = (RuntimeConfigurable)e.nextElement();
            UnknownElement childElement = new UnknownElement(childWrapper.getElementTag());
            parentElement.addChild(childElement);
            childElement.setProject(this.getProject());
            childElement.setRuntimeConfigurableWrapper(childWrapper);
            childWrapper.setProxy(childElement);
            this.replaceChildren(childWrapper, childElement);
        }
    }

    public String getTaskType() {
        return this.taskType;
    }

    protected RuntimeConfigurable getWrapper() {
        return this.wrapper;
    }
}

