/*--------------------------------------------------------------------------+
$Id: ArrayBackedStringMapTest.java 29400 2010-07-27 15:03:30Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.collections;

import java.util.Map;

import edu.tum.cs.commons.test.CCSMTestCaseBase;

/**
 * Tests the {@link ArrayBackedStringMap}.
 * 
 * @author hummelb
 * @author $Author: juergens $
 * @version $Rev: 29400 $
 * @levd.rating GREEN Hash: 6CC885DB95654EA492C6F68510712B59
 */
public class ArrayBackedStringMapTest extends CCSMTestCaseBase {

	/** This test ensures that string interning did not introduce errors. */
	public void testStringHandling() {
		Map<String, Integer> map = new ArrayBackedStringMap<Integer>();

		map.put("A", 1);
		map.put("B", 2);

		assertEquals((Integer) 1, map.get("A"));
		assertEquals((Integer) 2, map.get("B"));

		assertEquals((Integer) 1, map.get(new String("A")));

		assertEquals((Integer) 1, map.put(new String("A"), 3));
		assertEquals((Integer) 3, map.get(new String("A")));

		assertEquals((Integer) 3, map.remove(new String("A")));

		assertEquals(1, map.size());
	}

}
