/*--------------------------------------------------------------------------+
$Id: IdentityHashSetTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.collections;

import java.util.ArrayList;

import junit.framework.TestCase;

/**
 * Test for {@link IdentityHashSet}.
 * <p>
 * For test design see also class comment of {@link IdManagerTest}.
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * 
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: E0BDFD16BCA833F91CF4829314177C45
 */
public class IdentityHashSetTest extends TestCase {

	/**
	 * Set under test. See also class comment of {@link IdManagerTest}.
	 */
	private final IdentityHashSet<Integer> testSet = new IdentityHashSet<Integer>();

	/** Test {@link IdentityHashSet#size()}. */
	public void testSize() {
		assertEquals(0, testSet.size());
		testSet.add(1);
		assertEquals(1, testSet.size());

	}

	/** Test {@link IdentityHashSet#isEmpty()}. */
	public void testIsEmpty() {
		assertTrue(testSet.isEmpty());
		testSet.add(1);
		assertFalse(testSet.isEmpty());
	}

	/** Test {@link IdentityHashSet#clear()}. */
	public void testClear() {
		testSet.add(1);
		assertFalse(testSet.isEmpty());
		testSet.clear();
		assertTrue(testSet.isEmpty());
		assertEquals(0, testSet.size());
	}

	/** Test {@link IdentityHashSet#IdentityHashSet(java.util.Collection)}. */
	public void testConstructor() {
		ArrayList<Integer> testList = new ArrayList<Integer>();

		testList.add(1);
		testList.add(2);
		testList.add(3);

		IdentityHashSet<Integer> set = new IdentityHashSet<Integer>(testList);
		assertEquals(3, set.size());
	}

	/** Test {@link IdentityHashSet#add(Object)}. */
	public void testAdd() {

		testSet.add(1);
		assertEquals(1, testSet.size());
		assertEquals((Integer) 1, testSet.iterator().next());

	}

	/** Test {@link IdentityHashSet#clone()}. */
	public void testClone() {
		testSet.add(1);
		IdentityHashSet<Integer> clone = testSet.clone();
		assertNotSame(clone, testSet);

		assertEquals(1, clone.size());
		assertEquals((Integer) 1, clone.iterator().next());
	}

	/** Test {@link IdentityHashSet#contains(Object)}. */
	public void testContains() {

		Integer one = new Integer(1);

		testSet.add(one);
		assertEquals(1, testSet.size());

		assertTrue(testSet.contains(one));
		assertFalse(testSet.contains(new Integer(1)));
	}

	/** Test {@link IdentityHashSet#remove(Object)}. */
	public void testRemove() {
		Integer one = new Integer(1);
		testSet.add(one);
		assertEquals(1, testSet.size());
		testSet.remove(one);
		assertEquals(0, testSet.size());

		testSet.add(one);
		assertEquals(1, testSet.size());
		testSet.remove(new Integer(1));
		assertEquals(1, testSet.size());
	}

}