/*--------------------------------------------------------------------------+
$Id: MultiplexedOutputStreamTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.io;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;

import junit.framework.TestCase;
import edu.tum.cs.commons.filesystem.FileSystemUtils;

/**
 * Test for the <code>MultiplexedOutputStream</code>-class. This test uses to
 * underlying <code>FileOutputStreams</code>.
 * 
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: D47D27D0FD509FCC050DFBD462486A59
 */
public class MultiplexedOutputStreamTest extends TestCase {

    /** test file 1 */
    private final File file1 = new File("test-tmp/stream1.txt");

    /** test file 2 */
    private final File file2 = new File("test-tmp/stream2.txt");

    /** stream 1 */
    private FileOutputStream stream1;

    /** stream 2 */
    private FileOutputStream stream2;

    /** the mulitplexed stream to test */
    private MultiplexedOutputStream multiplexedStream;

    /** Create directory and streams. */
    @Override
	public void setUp() throws IOException {
        FileSystemUtils.ensureParentDirectoryExists(file1);
        stream1 = new FileOutputStream(file1);
        stream2 = new FileOutputStream(file2);
        multiplexedStream = new MultiplexedOutputStream(stream1, stream2);
    }

    /** Write to multiplexed stream and check if resulting files are equal. */
    public void testWrite() throws IOException {
        byte[] testArray = "This is a test".getBytes();

        multiplexedStream.write(testArray);

        multiplexedStream.close();

        String file1Content = FileSystemUtils.readFile(file1);
        String file2Content = FileSystemUtils.readFile(file2);

        assertEquals(file1Content, file2Content);

    }

    /**
     * Close multiplexed streams and check if underlying streams are really
     * closed.
     */
    public void testClose() throws IOException {
        byte[] testArray = "This is a test".getBytes();
        multiplexedStream.close();

        try {
            stream1.write(testArray);
            fail();
        } catch (IOException ex) {
            // this should fail as stream must be closed
        }

        try {
            stream2.write(testArray);
            fail();
        } catch (IOException ex) {
            // this should fail as stream must be closed
        }
    }

    /** Delete test files. */
    @Override
	public void tearDown() {
        file1.delete();
        file2.delete();
    }

}