/*--------------------------------------------------------------------------+
$Id: SocketUtilsTest.java 28668 2010-06-23 14:46:45Z heineman $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.net;

import java.io.IOException;
import java.net.ServerSocket;

import junit.framework.TestCase;

/**
 * Tests for the {@link SocketUtils} class.
 * 
 * @author hummelb
 * @author $Author: heineman $
 * @version $Rev: 28668 $
 * @levd.rating GREEN Hash: 6C2A4D440FE8F21918FE1899D3F187C6
 */
public class SocketUtilsTest extends TestCase {

	/** Tests free port allocation and testing. */
	public void testFreePort() throws IOException {
		int port = SocketUtils.getFreePort();

		// test twice to see if repeated calling causes problems (port not yet
		// closed)
		assertTrue(SocketUtils.isFreePort(port));
		assertTrue(SocketUtils.isFreePort(port));

		ServerSocket socket = new ServerSocket(port);
		socket.setReuseAddress(true);
		assertFalse(SocketUtils.isFreePort(port));
		socket.close();
	}
}
