/*--------------------------------------------------------------------------+
$Id: ReflectionUtilsMethodReturnTypeTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.reflect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import junit.framework.TestCase;
import edu.tum.cs.commons.reflect.classes.TestClass01;
import edu.tum.cs.commons.reflect.classes.TestClass02;
import edu.tum.cs.commons.reflect.classes.TestClass03;
import edu.tum.cs.commons.reflect.classes.TestClass04;
import edu.tum.cs.commons.reflect.classes.TestClass05;
import edu.tum.cs.commons.reflect.classes.TestClass06;
import edu.tum.cs.commons.reflect.classes.TestClass09;
import edu.tum.cs.commons.reflect.classes.TestClass10;

/**
 * Tests for method {@link ReflectionUtils#obtainMethodReturnType(Class, String)}
 * 
 * 
 * @author Florian Deissenboeck
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 9EE64BC23D58DA969E44A383BE15DA73
 */
public class ReflectionUtilsMethodReturnTypeTest extends TestCase {

    /** name of the method for method return type tests */
    private static final String METHOD_NAME = "process";

  
    /**
     * Test method {@link ReflectionUtils#obtainMethodReturnType(Class, String)}
     * with class {@link TestClass01}.
     */
    public void testSimple() throws NoSuchMethodException {
        Class<?> actual = ReflectionUtils.obtainMethodReturnType(
                TestClass01.class, METHOD_NAME);

        assertEquals(Object.class, actual);
        
        actual = ReflectionUtils.obtainGenericMethodReturnType(
                TestClass01.class, METHOD_NAME);

        assertEquals(Object.class, actual);

    }

    /**
     * Test method {@link ReflectionUtils#obtainMethodReturnType(Class, String)}
     * with class {@link TestClass02}.
     */
    public void testInheritedMethod() throws NoSuchMethodException {
        Class<?> actual = ReflectionUtils.obtainMethodReturnType(
                TestClass02.class, METHOD_NAME);

        assertEquals(List.class, actual);
        
        actual = ReflectionUtils.obtainGenericMethodReturnType(
                TestClass02.class, METHOD_NAME);

        assertEquals(List.class, actual);

    }

    /**
     * Test method {@link ReflectionUtils#obtainMethodReturnType(Class, String)}
     * with class {@link TestClass03}.
     */
    public void testInheritedMethodWithCovariantReturnType()
            throws NoSuchMethodException {
        Class<?> actual = ReflectionUtils.obtainMethodReturnType(
                TestClass03.class, METHOD_NAME);

        assertEquals(ArrayList.class, actual);
        
        actual = ReflectionUtils.obtainGenericMethodReturnType(
                TestClass03.class, METHOD_NAME);

        assertEquals(ArrayList.class, actual);
    }

    /**
     * Test method for
     * {@link ReflectionUtils#obtainMethodReturnType(Class, String)} with class
     * {@link TestClass04}.
     * <p>
     * This does <i>not<i> work as one would expect right now.
     */
    public void testInheritedMethodWithGenericReturnType()
            throws NoSuchMethodException {
        Class<?> actual = ReflectionUtils.obtainMethodReturnType(
                TestClass04.class, METHOD_NAME);

        // expected behavior would be
        // assertEquals(List.class, actual);

        // actual behavior is
        assertEquals(Collection.class, actual);
        
        actual = ReflectionUtils.obtainGenericMethodReturnType(
                TestClass04.class, METHOD_NAME);
        assertEquals(List.class, actual);
    }

    /**
     * Test method {@link ReflectionUtils#obtainMethodReturnType(Class, String)}
     * with class {@link TestClass05}.
     */
    public void testInheritedMethodWithGenericCovariantReturnType()
            throws NoSuchMethodException {
        Class<?> actual = ReflectionUtils.obtainMethodReturnType(
                TestClass05.class, METHOD_NAME);

        assertEquals(ArrayList.class, actual);
        
        actual = ReflectionUtils.obtainGenericMethodReturnType(
                TestClass05.class, METHOD_NAME);

        assertEquals(ArrayList.class, actual);
    }

    /**
     * Test method {@link ReflectionUtils#obtainMethodReturnType(Class, String)}
     * with class {@link TestClass06}.
     */
    public void testSimpleWithCovariance() throws NoSuchMethodException {
        Class<?> actual = ReflectionUtils.obtainMethodReturnType(
                TestClass06.class, METHOD_NAME);

        assertEquals(String.class, actual);
        
        actual = ReflectionUtils.obtainGenericMethodReturnType(
                TestClass06.class, METHOD_NAME);

        assertEquals(String.class, actual);
    }

    /**
     * Test method {@link ReflectionUtils#obtainMethodReturnType(Class, String)}
     * with class {@link TestClass09}.
     * <p>
     * This does <i>not<i> work as one would expect right now.
     */
    public void testInheritedMethodWithParameterizedGenericReturnType()
            throws NoSuchMethodException {

        Class<?> actual = ReflectionUtils.obtainMethodReturnType(
                TestClass09.class, METHOD_NAME);

        // expected behavior would be
        // assertEquals(List.class, actual);

        // actual behavior is
        assertEquals(Collection.class, actual);
        
        actual = ReflectionUtils.obtainGenericMethodReturnType(
                TestClass09.class, METHOD_NAME);
       
        assertEquals(List.class, actual);

    }

    /**
     * Test method {@link ReflectionUtils#obtainMethodReturnType(Class, String)}
     * with class {@link TestClass10}.
     * <p>
     * This does <i>not<i> work as one would expect right now.
     */
    public void testGenericMethodWithMultipleParameters()
            throws NoSuchMethodException {

        Class<?> actual = ReflectionUtils.obtainMethodReturnType(
                TestClass10.class, METHOD_NAME);

        // expected behavior would be
        // assertEquals(List.class, actual);

        // actual behavior is
        assertEquals(Collection.class, actual);
        
        actual = ReflectionUtils.obtainGenericMethodReturnType(
                TestClass10.class, METHOD_NAME);
        assertEquals(List.class, actual);
    }

    /**
     * Test method {@link ReflectionUtils#obtainMethodReturnType(Class, String)}
     * with an unknown method.
     */
    public void testMethodNotFound() {

        try {
            ReflectionUtils.obtainMethodReturnType(TestClass05.class,
                    "unknown");
        } catch (NoSuchMethodException e) {
            return;
        }

        fail("should raise an exception");
    }

}