/*--------------------------------------------------------------------------+
$Id: DeepCloneTestUtilsTest.java 26283 2010-02-18 11:18:57Z juergens $
|                                                                          |
| Copyright 2005-2010 Technische Universitaet Muenchen                     |
|                                                                          |
| Licensed under the Apache License, Version 2.0 (the "License");          |
| you may not use this file except in compliance with the License.         |
| You may obtain a copy of the License at                                  |
|                                                                          |
|    http://www.apache.org/licenses/LICENSE-2.0                            |
|                                                                          |
| Unless required by applicable law or agreed to in writing, software      |
| distributed under the License is distributed on an "AS IS" BASIS,        |
| WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. |
| See the License for the specific language governing permissions and      |
| limitations under the License.                                           |
+--------------------------------------------------------------------------*/
package edu.tum.cs.commons.test;

import java.util.IdentityHashMap;

import junit.framework.TestCase;
import edu.tum.cs.commons.collections.IIdProvider;
import edu.tum.cs.commons.collections.IdentityHashSet;
import edu.tum.cs.commons.test.example.Address;
import edu.tum.cs.commons.test.example.Model;
import edu.tum.cs.commons.test.example.Order;
import edu.tum.cs.commons.test.example.Person;

/**
 * Test class for {@link DeepCloneTestUtils}.
 * 
 * 
 * @author deissenb
 * @author $Author: juergens $
 * @version $Rev: 26283 $
 * @levd.rating GREEN Hash: 7EE8B839A15BD84BFEF86743591FACD3
 */
public class DeepCloneTestUtilsTest extends TestCase {

	/** Test model. */
	private final Model model = new Model();

	/** The model itself plus all referenced objects. */
	private final IdentityHashSet<Object> elements = new IdentityHashSet<Object>();

	/** All {@link Order}s stored in the model. */
	private final IdentityHashSet<Order> orders = new IdentityHashSet<Order>();

	/** Create test model. */
	@Override
	public void setUp() {
		elements.add(model);

		Address addressA = new Address("Street A", "City A");
		elements.add(addressA);
		Address addressB = new Address("Street B", "City B");
		elements.add(addressB);

		Person personA = new Person("Person A", addressA, "details of person A");
		elements.add(personA);
		Person personB = new Person("Person B", addressB, "details of person B");
		elements.add(personB);

		Order order1 = new Order("Order 1", "1");
		elements.add(order1);
		orders.add(order1);
		Order order2 = new Order("Order 2", "2");
		elements.add(order2);
		orders.add(order2);
		Order order3 = new Order("Order 3", "3");
		elements.add(order3);
		orders.add(order3);
		Order order4 = new Order("Order 4", "4");
		elements.add(order4);
		orders.add(order4);

		personA.add(order1);
		personA.add(order2);

		personB.add(order3);
		personB.add(order4);

		model.add(personA);
		model.add(personB);
	}

	/**
	 * Test for
	 * {@link DeepCloneTestUtils#getAllReferencedObjects(Object, String...)}.
	 */
	public void testGetAllReferencedObjects() {
		IdentityHashSet<Object> result = DeepCloneTestUtils
				.getAllReferencedObjects(model, Model.class.getPackage()
						.getName());

		assertEquals(elements.size(), result.size());
		assertTrue(result.containsAll(elements));
		assertTrue(elements.containsAll(result));
	}

	/**
	 * Test for
	 * {@link DeepCloneTestUtils#getAllReferencedObjects(Object, Class, String...)}
	 */
	public void testGetAllReferencedObjectsByType() {
		IdentityHashSet<Order> result = DeepCloneTestUtils
				.getAllReferencedObjects(model, Order.class, Model.class
						.getPackage().getName());

		assertEquals(orders.size(), result.size());
		assertTrue(result.containsAll(orders));
		assertTrue(orders.containsAll(result));
	}

	/**
	 * Test for
	 * {@link DeepCloneTestUtils#testDeepCloning(Object, Object, IIdProvider, String...)}
	 */
	public void testTestDeepCloning() {
		Model clone = model.deepClone();
		IdentityHashMap<Object, Object> result = DeepCloneTestUtils
				.testDeepCloning(model, clone, new ModelIdProvider(),
						Model.class.getPackage().getName());
		assertEquals(elements.size(), result.size());
	}

	/** Simple Id provider for the test model. */
	private class ModelIdProvider implements IIdProvider<String, Object> {

		/** Obtain id. */
		public String obtainId(Object object) {
			if (object instanceof Model) {
				return "Model";
			}
			if (object instanceof Person) {
				return ((Person) object).getName();
			}
			if (object instanceof Address) {
				return ((Address) object).getCity()
						+ ((Address) object).getStreet();
			}
			if (object instanceof Order) {
				return ((Order) object).getArticleNumber();
			}
			throw new RuntimeException("Unknown type: " + object);
		}

	}
}