#!/usr/bin/perl
#
# SUMMARY:      
# USAGE:        <script-name>
#
# AUTHOR:       Christophe Prud'homme
# ORG:          Christophe Prud'homme
# ORIG-DATE:    27-Jul-00 at 01:55:59
# LAST-MOD:     27-Jul-00 at 02:54:15 by Christophe Prud'homme
# DESCRIPTION:
#  
# genmake.pl generates automatically a Makefile for corelinux 
# examples. 
# the binaries are built upon the exampXY.cpp files.
# other .cpp files will be only compiled
# a clean rule is provided
#
# Copyright 2000 (C) Christophe Prud'homme
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#  
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#
# DESCRIP-END.

#use strict;
use File::Find;
use File::Basename;

@ARGV = ('.') unless @ARGV;

# the list of binary files
@binaries=();

# the list of object files
@objects=();

sub genrule {
  if (/\.[cpp]+$/)
    {
      my($prefix,$dir,$ext)=('','','');
      ($prefix,$dir,$ext)=fileparse($_,'\.cpp');
      if (/examp/)
	{
	  push(@binaries,$prefix);
	}
      else
	{
	  push(@objects,"$prefix.o");
	}
    }
}
find(\&genrule, @ARGV);
@binaries = sort @binaries;
@objects = sort @objects;

open(M, "> @ARGV/Makefile");
print M "# do not change this file, automatically generated by genmake.pl\n";
print M "# CoreLinux Consortium examples builder\n\n";
print M "CXXFLAGS = -g -O2 -Wall -I. -I/usr/include/corelinux\n";
print M "LIBS     = -lcl++\n\n";

print M "all: @binaries\n\n\n";

# write down the linking rules
foreach $binary (@binaries) {
  print M "$binary: $binary.o @objects\n";
  print M "\tg++ -o $binary @objects $binary.o \$(LIBS)\n\n";
  
  print M "$binary.o: $binary.cpp\n";
  print M "\tg++ -c -o $binary.o \$(CXXFLAGS) $binary.cpp\n\n";
}
foreach $object (@objects) {
  print M "$object.o: $object.cpp\n";
  print M "\tg++ -c -o $object.o \$(CXXFLAGS) $object.cpp\n\n";
}
print M "clean:\n";
print M "\trm -f *~ *.o @binaries\n";
print M ".PHONY: clean\n";

close(M);
