# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AbsoluteMarker(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of AbsoluteMarker."""

    ALL_BACKUP = "AllBackup"
    FIRST_OF_DAY = "FirstOfDay"
    FIRST_OF_MONTH = "FirstOfMonth"
    FIRST_OF_WEEK = "FirstOfWeek"
    FIRST_OF_YEAR = "FirstOfYear"


class ActionType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Extensible enum. Indicates the action type. "Internal" refers to actions that are for internal
    only APIs.
    """

    INTERNAL = "Internal"
    """Actions are for internal-only APIs."""


class AKSVolumeTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of AKSVolumeTypes."""

    AZURE_DISK = "AzureDisk"
    AZURE_FILE_SHARE_SMB = "AzureFileShareSMB"


class AlertsState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of AlertsState."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class BCDRSecurityLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Security Level of Backup Vault."""

    POOR = "Poor"
    FAIR = "Fair"
    GOOD = "Good"
    EXCELLENT = "Excellent"
    NOT_SUPPORTED = "NotSupported"


class CreatedByType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of entity that created the resource."""

    USER = "User"
    """The entity was created by a user."""
    APPLICATION = "Application"
    """The entity was created by an application."""
    MANAGED_IDENTITY = "ManagedIdentity"
    """The entity was created by a managed identity."""
    KEY = "Key"
    """The entity was created by a key."""


class CrossRegionRestoreState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CrossRegionRestore state."""

    DISABLED = "Disabled"
    ENABLED = "Enabled"


class CrossSubscriptionRestoreState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """CrossSubscriptionRestore state."""

    DISABLED = "Disabled"
    PERMANENTLY_DISABLED = "PermanentlyDisabled"
    ENABLED = "Enabled"


class CurrentProtectionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the current protection state of the resource."""

    INVALID = "Invalid"
    NOT_PROTECTED = "NotProtected"
    CONFIGURING_PROTECTION = "ConfiguringProtection"
    PROTECTION_CONFIGURED = "ProtectionConfigured"
    BACKUP_SCHEDULES_SUSPENDED = "BackupSchedulesSuspended"
    RETENTION_SCHEDULES_SUSPENDED = "RetentionSchedulesSuspended"
    PROTECTION_STOPPED = "ProtectionStopped"
    PROTECTION_ERROR = "ProtectionError"
    CONFIGURING_PROTECTION_FAILED = "ConfiguringProtectionFailed"
    SOFT_DELETING = "SoftDeleting"
    SOFT_DELETED = "SoftDeleted"
    UPDATING_PROTECTION = "UpdatingProtection"


class DataStoreTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """type of datastore; Operational/Vault/Archive."""

    OPERATIONAL_STORE = "OperationalStore"
    VAULT_STORE = "VaultStore"
    ARCHIVE_STORE = "ArchiveStore"


class DayOfWeek(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of DayOfWeek."""

    FRIDAY = "Friday"
    MONDAY = "Monday"
    SATURDAY = "Saturday"
    SUNDAY = "Sunday"
    THURSDAY = "Thursday"
    TUESDAY = "Tuesday"
    WEDNESDAY = "Wednesday"


class EncryptionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Encryption state of the Backup Vault."""

    ENABLED = "Enabled"
    """CMK encryption is enabled on the Backup Vault"""
    DISABLED = "Disabled"
    """CMK encryption is disabled on the Backup Vault. User can not set this state once Encryption
    State is 'Enabled'."""
    INCONSISTENT = "Inconsistent"
    """CMK encryption is in inconsistent state on the Backup Vault. This state indicates that user
    needs to retry the encryption settings operation immediately to correct the state."""


class ExistingResourcePolicy(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the Conflict Policy property. This property sets policy during conflict of
    resources during restore.
    """

    SKIP = "Skip"
    PATCH = "Patch"


class FeatureSupportStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """feature support status."""

    INVALID = "Invalid"
    NOT_SUPPORTED = "NotSupported"
    ALPHA_PREVIEW = "AlphaPreview"
    PRIVATE_PREVIEW = "PrivatePreview"
    PUBLIC_PREVIEW = "PublicPreview"
    GENERALLY_AVAILABLE = "GenerallyAvailable"


class FeatureType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """backup support feature type."""

    INVALID = "Invalid"
    DATA_SOURCE_TYPE = "DataSourceType"


class IdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The identity type. 'SystemAssigned' and 'UserAssigned' are mutually exclusive. 'SystemAssigned'
    will use implicitly created managed identity.
    """

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"


class ImmutabilityState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Immutability state."""

    DISABLED = "Disabled"
    UNLOCKED = "Unlocked"
    LOCKED = "Locked"


class InfrastructureEncryptionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Enabling/Disabling the Double Encryption state."""

    ENABLED = "Enabled"
    DISABLED = "Disabled"


class Month(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of Month."""

    APRIL = "April"
    AUGUST = "August"
    DECEMBER = "December"
    FEBRUARY = "February"
    JANUARY = "January"
    JULY = "July"
    JUNE = "June"
    MARCH = "March"
    MAY = "May"
    NOVEMBER = "November"
    OCTOBER = "October"
    SEPTEMBER = "September"


class Origin(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
    logs UX. Default value is "user,system".
    """

    USER = "user"
    """Indicates the operation is initiated by a user."""
    SYSTEM = "system"
    """Indicates the operation is initiated by a system."""
    USER_SYSTEM = "user,system"
    """Indicates the operation is initiated by a user or system."""


class PersistentVolumeRestoreMode(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the PV (Persistent Volume) Restore Mode property. This property sets whether
    volumes needs to be restored.
    """

    RESTORE_WITH_VOLUME_DATA = "RestoreWithVolumeData"
    RESTORE_WITHOUT_VOLUME_DATA = "RestoreWithoutVolumeData"


class ProvisioningState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Provisioning state of the BackupVault resource."""

    FAILED = "Failed"
    PROVISIONING = "Provisioning"
    SUCCEEDED = "Succeeded"
    UNKNOWN = "Unknown"
    UPDATING = "Updating"


class RecoveryOption(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Recovery Option."""

    FAIL_IF_EXISTS = "FailIfExists"


class RecoveryPointCompletionState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies recovery point completeness. Partial (i.e., only some of the intended items were
    backed up), or Completed (i.e., ALL intended items were backed up).
    """

    COMPLETED = "Completed"
    PARTIAL = "Partial"


class RehydrationPriority(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Priority to be used for rehydration. Values High or Standard."""

    INVALID = "Invalid"
    HIGH = "High"
    STANDARD = "Standard"


class RehydrationStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of RehydrationStatus."""

    CREATE_IN_PROGRESS = "CREATE_IN_PROGRESS"
    COMPLETED = "COMPLETED"
    DELETE_IN_PROGRESS = "DELETE_IN_PROGRESS"
    DELETED = "DELETED"
    FAILED = "FAILED"


class ResourceMoveState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Resource move state for backup vault."""

    UNKNOWN = "Unknown"
    IN_PROGRESS = "InProgress"
    PREPARE_FAILED = "PrepareFailed"
    COMMIT_FAILED = "CommitFailed"
    FAILED = "Failed"
    PREPARE_TIMEDOUT = "PrepareTimedout"
    COMMIT_TIMEDOUT = "CommitTimedout"
    CRITICAL_FAILURE = "CriticalFailure"
    PARTIAL_SUCCESS = "PartialSuccess"
    MOVE_SUCCEEDED = "MoveSucceeded"


class ResourcePropertiesObjectType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of the specific object - used for deserializing."""

    DEFAULT_RESOURCE_PROPERTIES = "DefaultResourceProperties"


class RestoreSourceDataStoreType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the type of the source data store."""

    OPERATIONAL_STORE = "OperationalStore"
    VAULT_STORE = "VaultStore"
    ARCHIVE_STORE = "ArchiveStore"


class RestoreTargetLocationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Denotes the target location where the data will be restored,
    string value for the enum
    {Microsoft.Internal.AzureBackup.DataProtection.Common.Interface.RestoreTargetLocationType}.
    """

    INVALID = "Invalid"
    AZURE_BLOBS = "AzureBlobs"
    AZURE_FILES = "AzureFiles"


class SecretStoreType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the type of secret store."""

    INVALID = "Invalid"
    AZURE_KEY_VAULT = "AzureKeyVault"


class SecureScoreLevel(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Secure Score of Backup Vault."""

    NONE = "None"
    MINIMUM = "Minimum"
    ADEQUATE = "Adequate"
    MAXIMUM = "Maximum"
    NOT_SUPPORTED = "NotSupported"


class SoftDeleteState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """State of soft delete."""

    OFF = "Off"
    """Soft Delete is turned off for the BackupVault"""
    ON = "On"
    """Soft Delete is enabled for the BackupVault but can be turned off"""
    ALWAYS_ON = "AlwaysOn"
    """Soft Delete is permanently enabled for the BackupVault and the setting cannot be changed"""


class SourceDataStoreType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the type of the source data store."""

    ARCHIVE_STORE = "ArchiveStore"
    SNAPSHOT_STORE = "SnapshotStore"
    OPERATIONAL_STORE = "OperationalStore"
    VAULT_STORE = "VaultStore"


class Status(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the protection status of the resource."""

    CONFIGURING_PROTECTION = "ConfiguringProtection"
    CONFIGURING_PROTECTION_FAILED = "ConfiguringProtectionFailed"
    PROTECTION_CONFIGURED = "ProtectionConfigured"
    PROTECTION_STOPPED = "ProtectionStopped"
    SOFT_DELETED = "SoftDeleted"
    SOFT_DELETING = "SoftDeleting"


class StorageSettingStoreTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the type of the datastore."""

    ARCHIVE_STORE = "ArchiveStore"
    OPERATIONAL_STORE = "OperationalStore"
    VAULT_STORE = "VaultStore"


class StorageSettingTypes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Gets or sets the type."""

    GEO_REDUNDANT = "GeoRedundant"
    LOCALLY_REDUNDANT = "LocallyRedundant"
    ZONE_REDUNDANT = "ZoneRedundant"


class SyncType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Field indicating sync type e.g. to sync only in case of failure or in all cases."""

    DEFAULT = "Default"
    FORCE_RESYNC = "ForceResync"


class ValidationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Specifies the type of validation. In case of DeepValidation, all validations from
    /validateForBackup API will run again.
    """

    SHALLOW_VALIDATION = "ShallowValidation"
    DEEP_VALIDATION = "DeepValidation"


class WeekNumber(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Type of WeekNumber."""

    FIRST = "First"
    FOURTH = "Fourth"
    LAST = "Last"
    SECOND = "Second"
    THIRD = "Third"
