# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::NotificationHubs
  #
  # Azure NotificationHub client
  #
  class Namespaces
    include MsRestAzure

    #
    # Creates and initializes a new instance of the Namespaces class.
    # @param client service class for accessing basic functionality.
    #
    def initialize(client)
      @client = client
    end

    # @return [NotificationHubsManagementClient] reference to the NotificationHubsManagementClient
    attr_reader :client

    #
    # Checks the availability of the given service namespace across all Azure
    # subscriptions. This is useful because the domain name is created based on the
    # service namespace name.
    #
    # @param parameters [CheckAvailabilityParameters] The namespace name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [CheckAvailabilityResult] operation results.
    #
    def check_availability(parameters, custom_headers = nil)
      response = check_availability_async(parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Checks the availability of the given service namespace across all Azure
    # subscriptions. This is useful because the domain name is created based on the
    # service namespace name.
    #
    # @param parameters [CheckAvailabilityParameters] The namespace name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def check_availability_with_http_info(parameters, custom_headers = nil)
      check_availability_async(parameters, custom_headers).value!
    end

    #
    # Checks the availability of the given service namespace across all Azure
    # subscriptions. This is useful because the domain name is created based on the
    # service namespace name.
    #
    # @param parameters [CheckAvailabilityParameters] The namespace name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def check_availability_async(parameters, custom_headers = nil)
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::NotificationHubs::Models::CheckAvailabilityParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.NotificationHubs/checkNamespaceAvailability'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::NotificationHubs::Models::CheckAvailabilityResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates/Updates a service namespace. Once created, this namespace's resource
    # manifest is immutable. This operation is idempotent.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param parameters [NamespaceCreateOrUpdateParameters] Parameters supplied to
    # create a Namespace Resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NamespaceResource] operation results.
    #
    def create_or_update(resource_group_name, namespace_name, parameters, custom_headers = nil)
      response = create_or_update_async(resource_group_name, namespace_name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates/Updates a service namespace. Once created, this namespace's resource
    # manifest is immutable. This operation is idempotent.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param parameters [NamespaceCreateOrUpdateParameters] Parameters supplied to
    # create a Namespace Resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_with_http_info(resource_group_name, namespace_name, parameters, custom_headers = nil)
      create_or_update_async(resource_group_name, namespace_name, parameters, custom_headers).value!
    end

    #
    # Creates/Updates a service namespace. Once created, this namespace's resource
    # manifest is immutable. This operation is idempotent.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param parameters [NamespaceCreateOrUpdateParameters] Parameters supplied to
    # create a Namespace Resource.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_async(resource_group_name, namespace_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::NotificationHubs::Models::NamespaceCreateOrUpdateParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 201 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 201
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::NotificationHubs::Models::NamespaceResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::NotificationHubs::Models::NamespaceResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Patches the existing namespace
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param parameters [NamespacePatchParameters] Parameters supplied to patch a
    # Namespace Resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NamespaceResource] operation results.
    #
    def patch(resource_group_name, namespace_name, parameters, custom_headers = nil)
      response = patch_async(resource_group_name, namespace_name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Patches the existing namespace
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param parameters [NamespacePatchParameters] Parameters supplied to patch a
    # Namespace Resource.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def patch_with_http_info(resource_group_name, namespace_name, parameters, custom_headers = nil)
      patch_async(resource_group_name, namespace_name, parameters, custom_headers).value!
    end

    #
    # Patches the existing namespace
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param parameters [NamespacePatchParameters] Parameters supplied to patch a
    # Namespace Resource.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def patch_async(resource_group_name, namespace_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::NotificationHubs::Models::NamespacePatchParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:patch, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::NotificationHubs::Models::NamespaceResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes an existing namespace. This operation also removes all associated
    # notificationHubs under the namespace.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    def delete(resource_group_name, namespace_name, custom_headers = nil)
      response = delete_async(resource_group_name, namespace_name, custom_headers).value!
      nil
    end

    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Concurrent::Promise] promise which provides async access to http
    # response.
    #
    def delete_async(resource_group_name, namespace_name, custom_headers = nil)
      # Send request
      promise = begin_delete_async(resource_group_name, namespace_name, custom_headers)

      promise = promise.then do |response|
        # Defining deserialization method.
        deserialize_method = lambda do |parsed_response|
        end

        # Waiting for response.
        @client.get_long_running_operation_result(response, deserialize_method)
      end

      promise
    end

    #
    # Returns the description for the specified namespace.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NamespaceResource] operation results.
    #
    def get(resource_group_name, namespace_name, custom_headers = nil)
      response = get_async(resource_group_name, namespace_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Returns the description for the specified namespace.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_with_http_info(resource_group_name, namespace_name, custom_headers = nil)
      get_async(resource_group_name, namespace_name, custom_headers).value!
    end

    #
    # Returns the description for the specified namespace.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_async(resource_group_name, namespace_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::NotificationHubs::Models::NamespaceResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Creates an authorization rule for a namespace
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param authorization_rule_name [String] Aauthorization Rule Name.
    # @param parameters [SharedAccessAuthorizationRuleCreateOrUpdateParameters] The
    # shared access authorization rule.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SharedAccessAuthorizationRuleResource] operation results.
    #
    def create_or_update_authorization_rule(resource_group_name, namespace_name, authorization_rule_name, parameters, custom_headers = nil)
      response = create_or_update_authorization_rule_async(resource_group_name, namespace_name, authorization_rule_name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Creates an authorization rule for a namespace
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param authorization_rule_name [String] Aauthorization Rule Name.
    # @param parameters [SharedAccessAuthorizationRuleCreateOrUpdateParameters] The
    # shared access authorization rule.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def create_or_update_authorization_rule_with_http_info(resource_group_name, namespace_name, authorization_rule_name, parameters, custom_headers = nil)
      create_or_update_authorization_rule_async(resource_group_name, namespace_name, authorization_rule_name, parameters, custom_headers).value!
    end

    #
    # Creates an authorization rule for a namespace
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param authorization_rule_name [String] Aauthorization Rule Name.
    # @param parameters [SharedAccessAuthorizationRuleCreateOrUpdateParameters] The
    # shared access authorization rule.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def create_or_update_authorization_rule_async(resource_group_name, namespace_name, authorization_rule_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'authorization_rule_name is nil' if authorization_rule_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::NotificationHubs::Models::SharedAccessAuthorizationRuleCreateOrUpdateParameters.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'authorizationRuleName' => authorization_rule_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:put, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::NotificationHubs::Models::SharedAccessAuthorizationRuleResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes a namespace authorization rule
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param authorization_rule_name [String] Authorization Rule Name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def delete_authorization_rule(resource_group_name, namespace_name, authorization_rule_name, custom_headers = nil)
      response = delete_authorization_rule_async(resource_group_name, namespace_name, authorization_rule_name, custom_headers).value!
      nil
    end

    #
    # Deletes a namespace authorization rule
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param authorization_rule_name [String] Authorization Rule Name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def delete_authorization_rule_with_http_info(resource_group_name, namespace_name, authorization_rule_name, custom_headers = nil)
      delete_authorization_rule_async(resource_group_name, namespace_name, authorization_rule_name, custom_headers).value!
    end

    #
    # Deletes a namespace authorization rule
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param authorization_rule_name [String] Authorization Rule Name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def delete_authorization_rule_async(resource_group_name, namespace_name, authorization_rule_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'authorization_rule_name is nil' if authorization_rule_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'authorizationRuleName' => authorization_rule_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204 || status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Gets an authorization rule for a namespace by name.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name
    # @param authorization_rule_name [String] Authorization rule name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SharedAccessAuthorizationRuleResource] operation results.
    #
    def get_authorization_rule(resource_group_name, namespace_name, authorization_rule_name, custom_headers = nil)
      response = get_authorization_rule_async(resource_group_name, namespace_name, authorization_rule_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets an authorization rule for a namespace by name.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name
    # @param authorization_rule_name [String] Authorization rule name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def get_authorization_rule_with_http_info(resource_group_name, namespace_name, authorization_rule_name, custom_headers = nil)
      get_authorization_rule_async(resource_group_name, namespace_name, authorization_rule_name, custom_headers).value!
    end

    #
    # Gets an authorization rule for a namespace by name.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name
    # @param authorization_rule_name [String] Authorization rule name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def get_authorization_rule_async(resource_group_name, namespace_name, authorization_rule_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'authorization_rule_name is nil' if authorization_rule_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'authorizationRuleName' => authorization_rule_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::NotificationHubs::Models::SharedAccessAuthorizationRuleResource.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the available namespaces within a resourceGroup.
    #
    # @param resource_group_name [String] The name of the resource group. If
    # resourceGroupName value is null the method lists all the namespaces within
    # subscription
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<NamespaceResource>] operation results.
    #
    def list(resource_group_name, custom_headers = nil)
      first_page = list_as_lazy(resource_group_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Lists the available namespaces within a resourceGroup.
    #
    # @param resource_group_name [String] The name of the resource group. If
    # resourceGroupName value is null the method lists all the namespaces within
    # subscription
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_with_http_info(resource_group_name, custom_headers = nil)
      list_async(resource_group_name, custom_headers).value!
    end

    #
    # Lists the available namespaces within a resourceGroup.
    #
    # @param resource_group_name [String] The name of the resource group. If
    # resourceGroupName value is null the method lists all the namespaces within
    # subscription
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_async(resource_group_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::NotificationHubs::Models::NamespaceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all the available namespaces within the subscription irrespective of
    # the resourceGroups.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<NamespaceResource>] operation results.
    #
    def list_all(custom_headers = nil)
      first_page = list_all_as_lazy(custom_headers)
      first_page.get_all_items
    end

    #
    # Lists all the available namespaces within the subscription irrespective of
    # the resourceGroups.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_all_with_http_info(custom_headers = nil)
      list_all_async(custom_headers).value!
    end

    #
    # Lists all the available namespaces within the subscription irrespective of
    # the resourceGroups.
    #
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_all_async(custom_headers = nil)
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/providers/Microsoft.NotificationHubs/namespaces'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::NotificationHubs::Models::NamespaceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the authorization rules for a namespace.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [Array<SharedAccessAuthorizationRuleResource>] operation results.
    #
    def list_authorization_rules(resource_group_name, namespace_name, custom_headers = nil)
      first_page = list_authorization_rules_as_lazy(resource_group_name, namespace_name, custom_headers)
      first_page.get_all_items
    end

    #
    # Gets the authorization rules for a namespace.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_authorization_rules_with_http_info(resource_group_name, namespace_name, custom_headers = nil)
      list_authorization_rules_async(resource_group_name, namespace_name, custom_headers).value!
    end

    #
    # Gets the authorization rules for a namespace.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_authorization_rules_async(resource_group_name, namespace_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/AuthorizationRules'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::NotificationHubs::Models::SharedAccessAuthorizationRuleListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the Primary and Secondary ConnectionStrings to the namespace
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param authorization_rule_name [String] The connection string of the
    # namespace for the specified authorizationRule.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceListKeys] operation results.
    #
    def list_keys(resource_group_name, namespace_name, authorization_rule_name, custom_headers = nil)
      response = list_keys_async(resource_group_name, namespace_name, authorization_rule_name, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the Primary and Secondary ConnectionStrings to the namespace
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param authorization_rule_name [String] The connection string of the
    # namespace for the specified authorizationRule.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_keys_with_http_info(resource_group_name, namespace_name, authorization_rule_name, custom_headers = nil)
      list_keys_async(resource_group_name, namespace_name, authorization_rule_name, custom_headers).value!
    end

    #
    # Gets the Primary and Secondary ConnectionStrings to the namespace
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param authorization_rule_name [String] The connection string of the
    # namespace for the specified authorizationRule.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_keys_async(resource_group_name, namespace_name, authorization_rule_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'authorization_rule_name is nil' if authorization_rule_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}/listKeys'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'authorizationRuleName' => authorization_rule_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::NotificationHubs::Models::ResourceListKeys.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Regenerates the Primary/Secondary Keys to the Namespace Authorization Rule
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param authorization_rule_name [String] The connection string of the
    # namespace for the specified authorizationRule.
    # @param parameters [PolicykeyResource] Parameters supplied to regenerate the
    # Namespace Authorization Rule Key.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [ResourceListKeys] operation results.
    #
    def regenerate_keys(resource_group_name, namespace_name, authorization_rule_name, parameters, custom_headers = nil)
      response = regenerate_keys_async(resource_group_name, namespace_name, authorization_rule_name, parameters, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Regenerates the Primary/Secondary Keys to the Namespace Authorization Rule
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param authorization_rule_name [String] The connection string of the
    # namespace for the specified authorizationRule.
    # @param parameters [PolicykeyResource] Parameters supplied to regenerate the
    # Namespace Authorization Rule Key.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def regenerate_keys_with_http_info(resource_group_name, namespace_name, authorization_rule_name, parameters, custom_headers = nil)
      regenerate_keys_async(resource_group_name, namespace_name, authorization_rule_name, parameters, custom_headers).value!
    end

    #
    # Regenerates the Primary/Secondary Keys to the Namespace Authorization Rule
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param authorization_rule_name [String] The connection string of the
    # namespace for the specified authorizationRule.
    # @param parameters [PolicykeyResource] Parameters supplied to regenerate the
    # Namespace Authorization Rule Key.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def regenerate_keys_async(resource_group_name, namespace_name, authorization_rule_name, parameters, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, 'authorization_rule_name is nil' if authorization_rule_name.nil?
      fail ArgumentError, 'parameters is nil' if parameters.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?

      request_headers['Content-Type'] = 'application/json; charset=utf-8'

      # Serialize Request
      request_mapper = Azure::ARM::NotificationHubs::Models::PolicykeyResource.mapper()
      request_content = @client.serialize(request_mapper,  parameters)
      request_content = request_content != nil ? JSON.generate(request_content, quirks_mode: true) : nil

      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}/AuthorizationRules/{authorizationRuleName}/regenerateKeys'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'authorizationRuleName' => authorization_rule_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          body: request_content,
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:post, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::NotificationHubs::Models::ResourceListKeys.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Deletes an existing namespace. This operation also removes all associated
    # notificationHubs under the namespace.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    #
    def begin_delete(resource_group_name, namespace_name, custom_headers = nil)
      response = begin_delete_async(resource_group_name, namespace_name, custom_headers).value!
      nil
    end

    #
    # Deletes an existing namespace. This operation also removes all associated
    # notificationHubs under the namespace.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def begin_delete_with_http_info(resource_group_name, namespace_name, custom_headers = nil)
      begin_delete_async(resource_group_name, namespace_name, custom_headers).value!
    end

    #
    # Deletes an existing namespace. This operation also removes all associated
    # notificationHubs under the namespace.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def begin_delete_async(resource_group_name, namespace_name, custom_headers = nil)
      fail ArgumentError, 'resource_group_name is nil' if resource_group_name.nil?
      fail ArgumentError, 'namespace_name is nil' if namespace_name.nil?
      fail ArgumentError, '@client.api_version is nil' if @client.api_version.nil?
      fail ArgumentError, '@client.subscription_id is nil' if @client.subscription_id.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = 'subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.NotificationHubs/namespaces/{namespaceName}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          path_params: {'resourceGroupName' => resource_group_name,'namespaceName' => namespace_name,'subscriptionId' => @client.subscription_id},
          query_params: {'api-version' => @client.api_version},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:delete, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 204 || status_code == 200 || status_code == 202
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?

        result
      end

      promise.execute
    end

    #
    # Lists the available namespaces within a resourceGroup.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NamespaceListResult] operation results.
    #
    def list_next(next_page_link, custom_headers = nil)
      response = list_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists the available namespaces within a resourceGroup.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_next_with_http_info(next_page_link, custom_headers = nil)
      list_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists the available namespaces within a resourceGroup.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::NotificationHubs::Models::NamespaceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists all the available namespaces within the subscription irrespective of
    # the resourceGroups.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NamespaceListResult] operation results.
    #
    def list_all_next(next_page_link, custom_headers = nil)
      response = list_all_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Lists all the available namespaces within the subscription irrespective of
    # the resourceGroups.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_all_next_with_http_info(next_page_link, custom_headers = nil)
      list_all_next_async(next_page_link, custom_headers).value!
    end

    #
    # Lists all the available namespaces within the subscription irrespective of
    # the resourceGroups.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_all_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::NotificationHubs::Models::NamespaceListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Gets the authorization rules for a namespace.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SharedAccessAuthorizationRuleListResult] operation results.
    #
    def list_authorization_rules_next(next_page_link, custom_headers = nil)
      response = list_authorization_rules_next_async(next_page_link, custom_headers).value!
      response.body unless response.nil?
    end

    #
    # Gets the authorization rules for a namespace.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [MsRestAzure::AzureOperationResponse] HTTP response information.
    #
    def list_authorization_rules_next_with_http_info(next_page_link, custom_headers = nil)
      list_authorization_rules_next_async(next_page_link, custom_headers).value!
    end

    #
    # Gets the authorization rules for a namespace.
    #
    # @param next_page_link [String] The NextLink from the previous successful call
    # to List operation.
    # @param [Hash{String => String}] A hash of custom headers that will be added
    # to the HTTP request.
    #
    # @return [Concurrent::Promise] Promise object which holds the HTTP response.
    #
    def list_authorization_rules_next_async(next_page_link, custom_headers = nil)
      fail ArgumentError, 'next_page_link is nil' if next_page_link.nil?


      request_headers = {}

      # Set Headers
      request_headers['x-ms-client-request-id'] = SecureRandom.uuid
      request_headers['accept-language'] = @client.accept_language unless @client.accept_language.nil?
      path_template = '{nextLink}'

      request_url = @base_url || @client.base_url

      options = {
          middlewares: [[MsRest::RetryPolicyMiddleware, times: 3, retry: 0.02], [:cookie_jar]],
          skip_encoding_path_params: {'nextLink' => next_page_link},
          headers: request_headers.merge(custom_headers || {}),
          base_url: request_url
      }
      promise = @client.make_request_async(:get, path_template, options)

      promise = promise.then do |result|
        http_response = result.response
        status_code = http_response.status
        response_content = http_response.body
        unless status_code == 200
          error_model = JSON.load(response_content)
          fail MsRestAzure::AzureOperationError.new(result.request, http_response, error_model)
        end

        result.request_id = http_response['x-ms-request-id'] unless http_response['x-ms-request-id'].nil?
        # Deserialize Response
        if status_code == 200
          begin
            parsed_response = response_content.to_s.empty? ? nil : JSON.load(response_content)
            result_mapper = Azure::ARM::NotificationHubs::Models::SharedAccessAuthorizationRuleListResult.mapper()
            result.body = @client.deserialize(result_mapper, parsed_response)
          rescue Exception => e
            fail MsRest::DeserializationError.new('Error occurred in deserializing the response', e.message, e.backtrace, result)
          end
        end

        result
      end

      promise.execute
    end

    #
    # Lists the available namespaces within a resourceGroup.
    #
    # @param resource_group_name [String] The name of the resource group. If
    # resourceGroupName value is null the method lists all the namespaces within
    # subscription
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NamespaceListResult] which provide lazy access to pages of the
    # response.
    #
    def list_as_lazy(resource_group_name, custom_headers = nil)
      response = list_async(resource_group_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Lists all the available namespaces within the subscription irrespective of
    # the resourceGroups.
    #
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [NamespaceListResult] which provide lazy access to pages of the
    # response.
    #
    def list_all_as_lazy(custom_headers = nil)
      response = list_all_async(custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_all_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

    #
    # Gets the authorization rules for a namespace.
    #
    # @param resource_group_name [String] The name of the resource group.
    # @param namespace_name [String] The namespace name
    # @param custom_headers [Hash{String => String}] A hash of custom headers that
    # will be added to the HTTP request.
    #
    # @return [SharedAccessAuthorizationRuleListResult] which provide lazy access
    # to pages of the response.
    #
    def list_authorization_rules_as_lazy(resource_group_name, namespace_name, custom_headers = nil)
      response = list_authorization_rules_async(resource_group_name, namespace_name, custom_headers).value!
      unless response.nil?
        page = response.body
        page.next_method = Proc.new do |next_page_link|
          list_authorization_rules_next_async(next_page_link, custom_headers)
        end
        page
      end
    end

  end
end
