# encoding: utf-8
# Code generated by Microsoft (R) AutoRest Code Generator 1.2.2.0
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.

module Azure::ARM::SQL
  module Models
    #
    # An update request for an Azure SQL Database server.
    #
    class ServerUpdate

      include MsRestAzure

      include MsRest::JSONable
      # @return [String] Administrator username for the server. Once created it
      # cannot be changed.
      attr_accessor :administrator_login

      # @return [String] The administrator login password (required for server
      # creation).
      attr_accessor :administrator_login_password

      # @return [String] The version of the server.
      attr_accessor :version

      # @return [String] The state of the server.
      attr_accessor :state

      # @return [String] The fully qualified domain name of the server.
      attr_accessor :fully_qualified_domain_name

      # @return [Hash{String => String}] Resource tags.
      attr_accessor :tags


      #
      # Mapper for ServerUpdate class as Ruby Hash.
      # This will be used for serialization/deserialization.
      #
      def self.mapper()
        {
          required: false,
          serialized_name: 'ServerUpdate',
          type: {
            name: 'Composite',
            class_name: 'ServerUpdate',
            model_properties: {
              administrator_login: {
                required: false,
                serialized_name: 'properties.administratorLogin',
                type: {
                  name: 'String'
                }
              },
              administrator_login_password: {
                required: false,
                serialized_name: 'properties.administratorLoginPassword',
                type: {
                  name: 'String'
                }
              },
              version: {
                required: false,
                serialized_name: 'properties.version',
                type: {
                  name: 'String'
                }
              },
              state: {
                required: false,
                read_only: true,
                serialized_name: 'properties.state',
                type: {
                  name: 'String'
                }
              },
              fully_qualified_domain_name: {
                required: false,
                read_only: true,
                serialized_name: 'properties.fullyQualifiedDomainName',
                type: {
                  name: 'String'
                }
              },
              tags: {
                required: false,
                serialized_name: 'tags',
                type: {
                  name: 'Dictionary',
                  value: {
                      required: false,
                      serialized_name: 'StringElementType',
                      type: {
                        name: 'String'
                      }
                  }
                }
              }
            }
          }
        }
      end
    end
  end
end
