from bzrlib.plugins.bzrtools.fetch_ghosts import GhostFetcher
from bzrlib.tests import TestCaseWithTransport


class TestFetchGhosts(TestCaseWithTransport):

    def prepare_with_ghosts(self):
        tree = self.make_branch_and_tree('.')
        tree.commit('rev1', rev_id='rev1-id')
        tree.set_parent_ids(['rev1-id', 'ghost-id'])
        tree.commit('rev2')
        return tree

    def test_fetch_ghosts_failure(self):
        tree = self.prepare_with_ghosts()
        branch = self.make_branch('branch')
        GhostFetcher(tree.branch, branch).run()
        self.assertFalse(tree.branch.repository.has_revision('ghost-id'))

    def test_fetch_ghosts_success(self):
        tree = self.prepare_with_ghosts()
        ghost_tree = self.make_branch_and_tree('ghost_tree')
        ghost_tree.commit('ghost', rev_id='ghost-id')
        GhostFetcher(tree.branch, ghost_tree.branch).run()
        self.assertTrue(tree.branch.repository.has_revision('ghost-id'))
