/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.CharacterStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.Column;
import com.microsoft.sqlserver.jdbc.ColumnFilter;
import com.microsoft.sqlserver.jdbc.DataTypes;
import com.microsoft.sqlserver.jdbc.InputStreamGetterArgs;
import com.microsoft.sqlserver.jdbc.InputStreamSetterArgs;
import com.microsoft.sqlserver.jdbc.SQLServerClob;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerParameterMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.microsoft.sqlserver.jdbc.SQLServerResultSetMetaData;
import com.microsoft.sqlserver.jdbc.SQLServerStatement;
import com.microsoft.sqlserver.jdbc.ScrollWindow;
import com.microsoft.sqlserver.jdbc.StreamColumns;
import com.microsoft.sqlserver.jdbc.StreamDone;
import com.microsoft.sqlserver.jdbc.StreamRetStatus;
import com.microsoft.sqlserver.jdbc.TDSCommand;
import com.microsoft.sqlserver.jdbc.TDSParser;
import com.microsoft.sqlserver.jdbc.TDSReader;
import com.microsoft.sqlserver.jdbc.TDSReaderMark;
import com.microsoft.sqlserver.jdbc.TDSTokenHandler;
import com.microsoft.sqlserver.jdbc.TDSWriter;
import com.microsoft.sqlserver.jdbc.TypeInfo;
import com.microsoft.sqlserver.jdbc.UninterruptableTDSCommand;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class SQLServerResultSet
implements ResultSet {
    public static final int TYPE_SS_DIRECT_FORWARD_ONLY = 2003;
    public static final int TYPE_SS_SERVER_CURSOR_FORWARD_ONLY = 2004;
    public static final int TYPE_SS_SCROLL_STATIC = 1004;
    public static final int TYPE_SS_SCROLL_KEYSET = 1005;
    public static final int TYPE_SS_SCROLL_DYNAMIC = 1006;
    public static final int CONCUR_SS_OPTIMISTIC_CC = 1008;
    public static final int CONCUR_SS_SCROLL_LOCKS = 1009;
    public static final int CONCUR_SS_OPTIMISTIC_CCVAL = 1010;
    private final int resultSetID;
    private static int lastResultSetID;
    static Logger logger;
    SQLServerStatement stmt;
    private final int maxRows;
    private ResultSetMetaData metaData;
    private boolean isClosed = false;
    private final int serverCursorId;
    private String cursorTableName;
    private int fetchDirection;
    private int fetchSize;
    private boolean isOnInsertRow = false;
    private boolean lastValueWasNull = false;
    private int lastColumnIndex;
    private Object activeStream;
    private final ScrollWindow scrollWindow;
    private static final int BEFORE_FIRST_ROW = 0;
    private static final int AFTER_LAST_ROW = -1;
    private static final int UNKNOWN_ROW = -2;
    private int currentRow = 0;
    private boolean updatedCurrentRow = false;
    private boolean deletedCurrentRow = false;
    private static final int UNKNOWN_ROW_COUNT = -3;
    private int rowCount;
    private final Column[] columns;
    private TDSReader tdsReader;
    private int numFetchedRows;
    private final FetchBuffer fetchBuffer = new FetchBuffer();
    static final /* synthetic */ boolean $assertionsDisabled;

    private static synchronized int nextResultSetID() {
        return ++lastResultSetID;
    }

    String toLogString() {
        return "ResultSet ID:" + this.resultSetID + " (" + this.stmt.connection.toLogString() + ")";
    }

    String logCursorState() {
        return " currentRow:" + this.currentRow + " numFetchedRows:" + this.numFetchedRows + " rowCount:" + this.rowCount;
    }

    final boolean getUpdatedCurrentRow() {
        return this.updatedCurrentRow;
    }

    final void setUpdatedCurrentRow(boolean bl) {
        this.updatedCurrentRow = bl;
    }

    final boolean getDeletedCurrentRow() {
        return this.deletedCurrentRow;
    }

    final void setDeletedCurrentRow(boolean bl) {
        this.deletedCurrentRow = bl;
    }

    final void setColumnName(int n, String string) {
        this.columns[n - 1].name = string;
    }

    private final void skipColumns(int n, boolean bl) throws SQLServerException {
        if (!$assertionsDisabled && this.lastColumnIndex < 1) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || 0 <= n && n <= this.columns.length)) {
            throw new AssertionError();
        }
        this.closeActiveStream();
        for (int i = 0; i < n; ++i) {
            Column column = this.getColumn(this.lastColumnIndex++);
            column.skipValue(this.tdsReader, bl && this.isForwardOnly());
            if (!bl) continue;
            column.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeActiveStream() throws SQLServerException {
        if (null != this.activeStream) {
            try {
                if (this.activeStream instanceof InputStream) {
                    ((InputStream)this.activeStream).close();
                } else if (this.activeStream instanceof Reader) {
                    ((Reader)this.activeStream).close();
                } else if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            catch (IOException iOException) {
                SQLServerException.makeFromDriverError(null, null, iOException.getMessage(), null, true);
            }
            finally {
                this.activeStream = null;
            }
        }
    }

    SQLServerResultSet(SQLServerStatement sQLServerStatement, Column[] columnArray, int n, int n2) {
        this.resultSetID = SQLServerResultSet.nextResultSetID();
        this.stmt = sQLServerStatement;
        this.maxRows = sQLServerStatement.maxRows;
        this.tdsReader = 0 == n ? sQLServerStatement.tdsReader : null;
        this.fetchBuffer.init(this.tdsReader, !this.isForwardOnly());
        this.fetchSize = sQLServerStatement.nFetchSize;
        this.fetchDirection = sQLServerStatement.nFetchDirection;
        this.columns = columnArray;
        this.serverCursorId = n;
        this.scrollWindow = this.isForwardOnly() ? null : new ScrollWindow(this.fetchSize);
        this.rowCount = -1 != n2 ? n2 : -3;
        this.numFetchedRows = 0;
    }

    void checkClosed() throws SQLServerException {
        if (this.isClosed) {
            SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_resultsetClosed"), null, false);
        }
        this.stmt.checkClosed();
    }

    private final void throwNotScrollable() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this, SQLServerException.getErrString("R_requestedOpNotSupportedOnForward"), null, true);
    }

    private final boolean isForwardOnly() {
        return 2003 == this.stmt.getSQLResultSetType() || 2004 == this.stmt.getSQLResultSetType();
    }

    private final boolean isDynamic() {
        return 0 != this.serverCursorId && 2 == this.stmt.getCursorType();
    }

    private final void verifyResultSetIsScrollable() throws SQLServerException {
        if (this.isForwardOnly()) {
            this.throwNotScrollable();
        }
    }

    private final void throwNotUpdatable() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this, SQLServerException.getErrString("R_resultsetNotUpdatable"), null, true);
    }

    private final void verifyResultSetIsUpdatable() throws SQLServerException {
        if (1007 == this.stmt.resultSetConcurrency || 0 == this.serverCursorId) {
            this.throwNotUpdatable();
        }
    }

    private boolean hasCurrentRow() {
        return 0 != this.currentRow && -1 != this.currentRow;
    }

    private void verifyResultSetHasCurrentRow() throws SQLServerException {
        if (!this.hasCurrentRow()) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_resultsetNoCurrentRow"), null, true);
        }
    }

    private void verifyCurrentRowIsNotDeleted(String string) throws SQLServerException {
        if (this.currentRowDeleted()) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString(string), null, true);
        }
    }

    private void verifyValidColumnIndex(int n) throws SQLServerException {
        int n2 = this.columns.length;
        if (0 != this.serverCursorId) {
            --n2;
        }
        if (n < 1 || n > n2) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_indexOutOfRange"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, messageFormat.format(objectArray), "07009", false);
        }
    }

    private void verifyResultSetIsNotOnInsertRow() throws SQLServerException {
        if (this.isOnInsertRow) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_mustNotBeOnInsertRow"), null, true);
        }
    }

    private final void throwUnsupportedCursorOp() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this, SQLServerException.getErrString("R_unsupportedCursorOperation"), null, true);
    }

    public void close() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString());
        }
        if (this.isClosed || this.stmt.connection.isClosed()) {
            return;
        }
        if (null != this.scrollWindow) {
            while (this.scrollWindow.next(this)) {
            }
            this.scrollWindow.clear();
        }
        while (this.fetchBufferNext()) {
        }
        this.metaData = null;
        this.isClosed = true;
        if (0 != this.serverCursorId) {
            this.closeServerCursor();
        }
    }

    public int findColumn(String string) throws SQLServerException {
        int n;
        this.checkClosed();
        for (n = 0; n < this.columns.length; ++n) {
            if (!this.columns[n].name.equals(string)) continue;
            return n + 1;
        }
        for (n = 0; n < this.columns.length; ++n) {
            if (!this.columns[n].name.equalsIgnoreCase(string)) continue;
            return n + 1;
        }
        MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidColumnName"));
        Object[] objectArray = new Object[]{string};
        SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, messageFormat.format(objectArray), "07009", false);
        return 0;
    }

    final int getColumnCount() {
        int n = this.columns.length;
        if (0 != this.serverCursorId) {
            --n;
        }
        return n;
    }

    final void setFilter(int n, ColumnFilter columnFilter) throws SQLServerException {
        this.getColumn(n).setFilter(columnFilter);
    }

    final TypeInfo getTypeInfo(int n) throws SQLServerException {
        return this.getColumn(n).getTypeInfo();
    }

    private final Column getColumn(int n) throws SQLServerException {
        return this.columns[n - 1];
    }

    final String getTableName(int n) throws SQLServerException {
        return this.getColumn((int)n).tableName;
    }

    final String getColumnName(int n) throws SQLServerException {
        return this.getColumn((int)n).name;
    }

    private final Column loadColumn(int n) throws SQLServerException {
        if (!($assertionsDisabled || 1 <= n && n <= this.columns.length)) {
            throw new AssertionError();
        }
        if (n > this.lastColumnIndex) {
            this.skipColumns(n - this.lastColumnIndex, false);
        }
        return this.getColumn(n);
    }

    private void NotImplemented() throws SQLServerException {
        SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_notSupported"), null, false);
    }

    public void clearWarnings() throws SQLServerException {
    }

    private void moverInit() throws SQLServerException {
        this.closeActiveStream();
        this.cancelInsert();
        this.cancelUpdates();
    }

    public boolean relative(int n) throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + " rows:" + n + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.verifyResultSetHasCurrentRow();
        this.moverInit();
        this.moveRelative(n);
        return this.hasCurrentRow();
    }

    private final void moveRelative(int n) throws SQLServerException {
        if (!$assertionsDisabled && !this.hasCurrentRow()) {
            throw new AssertionError();
        }
        if (0 == n) {
            return;
        }
        if (n > 0) {
            this.moveForward(n);
        } else {
            this.moveBackward(n);
        }
    }

    private final void moveForward(int n) throws SQLServerException {
        if (!$assertionsDisabled && !this.hasCurrentRow()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        if (this.scrollWindow.getRow() + n <= this.scrollWindow.getMaxRows()) {
            int n2 = 0;
            while (n > 0 && this.scrollWindow.next(this)) {
                ++n2;
                --n;
            }
            if (-2 != this.currentRow) {
                this.currentRow += n2;
            }
            if (0 == n) {
                return;
            }
        }
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        if (0 == this.serverCursorId) {
            this.currentRow = this.clientMoveAbsolute(this.currentRow + n);
            return;
        }
        if (1 == n) {
            this.doServerFetch(2, 0, this.fetchSize);
        } else {
            this.doServerFetch(32, n + this.scrollWindow.getRow() - 1, this.fetchSize);
        }
        if (!this.scrollWindow.next(this)) {
            this.currentRow = -1;
            return;
        }
        if (-2 != this.currentRow) {
            this.currentRow += n;
        }
    }

    private final void moveBackward(int n) throws SQLServerException {
        if (!$assertionsDisabled && !this.hasCurrentRow()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && n >= 0) {
            throw new AssertionError();
        }
        if (this.scrollWindow.getRow() + n >= 1) {
            for (int i = 0; i > n; --i) {
                this.scrollWindow.previous(this);
            }
            if (-2 != this.currentRow) {
                this.currentRow += n;
            }
            return;
        }
        if (0 == this.serverCursorId) {
            if (this.currentRow + n < 1) {
                this.moveBeforeFirst();
            } else {
                this.currentRow = this.clientMoveAbsolute(this.currentRow + n);
            }
            return;
        }
        if (-1 == n) {
            this.doServerFetch(512, 0, this.fetchSize);
            if (!this.scrollWindow.next(this)) {
                this.currentRow = 0;
                return;
            }
            while (this.scrollWindow.next(this)) {
            }
            this.scrollWindow.previous(this);
        } else {
            this.doServerFetch(32, n + this.scrollWindow.getRow() - 1, this.fetchSize);
            if (!this.scrollWindow.next(this)) {
                this.currentRow = 0;
                return;
            }
        }
        if (-2 != this.currentRow) {
            this.currentRow += n;
        }
    }

    public boolean next() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.moverInit();
        if (-1 == this.currentRow) {
            return false;
        }
        if (!this.isForwardOnly()) {
            if (0 == this.currentRow) {
                this.moveFirst();
            } else {
                this.moveForward(1);
            }
            return this.hasCurrentRow();
        }
        if (0 != this.serverCursorId && this.maxRows > 0 && this.currentRow == this.maxRows) {
            this.currentRow = -1;
            return false;
        }
        if (this.fetchBufferNext()) {
            this.currentRow = 0 == this.currentRow ? 1 : ++this.currentRow;
            if (!$assertionsDisabled && 0 != this.maxRows && this.currentRow > this.maxRows) {
                throw new AssertionError();
            }
            return true;
        }
        if (0 != this.serverCursorId) {
            this.doServerFetch(2, 0, this.fetchSize);
            if (this.fetchBufferNext()) {
                this.currentRow = 0 == this.currentRow ? 1 : ++this.currentRow;
                if (!$assertionsDisabled && 0 != this.maxRows && this.currentRow > this.maxRows) {
                    throw new AssertionError();
                }
                return true;
            }
        }
        if (-3 == this.rowCount) {
            this.rowCount = this.currentRow;
        }
        this.currentRow = -1;
        return false;
    }

    public boolean wasNull() throws SQLServerException {
        this.checkClosed();
        return this.lastValueWasNull;
    }

    public boolean isBeforeFirst() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        if (0 != this.serverCursorId) {
            switch (this.stmt.getCursorType()) {
                case 4: {
                    this.throwNotScrollable();
                }
                case 2: {
                    this.throwUnsupportedCursorOp();
                }
                case 16: {
                    this.throwNotScrollable();
                }
            }
        }
        if (this.isOnInsertRow) {
            return false;
        }
        if (0 != this.currentRow) {
            return false;
        }
        if (0 == this.serverCursorId) {
            return this.fetchBufferHasRows();
        }
        if (!$assertionsDisabled && this.rowCount < 0) {
            throw new AssertionError();
        }
        return this.rowCount > 0;
    }

    public boolean isAfterLast() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        if (0 != this.serverCursorId) {
            this.verifyResultSetIsScrollable();
            if (2 == this.stmt.getCursorType() && !this.isForwardOnly()) {
                this.throwUnsupportedCursorOp();
            }
        }
        if (this.isOnInsertRow) {
            return false;
        }
        if (!$assertionsDisabled && -1 == this.currentRow && -3 == this.rowCount) {
            throw new AssertionError();
        }
        return -1 == this.currentRow && this.rowCount > 0;
    }

    public boolean isFirst() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        if (this.isDynamic()) {
            this.throwUnsupportedCursorOp();
        }
        if (this.isOnInsertRow) {
            return false;
        }
        if (!$assertionsDisabled && -2 == this.currentRow) {
            throw new AssertionError();
        }
        return 1 == this.currentRow;
    }

    public boolean isLast() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        if (this.isDynamic()) {
            this.throwUnsupportedCursorOp();
        }
        if (this.isOnInsertRow) {
            return false;
        }
        if (!this.hasCurrentRow()) {
            return false;
        }
        if (!$assertionsDisabled && this.currentRow < 1) {
            throw new AssertionError();
        }
        if (-3 != this.rowCount) {
            if (!$assertionsDisabled && this.currentRow > this.rowCount) {
                throw new AssertionError();
            }
            return this.currentRow == this.rowCount;
        }
        if (!$assertionsDisabled && 0 != this.serverCursorId) {
            throw new AssertionError();
        }
        boolean bl = !this.next();
        this.previous();
        return bl;
    }

    public void beforeFirst() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.moverInit();
        this.moveBeforeFirst();
    }

    private final void moveBeforeFirst() throws SQLServerException {
        if (0 == this.serverCursorId) {
            this.fetchBufferBeforeFirst();
            this.scrollWindow.clear();
        } else {
            this.doServerFetch(1, 0, 0);
        }
        this.currentRow = 0;
    }

    public void afterLast() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.moverInit();
        this.moveAfterLast();
    }

    private void moveAfterLast() throws SQLServerException {
        if (!$assertionsDisabled && this.isForwardOnly()) {
            throw new AssertionError();
        }
        if (0 == this.serverCursorId) {
            this.clientMoveAfterLast();
        } else {
            this.doServerFetch(8, 0, 0);
        }
        this.currentRow = -1;
    }

    public boolean first() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.moverInit();
        this.moveFirst();
        return this.hasCurrentRow();
    }

    private final void moveFirst() throws SQLServerException {
        if (0 == this.serverCursorId) {
            this.moveBeforeFirst();
        } else {
            this.doServerFetch(1, 0, this.fetchSize);
        }
        if (!this.scrollWindow.next(this)) {
            this.currentRow = -1;
            return;
        }
        this.currentRow = this.isDynamic() ? -2 : 1;
    }

    public boolean last() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.moverInit();
        this.moveLast();
        return this.hasCurrentRow();
    }

    private final void moveLast() throws SQLServerException {
        if (0 == this.serverCursorId) {
            this.currentRow = this.clientMoveAbsolute(-1);
            return;
        }
        this.doServerFetch(8, 0, this.fetchSize);
        if (!this.scrollWindow.next(this)) {
            this.currentRow = -1;
            return;
        }
        while (this.scrollWindow.next(this)) {
        }
        this.scrollWindow.previous(this);
        this.currentRow = this.isDynamic() ? -2 : this.rowCount;
    }

    public int getRow() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        if (this.isDynamic() && !this.isForwardOnly()) {
            this.throwUnsupportedCursorOp();
        }
        if (!this.hasCurrentRow() || this.isOnInsertRow) {
            return 0;
        }
        if (!$assertionsDisabled && this.currentRow < 1) {
            throw new AssertionError();
        }
        return this.currentRow;
    }

    public boolean absolute(int n) throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + " row:" + n + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        if (this.isDynamic()) {
            this.throwUnsupportedCursorOp();
        }
        this.moverInit();
        this.moveAbsolute(n);
        return this.hasCurrentRow();
    }

    private void moveAbsolute(int n) throws SQLServerException {
        if (!$assertionsDisabled && -2 == this.currentRow) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.isDynamic()) {
            throw new AssertionError();
        }
        switch (n) {
            case 0: {
                this.moveBeforeFirst();
                return;
            }
            case 1: {
                this.moveFirst();
                return;
            }
            case -1: {
                this.moveLast();
                return;
            }
        }
        if (this.hasCurrentRow() && -2 != this.currentRow) {
            if (!$assertionsDisabled && this.currentRow < 1) {
                throw new AssertionError();
            }
            if (n > 0) {
                this.moveRelative(n - this.currentRow);
                return;
            }
            if (-3 != this.rowCount) {
                if (!$assertionsDisabled && n >= 0) {
                    throw new AssertionError();
                }
                this.moveRelative(this.rowCount + n + 1 - this.currentRow);
                return;
            }
        }
        if (0 == this.serverCursorId) {
            this.currentRow = this.clientMoveAbsolute(n);
            return;
        }
        this.doServerFetch(16, n, this.fetchSize);
        if (!this.scrollWindow.next(this)) {
            this.currentRow = n < 0 ? 0 : -1;
            return;
        }
        if (n > 0) {
            this.currentRow = n;
        } else {
            if (!$assertionsDisabled && n >= 0) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && this.rowCount <= 0) {
                throw new AssertionError();
            }
            this.currentRow = this.rowCount + n + 1;
        }
    }

    private final boolean fetchBufferHasRows() throws SQLServerException {
        if (!$assertionsDisabled && 0 != this.serverCursorId) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && null == this.tdsReader) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.lastColumnIndex < 0) {
            throw new AssertionError();
        }
        if (this.lastColumnIndex >= 1) {
            return true;
        }
        int n = this.tdsReader.peekTokenType();
        return 209 == n || 171 == n || 170 == n;
    }

    final void discardCurrentRow() throws SQLServerException {
        if (!$assertionsDisabled && this.lastColumnIndex < 0) {
            throw new AssertionError();
        }
        this.updatedCurrentRow = false;
        this.deletedCurrentRow = false;
        if (this.lastColumnIndex >= 1) {
            for (int i = 1; i < this.lastColumnIndex; ++i) {
                this.getColumn(i).clear();
            }
            this.skipColumns(this.columns.length + 1 - this.lastColumnIndex, true);
        }
    }

    final int fetchBufferGetRow() {
        if (this.isForwardOnly()) {
            return this.numFetchedRows;
        }
        return this.scrollWindow.getRow();
    }

    final void fetchBufferBeforeFirst() throws SQLServerException {
        if (!$assertionsDisabled && 0 != this.serverCursorId) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && null == this.tdsReader) {
            throw new AssertionError();
        }
        this.discardCurrentRow();
        this.fetchBuffer.reset();
        this.lastColumnIndex = 0;
    }

    final TDSReaderMark fetchBufferMark() {
        if (!$assertionsDisabled && null == this.tdsReader) {
            throw new AssertionError();
        }
        return this.tdsReader.mark();
    }

    final void fetchBufferReset(TDSReaderMark tDSReaderMark) throws SQLServerException {
        if (!$assertionsDisabled && null == this.tdsReader) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && null == tDSReaderMark) {
            throw new AssertionError();
        }
        this.discardCurrentRow();
        this.tdsReader.reset(tDSReaderMark);
        this.lastColumnIndex = 1;
    }

    final boolean fetchBufferNext() throws SQLServerException {
        if (null == this.tdsReader) {
            return false;
        }
        this.discardCurrentRow();
        if (!this.fetchBuffer.nextRow()) {
            this.lastColumnIndex = 0;
            return false;
        }
        ++this.numFetchedRows;
        this.lastColumnIndex = 1;
        return true;
    }

    private final void clientMoveAfterLast() throws SQLServerException {
        if (!$assertionsDisabled && -2 == this.currentRow) {
            throw new AssertionError();
        }
        int n = 0;
        while (this.fetchBufferNext()) {
            ++n;
        }
        if (-3 == this.rowCount) {
            if (!$assertionsDisabled && -1 == this.currentRow) {
                throw new AssertionError();
            }
            this.rowCount = (0 == this.currentRow ? 0 : this.currentRow) + n;
        }
    }

    private final int clientMoveAbsolute(int n) throws SQLServerException {
        if (!$assertionsDisabled && 0 != this.serverCursorId) {
            throw new AssertionError();
        }
        this.scrollWindow.clear();
        if (n < 0) {
            if (-3 == this.rowCount) {
                this.clientMoveAfterLast();
                this.currentRow = -1;
            }
            if (!$assertionsDisabled && this.rowCount < 0) {
                throw new AssertionError();
            }
            if (this.rowCount + n < 0) {
                this.moveBeforeFirst();
                return 0;
            }
            n = this.rowCount + n + 1;
        }
        if (!$assertionsDisabled && n <= 0) {
            throw new AssertionError();
        }
        if (-1 == this.currentRow || n <= this.currentRow) {
            this.moveBeforeFirst();
        }
        if (!$assertionsDisabled && 0 != this.currentRow && this.currentRow >= n) {
            throw new AssertionError();
        }
        while (this.currentRow != n) {
            if (!this.fetchBufferNext()) {
                if (-3 == this.rowCount) {
                    this.rowCount = this.currentRow;
                }
                return -1;
            }
            if (0 == this.currentRow) {
                this.currentRow = 1;
                continue;
            }
            ++this.currentRow;
        }
        return n;
    }

    public boolean previous() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.moverInit();
        if (0 == this.currentRow) {
            return false;
        }
        if (-1 == this.currentRow) {
            this.moveLast();
        } else {
            this.moveBackward(-1);
        }
        return this.hasCurrentRow();
    }

    private final void cancelInsert() {
        if (this.isOnInsertRow) {
            this.isOnInsertRow = false;
            this.clearColumnsValues();
        }
    }

    final void clearColumnsValues() {
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            this.columns[i].cancelUpdates();
        }
    }

    public SQLWarning getWarnings() throws SQLServerException {
        return null;
    }

    public void setFetchDirection(int n) throws SQLServerException {
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        if (1000 != n && 1001 != n && 1002 != n || 1000 != n && (2003 == this.stmt.resultSetType || 2004 == this.stmt.resultSetType)) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidFetchDirection"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, messageFormat.format(objectArray), null, false);
        }
        this.fetchDirection = n;
    }

    public int getFetchDirection() throws SQLServerException {
        this.checkClosed();
        return this.fetchDirection;
    }

    public void setFetchSize(int n) throws SQLServerException {
        this.checkClosed();
        if (n < 0) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_invalidFetchSize"), null, false);
        }
        this.fetchSize = 0 == n ? this.stmt.defaultFetchSize : n;
    }

    public int getFetchSize() throws SQLServerException {
        this.checkClosed();
        return this.fetchSize;
    }

    public int getType() throws SQLServerException {
        this.checkClosed();
        return this.stmt.getResultSetType();
    }

    public int getConcurrency() throws SQLServerException {
        this.checkClosed();
        return this.stmt.getResultSetConcurrency();
    }

    private Column getterGetColumn(int n) throws SQLServerException {
        this.checkClosed();
        this.closeActiveStream();
        this.verifyResultSetHasCurrentRow();
        this.verifyCurrentRowIsNotDeleted("R_cantGetColumnValueFromDeletedRow");
        this.verifyValidColumnIndex(n);
        if (this.updatedCurrentRow) {
            this.doRefreshRow();
            this.verifyResultSetHasCurrentRow();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.fine(this.toLogString() + " Getting Column:" + n);
        }
        return this.loadColumn(n);
    }

    public InputStream getAsciiStream(int n) throws SQLServerException {
        Column column = this.getterGetColumn(n);
        column.checkGetAsciiStream();
        InputStream inputStream = (InputStream)column.getValue(1, new InputStreamGetterArgs(3, this.stmt.getExecProps().isResponseBufferingAdaptive(), this.isForwardOnly(), this.toLogString()), null, this.tdsReader);
        this.activeStream = inputStream;
        this.lastValueWasNull = null == inputStream;
        return inputStream;
    }

    public InputStream getAsciiStream(String string) throws SQLServerException {
        return this.getAsciiStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n, int n2) throws SQLServerException {
        BigDecimal bigDecimal = ((BigDecimal)this.getterGetColumn(n).getValue(3, this.tdsReader)).setScale(n2, 1);
        this.lastValueWasNull = null == bigDecimal;
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string, int n) throws SQLServerException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    public InputStream getBinaryStream(int n) throws SQLServerException {
        Column column = this.getterGetColumn(n);
        column.checkGetBinaryStream();
        InputStream inputStream = (InputStream)column.getValue(-4, new InputStreamGetterArgs(1, this.stmt.getExecProps().isResponseBufferingAdaptive(), this.isForwardOnly(), this.toLogString()), null, this.tdsReader);
        this.activeStream = inputStream;
        this.lastValueWasNull = null == inputStream;
        return inputStream;
    }

    public InputStream getBinaryStream(String string) throws SQLServerException {
        return this.getBinaryStream(this.findColumn(string));
    }

    public boolean getBoolean(int n) throws SQLServerException {
        Object object = this.getterGetColumn(n).getValue(-7, this.tdsReader);
        boolean bl = this.lastValueWasNull = null == object;
        if (this.lastValueWasNull) {
            return false;
        }
        return (Boolean)object;
    }

    public boolean getBoolean(String string) throws SQLServerException {
        return this.getBoolean(this.findColumn(string));
    }

    public byte getByte(int n) throws SQLServerException {
        Column column = this.getterGetColumn(n);
        byte by = column.getByte(this.tdsReader);
        this.lastValueWasNull = column.isNull();
        return by;
    }

    public byte getByte(String string) throws SQLServerException {
        return this.getByte(this.findColumn(string));
    }

    public byte[] getBytes(int n) throws SQLServerException {
        byte[] byArray = (byte[])this.getterGetColumn(n).getValue(-2, this.tdsReader);
        this.lastValueWasNull = null == byArray;
        return byArray;
    }

    public byte[] getBytes(String string) throws SQLServerException {
        return this.getBytes(this.findColumn(string));
    }

    public Date getDate(int n) throws SQLServerException {
        return this.getDate(n, null);
    }

    public Date getDate(String string) throws SQLServerException {
        return this.getDate(this.findColumn(string), null);
    }

    public Date getDate(int n, Calendar calendar) throws SQLServerException {
        Date date = (Date)this.getterGetColumn(n).getValue(91, calendar, this.tdsReader);
        this.lastValueWasNull = null == date;
        return date;
    }

    public Date getDate(String string, Calendar calendar) throws SQLServerException {
        return this.getDate(this.findColumn(string), calendar);
    }

    public double getDouble(int n) throws SQLServerException {
        Object object = this.getterGetColumn(n).getValue(8, this.tdsReader);
        boolean bl = this.lastValueWasNull = null == object;
        if (this.lastValueWasNull) {
            return 0.0;
        }
        return (Double)object;
    }

    public double getDouble(String string) throws SQLServerException {
        return this.getDouble(this.findColumn(string));
    }

    public float getFloat(int n) throws SQLServerException {
        Object object = this.getterGetColumn(n).getValue(6, this.tdsReader);
        boolean bl = this.lastValueWasNull = null == object;
        if (this.lastValueWasNull) {
            return 0.0f;
        }
        return ((Float)object).floatValue();
    }

    public float getFloat(String string) throws SQLServerException {
        return this.getFloat(this.findColumn(string));
    }

    public int getInt(int n) throws SQLServerException {
        Column column = this.getterGetColumn(n);
        int n2 = column.getInt(this.tdsReader);
        this.lastValueWasNull = column.isNull();
        return n2;
    }

    public int getInt(String string) throws SQLServerException {
        return this.getInt(this.findColumn(string));
    }

    public long getLong(int n) throws SQLServerException {
        Object object = this.getterGetColumn(n).getValue(-5, this.tdsReader);
        boolean bl = this.lastValueWasNull = null == object;
        if (this.lastValueWasNull) {
            return 0L;
        }
        return (Long)object;
    }

    public long getLong(String string) throws SQLServerException {
        return this.getLong(this.findColumn(string));
    }

    public ResultSetMetaData getMetaData() throws SQLServerException {
        this.checkClosed();
        if (this.metaData == null) {
            this.metaData = new SQLServerResultSetMetaData(this.stmt.connection, this);
        }
        return this.metaData;
    }

    public Object getObject(int n) throws SQLServerException {
        int n2;
        Column column = this.getterGetColumn(n);
        Object object = column.getValue(n2 = DataTypes.nativeTypeToJdbcType(this.stmt.connection, column.getTypeInfo().getNativeType(), column.getTypeInfo().getMaxLength()), this.tdsReader);
        boolean bl = this.lastValueWasNull = null == object;
        if (this.lastValueWasNull) {
            return null;
        }
        if (object instanceof InputStream || object instanceof Reader) {
            this.activeStream = object;
        }
        return object;
    }

    public Object getObject(String string) throws SQLServerException {
        return this.getObject(this.findColumn(string));
    }

    public short getShort(int n) throws SQLServerException {
        Column column = this.getterGetColumn(n);
        short s = column.getShort(this.tdsReader);
        this.lastValueWasNull = column.isNull();
        return s;
    }

    public short getShort(String string) throws SQLServerException {
        return this.getShort(this.findColumn(string));
    }

    public String getString(int n) throws SQLServerException {
        String string = (String)this.getterGetColumn(n).getValue(1, this.tdsReader);
        this.lastValueWasNull = null == string;
        return string;
    }

    public String getString(String string) throws SQLServerException {
        return this.getString(this.findColumn(string));
    }

    public Time getTime(int n) throws SQLServerException {
        return this.getTime(n, null);
    }

    public Time getTime(String string) throws SQLServerException {
        return this.getTime(this.findColumn(string), null);
    }

    public Time getTime(int n, Calendar calendar) throws SQLServerException {
        Time time = (Time)this.getterGetColumn(n).getValue(92, calendar, this.tdsReader);
        this.lastValueWasNull = null == time;
        return time;
    }

    public Time getTime(String string, Calendar calendar) throws SQLServerException {
        return this.getTime(this.findColumn(string), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLServerException {
        return this.getTimestamp(n, null);
    }

    public Timestamp getTimestamp(String string) throws SQLServerException {
        return this.getTimestamp(this.findColumn(string), null);
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLServerException {
        Timestamp timestamp = (Timestamp)this.getterGetColumn(n).getValue(93, calendar, this.tdsReader);
        this.lastValueWasNull = null == timestamp;
        return timestamp;
    }

    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLServerException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    public InputStream getUnicodeStream(int n) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public InputStream getUnicodeStream(String string) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Object getObject(int n, Map map) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Ref getRef(int n) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Blob getBlob(int n) throws SQLServerException {
        Blob blob = (Blob)this.getterGetColumn(n).getValue(2004, this.tdsReader);
        this.lastValueWasNull = null == blob;
        return blob;
    }

    public Clob getClob(int n) throws SQLServerException {
        Column column = this.getterGetColumn(n);
        SQLServerClob sQLServerClob = (SQLServerClob)column.getValue(2005, this.tdsReader);
        boolean bl = this.lastValueWasNull = null == sQLServerClob;
        if (null != sQLServerClob) {
            sQLServerClob.setSQLCollation(column.getTypeInfo().getSQLCollation());
        }
        return sQLServerClob;
    }

    public Array getArray(int n) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Object getObject(String string, Map map) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Ref getRef(String string) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public Blob getBlob(String string) throws SQLServerException {
        return this.getBlob(this.findColumn(string));
    }

    public Clob getClob(String string) throws SQLServerException {
        return this.getClob(this.findColumn(string));
    }

    public Array getArray(String string) throws SQLServerException {
        this.NotImplemented();
        return null;
    }

    public String getCursorName() throws SQLServerException {
        SQLServerException.makeFromDriverError(null, null, SQLServerException.getErrString("R_positionedUpdatesNotSupported"), null, false);
        return null;
    }

    public Reader getCharacterStream(int n) throws SQLServerException {
        Object object;
        Column column = this.getterGetColumn(n);
        column.checkGetCharacterStream();
        this.activeStream = object = column.getValue(-1, new InputStreamGetterArgs(2, this.stmt.getExecProps().isResponseBufferingAdaptive(), this.isForwardOnly(), this.toLogString()), null, this.tdsReader);
        if (null != object && object instanceof InputStream) {
            try {
                object = new BufferedReader(new InputStreamReader((InputStream)object, "UTF-16LE"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SQLServerException(null, unsupportedEncodingException.getMessage(), null, 0, true);
            }
        }
        this.lastValueWasNull = null == object;
        return (Reader)object;
    }

    public Reader getCharacterStream(String string) throws SQLServerException {
        return this.getCharacterStream(this.findColumn(string));
    }

    public BigDecimal getBigDecimal(int n) throws SQLServerException {
        BigDecimal bigDecimal = (BigDecimal)this.getterGetColumn(n).getValue(3, this.tdsReader);
        this.lastValueWasNull = null == bigDecimal;
        return bigDecimal;
    }

    public BigDecimal getBigDecimal(String string) throws SQLServerException {
        return this.getBigDecimal(this.findColumn(string));
    }

    public boolean rowUpdated() throws SQLServerException {
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        return false;
    }

    public boolean rowInserted() throws SQLServerException {
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        return false;
    }

    public boolean rowDeleted() throws SQLServerException {
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        if (this.isOnInsertRow || !this.hasCurrentRow()) {
            return false;
        }
        return this.currentRowDeleted();
    }

    private final boolean currentRowDeleted() throws SQLServerException {
        if (!$assertionsDisabled && !this.hasCurrentRow()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && null == this.tdsReader) {
            throw new AssertionError();
        }
        return this.deletedCurrentRow || 0 != this.serverCursorId && 2 == this.loadColumn(this.columns.length).getInt(this.tdsReader);
    }

    private final Column updaterGetColumn(int n) throws SQLServerException {
        this.checkClosed();
        this.closeActiveStream();
        this.verifyResultSetIsUpdatable();
        if (!this.isOnInsertRow) {
            if (!this.hasCurrentRow()) {
                SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_resultsetNoCurrentRow"), null, true);
            }
            this.verifyCurrentRowIsNotDeleted("R_cantUpdateDeletedRow");
        }
        this.verifyValidColumnIndex(n);
        return this.getColumn(n);
    }

    public void updateNull(int n) throws SQLServerException {
        Column column = this.updaterGetColumn(n);
        int n2 = DataTypes.nativeTypeToJdbcType(this.stmt.connection, column.getTypeInfo().getNativeType(), column.getTypeInfo().getMaxLength());
        column.updateValue(n2, null, this.stmt.connection);
    }

    public void updateBoolean(int n, boolean bl) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(-7, new Boolean(bl), this.stmt.connection);
    }

    public void updateByte(int n, byte by) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(5, new Byte(by), this.stmt.connection);
    }

    public void updateShort(int n, short s) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(5, new Short(s), this.stmt.connection);
    }

    public void updateInt(int n, int n2) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(4, new Integer(n2), this.stmt.connection);
    }

    public void updateLong(int n, long l) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(-5, new Long(l), this.stmt.connection);
    }

    public void updateFloat(int n, float f) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(7, new Float(f), this.stmt.connection);
    }

    public void updateDouble(int n, double d) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(8, new Double(d), this.stmt.connection);
    }

    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(3, bigDecimal, this.stmt.connection);
    }

    public void updateString(int n, String string) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(1, string, this.stmt.connection);
    }

    public void updateBytes(int n, byte[] byArray) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(-2, byArray, this.stmt.connection);
    }

    public void updateDate(int n, Date date) throws SQLServerException {
        Column column = this.updaterGetColumn(n);
        column.updateValue(91, date, this.stmt.connection);
    }

    public void updateTime(int n, Time time) throws SQLServerException {
        Column column = this.updaterGetColumn(n);
        column.updateValue(92, time, this.stmt.connection);
    }

    public void updateTimestamp(int n, Timestamp timestamp) throws SQLServerException {
        Column column = this.updaterGetColumn(n);
        column.updateValue(93, timestamp, this.stmt.connection);
    }

    private void checkLength(int n) throws SQLServerException {
        if (n < -1) {
            MessageFormat messageFormat = new MessageFormat(SQLServerException.getErrString("R_invalidLength"));
            Object[] objectArray = new Object[]{new Integer(n)};
            SQLServerException.makeFromDriverError(this.stmt.connection, this, messageFormat.format(objectArray), null, false);
        }
    }

    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLServerException {
        this.checkClosed();
        this.checkLength(n2);
        Column column = this.updaterGetColumn(n);
        column.checkUpdateAsciiStream();
        column.updateValue(-1, inputStream, new InputStreamSetterArgs(3, n2), this.stmt.connection);
    }

    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLServerException {
        this.checkClosed();
        this.checkLength(n2);
        Column column = this.updaterGetColumn(n);
        column.checkUpdateBinaryStream();
        column.updateValue(-4, inputStream, new InputStreamSetterArgs(1, n2), this.stmt.connection);
    }

    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLServerException {
        this.checkClosed();
        this.checkLength(n2);
        Column column = this.updaterGetColumn(n);
        column.checkUpdateCharacterStream();
        column.updateValue(-1, reader, new CharacterStreamSetterArgs(n2), this.stmt.connection);
    }

    public void updateObject(int n, Object object) throws SQLServerException {
        this.updateObject(n, object, (Integer)null);
    }

    public void updateObject(int n, Object object, int n2) throws SQLServerException {
        this.updateObject(n, object, new Integer(n2));
    }

    private final void updateObject(int n, Object object, Integer n2) throws SQLServerException {
        Column column = this.updaterGetColumn(n);
        int n3 = DataTypes.nativeTypeToJdbcType(this.stmt.connection, column.getTypeInfo().getNativeType(), column.getTypeInfo().getMaxLength());
        int n4 = DataTypes.getObjectJDBCType(object, n3);
        if (Reader.class.isInstance(object)) {
            column.updateValue(n4, object, new CharacterStreamSetterArgs(-1), this.stmt.connection);
        } else if (InputStream.class.isInstance(object)) {
            column.updateValue(n4, object, new InputStreamSetterArgs(DataTypes.isBinary(column.getTypeInfo().getNativeType()) ? 1 : 3, -1L), this.stmt.connection);
        } else {
            column.updateValue(n4, object, n2, this.stmt.connection);
        }
    }

    public void updateNull(String string) throws SQLServerException {
        this.checkClosed();
        this.updateNull(this.findColumn(string));
    }

    public void updateBoolean(String string, boolean bl) throws SQLServerException {
        this.checkClosed();
        this.updateBoolean(this.findColumn(string), bl);
    }

    public void updateByte(String string, byte by) throws SQLServerException {
        this.checkClosed();
        this.updateByte(this.findColumn(string), by);
    }

    public void updateShort(String string, short s) throws SQLServerException {
        this.checkClosed();
        this.updateShort(this.findColumn(string), s);
    }

    public void updateInt(String string, int n) throws SQLServerException {
        this.checkClosed();
        this.updateInt(this.findColumn(string), n);
    }

    public void updateLong(String string, long l) throws SQLServerException {
        this.checkClosed();
        this.updateLong(this.findColumn(string), l);
    }

    public void updateFloat(String string, float f) throws SQLServerException {
        this.checkClosed();
        this.updateFloat(this.findColumn(string), f);
    }

    public void updateDouble(String string, double d) throws SQLServerException {
        this.checkClosed();
        this.updateDouble(this.findColumn(string), d);
    }

    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLServerException {
        this.checkClosed();
        this.updateBigDecimal(this.findColumn(string), bigDecimal);
    }

    public void updateString(String string, String string2) throws SQLServerException {
        this.checkClosed();
        this.updateString(this.findColumn(string), string2);
    }

    public void updateBytes(String string, byte[] byArray) throws SQLServerException {
        this.checkClosed();
        this.updateBytes(this.findColumn(string), byArray);
    }

    public void updateDate(String string, Date date) throws SQLServerException {
        this.checkClosed();
        this.updateDate(this.findColumn(string), date);
    }

    public void updateTime(String string, Time time) throws SQLServerException {
        this.checkClosed();
        this.updateTime(this.findColumn(string), time);
    }

    public void updateTimestamp(String string, Timestamp timestamp) throws SQLServerException {
        this.checkClosed();
        this.updateTimestamp(this.findColumn(string), timestamp);
    }

    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLServerException {
        this.checkClosed();
        this.updateAsciiStream(this.findColumn(string), inputStream, n);
    }

    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLServerException {
        this.checkClosed();
        this.updateBinaryStream(this.findColumn(string), inputStream, n);
    }

    public void updateCharacterStream(String string, Reader reader, int n) throws SQLServerException {
        this.checkClosed();
        this.updateCharacterStream(this.findColumn(string), reader, n);
    }

    public void updateObject(String string, Object object, int n) throws SQLServerException {
        this.checkClosed();
        this.updateObject(this.findColumn(string), object, n);
    }

    public void updateObject(String string, Object object) throws SQLServerException {
        this.checkClosed();
        this.updateObject(this.findColumn(string), object);
    }

    public void insertRow() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.closeActiveStream();
        this.verifyResultSetIsUpdatable();
        if (!this.isOnInsertRow) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_mustBeOnInsertRow"), null, true);
        }
        final class InsertRowRPC
        extends TDSCommand {
            InsertRowRPC() {
                super("InsertRowRPC", 0);
            }

            final boolean doExecute() throws SQLServerException {
                SQLServerResultSet.this.doInsertRowRPC(this);
                return true;
            }
        }
        this.stmt.executeCommand(new InsertRowRPC());
        if (-3 != this.rowCount) {
            ++this.rowCount;
        }
    }

    private final void doInsertRowRPC(TDSCommand tDSCommand) throws SQLServerException {
        if (!$assertionsDisabled && 0 == this.serverCursorId) {
            throw new AssertionError();
        }
        TDSWriter tDSWriter = tDSCommand.startRequest((byte)3);
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)1);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(this.serverCursorId), false);
        tDSWriter.writeRPCInt(null, new Integer(4), false);
        tDSWriter.writeRPCInt(null, new Integer(this.fetchBufferGetRow()), false);
        tDSWriter.writeRPCString("");
        if (this.hasUpdatedColumns()) {
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i].sendByRPC(tDSWriter, this.stmt.connection, i);
            }
        } else {
            if (null == this.cursorTableName) {
                if (null == this.stmt.getPreparedSQL()) {
                    SQLServerException.makeFromDriverError(this.stmt.connection, this, SQLServerException.getErrString("R_noColumnParameterValue"), null, true);
                }
                this.cursorTableName = new SQLServerParameterMetaData(this.stmt, this.stmt.getPreparedSQL()).getTableName();
            }
            if (!$assertionsDisabled && null == this.cursorTableName) {
                throw new AssertionError();
            }
            tDSWriter.writeRPCString("INSERT " + this.cursorTableName + " DEFAULT VALUES");
        }
        TDSParser.parse(tDSCommand.startResponse(), tDSCommand.getLogContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRow() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.closeActiveStream();
        this.verifyResultSetIsUpdatable();
        this.verifyResultSetIsNotOnInsertRow();
        this.verifyResultSetHasCurrentRow();
        this.verifyCurrentRowIsNotDeleted("R_cantUpdateDeletedRow");
        if (!this.hasUpdatedColumns()) {
            SQLServerException.makeFromDriverError(this.stmt.connection, this.stmt, SQLServerException.getErrString("R_noColumnParameterValue"), null, true);
        }
        try {
            final class UpdateRowRPC
            extends TDSCommand {
                UpdateRowRPC() {
                    super("UpdateRowRPC", 0);
                }

                final boolean doExecute() throws SQLServerException {
                    SQLServerResultSet.this.doUpdateRowRPC(this);
                    return true;
                }
            }
            this.stmt.executeCommand(new UpdateRowRPC());
        }
        finally {
            this.cancelUpdates();
        }
        this.updatedCurrentRow = true;
    }

    private final void doUpdateRowRPC(TDSCommand tDSCommand) throws SQLServerException {
        if (!$assertionsDisabled && 0 == this.serverCursorId) {
            throw new AssertionError();
        }
        TDSWriter tDSWriter = tDSCommand.startRequest((byte)3);
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)1);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(this.serverCursorId), false);
        tDSWriter.writeRPCInt(null, new Integer(33), false);
        tDSWriter.writeRPCInt(null, new Integer(this.fetchBufferGetRow()), false);
        tDSWriter.writeRPCString("");
        if (!$assertionsDisabled && !this.hasUpdatedColumns()) {
            throw new AssertionError();
        }
        for (int i = 0; i < this.columns.length; ++i) {
            this.columns[i].sendByRPC(tDSWriter, this.stmt.connection, i);
        }
        TDSParser.parse(tDSCommand.startResponse(), tDSCommand.getLogContext());
    }

    final boolean hasUpdatedColumns() {
        for (int i = 0; i < this.columns.length; ++i) {
            if (!this.columns[i].hasUpdates()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteRow() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.closeActiveStream();
        this.verifyResultSetIsUpdatable();
        this.verifyResultSetIsNotOnInsertRow();
        this.verifyResultSetHasCurrentRow();
        this.verifyCurrentRowIsNotDeleted("R_cantUpdateDeletedRow");
        try {
            final class DeleteRowRPC
            extends TDSCommand {
                DeleteRowRPC() {
                    super("DeleteRowRPC", 0);
                }

                final boolean doExecute() throws SQLServerException {
                    SQLServerResultSet.this.doDeleteRowRPC(this);
                    return true;
                }
            }
            this.stmt.executeCommand(new DeleteRowRPC());
        }
        finally {
            this.cancelUpdates();
        }
        this.deletedCurrentRow = true;
    }

    private final void doDeleteRowRPC(TDSCommand tDSCommand) throws SQLServerException {
        if (!$assertionsDisabled && 0 == this.serverCursorId) {
            throw new AssertionError();
        }
        TDSWriter tDSWriter = tDSCommand.startRequest((byte)3);
        tDSWriter.writeShort((short)-1);
        tDSWriter.writeShort((short)1);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeByte((byte)0);
        tDSWriter.writeRPCInt(null, new Integer(this.serverCursorId), false);
        tDSWriter.writeRPCInt(null, new Integer(34), false);
        tDSWriter.writeRPCInt(null, new Integer(this.fetchBufferGetRow()), false);
        tDSWriter.writeRPCString("");
        TDSParser.parse(tDSCommand.startResponse(), tDSCommand.getLogContext());
    }

    public void refreshRow() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsScrollable();
        this.verifyResultSetIsUpdatable();
        this.verifyResultSetIsNotOnInsertRow();
        this.verifyResultSetHasCurrentRow();
        this.verifyCurrentRowIsNotDeleted("R_cantUpdateDeletedRow");
        if (1004 == this.stmt.getResultSetType() || 0 == this.serverCursorId) {
            return;
        }
        this.cancelUpdates();
        this.doRefreshRow();
    }

    private void doRefreshRow() throws SQLServerException {
        int n;
        if (!$assertionsDisabled && !this.hasCurrentRow()) {
            throw new AssertionError();
        }
        this.closeActiveStream();
        int n2 = this.fetchBufferGetRow();
        this.doServerFetch(128, 0, 0);
        for (n = 0; n < n2 && (this.isForwardOnly() ? this.fetchBufferNext() : this.scrollWindow.next(this)); ++n) {
        }
        if (n < n2) {
            this.currentRow = -1;
            return;
        }
        this.updatedCurrentRow = false;
    }

    private final void cancelUpdates() {
        if (!this.isOnInsertRow) {
            this.clearColumnsValues();
        }
    }

    public void cancelRowUpdates() throws SQLServerException {
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        this.verifyResultSetIsNotOnInsertRow();
        this.cancelUpdates();
    }

    public void moveToInsertRow() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        this.cancelUpdates();
        this.isOnInsertRow = true;
    }

    public void moveToCurrentRow() throws SQLServerException {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + this.logCursorState());
        }
        this.checkClosed();
        this.verifyResultSetIsUpdatable();
        this.cancelInsert();
    }

    public Statement getStatement() throws SQLServerException {
        this.checkClosed();
        return this.stmt;
    }

    public void updateClob(int n, Clob clob) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(2005, clob, this.stmt.connection);
    }

    public void updateClob(String string, Clob clob) throws SQLServerException {
        this.checkClosed();
        this.updateClob(this.findColumn(string), clob);
    }

    public void updateBlob(int n, Blob blob) throws SQLServerException {
        this.updaterGetColumn(n).updateValue(2004, blob, this.stmt.connection);
    }

    public void updateBlob(String string, Blob blob) throws SQLServerException {
        this.checkClosed();
        this.updateBlob(this.findColumn(string), blob);
    }

    public void updateArray(int n, Array array) throws SQLServerException {
        this.stmt.NotImplemented();
    }

    public void updateArray(String string, Array array) throws SQLServerException {
        this.stmt.NotImplemented();
    }

    public void updateRef(int n, Ref ref) throws SQLServerException {
        this.stmt.NotImplemented();
    }

    public void updateRef(String string, Ref ref) throws SQLServerException {
        this.stmt.NotImplemented();
    }

    public URL getURL(int n) throws SQLServerException {
        this.stmt.NotImplemented();
        return null;
    }

    public URL getURL(String string) throws SQLServerException {
        this.stmt.NotImplemented();
        return null;
    }

    final void doServerFetch(int n, int n2, int n3) throws SQLServerException {
        if (logger.isLoggable(Level.FINER)) {
            logger.fine(this.toLogString() + " fetchType:" + n + " startRow:" + n2 + " numRows:" + n3);
        }
        this.fetchBuffer.clearStartMark();
        if (null != this.scrollWindow) {
            this.scrollWindow.clear();
        }
        while (this.fetchBufferNext()) {
        }
        final class CursorFetchCommand
        extends TDSCommand {
            private final int serverCursorId;
            private int fetchType;
            private int startRow;
            private int numRows;

            CursorFetchCommand(int n, int n2, int n3, int n4) {
                super("doServerFetch", SQLServerResultSet.this.stmt.queryTimeout);
                this.serverCursorId = n;
                this.fetchType = n2;
                this.startRow = n3;
                this.numRows = n4;
            }

            final boolean doExecute() throws SQLServerException {
                TDSWriter tDSWriter = this.startRequest((byte)3);
                tDSWriter.writeShort((short)-1);
                tDSWriter.writeShort((short)7);
                tDSWriter.writeByte((byte)2);
                tDSWriter.writeByte((byte)0);
                tDSWriter.writeRPCInt(null, new Integer(this.serverCursorId), false);
                tDSWriter.writeRPCInt(null, new Integer(this.fetchType), false);
                tDSWriter.writeRPCInt(null, new Integer(this.startRow), false);
                tDSWriter.writeRPCInt(null, new Integer(this.numRows), false);
                SQLServerResultSet.this.tdsReader = this.startResponse(SQLServerResultSet.this.isForwardOnly() && 1007 != SQLServerResultSet.this.stmt.resultSetConcurrency && SQLServerResultSet.this.stmt.getExecProps().wasResponseBufferingSet() && SQLServerResultSet.this.stmt.getExecProps().isResponseBufferingAdaptive());
                final class ServerFetchHandler
                extends TDSTokenHandler {
                    private final /* synthetic */ SQLServerResultSet this$0;

                    ServerFetchHandler(SQLServerResultSet sQLServerResultSet) {
                        this.this$0 = sQLServerResultSet;
                        super("ServerFetchHandler");
                    }

                    boolean onColMetaData(TDSReader tDSReader) throws SQLServerException {
                        new StreamColumns().setFromTDS(tDSReader);
                        return false;
                    }
                }
                TDSParser.parse(SQLServerResultSet.this.tdsReader, new ServerFetchHandler(SQLServerResultSet.this));
                return false;
            }

            final void processResponse(TDSReader tDSReader) throws SQLServerException {
                TDSParser.parse(tDSReader, new ServerFetchHandler(SQLServerResultSet.this));
                SQLServerResultSet.this.processCursorFetch(tDSReader);
            }
        }
        this.stmt.executeCommand(new CursorFetchCommand(this.serverCursorId, n, n2, n3));
        this.fetchBuffer.init(this.tdsReader, !this.isForwardOnly());
        this.numFetchedRows = 0;
        this.lastColumnIndex = 0;
        if (null != this.scrollWindow && 128 != n) {
            this.scrollWindow.resize(this.fetchSize);
        }
        if (n3 < 0 || n2 < 0) {
            block9: {
                try {
                    while (this.scrollWindow.next(this)) {
                    }
                }
                catch (SQLException sQLException) {
                    if (!logger.isLoggable(Level.FINE)) break block9;
                    logger.fine(this.toLogString() + " Ignored exception from row error during server cursor fixup: " + sQLException.getMessage());
                }
            }
            final class ServerCursorFixup
            extends TDSTokenHandler {
                boolean isNeeded;

                ServerCursorFixup() {
                    super("ServerCursorFixup");
                    this.isNeeded = false;
                }

                boolean onRetStatus(TDSReader tDSReader) throws SQLServerException {
                    StreamRetStatus streamRetStatus = new StreamRetStatus();
                    streamRetStatus.setFromTDS(tDSReader);
                    this.isNeeded = 2 == streamRetStatus.getStatus();
                    return false;
                }
            }
            ServerCursorFixup serverCursorFixup = new ServerCursorFixup();
            TDSParser.parse(this.tdsReader, serverCursorFixup);
            if (serverCursorFixup.isNeeded) {
                this.doServerFetch(1, 0, 0);
                return;
            }
            this.scrollWindow.reset();
        }
    }

    private final void processCursorFetch(TDSReader tDSReader) throws SQLServerException {
        this.tdsReader = tDSReader;
        this.fetchBuffer.init(tDSReader, !this.isForwardOnly());
        while (this.fetchBufferNext()) {
        }
    }

    final void closeServerCursor() throws SQLServerException {
        if (!$assertionsDisabled && 0 == this.serverCursorId) {
            throw new AssertionError();
        }
        if (this.stmt.connection.isClosed()) {
            return;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + " Closing cursor:" + this.serverCursorId);
        }
        try {
            final class CloseServerCursorCommand
            extends UninterruptableTDSCommand {
                CloseServerCursorCommand() {
                    super("closeServerCursor");
                }

                final boolean doExecute() throws SQLServerException {
                    this.startRequest((byte)1).writeString("sp_cursorclose " + SQLServerResultSet.this.serverCursorId);
                    TDSParser.parse(this.startResponse(), this.getLogContext());
                    return true;
                }
            }
            this.stmt.executeCommand(new CloseServerCursorCommand());
        }
        catch (SQLServerException sQLServerException) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine(this.toLogString() + " Error closing cursor:" + this.serverCursorId + " " + sQLServerException.getMessage());
            }
            throw sQLServerException;
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.toLogString() + " Closed cursor:" + this.serverCursorId);
        }
    }

    static {
        $assertionsDisabled = !SQLServerResultSet.class.desiredAssertionStatus();
        lastResultSetID = 0;
        logger = Logger.getLogger("com.microsoft.sqlserver.jdbc.SQLServerResultSet");
    }

    private class FetchBuffer {
        private TDSReader tdsReader = null;
        private TDSReaderMark startMark = null;
        private boolean foundRow = false;
        private boolean done = false;
        private final FetchBufferTokenHandler tokenHandler = new FetchBufferTokenHandler();
        static final /* synthetic */ boolean $assertionsDisabled;

        FetchBuffer() {
        }

        final void clearStartMark() {
            this.startMark = null;
        }

        final void reset() {
            if (!$assertionsDisabled && null == this.tdsReader) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && null == this.startMark) {
                throw new AssertionError();
            }
            this.tdsReader.reset(this.startMark);
            this.foundRow = false;
            this.done = false;
        }

        final void init(TDSReader tDSReader, boolean bl) {
            this.tdsReader = tDSReader;
            if (null != tDSReader && bl) {
                this.startMark = tDSReader.mark();
            }
            this.foundRow = false;
            this.done = false;
        }

        final boolean nextRow() throws SQLServerException {
            this.foundRow = false;
            if (!this.done) {
                if (!$assertionsDisabled && null == this.tdsReader) {
                    throw new AssertionError();
                }
                TDSParser.parse(this.tdsReader, this.tokenHandler);
            }
            return this.foundRow;
        }

        static {
            $assertionsDisabled = !(class$com$microsoft$sqlserver$jdbc$SQLServerResultSet == null ? (class$com$microsoft$sqlserver$jdbc$SQLServerResultSet = SQLServerResultSet.class$("com.microsoft.sqlserver.jdbc.SQLServerResultSet")) : class$com$microsoft$sqlserver$jdbc$SQLServerResultSet).desiredAssertionStatus();
        }

        class FetchBufferTokenHandler
        extends TDSTokenHandler {
            static final /* synthetic */ boolean $assertionsDisabled;

            FetchBufferTokenHandler() {
                super("FetchBufferTokenHandler");
            }

            boolean onRow(TDSReader tDSReader) throws SQLServerException {
                if (209 != tDSReader.readUnsignedByte() && !$assertionsDisabled) {
                    throw new AssertionError();
                }
                FetchBuffer.this.foundRow = true;
                return false;
            }

            boolean onDone(TDSReader tDSReader) throws SQLServerException {
                StreamDone streamDone = new StreamDone();
                streamDone.setFromTDS(tDSReader);
                FetchBuffer.this.done = true;
                return false;
            }

            static {
                $assertionsDisabled = !(class$com$microsoft$sqlserver$jdbc$SQLServerResultSet == null ? (class$com$microsoft$sqlserver$jdbc$SQLServerResultSet = SQLServerResultSet.class$("com.microsoft.sqlserver.jdbc.SQLServerResultSet")) : class$com$microsoft$sqlserver$jdbc$SQLServerResultSet).desiredAssertionStatus();
            }
        }
    }
}

