#
# PySNMP MIB module GSMP-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/GSMP-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:14:33 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( OctetString, ObjectIdentifier, Integer, ) = mibBuilder.importSymbols("ASN1", "OctetString", "ObjectIdentifier", "Integer")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ValueRangeConstraint, ConstraintsIntersection, SingleValueConstraint, ConstraintsUnion, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ValueRangeConstraint", "ConstraintsIntersection", "SingleValueConstraint", "ConstraintsUnion", "ValueSizeConstraint")
( AtmVcIdentifier, AtmVpIdentifier, ) = mibBuilder.importSymbols("ATM-TC-MIB", "AtmVcIdentifier", "AtmVpIdentifier")
( InterfaceIndex, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndex")
( InetAddress, InetAddressType, InetPortNumber, ) = mibBuilder.importSymbols("INET-ADDRESS-MIB", "InetAddress", "InetAddressType", "InetPortNumber")
( ZeroBasedCounter32, ) = mibBuilder.importSymbols("RMON2-MIB", "ZeroBasedCounter32")
( NotificationGroup, ObjectGroup, ModuleCompliance, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ObjectGroup", "ModuleCompliance")
( Counter32, TimeTicks, ObjectIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, Unsigned32, Counter64, mib_2, ModuleIdentity, Bits, Integer32, NotificationType, iso, IpAddress, Gauge32, MibIdentifier, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Counter32", "TimeTicks", "ObjectIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "Unsigned32", "Counter64", "mib-2", "ModuleIdentity", "Bits", "Integer32", "NotificationType", "iso", "IpAddress", "Gauge32", "MibIdentifier")
( StorageType, TruthValue, DisplayString, TextualConvention, RowStatus, TimeStamp, ) = mibBuilder.importSymbols("SNMPv2-TC", "StorageType", "TruthValue", "DisplayString", "TextualConvention", "RowStatus", "TimeStamp")
gsmpMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 98)).setRevisions(("2002-05-31 00:00",))
if mibBuilder.loadTexts: gsmpMIB.setLastUpdated('200205310000Z')
if mibBuilder.loadTexts: gsmpMIB.setOrganization('General Switch Management Protocol (gsmp)\n                      Working Group, IETF')
if mibBuilder.loadTexts: gsmpMIB.setContactInfo('WG Charter:\n               http://www.ietf.org/html.charters/gsmp-charter.html\n\n               WG-email:          gsmp@ietf.org\n               Subscribe:         gsmp-request@ietf.org\n               Email Archive:\n               ftp://ftp.ietf.org/ietf-mail-archive/gsmp/\n\n               WG Chair:    Avri Doria\n               Email:       avri@acm.org\n\n               WG Chair:    Kenneth Sundell\n               Email:       ksundell@nortelnetworks.com\n\n               Editor:      Hans Sjostrand\n               Email:       hans@ipunplugged.com\n\n\n\n\n               Editor:      Joachim Buerkle\n               Email:       joachim.buerkle@nortelnetworks.com\n\n               Editor:      Balaji Srinivasan\n               Email:       balaji@cplane.com')
if mibBuilder.loadTexts: gsmpMIB.setDescription('This MIB contains managed object definitions for the\n            General Switch Management Protocol, GSMP, version 3')
gsmpNotifications = MibIdentifier((1, 3, 6, 1, 2, 1, 98, 0))
gsmpObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 98, 1))
gsmpNotificationsObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 98, 2))
gsmpConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 98, 3))
class GsmpNameType(OctetString, TextualConvention):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(6,6)
    fixedLength = 6

class GsmpPartitionType(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ConstraintsUnion(SingleValueConstraint(1, 2, 3,))
    namedValues = NamedValues(("noPartition", 1), ("fixedPartitionRequest", 2), ("fixedPartitionAssigned", 3),)

class GsmpPartitionIdType(OctetString, TextualConvention):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(1,1)
    fixedLength = 1

class GsmpVersion(Unsigned32, TextualConvention):
    pass

class GsmpLabelType(OctetString, TextualConvention):
    pass

gsmpControllerTable = MibTable((1, 3, 6, 1, 2, 1, 98, 1, 1), )
if mibBuilder.loadTexts: gsmpControllerTable.setDescription('This table represents the Switch Controller\n             Entities. An entry in this table needs to be configured\n             (created) before a GSMP session might be started.')
gsmpControllerEntry = MibTableRow((1, 3, 6, 1, 2, 1, 98, 1, 1, 1), ).setIndexNames((0, "GSMP-MIB", "gsmpControllerEntityId"))
if mibBuilder.loadTexts: gsmpControllerEntry.setDescription('An entry in the table showing\n              the data for a specific Switch Controller\n              Entity. If partitions are used, one entity\n              corresponds to one specific switch partition.\n              Depending of the encapsulation used,\n              a corresponding row in the gsmpAtmEncapTable or the\n              gsmpTcpIpEncapTable may have been created.')
gsmpControllerEntityId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 1), GsmpNameType())
if mibBuilder.loadTexts: gsmpControllerEntityId.setDescription('The Switch Controller Entity Id is unique\n              within the operational context of the device.')
gsmpControllerMaxVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 2), GsmpVersion().clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerMaxVersion.setDescription('The max version number of the GSMP protocol being used\n             in this session. The version is negotiated by the\n             adjacency protocol.')
gsmpControllerTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,255)).clone(10)).setUnits('100ms').setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerTimer.setDescription('The timer specifies the nominal time between\n           periodic adjacency protocol messages. It is a constant\n           for the duration of a GSMP session. The timer is\n           specified in units of 100ms.')
gsmpControllerPort = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 4), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerPort.setDescription('The local port number for the Switch Controller\n           Entity.')
gsmpControllerInstance = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 5), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,16777215))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpControllerInstance.setDescription('The instance number for the Switch Controller\n           Entity. The Instance number is a 24-bit number\n           that should be guaranteed to be unique within\n           the recent past and to change when the link\n           or node comes back up after going down. Zero is\n           not a valid instance number. ')
gsmpControllerPartitionType = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 6), GsmpPartitionType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerPartitionType.setDescription('A controller can request the specific partition identifier\n          to the session by setting the Partition Type to\n          fixedPartitionRequest(2). A controller can let the switch\n          decide whether it wants to assign a fixed partition ID or\n\n\n\n          not, by setting the Partition Type to noPartition(1).')
gsmpControllerPartitionId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 7), GsmpPartitionIdType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerPartitionId.setDescription('The Id for the specific switch partition that this\n           Switch Controller is concerned with.\n           If partitions are not used or if the controller lets the\n           switch assigns Partition ID, i.e Partition Type =\n           noPartition(1), then this object is undefined.')
gsmpControllerDoResync = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 8), TruthValue().clone('true')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerDoResync.setDescription('This object specifies whether the controller should\n           resynchronise or reset in case of loss of synchronisation.\n           If this object is set to true then the Controller should\n           resync with PFLAG=2 (recovered adjacency).')
gsmpControllerNotificationMap = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 9), Bits().clone(namedValues=NamedValues(("sessionDown", 0), ("sessionUp", 1), ("sendFailureIndication", 2), ("receivedFailureIndication", 3), ("portUpEvent", 4), ("portDownEvent", 5), ("invalidLabelEvent", 6), ("newPortEvent", 7), ("deadPortEvent", 8), ("adjacencyUpdateEvent", 9),)).clone(namedValues=NamedValues(("sessionDown", 0), ("sessionUp", 1), ("sendFailureIndication", 2), ("receivedFailureIndication", 3),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerNotificationMap.setDescription('This bitmap defines whether a corresponding SNMP\n           notification should be sent if a GSMP event is received\n           by the Switch Controller. If the bit is set to 1 a\n           notification should be sent. The handling and filtering of\n           the SNMP notifications are then further specified in the\n\n\n\n           SNMP notification originator application. ')
gsmpControllerSessionState = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 10), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("null", 1), ("synsent", 2), ("synrcvd", 3), ("estab", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpControllerSessionState.setDescription('The state for the existing or potential session that\n             this entity is concerned with.\n             The NULL state is returned if the proper encapsulation\n             data is not yet configured, if the row is not in active\n             status or if the session is in NULL state as defined in\n             the GSMP specification.')
gsmpControllerStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 11), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerStorageType.setDescription("The storage type for this controller entity.\n             Conceptual rows having the value 'permanent' need not allow\n             write-access to any columnar objects in the row.")
gsmpControllerRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 1, 1, 12), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpControllerRowStatus.setDescription("An object that allows entries in this table to\n              be created and deleted using the\n              RowStatus convention.\n              While the row is in active state it's not\n              possible to modify the value of any object\n              for that row except the gsmpControllerNotificationMap\n              and the gsmpControllerRowStatus objects.")
gsmpSwitchTable = MibTable((1, 3, 6, 1, 2, 1, 98, 1, 2), )
if mibBuilder.loadTexts: gsmpSwitchTable.setDescription('This table represents the Switch\n             Entities. An entry in this table needs to be configured\n             (created) before a GSMP session might be started.')
gsmpSwitchEntry = MibTableRow((1, 3, 6, 1, 2, 1, 98, 1, 2, 1), ).setIndexNames((0, "GSMP-MIB", "gsmpSwitchEntityId"))
if mibBuilder.loadTexts: gsmpSwitchEntry.setDescription('An entry in the table showing\n             the data for a specific Switch\n             Entity. If partitions are used, one entity\n             corresponds to one specific switch partition.\n             Depending of the encapsulation used,\n             a corresponding row in the gsmpAtmEncapTable or the\n             gsmpTcpIpEncapTable may have been created.')
gsmpSwitchEntityId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 1), GsmpNameType())
if mibBuilder.loadTexts: gsmpSwitchEntityId.setDescription('The Switch Entity Id is unique\n             within the operational context of the device. ')
gsmpSwitchMaxVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 2), GsmpVersion().clone(3)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchMaxVersion.setDescription('The max version number of the GSMP protocol being\n           supported by this Switch. The version is negotiated by\n           the adjacency protocol.')
gsmpSwitchTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 3), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,255)).clone(10)).setUnits('100ms').setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchTimer.setDescription('The timer specifies the nominal time between\n           periodic adjacency protocol messages. It is a constant\n           for the duration of a GSMP session. The timer is\n           specified in units of 100ms.')
gsmpSwitchName = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 4), GsmpNameType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchName.setDescription('The name of the Switch. The first three octets must be an\n           Organisationally Unique Identifier (OUI) that identifies\n           the manufacturer of the Switch. This is by default set to\n           the same value as the gsmpSwitchId object if not\n           separately specified. ')
gsmpSwitchPort = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 5), Unsigned32()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchPort.setDescription('The local port number for this Switch Entity.')
gsmpSwitchInstance = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 6), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,16777215))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSwitchInstance.setDescription('The instance number for the Switch Entity.\n           The Instance number is a 24-bit number\n           that should be guaranteed to be unique within\n           the recent past and to change when the link\n           or node comes back up after going down. Zero is\n           not a valid instance number.')
gsmpSwitchPartitionType = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 7), GsmpPartitionType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchPartitionType.setDescription('A switch can assign the specific partition identifier to\n           the session by setting the Partition Type to\n           fixedPartitionAssigned(3). A switch can specify\n           that no partitions are handled in the session by setting\n           the Partition Type to noPartition(1).')
gsmpSwitchPartitionId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 8), GsmpPartitionIdType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchPartitionId.setDescription('The Id for this specific switch partition that the switch\n           entity represents. If partitions are not used, i.e.\n           Partition Type = noPartition(1), then this object is\n           undefined.')
gsmpSwitchNotificationMap = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 9), Bits().clone(namedValues=NamedValues(("sessionDown", 0), ("sessionUp", 1), ("sendFailureIndication", 2), ("receivedFailureIndication", 3), ("portUpEvent", 4), ("portDownEvent", 5), ("invalidLabelEvent", 6), ("newPortEvent", 7), ("deadPortEvent", 8), ("adjacencyUpdateEvent", 9),)).clone(namedValues=NamedValues(("sessionDown", 0), ("sessionUp", 1), ("sendFailureIndication", 2), ("receivedFailureIndication", 3),))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchNotificationMap.setDescription('This bitmap defines whether a corresponding SNMP\n           notification should be sent if an GSMP event is sent\n           by the Switch Entity. If the bit is set to 1 a\n           notification should be sent. The handling and filtering of\n           the SNMP notifications are then further specified in the\n           SNMP notification originator application. ')
gsmpSwitchSwitchType = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 10), OctetString().subtype(subtypeSpec=ValueSizeConstraint(2,2)).setFixedLength(2)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchSwitchType.setDescription('A 16-bit field allocated by the manufacturer\n           of the switch. The Switch Type\n           identifies the product. When the Switch Type is combined\n           with the OUI from the Switch Name the product is\n           uniquely identified. ')
gsmpSwitchWindowSize = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 11), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,65535))).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchWindowSize.setDescription('The maximum number of unacknowledged request messages\n           that may be transmitted by the controller without the\n           possibility of loss. This field is used to prevent\n           request messages from being lost in the switch because of\n           overflow in the receive buffer. The field is a hint to\n           the controller.')
gsmpSwitchSessionState = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 12), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("null", 1), ("synsent", 2), ("synrcvd", 3), ("estab", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSwitchSessionState.setDescription('The state for the existing or potential session that\n           this entity is concerned with.\n           The NULL state is returned if the proper encapsulation\n           data is not yet configured, if the row is not in active\n           status or if the session is in NULL state as defined in\n           the GSMP specification.')
gsmpSwitchStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 13), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchStorageType.setDescription("The storage type for this switch entity.\n             Conceptual rows having the value 'permanent' need not allow\n             write-access to any columnar objects in the row.")
gsmpSwitchRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 2, 1, 14), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpSwitchRowStatus.setDescription("An object that allows entries in this table to\n              be created and deleted using the\n              RowStatus convention.\n              While the row is in active state it's not\n              possible to modify the value of any object\n              for that row except the gsmpSwitchNotificationMap\n              and the gsmpSwitchRowStatus objects.")
gsmpAtmEncapTable = MibTable((1, 3, 6, 1, 2, 1, 98, 1, 3), )
if mibBuilder.loadTexts: gsmpAtmEncapTable.setDescription('This table contains the atm encapsulation data\n              for the Controller or Switch that uses atm aal5 as\n              encapsulation. ')
gsmpAtmEncapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 98, 1, 3, 1), ).setIndexNames((0, "GSMP-MIB", "gsmpAtmEncapEntityId"))
if mibBuilder.loadTexts: gsmpAtmEncapEntry.setDescription('An entry in the table showing\n             the encapsulation data for a specific\n             Switch Controller entity or Switch entity.')
gsmpAtmEncapEntityId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 3, 1, 1), GsmpNameType())
if mibBuilder.loadTexts: gsmpAtmEncapEntityId.setDescription('The Controller Id or Switch Id that is unique\n             within the operational context of the device. ')
gsmpAtmEncapIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 3, 1, 2), InterfaceIndex()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpAtmEncapIfIndex.setDescription('The interface index for the virtual channel over which\n             the GSMP session is established, i.e., the GSMP control\n             channel for LLC/SNAP encapsulated GSMP messages on an\n             ATM data link layer.')
gsmpAtmEncapVpi = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 3, 1, 3), AtmVpIdentifier()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpAtmEncapVpi.setDescription(' The VPI value for the virtual channel over which the\n             GSMP session is established, i.e., the GSMP control\n             channel for LLC/SNAP encapsulated GSMP messages on an\n             ATM data link layer.')
gsmpAtmEncapVci = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 3, 1, 4), AtmVcIdentifier().clone(15)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpAtmEncapVci.setDescription(' The VCI value for the virtual channel over which the\n              GSMP session is established, i.e., the GSMP control\n              channel for LLC/SNAP encapsulated GSMP messages on an\n              ATM data link layer.')
gsmpAtmEncapStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 3, 1, 5), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpAtmEncapStorageType.setDescription('The storage type for this entry. It should have the same\n              value as the StorageType in the referring Switch\n              Controller entity or Switch entity.')
gsmpAtmEncapRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 3, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpAtmEncapRowStatus.setDescription("An object that allows entries in this table to\n              be created and deleted using the\n              RowStatus convention.\n              While the row is in active state it's not\n              possible to modify the value of any object\n              for that row except the gsmpAtmEncapRowStatus object.")
gsmpTcpIpEncapTable = MibTable((1, 3, 6, 1, 2, 1, 98, 1, 4), )
if mibBuilder.loadTexts: gsmpTcpIpEncapTable.setDescription('This table contains the encapsulation data\n              for the Controller or Switch that uses TCP/IP as\n              encapsulation.')
gsmpTcpIpEncapEntry = MibTableRow((1, 3, 6, 1, 2, 1, 98, 1, 4, 1), ).setIndexNames((0, "GSMP-MIB", "gsmpTcpIpEncapEntityId"))
if mibBuilder.loadTexts: gsmpTcpIpEncapEntry.setDescription('An entry in the table showing\n             the encapsulation data for a specific\n             Switch Controller entity or Switch entity.')
gsmpTcpIpEncapEntityId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 4, 1, 1), GsmpNameType())
if mibBuilder.loadTexts: gsmpTcpIpEncapEntityId.setDescription('The Controller or Switch Id is unique\n             within the operational context of the device. ')
gsmpTcpIpEncapAddressType = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 4, 1, 2), InetAddressType()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpTcpIpEncapAddressType.setDescription('The type of address in gsmpTcpIpEncapAddress.')
gsmpTcpIpEncapAddress = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 4, 1, 3), InetAddress()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpTcpIpEncapAddress.setDescription('The IPv4 or IPv6 address used for\n             the GSMP session peer.')
gsmpTcpIpEncapPortNumber = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 4, 1, 4), InetPortNumber().clone(6068)).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpTcpIpEncapPortNumber.setDescription('The TCP port number used for the TCP session\n              establishment to the GSMP peer.')
gsmpTcpIpEncapStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 4, 1, 5), StorageType().clone('nonVolatile')).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpTcpIpEncapStorageType.setDescription('The storage type for this entry. It should have the same\n              value as the StorageType in the referring Switch\n              Controller entity or Switch entity.')
gsmpTcpIpEncapRowStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 4, 1, 6), RowStatus()).setMaxAccess("readcreate")
if mibBuilder.loadTexts: gsmpTcpIpEncapRowStatus.setDescription("An object that allows entries in this table to\n              be created and deleted using the\n              RowStatus convention.\n              While the row is in active state it's not\n              possible to modify the value of any object\n              for that row except the gsmpTcpIpEncapRowStatus object.")
gsmpSessionTable = MibTable((1, 3, 6, 1, 2, 1, 98, 1, 5), )
if mibBuilder.loadTexts: gsmpSessionTable.setDescription('This table represents the sessions between\n              Controller and Switch pairs. ')
gsmpSessionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 98, 1, 5, 1), ).setIndexNames((0, "GSMP-MIB", "gsmpSessionThisSideId"), (0, "GSMP-MIB", "gsmpSessionFarSideId"))
if mibBuilder.loadTexts: gsmpSessionEntry.setDescription('An entry in the table showing\n             the session data for a specific Controller and\n             Switch pair. Also, statistics for this specific\n             session is shown.')
gsmpSessionThisSideId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 1), GsmpNameType())
if mibBuilder.loadTexts: gsmpSessionThisSideId.setDescription('This side ID uniquely identifies the entity that this\n             session relates to within the operational\n             context of the device. ')
gsmpSessionFarSideId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 2), GsmpNameType())
if mibBuilder.loadTexts: gsmpSessionFarSideId.setDescription('The Far side ID uniquely identifies the entity that this\n            session is established against. ')
gsmpSessionVersion = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 3), GsmpVersion()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionVersion.setDescription('The version number of the GSMP protocol being used in\n           this session. The version is the result of the\n           negotiation by the adjacency protocol.')
gsmpSessionTimer = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 4), Integer32()).setUnits('100ms').setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionTimer.setDescription('The timer specifies the time remaining until the\n           adjacency timer expires. The object could take negative\n           values since if no valid GSMP messages are\n           received in any period of time in excess of three times\n           the value of the Timer negotiated by the adjacency\n           protocol loss of synchronisation may be declared. The\n           timer is specified in units of 100ms.')
gsmpSessionPartitionId = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 5), GsmpPartitionIdType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionPartitionId.setDescription('The Partition Id for the specific switch partition that\n           this session is concerned with.')
gsmpSessionAdjacencyCount = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 6), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionAdjacencyCount.setDescription('This object specifies the current number of adjacencies\n           that are established with controllers and the switch\n           partition that is used for this session. The value\n           includes this session.')
gsmpSessionFarSideName = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 7), GsmpNameType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionFarSideName.setDescription('The name of the far side as advertised in the adjacency\n           message.')
gsmpSessionFarSidePort = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 8), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionFarSidePort.setDescription('The local port number of the link across which the\n           message is being sent.')
gsmpSessionFarSideInstance = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 9), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1,16777215))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionFarSideInstance.setDescription('The instance number used for the link during this\n           session. The Instance number is a 24-bit number\n           that should be guaranteed to be unique within\n\n\n\n           the recent past and to change when the link\n           or node comes back up after going down. Zero is not\n           a valid instance number.')
gsmpSessionLastFailureCode = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 10), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(0,255))).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionLastFailureCode.setDescription('This is the last failure code that was received over\n           this session. If no failure code have been received, the\n           value is zero.')
gsmpSessionDiscontinuityTime = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 11), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionDiscontinuityTime.setDescription("The value of sysUpTime on the most recent occasion at\n           which one or more of this session's counters\n           suffered a discontinuity. If no such discontinuities have\n           occurred since then, this object contains the same\n           timestamp as gsmpSessionStartUptime .")
gsmpSessionStartUptime = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 12), TimeStamp()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStartUptime.setDescription(' The value of sysUpTime when the session came to\n           established state.')
gsmpSessionStatSentMessages = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 13), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatSentMessages.setDescription('The number of messages that have been sent in this\n           session. All GSMP messages pertaining to this session after\n           the session came to established state SHALL\n           be counted, also including adjacency protocol messages\n           and failure response messages.\n           When the counter suffers any discontinuity, then\n           the gsmpSessionDiscontinuityTime object indicates when it\n\n\n\n           happened.')
gsmpSessionStatFailureInds = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 14), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatFailureInds.setDescription('The number of messages that have been sent with a\n           failure indication in this session. Warning messages\n           SHALL NOT be counted.\n           When the counter suffers any discontinuity, then\n           the gsmpSessionDiscontinuityTime object indicates when it\n           happened.')
gsmpSessionStatReceivedMessages = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 15), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatReceivedMessages.setDescription('The number of messages that have been received in\n           this session. All legal GSMP messages pertaining to this\n           session after the session came to established state SHALL\n           be counted, also including adjacency protocol messages\n           and failure response messages.\n           When the counter suffers any discontinuity, then\n           the gsmpSessionDiscontinuityTime object indicates when it\n           happened.')
gsmpSessionStatReceivedFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 16), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatReceivedFailures.setDescription('The number of messages that have been received in\n           this session with a failure indication. Warning messages\n           SHALL NOT be counted.\n           When the counter suffers any discontinuity, then\n           the gsmpSessionDiscontinuityTime object indicates when it\n           happened.')
gsmpSessionStatPortUpEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 17), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatPortUpEvents.setDescription('The number of Port Up events that have been sent or\n           received on this session.\n           When the counter suffers any discontinuity, then\n           the gsmpSessionDiscontinuityTime object indicates when it\n           happened.')
gsmpSessionStatPortDownEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 18), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatPortDownEvents.setDescription('The number of Port Down events that have been sent or\n           received on this session.\n           When the counter suffers any discontinuity, then\n           the gsmpSessionDiscontinuityTime object indicates when it\n           happened.')
gsmpSessionStatInvLabelEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 19), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatInvLabelEvents.setDescription('The number of Invalid label events that have been sent\n           or received on this session.\n           When the counter suffers any discontinuity, then\n           the gsmpSessionDiscontinuityTime object indicates when it\n           happened.')
gsmpSessionStatNewPortEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 20), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatNewPortEvents.setDescription('The number of New Port events that have been sent or\n\n\n\n           received on this session.\n           When the counter suffers any discontinuity, then\n           the gsmpSessionDiscontinuityTime object indicates when it\n           happened.')
gsmpSessionStatDeadPortEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 21), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatDeadPortEvents.setDescription('The number of Dead Port events that have been sent or\n           received on this session.\n           When the counter suffers any discontinuity, then\n           the gsmpSessionDiscontinuityTime object indicates when it\n           happened.')
gsmpSessionStatAdjUpdateEvents = MibTableColumn((1, 3, 6, 1, 2, 1, 98, 1, 5, 1, 22), ZeroBasedCounter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: gsmpSessionStatAdjUpdateEvents.setDescription('The number of Adjacency Update events that have been sent\n            or received on this session.\n            When the counter suffers any discontinuity, then\n            the gsmpSessionDiscontinuityTime object indicates when it\n            happened.')
gsmpEventPort = MibScalar((1, 3, 6, 1, 2, 1, 98, 2, 1), Unsigned32()).setMaxAccess("accessiblefornotify")
if mibBuilder.loadTexts: gsmpEventPort.setDescription('This object specifies the Port Number that is\n            carried in this event.')
gsmpEventPortSessionNumber = MibScalar((1, 3, 6, 1, 2, 1, 98, 2, 2), Unsigned32()).setMaxAccess("accessiblefornotify")
if mibBuilder.loadTexts: gsmpEventPortSessionNumber.setDescription('This object specifies the Port Session Number that is\n            carried in this event.')
gsmpEventSequenceNumber = MibScalar((1, 3, 6, 1, 2, 1, 98, 2, 3), Unsigned32()).setMaxAccess("accessiblefornotify")
if mibBuilder.loadTexts: gsmpEventSequenceNumber.setDescription('This object specifies the Event Sequence Number that is\n            carried in this event.')
gsmpEventLabel = MibScalar((1, 3, 6, 1, 2, 1, 98, 2, 4), GsmpLabelType()).setMaxAccess("accessiblefornotify")
if mibBuilder.loadTexts: gsmpEventLabel.setDescription('This object specifies the Label that is\n            carried in this event.')
gsmpSessionDown = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 1)).setObjects(*(("GSMP-MIB", "gsmpSessionStartUptime"), ("GSMP-MIB", "gsmpSessionStatSentMessages"), ("GSMP-MIB", "gsmpSessionStatFailureInds"), ("GSMP-MIB", "gsmpSessionStatReceivedMessages"), ("GSMP-MIB", "gsmpSessionStatReceivedFailures"), ("GSMP-MIB", "gsmpSessionStatPortUpEvents"), ("GSMP-MIB", "gsmpSessionStatPortDownEvents"), ("GSMP-MIB", "gsmpSessionStatInvLabelEvents"), ("GSMP-MIB", "gsmpSessionStatNewPortEvents"), ("GSMP-MIB", "gsmpSessionStatDeadPortEvents"), ("GSMP-MIB", "gsmpSessionStatAdjUpdateEvents"),))
if mibBuilder.loadTexts: gsmpSessionDown.setDescription('When it has been enabled, this notification is\n              generated whenever a session is taken down, regardless\n              of whether the session went down normally or not.\n              Its purpose is to allow a management application\n              (primarily an accounting application) that is\n              monitoring the session statistics to receive the final\n              values of these counters, so that the application can\n              properly account for the amounts the counters were\n              incremented since the last time the application polled\n              them. The gsmpSessionStartUptime object provides the\n              total amount of time that the session was active.\n\n              This notification is not a substitute for polling the\n              session statistic counts. In particular, the count\n              values reported in this notification cannot be assumed\n             to be the complete totals for the life of the session,\n             since they may have wrapped while the\n             session was up.\n\n             The session to which this notification\n             applies is identified by the gsmpSessionThisSideId and\n             gsmpSessionFarSideId which could be inferred from the\n             Object Identifiers of the objects contained in the\n             notification.\n             An instance of this notification will contain exactly\n             one instance of each of its objects, and these objects\n             will all belong to the same conceptual row of the\n             gsmpSessionTable.')
gsmpSessionUp = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 2)).setObjects(*(("GSMP-MIB", "gsmpSessionFarSideInstance"),))
if mibBuilder.loadTexts: gsmpSessionUp.setDescription('When it has been enabled, this notification is\n            generated when new session is established.\n\n            The new session is identified by the gsmpSessionThisSideId\n            and gsmpSessionFarSideId which could be inferred from the\n            Object Identifier of the gsmpSessionFarSideInstance object\n\n\n\n            contained in the notification.')
gsmpSentFailureInd = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 3)).setObjects(*(("GSMP-MIB", "gsmpSessionLastFailureCode"), ("GSMP-MIB", "gsmpSessionStatFailureInds"),))
if mibBuilder.loadTexts: gsmpSentFailureInd.setDescription('When it has been enabled, this notification is\n            generated when a message with a failure indication was\n            sent.\n\n            The notification indicates a change in the value of\n            gsmpSessionStatFailureInds. The\n            gsmpSessionLastFailureCode contains the failure\n            reason.\n\n            The session to which this notification\n            applies is identified by the gsmpSessionThisSideId and\n            gsmpSessionFarSideId which could be inferred from the\n            Object Identifiers of the objects contained in the\n            notification.')
gsmpReceivedFailureInd = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 4)).setObjects(*(("GSMP-MIB", "gsmpSessionLastFailureCode"), ("GSMP-MIB", "gsmpSessionStatReceivedFailures"),))
if mibBuilder.loadTexts: gsmpReceivedFailureInd.setDescription('When it has been enabled, this notification is\n            generate when a message with a failure indication\n            is received.\n\n            The notification indicates a change in the value of\n            gsmpSessionStatReceivedFailures. The\n            gsmpSessionLastFailureCode contains the failure\n            reason.\n\n            The session to which this notification\n            applies is identified by the gsmpSessionThisSideId and\n            gsmpSessionFarSideId which could be inferred from the\n            Object Identifiers of the objects contained in the\n            notification.')
gsmpPortUpEvent = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 5)).setObjects(*(("GSMP-MIB", "gsmpSessionStatPortUpEvents"), ("GSMP-MIB", "gsmpEventPort"), ("GSMP-MIB", "gsmpEventPortSessionNumber"), ("GSMP-MIB", "gsmpEventSequenceNumber"),))
if mibBuilder.loadTexts: gsmpPortUpEvent.setDescription('When it has been enabled, this notification is\n            generated when a Port Up Event occurs.\n\n            The notification indicates a change in the value of\n            gsmpSessionStatPortUpEvents.\n\n            The session to which this notification\n            applies is identified by the gsmpSessionThisSideId and\n            gsmpSessionFarSideId which could be inferred from the\n            Object Identifier of the gsmpSessionStatPortUpEvents\n            object contained in the notification.')
gsmpPortDownEvent = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 6)).setObjects(*(("GSMP-MIB", "gsmpSessionStatPortDownEvents"), ("GSMP-MIB", "gsmpEventPort"), ("GSMP-MIB", "gsmpEventPortSessionNumber"), ("GSMP-MIB", "gsmpEventSequenceNumber"),))
if mibBuilder.loadTexts: gsmpPortDownEvent.setDescription('When it has been enabled, this notification is\n            generated when a Port Down Event occurs.\n\n            The notification indicates a change in the value of\n            gsmpSessionStatPortDownEvents.\n\n            The session to which this notification\n            applies is identified by the gsmpSessionThisSideId and\n            gsmpSessionFarSideId which could be inferred from the\n            Object Identifier of the gsmpSessionStatPortDownEvents\n            object contained in the notification.')
gsmpInvalidLabelEvent = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 7)).setObjects(*(("GSMP-MIB", "gsmpSessionStatInvLabelEvents"), ("GSMP-MIB", "gsmpEventPort"), ("GSMP-MIB", "gsmpEventLabel"), ("GSMP-MIB", "gsmpEventSequenceNumber"),))
if mibBuilder.loadTexts: gsmpInvalidLabelEvent.setDescription('When it has been enabled, this notification is\n            generated when an Invalid Label Event occurs.\n\n            The notification indicates a change in the value of\n            gsmpSessionStatInvLabelEvents.\n\n            The session to which this notification\n            applies is identified by the gsmpSessionThisSideId and\n            gsmpSessionFarSideId which could be inferred from the\n            Object Identifier of the gsmpSessionStatInvLabelEvents\n            object contained in the notification.')
gsmpNewPortEvent = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 8)).setObjects(*(("GSMP-MIB", "gsmpSessionStatNewPortEvents"), ("GSMP-MIB", "gsmpEventPort"), ("GSMP-MIB", "gsmpEventPortSessionNumber"), ("GSMP-MIB", "gsmpEventSequenceNumber"),))
if mibBuilder.loadTexts: gsmpNewPortEvent.setDescription('When it has been enabled, this notification is\n            generated when a New Port Event occurs.\n\n            The notification indicates a change in the value of\n            gsmpSessionStatNewPortEvents.\n\n            The session to which this notification\n            applies is identified by the gsmpSessionThisSideId and\n            gsmpSessionFarSideId which could be inferred from the\n            Object Identifier of the gsmpSessionStatNewPortEvents\n            object contained in the notification.')
gsmpDeadPortEvent = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 9)).setObjects(*(("GSMP-MIB", "gsmpSessionStatDeadPortEvents"), ("GSMP-MIB", "gsmpEventPort"), ("GSMP-MIB", "gsmpEventPortSessionNumber"), ("GSMP-MIB", "gsmpEventSequenceNumber"),))
if mibBuilder.loadTexts: gsmpDeadPortEvent.setDescription('When it has been enabled, this notification is\n            generated when a Dead Port Event occurs.\n\n            The notification indicates a change in the value of\n            gsmpSessionStatDeadPortEvents.\n\n            The session to which this notification\n            applies is identified by the gsmpSessionThisSideId and\n            gsmpSessionFarSideId which could be inferred from the\n            Object Identifier of the gsmpSessionStatDeadPortEvents\n            object contained in the notification.')
gsmpAdjacencyUpdateEvent = NotificationType((1, 3, 6, 1, 2, 1, 98, 0, 10)).setObjects(*(("GSMP-MIB", "gsmpSessionAdjacencyCount"), ("GSMP-MIB", "gsmpSessionStatAdjUpdateEvents"), ("GSMP-MIB", "gsmpEventSequenceNumber"),))
if mibBuilder.loadTexts: gsmpAdjacencyUpdateEvent.setDescription('When it has been enabled, this notification is\n            generated when an Adjacency Update Event occurs.\n\n            The gsmpSessionAdjacencyCount contains the new value of\n            the number of adjacencies\n            that are established with controllers and the switch\n            partition that is used for this session.\n\n            The notification indicates a change in the value of\n            gsmpSessionStatAdjUpdateEvents.\n\n            The session to which this notification\n            applies is identified by the gsmpSessionThisSideId and\n            gsmpSessionFarSideId which could be inferred from the\n            Object Identifier of the gsmpSessionAdjacencyCount\n            or the gsmpSessionStatAdjUpdateEvents object contained\n            in the notification.')
gsmpGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 98, 3, 1))
gsmpCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 98, 3, 2))
gsmpModuleCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 98, 3, 2, 1)).setObjects(*(("GSMP-MIB", "gsmpGeneralGroup"), ("GSMP-MIB", "gsmpControllerGroup"), ("GSMP-MIB", "gsmpSwitchGroup"), ("GSMP-MIB", "gsmpAtmEncapGroup"), ("GSMP-MIB", "gsmpTcpIpEncapGroup"), ("GSMP-MIB", "gsmpNotificationObjectsGroup"), ("GSMP-MIB", "gsmpNotificationsGroup"),))
if mibBuilder.loadTexts: gsmpModuleCompliance.setDescription('The compliance statement for agents that support\n            the GSMP MIB.')
gsmpGeneralGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 98, 3, 1, 1)).setObjects(*(("GSMP-MIB", "gsmpSessionVersion"), ("GSMP-MIB", "gsmpSessionTimer"), ("GSMP-MIB", "gsmpSessionPartitionId"), ("GSMP-MIB", "gsmpSessionAdjacencyCount"), ("GSMP-MIB", "gsmpSessionFarSideName"), ("GSMP-MIB", "gsmpSessionFarSidePort"), ("GSMP-MIB", "gsmpSessionFarSideInstance"), ("GSMP-MIB", "gsmpSessionLastFailureCode"), ("GSMP-MIB", "gsmpSessionDiscontinuityTime"), ("GSMP-MIB", "gsmpSessionStartUptime"), ("GSMP-MIB", "gsmpSessionStatSentMessages"), ("GSMP-MIB", "gsmpSessionStatFailureInds"), ("GSMP-MIB", "gsmpSessionStatReceivedMessages"), ("GSMP-MIB", "gsmpSessionStatReceivedFailures"), ("GSMP-MIB", "gsmpSessionStatPortUpEvents"), ("GSMP-MIB", "gsmpSessionStatPortDownEvents"), ("GSMP-MIB", "gsmpSessionStatInvLabelEvents"), ("GSMP-MIB", "gsmpSessionStatNewPortEvents"), ("GSMP-MIB", "gsmpSessionStatDeadPortEvents"), ("GSMP-MIB", "gsmpSessionStatAdjUpdateEvents"),))
if mibBuilder.loadTexts: gsmpGeneralGroup.setDescription('Objects that apply to all GSMP implementations.')
gsmpControllerGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 98, 3, 1, 2)).setObjects(*(("GSMP-MIB", "gsmpControllerMaxVersion"), ("GSMP-MIB", "gsmpControllerTimer"), ("GSMP-MIB", "gsmpControllerPort"), ("GSMP-MIB", "gsmpControllerInstance"), ("GSMP-MIB", "gsmpControllerPartitionType"), ("GSMP-MIB", "gsmpControllerPartitionId"), ("GSMP-MIB", "gsmpControllerDoResync"), ("GSMP-MIB", "gsmpControllerNotificationMap"), ("GSMP-MIB", "gsmpControllerSessionState"), ("GSMP-MIB", "gsmpControllerStorageType"), ("GSMP-MIB", "gsmpControllerRowStatus"),))
if mibBuilder.loadTexts: gsmpControllerGroup.setDescription('Objects that apply GSMP implementations of\n             Switch Controllers.')
gsmpSwitchGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 98, 3, 1, 3)).setObjects(*(("GSMP-MIB", "gsmpSwitchMaxVersion"), ("GSMP-MIB", "gsmpSwitchTimer"), ("GSMP-MIB", "gsmpSwitchName"), ("GSMP-MIB", "gsmpSwitchPort"), ("GSMP-MIB", "gsmpSwitchInstance"), ("GSMP-MIB", "gsmpSwitchPartitionType"), ("GSMP-MIB", "gsmpSwitchPartitionId"), ("GSMP-MIB", "gsmpSwitchNotificationMap"), ("GSMP-MIB", "gsmpSwitchSwitchType"), ("GSMP-MIB", "gsmpSwitchWindowSize"), ("GSMP-MIB", "gsmpSwitchSessionState"), ("GSMP-MIB", "gsmpSwitchStorageType"), ("GSMP-MIB", "gsmpSwitchRowStatus"),))
if mibBuilder.loadTexts: gsmpSwitchGroup.setDescription('Objects that apply GSMP implementations of\n             Switches.')
gsmpAtmEncapGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 98, 3, 1, 4)).setObjects(*(("GSMP-MIB", "gsmpAtmEncapIfIndex"), ("GSMP-MIB", "gsmpAtmEncapVpi"), ("GSMP-MIB", "gsmpAtmEncapVci"), ("GSMP-MIB", "gsmpAtmEncapStorageType"), ("GSMP-MIB", "gsmpAtmEncapRowStatus"),))
if mibBuilder.loadTexts: gsmpAtmEncapGroup.setDescription('Objects that apply to GSMP implementations that\n             supports ATM for GSMP encapsulation.')
gsmpTcpIpEncapGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 98, 3, 1, 5)).setObjects(*(("GSMP-MIB", "gsmpTcpIpEncapAddressType"), ("GSMP-MIB", "gsmpTcpIpEncapAddress"), ("GSMP-MIB", "gsmpTcpIpEncapPortNumber"), ("GSMP-MIB", "gsmpTcpIpEncapStorageType"), ("GSMP-MIB", "gsmpTcpIpEncapRowStatus"),))
if mibBuilder.loadTexts: gsmpTcpIpEncapGroup.setDescription('Objects that apply to GSMP implementations that\n             supports TCP/IP for GSMP encapsulation.')
gsmpNotificationObjectsGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 98, 3, 1, 6)).setObjects(*(("GSMP-MIB", "gsmpEventPort"), ("GSMP-MIB", "gsmpEventPortSessionNumber"), ("GSMP-MIB", "gsmpEventSequenceNumber"), ("GSMP-MIB", "gsmpEventLabel"),))
if mibBuilder.loadTexts: gsmpNotificationObjectsGroup.setDescription('Objects that are contained in the notifications.')
gsmpNotificationsGroup = NotificationGroup((1, 3, 6, 1, 2, 1, 98, 3, 1, 7)).setObjects(*(("GSMP-MIB", "gsmpSessionDown"), ("GSMP-MIB", "gsmpSessionUp"), ("GSMP-MIB", "gsmpSentFailureInd"), ("GSMP-MIB", "gsmpReceivedFailureInd"), ("GSMP-MIB", "gsmpPortUpEvent"), ("GSMP-MIB", "gsmpPortDownEvent"), ("GSMP-MIB", "gsmpInvalidLabelEvent"), ("GSMP-MIB", "gsmpNewPortEvent"), ("GSMP-MIB", "gsmpDeadPortEvent"), ("GSMP-MIB", "gsmpAdjacencyUpdateEvent"),))
if mibBuilder.loadTexts: gsmpNotificationsGroup.setDescription('The notifications which indicate specific changes\n             in the value of objects gsmpSessionTable')
mibBuilder.exportSymbols("GSMP-MIB", gsmpControllerRowStatus=gsmpControllerRowStatus, gsmpControllerSessionState=gsmpControllerSessionState, gsmpSessionStatReceivedFailures=gsmpSessionStatReceivedFailures, gsmpControllerTimer=gsmpControllerTimer, gsmpControllerEntry=gsmpControllerEntry, gsmpControllerTable=gsmpControllerTable, gsmpInvalidLabelEvent=gsmpInvalidLabelEvent, gsmpTcpIpEncapRowStatus=gsmpTcpIpEncapRowStatus, gsmpSwitchPartitionType=gsmpSwitchPartitionType, gsmpSwitchGroup=gsmpSwitchGroup, gsmpSessionLastFailureCode=gsmpSessionLastFailureCode, gsmpSessionPartitionId=gsmpSessionPartitionId, gsmpNotificationsObjects=gsmpNotificationsObjects, gsmpAdjacencyUpdateEvent=gsmpAdjacencyUpdateEvent, gsmpSessionStatPortDownEvents=gsmpSessionStatPortDownEvents, gsmpTcpIpEncapEntityId=gsmpTcpIpEncapEntityId, gsmpTcpIpEncapStorageType=gsmpTcpIpEncapStorageType, gsmpNotificationObjectsGroup=gsmpNotificationObjectsGroup, gsmpSwitchRowStatus=gsmpSwitchRowStatus, gsmpAtmEncapVpi=gsmpAtmEncapVpi, gsmpNotificationsGroup=gsmpNotificationsGroup, gsmpTcpIpEncapPortNumber=gsmpTcpIpEncapPortNumber, gsmpSwitchMaxVersion=gsmpSwitchMaxVersion, GsmpPartitionType=GsmpPartitionType, gsmpSessionStatInvLabelEvents=gsmpSessionStatInvLabelEvents, gsmpMIB=gsmpMIB, gsmpReceivedFailureInd=gsmpReceivedFailureInd, gsmpAtmEncapTable=gsmpAtmEncapTable, gsmpControllerPartitionId=gsmpControllerPartitionId, gsmpAtmEncapStorageType=gsmpAtmEncapStorageType, GsmpNameType=GsmpNameType, gsmpPortDownEvent=gsmpPortDownEvent, gsmpSwitchPort=gsmpSwitchPort, gsmpSwitchSwitchType=gsmpSwitchSwitchType, gsmpTcpIpEncapAddressType=gsmpTcpIpEncapAddressType, gsmpSessionUp=gsmpSessionUp, gsmpControllerPort=gsmpControllerPort, gsmpAtmEncapEntityId=gsmpAtmEncapEntityId, gsmpSwitchName=gsmpSwitchName, gsmpControllerDoResync=gsmpControllerDoResync, gsmpGroups=gsmpGroups, gsmpControllerNotificationMap=gsmpControllerNotificationMap, gsmpSessionEntry=gsmpSessionEntry, gsmpTcpIpEncapGroup=gsmpTcpIpEncapGroup, gsmpAtmEncapIfIndex=gsmpAtmEncapIfIndex, gsmpSwitchNotificationMap=gsmpSwitchNotificationMap, gsmpTcpIpEncapEntry=gsmpTcpIpEncapEntry, gsmpAtmEncapRowStatus=gsmpAtmEncapRowStatus, gsmpSessionStartUptime=gsmpSessionStartUptime, gsmpSessionStatReceivedMessages=gsmpSessionStatReceivedMessages, gsmpSwitchTimer=gsmpSwitchTimer, gsmpAtmEncapGroup=gsmpAtmEncapGroup, gsmpDeadPortEvent=gsmpDeadPortEvent, gsmpSessionStatAdjUpdateEvents=gsmpSessionStatAdjUpdateEvents, gsmpSwitchWindowSize=gsmpSwitchWindowSize, gsmpSwitchEntityId=gsmpSwitchEntityId, gsmpControllerMaxVersion=gsmpControllerMaxVersion, gsmpSessionThisSideId=gsmpSessionThisSideId, gsmpSessionStatDeadPortEvents=gsmpSessionStatDeadPortEvents, gsmpObjects=gsmpObjects, gsmpSessionDown=gsmpSessionDown, PYSNMP_MODULE_ID=gsmpMIB, gsmpTcpIpEncapTable=gsmpTcpIpEncapTable, gsmpSentFailureInd=gsmpSentFailureInd, gsmpControllerEntityId=gsmpControllerEntityId, gsmpSessionStatNewPortEvents=gsmpSessionStatNewPortEvents, gsmpAtmEncapVci=gsmpAtmEncapVci, gsmpConformance=gsmpConformance, gsmpSessionFarSideName=gsmpSessionFarSideName, gsmpSessionStatSentMessages=gsmpSessionStatSentMessages, gsmpSessionAdjacencyCount=gsmpSessionAdjacencyCount, gsmpNewPortEvent=gsmpNewPortEvent, gsmpSessionFarSideInstance=gsmpSessionFarSideInstance, GsmpVersion=GsmpVersion, gsmpSwitchPartitionId=gsmpSwitchPartitionId, gsmpGeneralGroup=gsmpGeneralGroup, gsmpEventLabel=gsmpEventLabel, gsmpSwitchInstance=gsmpSwitchInstance, gsmpTcpIpEncapAddress=gsmpTcpIpEncapAddress, gsmpSessionFarSideId=gsmpSessionFarSideId, GsmpPartitionIdType=GsmpPartitionIdType, GsmpLabelType=GsmpLabelType, gsmpSessionTable=gsmpSessionTable, gsmpSessionTimer=gsmpSessionTimer, gsmpSwitchStorageType=gsmpSwitchStorageType, gsmpEventPort=gsmpEventPort, gsmpSwitchTable=gsmpSwitchTable, gsmpEventPortSessionNumber=gsmpEventPortSessionNumber, gsmpCompliances=gsmpCompliances, gsmpSessionDiscontinuityTime=gsmpSessionDiscontinuityTime, gsmpSessionVersion=gsmpSessionVersion, gsmpNotifications=gsmpNotifications, gsmpEventSequenceNumber=gsmpEventSequenceNumber, gsmpPortUpEvent=gsmpPortUpEvent, gsmpControllerInstance=gsmpControllerInstance, gsmpSessionStatFailureInds=gsmpSessionStatFailureInds, gsmpModuleCompliance=gsmpModuleCompliance, gsmpControllerPartitionType=gsmpControllerPartitionType, gsmpSessionStatPortUpEvents=gsmpSessionStatPortUpEvents, gsmpControllerStorageType=gsmpControllerStorageType, gsmpAtmEncapEntry=gsmpAtmEncapEntry, gsmpSessionFarSidePort=gsmpSessionFarSidePort, gsmpSwitchEntry=gsmpSwitchEntry, gsmpControllerGroup=gsmpControllerGroup, gsmpSwitchSessionState=gsmpSwitchSessionState)
