/*
 * (C) Copyright 2002, Schlund+Partner AG
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// Local configuration
#include "config.h"

// Implementation
#include "XMLException.hpp"

namespace SP {
namespace GXML {

XMLException::XMLException( int exception )
{
	exception_ = exception;
}

int
XMLException::getException()
{
	return exception_;
}

std::string
XMLException::getMessage()
{
	switch ( exception_ )
	{
	case XMLTREE_PARSE:
		return (std::string)"Error parsing XML tree";
	case XMLTREE_CREATE_CONTEXT:
		return (std::string)"Could not create XPath context";
	case XMLTREE_CREATE_NODE:
		return (std::string)"Could not create node";
	case XMLTREE_ADD_NODE:
		return (std::string)"Could not add node";
	case XMLTREE_TREE_INVALID:
		return (std::string)"Invalid XML tree";
	case XMLTREE_NO_NODE_FROM_PATH:
		return (std::string)"Path matches no node";
	case XMLTREE_NO_STRING_FROM_PATH:
		return (std::string)"Path returns no string";
	case XMLTREE_NO_BOOL_FROM_PATH:
		return (std::string)"Path returns no boolean";
	case XMLTREE_NO_FLOAT_FROM_PATH:
		return (std::string)"Path returns no float";
	case XMLNODE_NO_NODE:
		return (std::string)"Node pointer is NULL";
	case XMLNODE_LAST_NODE:
		return (std::string)"Node has no following sibling";
	case XMLNODE_FIRST_NODE:
		return (std::string)"Node has no preceding sibling";
	case XMLNODE_NO_PARENT:
		return (std::string)"Node has no parent node";
	case XMLNODE_NO_CHILD:
		return (std::string)"Node has no child node";
	case XMLNODE_NO_CONTENT:
		return (std::string)"Node contains no text";
	case XMLNODE_NO_ATTRIBUTE:
		return (std::string)"Node has no attributes";
	case XMLNODE_BUFFER_CREATE:
		return (std::string)"Could not create XML buffer";
	case XMLNODE_NODE_DUMP:
		return (std::string)"Could not dump the node";
	case XMLNODESET_EVAL:
		return (std::string)"Could not evaluate XPath";
	case XMLNODESET_NO_SET:
		return (std::string)"XPath delivers no node set";
	case XMLNODESET_NO_MATCH:
		return (std::string)"XPath doesn't exist";
	default:
		return (std::string)"Uknown exception";
	}
}

}}
