/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.remote.ErrorHandler;
import org.openqa.selenium.remote.HandshakeResponse;
import org.openqa.selenium.remote.InitialHandshakeResponse;
import org.openqa.selenium.remote.ProtocolHandshake;
import org.openqa.selenium.remote.Response;

class JsonWireProtocolResponse
implements HandshakeResponse {
    private final Function<InitialHandshakeResponse, Optional<ProtocolHandshake.Result>> error = tuple -> {
        if (!tuple.getData().containsKey("status")) {
            return Optional.empty();
        }
        Object rawStatus = tuple.getData().get("status");
        if (!(rawStatus instanceof Number)) {
            return Optional.empty();
        }
        if (((Number)rawStatus).intValue() == 0) {
            return Optional.empty();
        }
        if (!tuple.getData().containsKey("value")) {
            return Optional.empty();
        }
        Object value = tuple.getData().get("value");
        if (!(value instanceof Map)) {
            return Optional.empty();
        }
        Response response = new Response(null);
        response.setStatus(((Number)rawStatus).intValue());
        response.setValue(value);
        new ErrorHandler().throwIfResponseFailed(response, tuple.getRequestDuration().toMillis());
        return Optional.empty();
    };
    private final Function<InitialHandshakeResponse, Optional<ProtocolHandshake.Result>> success = tuple -> {
        Object rawStatus = tuple.getData().get("status");
        if (!(rawStatus instanceof Number)) {
            return Optional.empty();
        }
        if (0 != ((Number)rawStatus).intValue()) {
            return Optional.empty();
        }
        Object rawSessionId = tuple.getData().get("sessionId");
        Object rawCapabilities = tuple.getData().get("value");
        if (!(rawSessionId instanceof String) || !(rawCapabilities instanceof Map)) {
            return Optional.empty();
        }
        for (Object key : ((Map)rawCapabilities).keySet()) {
            if (key instanceof String) continue;
            return Optional.empty();
        }
        Map caps = (Map)rawCapabilities;
        String sessionId = (String)rawSessionId;
        return Optional.of(new ProtocolHandshake.Result(Dialect.OSS, sessionId, caps));
    };

    JsonWireProtocolResponse() {
    }

    @Override
    public Function<InitialHandshakeResponse, Optional<ProtocolHandshake.Result>> getResponseFunction() {
        return resp -> {
            Optional<ProtocolHandshake.Result> result = this.error.apply((InitialHandshakeResponse)resp);
            if (!result.isPresent()) {
                result = this.success.apply((InitialHandshakeResponse)resp);
            }
            return result;
        };
    }
}

