use strict;
use warnings;
use File::Basename qw/dirname/;
use File::Temp qw/tempdir/;
use FindBin qw/$RealBin/;
use Data::Dumper qw/Dumper/;

use Test::More tests => 4;

use lib "$RealBin/../lib";
use_ok 'Suffix::Trie';

# Test1: banana
my $str1  = "banana";
my @suffixes1 = qw($ a banana$ na na$);
my $trie1 = Suffix::Trie->new($str1);
is_deeply [@suffixes1], $trie1->suffixes, "correct suffixes for banana";

# Test2: mississippi
my $str2  ="mississippi";
my @suffixes2 = qw($ i i$ mississippi$ p pi$ ppi$ s si ssi ssippi$);
my $trie2 = Suffix::Trie->new($str2);
is_deeply [@suffixes2], $trie2->suffixes, "correct suffixes for mississippi";

# Test a DNA string. The array to check against is really long on the next line.
my $str3 = "TTGGAGCATTCCGATCTACCTAGTGCAATAGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG";
my @suffixes3 = qw($ A AA AACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ AACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ AAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ AAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ AATAGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ ACCTAGTGCAATAGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ ACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ ACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ AG$ AGCATTCCGATCTACCTAGTGCAATAGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ AGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ AGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ AGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ AGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ AT ATAGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ ATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ ATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ ATGATGATAG$ ATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ ATTCCGATCTACCTAGTGCAATAGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ ATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ C CAATAGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CCGACGATGATGATAG$ CCGATCTACCTAGTGCAATAGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CCTAGTGCAATAGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CG CGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CGACGATGATGATAG$ CGATGATGATAG$ CGCCCGACGATGATGATAG$ CGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CT CTACCTAGTGCAATAGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CTAGTGCAATAGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CTCTTGGCGCCCGACGATGATGATAG$ CTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ CTTGGCGCCCGACGATGATGATAG$ G G$ GA GAA GAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ GAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ GAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ GAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ GAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ GACGATGATGATAG$ GAT GATAG$ GATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ GATCTACCTAGTGCAATAGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ GATGATAG$ GCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ GCATTCCGATCTACCTAGTGCAATAGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ GCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ GCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ GCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ GGCGCCCGACGATGATGATAG$ GGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ GTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ GTATCTCTCTTGGCGCCCGACGATGATGATAG$ GTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ GTGCAATAGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ GTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ T TAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TATCTCTCTTGGCGCCCGACGATGATGATAG$ TC TCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TCTACCTAGTGCAATAGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TCTCTTGGCGCCCGACGATGATGATAG$ TGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TGCAATAGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TGGCGCCCGACGATGATGATAG$ TGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TTCCGATCTACCTAGTGCAATAGCGCGATATGCACTGAAATTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$ TTTTGTGAACGCTTAGGAAAACGGAAGTGTATCCCTATAAGGAAGCTGTGCCTGAAGCCGAAGTACGGTCGTATCTCTCTTGGCGCCCGACGATGATGATAG$);
my $trie3 = Suffix::Trie->new($str3);
is_deeply [@suffixes3], $trie3->suffixes, "correct suffixes for DNA string";
