use ExtUtils::MakeMaker;

# Check whether we have <attr/attributes.h> and <attr/xattr.h> on Linux.
# Suggest what the user needs to install, to get these files.
@DIRS = qw(. /usr/include);
if ($^O eq 'linux')
{
    my %headers = (
        'attr/attributes.h' => 0,
        'attr/xattr.h' => 0,
    );
    my $incdir;

    foreach $incdir (@DIRS)
    {
        foreach (keys %headers)
        {
            $headers{$_}++ if (-r "$incdir/$_");
        }
    }

    foreach (keys %headers)
    {
        die "<$_> not found; perhaps you need to install libattr-devel"
            if ($headers{$_} == 0);
    }
}

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    NAME              => 'File::ExtAttr',
    VERSION_FROM      => 'lib/File/ExtAttr.pm', # finds $VERSION
    PREREQ_PM         => {}, # e.g., Module::Name => 1.1
    ($] >= 5.005 ?     ## Add these new keywords supported since 5.005
      (ABSTRACT_FROM  => 'lib/File/ExtAttr.pm', # retrieve abstract from module
       AUTHOR         => 'Kevin M. Goess <kgoess@ensenda.com>'
                         .', Richard Dawe <rich@phekda.gotadsl.co.uk>') : ()),
# Don't actually need -lattr on Linux.
#    LIBS              => ['-lattr'], # e.g., '-lm'
    OBJECT            => '$(O_FILES)',
    DEFINE            => '', # e.g., '-DHAVE_SOMETHING'
    INC               => join(' ', map { "-I$_" } @DIRS),
#    'MYEXTLIB' => 'mylib/libxattrlib$(LIB_EXT)',
	# Un-comment this if you add C files to link with later:
    # OBJECT            => '$(O_FILES)', # link all the C files too
);


 sub MY::postamble {
'
$(MYEXTLIB): mylib/Makefile
		cd mylib && $(MAKE) $(PASSTHRU)
';
}
