######## GeoData for Geo::Location::TimeZone - Check main library for copyright.
######## Roughly GMT 2
package Geo::Location::TimeZone::B;
use Class::Singleton;
use Geo::Location::TimeZone;
@ISA = qw(Class::Singleton Geo::Location::TimeZone);
# Coordinates are X,Y, NOT lat,lon
# Output of partial data at 1172109537
my $data = {
	# Longitude 22.5 to 37.5
	"2" => {
		# Grid 2:-6 ; 2 records
		"-6" => {
			"def_z" => "Antartica/South_Pole",
			"501" => {
				"z" => "Etc/GMT+1",
				"c" => "ESRI",
				"s" => "34,1",
				"p" => [[27.4580535888672,-82.5],[22.5038223266602,-82.5],[22.5038223266602,-90],[22.5,-90],[22.5,-82.5],[23.4486083984375,-82.5],[27.4580535888672,-82.5],],
			},
		},
		# Grid 2:-5 ; 1 records
		"-5" => {
			"502" => {
				"z" => "Etc/GMT+1",
				"c" => "ESRI",
				"s" => "34,1",
				"p" => [[27.4580535888672,-67.5],[22.5038224855204,-67.5],[22.5038223266602,-70.5400314331055],[22.5038223266602,-82.5],[22.5,-82.5],[22.5,-67.5],[23.4486083984375,-67.5],[27.4580535888672,-67.5],],
			},
		},
		# Grid 2:-4 ; 1 records
		"-4" => {
			"503" => {
				"z" => "Etc/GMT+1",
				"c" => "ESRI",
				"s" => "34,1",
				"p" => [[27.4580535888672,-52.5],[22.5038232693624,-52.5],[22.5038224855204,-67.5],[22.5,-67.5],[22.5,-52.5],[23.4486083984375,-52.5],[27.4580535888672,-52.5],],
			},
		},
		# Grid 2:-3 ; 1 records
		"-3" => {
			"504" => {
				"z" => "Etc/GMT+1",
				"c" => "ESRI",
				"s" => "34,1",
				"p" => [[27.4580535888672,-37.5],[22.5038240532044,-37.5],[22.5038232693624,-52.5],[22.5,-52.5],[22.5,-37.5],[23.4486083984375,-37.5],[27.4580535888672,-37.5],],
			},
		},
		# Grid 2:-2 ; 2 records
		"-2" => {
			"def_z1" => "24.0666667,-26.6166667,Africa/Algiers",
			"def_z0" => "28.0833333,-26.2,Africa/Johannesburg",
			"def_z2" => "30.0333333,-24.4166667,Africa/Windhoek",
			"def_z3" => "25.9119444,-24.6463889,Africa/Gaborone",
			"def_z4" => "32.5891667,-25.9652778,Africa/Maputo",
			"505" => {
				"z" => "Etc/GMT+1",
				"c" => "ESRI",
				"s" => "34,1",
				"p" => [[27.4580535888672,-22.5],[22.5,-22.5],[22.5,-34.0406086734192],[22.5038242340088,-34.0400352478027],[22.5038240532044,-37.5],[22.5,-37.5],[22.5,-22.5],[23.4486083984375,-22.5],[27.4580535888672,-22.5],],
			},
		},
		# Grid 2:-1 ; 3 records
		"-1" => {
			"def_z1" => "27.4666667,-11.6666667,Africa/Lubumbashi",
			"def_z0" => "31.0447222,-17.8177778,Africa/Harare",
			"def_z2" => "35.0,-15.7833333,Africa/Blantyre",
			"337" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,2",
				"p" => [[37.5,-10.4781742095947],[37.5,-11.6892509021331],[37.462043762207,-11.7273292541504],[37.3472213745117,-11.6866683959961],[37.2861099243164,-11.7041683197021],[37.1258316040039,-11.6733341217041],[37.0258331298828,-11.5672225952148],[36.9044418334961,-11.5947227478027],[36.829719543457,-11.5686111450195],[36.6777725219727,-11.7147235870361],[36.5619430541992,-11.7402782440186],[36.4899978637695,-11.6811122894287],[36.1897201538086,-11.7066669464111],[36.1630554199219,-11.5777778625488],[35.9655532836914,-11.5008344650269],[35.9430541992188,-11.4347229003906],[35.8383331298828,-11.414722442627],[35.7724990844727,-11.4752788543701],[35.7038879394531,-11.4877796173096],[35.6524963378906,-11.5847234725952],[35.5763854980469,-11.60666847229],[35.5161056518555,-11.6108341217041],[35.4941635131836,-11.5791683197021],[34.9667282104492,-11.5721111297607],[34.959716796875,-11.4866676330566],[34.8905487060547,-11.383056640625],[34.805549621582,-11.3322238922119],[34.7636108398438,-11.3450012207031],[34.7102737426758,-11.2011127471924],[34.6149978637695,-11.1094455718994],[34.5930480957031,-11.0166683197021],[34.6430511474609,-10.9219455718994],[34.6761093139648,-10.7430572509766],[34.5758285522461,-10.5166683197021],[34.5827713012695,-10.2700004577637],[34.5238876342773,-10.1075000762939],[34.5224990844727,-10.0108337402344],[34.3380508422852,-9.78750038146973],[34.3252716064453,-9.73277854919434],[34.0394439697266,-9.48277854919434],[33.9572219848633,-9.52666854858398],[33.9530487060547,-9.6733341217041],[33.9196090698242,-9.7076587677002],[33.7558288574219,-9.58277893066406],[33.6836090087891,-9.61055564880371],[33.5849990844727,-9.58416748046875],[33.5088882446289,-9.62194633483887],[33.4377746582031,-9.61583518981934],[33.3938827514648,-9.53805732727051],[33.3144378662109,-9.48555564880371],[33.192497253418,-9.5091667175293],[33.1258316040039,-9.49027824401855],[32.9977722167969,-9.37333488464355],[32.9403991699219,-9.40507698059082],[32.7716598510742,-9.33555603027344],[32.741943359375,-9.28166770935059],[32.5452728271484,-9.26666831970215],[32.4255523681641,-9.12972259521484],[32.2494430541992,-9.13194465637207],[32.1599960327148,-9.06333351135254],[32.0561065673828,-9.04083442687988],[31.9797210693359,-9.07111167907715],[31.9341659545898,-9.01889038085938],[31.9561080932617,-8.93083381652832],[31.7855377197266,-8.88506698608398],[31.7386054992676,-8.91805458068848],[31.6836090087891,-8.90888977050781],[31.573055267334,-8.81861114501953],[31.5633316040039,-8.69861221313477],[31.4594421386719,-8.62944602966309],[31.3980522155762,-8.62944602966309],[31.3755531311035,-8.58222389221191],[31.2852745056152,-8.62333488464355],[31.2205543518066,-8.57666778564453],[31.1327743530273,-8.61555671691895],[31.0411109924316,-8.59027862548828],[30.9013862609863,-8.46000099182129],[30.771240234375,-8.19224739074707],[30.6544418334961,-7.88694477081299],[30.4558296203613,-7.58027839660645],[30.4383011531279,-7.5],[37.5,-7.5],[37.5,-22.5],[37.5,-10.4781742095947],],
			},
			"506" => {
				"z" => "Etc/GMT+1",
				"c" => "ESRI",
				"s" => "34,1",
				"p" => [[27.4580535888672,-7.5],[22.5,-7.5],[22.5,-11.0948970694291],[22.5297203063965,-11.0377788543701],[22.7166633605957,-11.093334197998],[22.8636093139648,-11.0491676330566],[22.9427757263184,-11.0950012207031],[23.0849990844727,-11.0966682434082],[23.2186088562012,-11.0763893127441],[23.3680534362793,-10.9827785491943],[23.4763870239258,-10.9583339691162],[23.8638877868652,-11.0272235870361],[23.9862060546875,-10.8704614639282],[24.0224990844727,-10.9688892364502],[24.025276184082,-11.2805557250977],[24.0844421386719,-11.4027786254883],[24.0308303833008,-11.4530563354492],[24.0302772521973,-11.5263900756836],[23.9658317565918,-11.6550006866455],[24.015552520752,-11.8141670227051],[23.9841651916504,-11.8822231292725],[23.9749984741211,-12.1991672515869],[24.0349998474121,-12.2641677856445],[24.0522193908691,-12.3852787017822],[23.9474983215332,-12.537223815918],[23.8861083984375,-12.7711124420166],[23.8938865661621,-12.8322238922119],[23.9977760314941,-12.9372234344482],[24.0205535888672,-13.0063896179199],[22.5,-13.0047187996877],[22.5,-16.7862495735748],[23.2016639709473,-17.4797248840332],[23.4761085510254,-17.6258354187012],[22.5,-17.8069528166536],[22.5,-22.5],[22.5,-7.5],[23.4486083984375,-7.5],[27.4580535888672,-7.5],],
			},
		},
		# Grid 2:0 ; 3 records
		"0" => {
			"def_z1" => "29.36,-3.3761111,Africa/Bujumbura",
			"def_z0" => "30.0605556,-1.9536111,Africa/Kigali",
			"def_z2" => "29.95,-2.3,Africa/Kigali",
			"338" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,2",
				"p" => [[34.5930480957031,-7.5],[30.4383011531279,-7.5],[30.4069442749023,-7.35638904571533],[30.3113861083984,-7.13694477081299],[30.086109161377,-6.86361122131348],[29.7324981689453,-6.62750053405762],[29.6611099243164,-6.45555591583252],[29.5502777099609,-6.29527854919434],[29.4977760314941,-5.97972297668457],[29.631664276123,-5.72194480895996],[29.3491630554199,-4.93972301483154],[29.3413887023926,-4.79777812957764],[29.4283332824707,-4.55222225189209],[29.4233322143555,-4.44750022888184],[29.7522201538086,-4.4611120223999],[29.8127746582031,-4.36027812957764],[29.8577766418457,-4.37111186981201],[30.0261077880859,-4.26944446563721],[30.0727767944336,-4.16666698455811],[30.1722221374512,-4.08666706085205],[30.2280540466309,-3.92805576324463],[30.3211097717285,-3.78666687011719],[30.4008331298828,-3.78611135482788],[30.3913879394531,-3.71110892295837],[30.4491653442383,-3.54722261428833],[30.6622200012207,-3.41888904571533],[30.6636085510254,-3.38666677474976],[30.622200012207,-3.37011384963989],[30.6516647338867,-3.33250045776367],[30.8349990844727,-3.25694465637207],[30.8522186279297,-3.14527797698975],[30.7955551147461,-3.04861116409302],[30.8447761535645,-2.97601318359375],[30.6661109924316,-2.97638893127441],[30.5633316040039,-2.89305591583252],[30.4849967956543,-2.9472222328186],[30.4174995422363,-2.86194467544556],[30.4402770996094,-2.74722242355347],[30.5222206115723,-2.65722227096558],[30.4572219848633,-2.68583345413208],[30.4330520629883,-2.64777803421021],[30.5733299255371,-2.39916706085205],[30.6524963378906,-2.39666700363159],[30.6997184753418,-2.34750032424927],[30.7822189331055,-2.38055562973022],[30.8291664123535,-2.35777807235718],[30.8941650390625,-2.07611131668091],[30.8083305358887,-1.9294445514679],[30.8349990844727,-1.80055570602417],[30.811107635498,-1.70055556297302],[30.840274810791,-1.67055559158325],[30.7488861083984,-1.5205557346344],[30.7391662597656,-1.43694448471069],[30.5616645812988,-1.32694458961487],[30.5122184753418,-1.16444444656372],[30.4694442749023,-1.15833353996277],[30.4533309936523,-1.09555578231812],[30.4822196960449,-1.06333351135254],[30.3599967956543,-1.06000018119812],[30.3456611633301,-1.12916779518127],[30.2291641235352,-1.26666688919067],[30.1847190856934,-1.27500009536743],[30.1705551147461,-1.33972239494324],[29.9749984741211,-1.46444463729858],[29.9074974060059,-1.46416687965393],[29.8413887023926,-1.32027792930603],[29.8030548095703,-1.36555576324463],[29.7341651916504,-1.34194445610046],[29.6833305358887,-1.38055562973022],[29.5969429016113,-1.3858335018158],[29.5663871765137,-1.00583338737488],[29.5783309936523,-0.900000095367432],[29.6283302307129,-0.888888955116272],[29.6183319091797,-0.733333349227905],[29.638053894043,-0.59333336353302],[29.6719436645508,-0.572222232818604],[29.648609161377,-0.439722239971161],[29.7349967956543,-0.000833333353511989],[29.7166633605957,0.0722222179174423],[29.7733306884766,0.172222197055817],[29.8138885498047,0.158611088991165],[29.8583297729492,0.366666615009308],[29.9624977111816,0.487222194671631],[29.9383316040039,0.634444355964661],[29.9605522155762,0.825555443763733],[30.1458320617676,0.898333311080933],[30.2186088562012,0.996388792991638],[30.2361106872559,1.13416647911072],[30.2780532836914,1.16888880729675],[30.3322219848633,1.1513888835907],[30.3486099243164,1.19611096382141],[30.4561080932617,1.21277761459351],[30.6880531311035,1.49388885498047],[31.0366630554199,1.7655553817749],[31.3027763366699,2.12138843536377],[31.299201965332,2.16285037994385],[31.2024993896484,2.22916650772095],[31.1969413757324,2.305832862854],[31.1252746582031,2.27805519104004],[31.0497207641602,2.30388879776001],[31.0702743530273,2.33499956130981],[30.970832824707,2.41194438934326],[30.9141654968262,2.33944416046143],[30.8802757263184,2.33749961853027],[30.8252754211426,2.39916658401489],[30.8266639709473,2.44222211837769],[30.7297210693359,2.44805526733398],[30.8166656494141,2.76916646957397],[30.8780517578125,2.8436107635498],[30.8555526733398,2.95749998092651],[30.7624969482422,3.05499982833862],[30.8299980163574,3.27555513381958],[30.9349975585938,3.41166639328003],[30.9172210693359,3.52194404602051],[30.8588180541992,3.49339437484741],[30.9747200012207,3.69194412231445],[31.1766662597656,3.79527759552002],[31.2880554199219,3.79472208023071],[31.5408325195312,3.65361070632935],[31.5738868713379,3.69166660308838],[31.7019424438477,3.71305513381958],[31.7994422912598,3.82555532455444],[31.9333305358887,3.68777751922607],[31.9511108398438,3.59388875961304],[32.0638885498047,3.59027767181396],[32.0936050415039,3.53249979019165],[32.1933288574219,3.51138877868652],[32.1944351196289,3.61104488372803],[32.4044418334961,3.74361085891724],[32.7194442749023,3.7558331489563],[32.8980484008789,3.81194400787354],[33.0166625976562,3.88861083984375],[33.1838836669922,3.76611089706421],[33.5169372558594,3.75222206115723],[33.9966659545898,4.22277736663818],[34.3881912231445,4.60968208312988],[35.5088806152344,4.61673545837402],[35.9405517578125,4.62249946594238],[35.7744369506836,4.79861068725586],[35.7738876342773,5.07527732849121],[35.8308258056641,5.15388870239258],[35.7955551147461,5.25138854980469],[35.8358306884766,5.31861019134521],[35.684440612793,5.39138793945312],[35.6049957275391,5.37305545806885],[35.5047149658203,5.43138885498047],[35.4474945068359,5.42944431304932],[35.3563842773438,5.35027694702148],[35.3113861083984,5.36694431304932],[35.2697219848633,5.44111061096191],[35.2899932861328,5.50777721405029],[35.1038818359375,5.63249969482422],[35.105827331543,5.69277763366699],[34.9863815307617,5.87805461883545],[34.9878234863281,6.01394367218018],[34.8605499267578,6.2616662979126],[34.8572158813477,6.34944438934326],[34.7977752685547,6.44472217559814],[34.7627716064453,6.60583305358887],[34.6374969482422,6.72722148895264],[34.5299987792969,6.74388885498047],[34.4699935913086,6.91611099243164],[34.2947006225586,6.96642684936523],[34.2024993896484,7.05222129821777],[34.1824951171875,7.16305541992188],[34.1336059570312,7.1588888168335],[34.0299987792969,7.2408332824707],[34.0308303833008,7.37499904632568],[33.9108989279366,7.5],[37.5,7.5],[37.5,-7.5],[34.5930480957031,-7.5],],
			},
			"507" => {
				"z" => "Etc/GMT+1",
				"c" => "ESRI",
				"s" => "34,1",
				"p" => [[22.5,7.5],[25.2062718353368,7.5],[25.2069435119629,7.49749946594238],[25.3311080932617,7.42527770996094],[25.3655548095703,7.34833240509033],[25.4649963378906,7.27999973297119],[25.5313873291016,7.27777767181396],[25.5938873291016,7.21638870239258],[25.8138885498047,7.14722156524658],[25.8197212219238,7.10833263397217],[26.0483322143555,6.99833297729492],[26.100830078125,6.84111022949219],[26.4062843322754,6.6352481842041],[26.2891654968262,6.46888828277588],[26.3136100769043,6.45777702331543],[26.3077774047852,6.38305473327637],[26.3952751159668,6.30777740478516],[26.4594421386719,6.29444408416748],[26.4761085510254,6.22472190856934],[26.523609161377,6.22111034393311],[26.523609161377,6.17361068725586],[26.4374961853027,6.07777690887451],[26.5141639709473,6.10972213745117],[26.554443359375,6.03361034393311],[26.8086090087891,5.97999954223633],[26.8394432067871,5.8983325958252],[26.9102745056152,5.89944362640381],[26.9497184753418,5.84694385528564],[27.0011100769043,5.86249923706055],[27.0491638183594,5.78999996185303],[27.1427764892578,5.77194404602051],[27.2408332824707,5.64777755737305],[27.23388671875,5.58833312988281],[27.281665802002,5.57861042022705],[27.2358322143555,5.42861080169678],[27.2547187805176,5.33138847351074],[27.2999992370605,5.22611045837402],[27.4580535888672,5.08361053466797],[27.4552764892578,5.01638793945312],[27.3936080932617,5.08916664123535],[27.0841636657715,5.20416641235352],[26.9377746582031,5.14111042022705],[26.8677749633789,5.02916622161865],[26.7316665649414,5.09277725219727],[26.4888877868652,5.04638862609863],[26.3863868713379,5.14555549621582],[26.2922210693359,5.14138793945312],[26.1327743530273,5.25722217559814],[26.056941986084,5.1924991607666],[25.973331451416,5.23166656494141],[25.8999977111816,5.16694355010986],[25.8758316040039,5.21749973297119],[25.8258323669434,5.19555473327637],[25.7908325195312,5.26388835906982],[25.7491645812988,5.24194431304932],[25.5422210693359,5.38138866424561],[25.538330078125,5.35055541992188],[25.3619422912598,5.31472206115723],[25.3755531311035,5.29472160339355],[25.3105545043945,5.19111061096191],[25.3494415283203,5.14472198486328],[25.3083305358887,5.03249931335449],[25.1758308410645,4.99527740478516],[25.1336097717285,5.01777744293213],[25.0702743530273,4.94583320617676],[24.9588851928711,4.98722171783447],[24.7344436645508,4.91083240509033],[24.6505546569824,4.92111110687256],[24.6611099243164,4.96444416046143],[24.5255546569824,5.07722187042236],[24.4474983215332,5.10583305358887],[24.4255523681641,5.06583309173584],[24.3941650390625,5.11555480957031],[24.3549995422363,5.05472183227539],[24.4005546569824,5.02999973297119],[24.2861099243164,4.99499988555908],[24.2561073303223,4.92944431304932],[24.2274971008301,4.96027755737305],[24.1519432067871,4.89999961853027],[24.1055526733398,4.91999912261963],[23.9819412231445,4.8552770614624],[23.9541664123535,4.87333297729492],[23.9422187805176,4.80999946594238],[23.8302764892578,4.82083320617676],[23.5844421386719,4.73444366455078],[23.4416656494141,4.65361022949219],[23.4263877868652,4.59194374084473],[23.385555267334,4.58777713775635],[23.2683296203613,4.62722206115723],[23.1824989318848,4.72722148895264],[23.0999984741211,4.70527744293213],[23.0224990844727,4.74305534362793],[22.9749984741211,4.83138847351074],[22.8958320617676,4.82111072540283],[22.8558311462402,4.70694351196289],[22.7758331298828,4.70666599273682],[22.6902770996094,4.48361110687256],[22.5944442749023,4.47055530548096],[22.6097221374512,4.35888862609863],[22.5411109924316,4.2811107635498],[22.5386085510254,4.21888828277588],[22.5,4.1851391525676],[22.5,4.12315317556241],[22.561107635498,4.1013879776001],[22.6872215270996,3.99805545806885],[22.7586097717285,3.99138879776001],[22.765552520752,3.90499973297119],[22.8580551147461,3.85861110687256],[22.9908332824707,3.88333320617676],[23.0355529785156,3.86055517196655],[23.1472206115723,3.89611101150513],[23.35888671875,3.80944442749023],[23.3994407653809,3.83527755737305],[23.5149993896484,3.82583332061768],[23.4869422912598,3.73833322525024],[23.3697204589844,3.6158332824707],[23.1711082458496,3.67805528640747],[23.0374984741211,3.54749965667725],[22.9286079406738,3.54805517196655],[22.6783332824707,3.45388841629028],[22.623607635498,3.38888883590698],[22.6433296203613,3.32527732849121],[22.79638671875,3.25944423675537],[22.7797203063965,3.06388854980469],[22.8147201538086,2.9961109161377],[22.8641662597656,3.01194429397583],[23.0011100769043,3.16166639328003],[23.0819435119629,3.14722204208374],[22.9847221374512,2.85777759552002],[23.0038871765137,2.75722217559814],[22.9599990844727,2.67222213745117],[23.0380554199219,2.55805540084839],[23.1266632080078,2.5024995803833],[23.3594436645508,2.52388858795166],[23.4224967956543,2.45194435119629],[23.627498626709,2.33083295822144],[23.6513862609863,2.19249963760376],[23.3438873291016,2.25138854980469],[23.090274810791,2.09388875961304],[22.975830078125,2.184166431427],[22.8608322143555,2.04583311080933],[22.7572212219238,2.01027774810791],[22.6997184753418,2.03416633605957],[22.6474990844727,2.10944414138794],[22.5722198486328,2.11027765274048],[22.5886077880859,2.04861068725586],[22.5166664123535,1.91638875007629],[22.5,1.83190214526191],[22.5,1.44522860675405],[22.6241645812988,1.36166644096375],[22.8147201538086,0.996388792991638],[22.861385345459,0.671111106872559],[22.9352760314941,0.570833325386047],[22.9936103820801,0.374999940395355],[23.4136085510254,-0.233611136674881],[23.293888092041,-0.317222237586975],[23.129997253418,-0.28083336353302],[22.9702758789062,-0.406388938426971],[23.2177772521973,-0.425000011920929],[23.2691650390625,-0.49527782201767],[23.4677772521973,-0.438611149787903],[23.6294441223145,-0.635833382606506],[23.4855537414551,-0.698888897895813],[23.3561096191406,-0.807222247123718],[23.5266647338867,-0.975833415985107],[23.7297210693359,-1.08333349227905],[23.772777557373,-1.17916679382324],[23.9488868713379,-1.3066668510437],[24.1058311462402,-1.3847222328186],[24.3038864135742,-1.39305567741394],[24.3758316040039,-1.53888893127441],[24.4213981628418,-1.78679585456848],[24.0352745056152,-1.7327778339386],[23.9852752685547,-1.76916670799255],[23.837776184082,-1.76500010490417],[23.7830543518066,-1.8066668510437],[23.7747192382812,-1.91750001907349],[23.698055267334,-1.93138909339905],[23.6938858032227,-2.0188889503479],[23.5,-2.01000022888184],[23.2211074829102,-2.08555603027344],[23.1094436645508,-1.94583344459534],[23.0327758789062,-1.92805576324463],[22.9366645812988,-1.96222233772278],[22.8702774047852,-1.8841667175293],[22.6797218322754,-1.8066668510437],[22.6255531311035,-1.80111122131348],[22.5097198486328,-1.95888900756836],[22.5,-1.95722607322488],[22.5,-7.5],[22.5,7.5],[25.8127746582031,7.5],[22.5,7.5],],
			},
		},
		# Grid 2:1 ; 3 records
		"1" => {
			"108" => {
				"z" => "Africa/Khartoum",
				"c" => "ESRI",
				"s" => "10,2",
				"p" => [[30.8588180541992,7.5],[25.2062718353368,7.5],[25.1838874816895,7.58333301544189],[25.2961082458496,7.64999961853027],[25.2583312988281,7.84083271026611],[25.186107635498,7.90194416046143],[25.0802764892578,7.89749908447266],[24.973331451416,7.99277687072754],[24.9427757263184,8.08388710021973],[24.8655548095703,8.1652774810791],[24.6599998474121,8.2186107635498],[24.5458297729492,8.20472145080566],[24.4599990844727,8.27138710021973],[24.3611106872559,8.24722099304199],[24.1772193908691,8.31611061096191],[24.1402740478516,8.37583160400391],[24.1658325195312,8.4777774810791],[24.2691650390625,8.58305549621582],[24.2302742004395,8.62499809265137],[24.2533302307129,8.69111061096191],[23.8238868713379,8.7277774810791],[23.7391662597656,8.70527648925781],[23.6330528259277,8.7369441986084],[23.5177764892578,8.71416664123535],[23.4983329772949,8.7783317565918],[23.5816650390625,8.9061107635498],[23.5830535888672,8.98860931396484],[23.5652770996094,9.00527763366699],[23.5036087036133,8.95972061157227],[23.4486083984375,9.02499961853027],[23.4927749633789,9.17416572570801],[23.5563888549805,9.18166542053223],[23.6522216796875,9.27999877929688],[23.6644439697266,9.44083213806152],[23.6313858032227,9.44944381713867],[23.6233329772949,9.53527641296387],[23.6947212219238,9.67166519165039],[23.6691665649414,9.866943359375],[23.3038864135742,10.4591655731201],[23.0094413757324,10.6986103057861],[22.8665046691895,10.9224472045898],[22.942497253418,11.0924987792969],[22.970832824707,11.2830543518066],[22.9308319091797,11.4158334732056],[22.7911109924316,11.4016666412354],[22.7755546569824,11.4622211456299],[22.6419410705566,11.5161094665527],[22.5616645812988,11.6216659545898],[22.6408309936523,12.0711097717285],[22.5636100769043,12.0747203826904],[22.5,12.0450503788483],[22.5,12.1689239019892],[22.5013885498047,12.1769428253174],[22.5,12.1815244761004],[22.5,14.0982495843603],[22.5549964904785,14.1255550384521],[22.5552749633789,14.2319431304932],[22.5,14.2519301407958],[22.5,14.6374373973686],[22.7024993896484,14.6913871765137],[22.6705551147461,14.8594436645508],[22.7388877868652,14.9027767181396],[22.7533302307129,14.9769439697266],[22.8491630554199,15.078332901001],[22.9358329772949,15.1161098480225],[22.9983329772949,15.356388092041],[22.9230537414551,15.4872207641602],[22.9372215270996,15.5619430541992],[23.1181564331055,15.7102928161621],[23.3569412231445,15.6816654205322],[23.60888671875,15.7583332061768],[23.9996032714844,15.6987085342407],[23.9998054504395,18.7543029785156],[24.0027465820312,19.4990653991699],[25.0008316040039,19.9991645812988],[25.0014228820801,21.9996948242188],[25.0011711935604,22.5],[37.5,22.5],[37.5,17.1616257894293],[37.4232864379883,17.0342140197754],[37.3069381713867,17.061107635498],[37.1519393920898,17.015552520752],[36.9958267211914,17.0738868713379],[37.0180511474609,17.0036087036133],[36.9869384765625,16.9430541992188],[37.0227737426758,16.8505554199219],[36.9805526733398,16.7061080932617],[36.9122161865234,16.6411094665527],[36.8963851928711,16.5177764892578],[36.9569396972656,16.4252777099609],[36.9730529785156,16.2694435119629],[36.9158325195312,16.2149963378906],[36.7636108398438,15.8080539703369],[36.6977767944336,15.7530536651611],[36.626106262207,15.4894428253174],[36.6477737426758,15.4497203826904],[36.6105499267578,15.4372215270996],[36.5427703857422,15.2347221374512],[36.4432830810547,15.1499519348145],[36.5428161621094,14.2620525360107],[36.4463882446289,13.9569444656372],[36.4869384765625,13.8394432067871],[36.3974990844727,13.567777633667],[36.2486038208008,13.3680553436279],[36.1594390869141,13.0416660308838],[36.1697158813477,12.9841651916504],[36.1327743530273,12.9233322143555],[36.1652755737305,12.8752765655518],[36.142692565918,12.7069225311279],[36.0063858032227,12.7241649627686],[35.6994400024414,12.6658334732056],[35.6952743530273,12.6122207641602],[35.6491622924805,12.594165802002],[35.4324951171875,12.200553894043],[35.381103515625,12.1611099243164],[35.3455505371094,12.0327758789062],[35.271110534668,11.9755554199219],[35.2355499267578,11.9008331298828],[35.0969390869141,11.8269443511963],[35.0580520629883,11.7205543518066],[35.0936050415039,11.5577774047852],[34.9638824462891,11.2569427490234],[35.0074996948242,11.1983318328857],[34.9333267211914,10.9566650390625],[34.9786071777344,10.9152765274048],[34.9752731323242,10.8644428253174],[34.8686065673828,10.785831451416],[34.8644409179688,10.7349987030029],[34.8086090087891,10.7294425964355],[34.7733306884766,10.6869430541992],[34.7733306884766,10.7458324432373],[34.5944442749023,10.8877773284912],[34.4397201538086,10.7844429016113],[34.2861099243164,10.5541648864746],[34.347770690918,10.2319431304932],[34.3230514526367,10.1172218322754],[34.2313842773438,10.0302772521973],[34.0858306884766,9.55305480957031],[34.1349945068359,8.95527648925781],[34.122802734375,8.58464622497559],[33.9788818359375,8.44138717651367],[33.8524932861328,8.42583274841309],[33.775993347168,8.36494636535645],[33.6933288574219,8.38638877868652],[33.6255493164062,8.47055435180664],[33.5780487060547,8.44944381713867],[33.5077743530273,8.48083305358887],[33.3877716064453,8.43777656555176],[33.2624969482422,8.46249961853027],[33.2044372558594,8.43388748168945],[33.1608276367188,8.35999870300293],[33.158332824707,8.2913875579834],[33.208610534668,8.2380542755127],[33.1652755737305,8.20472145080566],[33.1864242553711,8.13697814941406],[33.0302810668945,7.99524784088135],[32.996826171875,7.88721561431885],[33.0538864135742,7.7888879776001],[33.1680526733398,7.79638862609863],[33.3394393920898,7.71361064910889],[33.4702758789062,7.743332862854],[33.551383972168,7.68638801574707],[33.7113876342773,7.66027736663818],[33.7888870239258,7.56638813018799],[33.8927764892578,7.51888847351074],[33.9108989279366,7.5],[35.9405517578125,7.5],[30.8588180541992,7.5],],
			},
			"339" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,2",
				"p" => [[34.5930480957031,7.5],[33.9108989279366,7.5],[33.8927764892578,7.51888847351074],[33.7888870239258,7.56638813018799],[33.7113876342773,7.66027736663818],[33.551383972168,7.68638801574707],[33.4702758789062,7.743332862854],[33.3394393920898,7.71361064910889],[33.1680526733398,7.79638862609863],[33.0538864135742,7.7888879776001],[32.996826171875,7.88721561431885],[33.0302810668945,7.99524784088135],[33.1864242553711,8.13697814941406],[33.1652755737305,8.20472145080566],[33.208610534668,8.2380542755127],[33.158332824707,8.2913875579834],[33.1608276367188,8.35999870300293],[33.2044372558594,8.43388748168945],[33.2624969482422,8.46249961853027],[33.3877716064453,8.43777656555176],[33.5077743530273,8.48083305358887],[33.5780487060547,8.44944381713867],[33.6255493164062,8.47055435180664],[33.6933288574219,8.38638877868652],[33.775993347168,8.36494636535645],[33.8524932861328,8.42583274841309],[33.9788818359375,8.44138717651367],[34.122802734375,8.58464622497559],[34.1349945068359,8.95527648925781],[34.0858306884766,9.55305480957031],[34.2313842773438,10.0302772521973],[34.3230514526367,10.1172218322754],[34.347770690918,10.2319431304932],[34.2861099243164,10.5541648864746],[34.4397201538086,10.7844429016113],[34.5944442749023,10.8877773284912],[34.7733306884766,10.7458324432373],[34.7733306884766,10.6869430541992],[34.8086090087891,10.7294425964355],[34.8644409179688,10.7349987030029],[34.8686065673828,10.785831451416],[34.9752731323242,10.8644428253174],[34.9786071777344,10.9152765274048],[34.9333267211914,10.9566650390625],[35.0074996948242,11.1983318328857],[34.9638824462891,11.2569427490234],[35.0936050415039,11.5577774047852],[35.0580520629883,11.7205543518066],[35.0969390869141,11.8269443511963],[35.2355499267578,11.9008331298828],[35.271110534668,11.9755554199219],[35.3455505371094,12.0327758789062],[35.381103515625,12.1611099243164],[35.4324951171875,12.200553894043],[35.6491622924805,12.594165802002],[35.6952743530273,12.6122207641602],[35.6994400024414,12.6658334732056],[36.0063858032227,12.7241649627686],[36.142692565918,12.7069225311279],[36.1652755737305,12.8752765655518],[36.1327743530273,12.9233322143555],[36.1697158813477,12.9841651916504],[36.1594390869141,13.0416660308838],[36.2486038208008,13.3680553436279],[36.3974990844727,13.567777633667],[36.4869384765625,13.8394432067871],[36.4463882446289,13.9569444656372],[36.5428161621094,14.2620525360107],[36.4432830810547,15.1499519348145],[36.5427703857422,15.2347221374512],[36.6105499267578,15.4372215270996],[36.6477737426758,15.4497203826904],[36.626106262207,15.4894428253174],[36.6977767944336,15.7530536651611],[36.7636108398438,15.8080539703369],[36.9158325195312,16.2149963378906],[36.9730529785156,16.2694435119629],[36.9569396972656,16.4252777099609],[36.8963851928711,16.5177764892578],[36.9122161865234,16.6411094665527],[36.9805526733398,16.7061080932617],[37.0227737426758,16.8505554199219],[36.9869384765625,16.9430541992188],[37.0180511474609,17.0036087036133],[36.9958267211914,17.0738868713379],[37.1519393920898,17.015552520752],[37.3069381713867,17.061107635498],[37.4232864379883,17.0342140197754],[37.5,17.1616257894293],[37.5,22.5],[37.5,7.5],[34.5930480957031,7.5],],
			},
			"508" => {
				"z" => "Etc/GMT+1",
				"c" => "ESRI",
				"s" => "34,1",
				"p" => [[22.5,22.5],[25.0011711935604,22.5],[25.0014228820801,21.9996948242188],[25.0008316040039,19.9991645812988],[24.0027465820312,19.4990653991699],[23.9998054504395,18.7543029785156],[23.9996032714844,15.6987085342407],[23.60888671875,15.7583332061768],[23.3569412231445,15.6816654205322],[23.1181564331055,15.7102928161621],[22.9372215270996,15.5619430541992],[22.9230537414551,15.4872207641602],[22.9983329772949,15.356388092041],[22.9358329772949,15.1161098480225],[22.8491630554199,15.078332901001],[22.7533302307129,14.9769439697266],[22.7388877868652,14.9027767181396],[22.6705551147461,14.8594436645508],[22.7024993896484,14.6913871765137],[22.5,14.6374373973686],[22.5,14.2519301407958],[22.5552749633789,14.2319431304932],[22.5549964904785,14.1255550384521],[22.5,14.0982495843603],[22.5,12.1815244761004],[22.5013885498047,12.1769428253174],[22.5,12.1689239019892],[22.5,12.0450503788483],[22.5636100769043,12.0747203826904],[22.6408309936523,12.0711097717285],[22.5616645812988,11.6216659545898],[22.6419410705566,11.5161094665527],[22.7755546569824,11.4622211456299],[22.7911109924316,11.4016666412354],[22.9308319091797,11.4158334732056],[22.970832824707,11.2830543518066],[22.942497253418,11.0924987792969],[22.8665046691895,10.9224472045898],[23.0094413757324,10.6986103057861],[23.3038864135742,10.4591655731201],[23.6691665649414,9.866943359375],[23.6947212219238,9.67166519165039],[23.6233329772949,9.53527641296387],[23.6313858032227,9.44944381713867],[23.6644439697266,9.44083213806152],[23.6522216796875,9.27999877929688],[23.5563888549805,9.18166542053223],[23.4927749633789,9.17416572570801],[23.4486083984375,9.02499961853027],[23.5036087036133,8.95972061157227],[23.5652770996094,9.00527763366699],[23.5830535888672,8.98860931396484],[23.5816650390625,8.9061107635498],[23.4983329772949,8.7783317565918],[23.5177764892578,8.71416664123535],[23.6330528259277,8.7369441986084],[23.7391662597656,8.70527648925781],[23.8238868713379,8.7277774810791],[24.2533302307129,8.69111061096191],[24.2302742004395,8.62499809265137],[24.2691650390625,8.58305549621582],[24.1658325195312,8.4777774810791],[24.1402740478516,8.37583160400391],[24.1772193908691,8.31611061096191],[24.3611106872559,8.24722099304199],[24.4599990844727,8.27138710021973],[24.5458297729492,8.20472145080566],[24.6599998474121,8.2186107635498],[24.8655548095703,8.1652774810791],[24.9427757263184,8.08388710021973],[24.973331451416,7.99277687072754],[25.0802764892578,7.89749908447266],[25.186107635498,7.90194416046143],[25.2583312988281,7.84083271026611],[25.2961082458496,7.64999961853027],[25.1838874816895,7.58333301544189],[25.2062718353368,7.5],[22.5,7.5],[22.5,22.5],[25.8127746582031,22.5],[22.5,22.5],],
			},
		},
		# Grid 2:2 ; 3 records
		"2" => {
			"109" => {
				"z1" => "33.3666667,35.1666667,Asia/Nicosia",
				"z0" => "36.3,33.5,Asia/Damascus",
				"z2" => "35.9333333,31.95,Asia/Amman",
				"z3" => "31.25,30.05,Africa/Cairo",
				"z6" => "35.5097222,33.8719444,Asia/Beirut",
				"z4" => "35.23,31.78,Asia/Jerusalem",
				"z5" => "34.3,31.3,Asia/Gaza",
				"c" => "ESRI",
				"s" => "10,2",
				"p" => [[30.8588180541992,22.5],[25.0011711935604,22.5],[24.9977760314941,29.2488861083984],[24.877498626709,29.5063858032227],[24.8869438171387,29.6638870239258],[24.8124961853027,29.7844429016113],[24.8347206115723,29.8766632080078],[24.7066650390625,30.1686096191406],[24.7808303833008,30.3338851928711],[24.9261093139648,30.5061073303223],[25.0191650390625,30.7874984741211],[24.869441986084,31.1563873291016],[24.8683319091797,31.3749961853027],[25.0422210693359,31.4997215270996],[25.0697212219238,31.5816650390625],[25.1516647338867,31.6469421386719],[25.0255546569824,31.8413887023926],[25.0361099243164,31.9244422912598],[24.9738883972168,31.9699974060059],[24.7274971008301,32.0269393920898],[24.5430526733398,31.9852752685547],[24.0947189331055,32.001106262207],[23.9677772521973,32.067497253418],[23.986385345459,32.0983276367188],[23.7263870239258,32.1747207641602],[23.5016632080078,32.17138671875],[23.3077774047852,32.2186050415039],[23.3091659545898,32.1586074829102],[23.2088851928711,32.2755508422852],[23.0813865661621,32.3327713012695],[23.0930519104004,32.4266662597656],[23.1333312988281,32.3966598510742],[23.1455535888672,32.4669418334961],[23.098331451416,32.5216598510742],[23.1222190856934,32.6266632080078],[22.5025749206543,32.7931327819824],[22.5025749206543,36.376651763916],[22.5,36.3781215649597],[22.5,37.5],[37.5,37.5],[37.5,31.6292532087873],[37.0052719116211,31.5055541992188],[37.5,31.008207780156],[37.5,30.0017171662731],[36.7436065673828,29.8647193908691],[36.5005493164062,29.5027770996094],[36.0699996948242,29.1888885498047],[34.9613876342773,29.3608322143555],[34.8552703857422,29.0386085510254],[34.8425369262695,28.8845176696777],[34.7805480957031,28.6708297729492],[34.8077774047852,28.5363883972168],[34.6452713012695,28.1936073303223],[34.6597213745117,28.1644439697266],[34.6274948120117,28.173885345459],[34.5713882446289,28.0905532836914],[34.4849395751953,27.995418548584],[34.4948310852051,27.9373168945312],[34.6346015930176,27.8718509674072],[34.8818817138672,27.8959770202637],[35.2678871154785,27.6305999755859],[35.7142066955566,27.0998439788818],[36.4982757568359,26.0624580383301],[36.4741516113281,25.6221714019775],[36.5404930114746,25.5437641143799],[36.8299980163574,25.5196399688721],[36.9687194824219,25.3990135192871],[37.0109367370605,24.9707889556885],[37.5,24.2149216073864],[37.5,22.5],[35.9405517578125,22.5],[30.8588180541992,22.5],],
			},
			"340" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,2",
				"p" => [[34.5930480957031,22.5],[37.5,22.5],[37.5,24.2149216073864],[37.0109367370605,24.9707889556885],[36.9687194824219,25.3990135192871],[36.8299980163574,25.5196399688721],[36.5404930114746,25.5437641143799],[36.4741516113281,25.6221714019775],[36.4982757568359,26.0624580383301],[35.7142066955566,27.0998439788818],[35.2678871154785,27.6305999755859],[34.8818817138672,27.8959770202637],[34.6346015930176,27.8718509674072],[34.4948310852051,27.9373168945312],[34.4849395751953,27.995418548584],[34.5713882446289,28.0905532836914],[34.6274948120117,28.173885345459],[34.6597213745117,28.1644439697266],[34.6452713012695,28.1936073303223],[34.8077774047852,28.5363883972168],[34.7805480957031,28.6708297729492],[34.8425369262695,28.8845176696777],[34.8552703857422,29.0386085510254],[34.9613876342773,29.3608322143555],[36.0699996948242,29.1888885498047],[36.5005493164062,29.5027770996094],[36.7436065673828,29.8647193908691],[37.5,30.0017171662731],[37.5,31.008207780156],[37.0052719116211,31.5055541992188],[37.5,31.6292532087873],[37.5,22.5],[34.5930480957031,22.5],],
			},
			"509" => {
				"z" => "Etc/GMT+1",
				"c" => "ESRI",
				"s" => "34,1",
				"p" => [[27.4580535888672,22.5],[22.5,22.5],[22.5,37.5],[22.5,36.3781215649597],[22.5025749206543,36.376651763916],[22.5025749206543,32.7931327819824],[23.1222190856934,32.6266632080078],[23.098331451416,32.5216598510742],[23.1455535888672,32.4669418334961],[23.1333312988281,32.3966598510742],[23.0930519104004,32.4266662597656],[23.0813865661621,32.3327713012695],[23.2088851928711,32.2755508422852],[23.3091659545898,32.1586074829102],[23.3077774047852,32.2186050415039],[23.5016632080078,32.17138671875],[23.7263870239258,32.1747207641602],[23.986385345459,32.0983276367188],[23.9677772521973,32.067497253418],[24.0947189331055,32.001106262207],[24.5430526733398,31.9852752685547],[24.7274971008301,32.0269393920898],[24.9738883972168,31.9699974060059],[25.0361099243164,31.9244422912598],[25.0255546569824,31.8413887023926],[25.1516647338867,31.6469421386719],[25.0697212219238,31.5816650390625],[25.0422210693359,31.4997215270996],[24.8683319091797,31.3749961853027],[24.869441986084,31.1563873291016],[25.0191650390625,30.7874984741211],[24.9261093139648,30.5061073303223],[24.7808303833008,30.3338851928711],[24.7066650390625,30.1686096191406],[24.8347206115723,29.8766632080078],[24.8124961853027,29.7844429016113],[24.8869438171387,29.6638870239258],[24.877498626709,29.5063858032227],[24.9977760314941,29.2488861083984],[25.0011711935604,22.5],[23.4486083984375,22.5],[27.4580535888672,22.5],],
			},
		},
		# Grid 2:3 ; 3 records
		"3" => {
			"110" => {
				"z8" => "23.7333333,37.9833333,Europe/Athens",
				"z1" => "30.5166667,50.4333333,Europe/Kiev",
				"z0" => "28.8575,47.0055556,Europe/Chisinau",
				"z7" => "34.1,44.95,Europe/Simferopol",
				"z2" => "26.3833333,45.4,Asia/Magadan",
				"z3" => "28.9647222,41.0186111,Europe/Istanbul",
				"z6" => "23.3166667,42.6833333,Europe/Sofia",
				"z4" => "26.1,44.4333333,Europe/Bucharest",
				"z5" => "35.0402778,46.9588889,Europe/Zaporozhye",
				"c" => "ESRI",
				"s" => "10,2",
				"p" => [[30.8588180541992,37.5],[22.5,37.5],[22.5,41.1220865252528],[22.5855522155762,41.1194381713867],[22.6724967956543,41.1877746582031],[22.7291641235352,41.1447219848633],[22.7722206115723,41.3244400024414],[22.9608306884766,41.3586044311523],[22.9524993896484,41.6344375610352],[23.0327758789062,41.7283325195312],[22.9619407653809,41.7786102294922],[22.8958320617676,41.8852767944336],[22.8644409179688,42.0272216796875],[22.6752777099609,42.067497253418],[22.521110534668,42.1486053466797],[22.5,42.1723498534708],[22.5,42.3998546937425],[22.5580520629883,42.4791641235352],[22.5,42.5256042906882],[22.5,42.7375574409087],[22.5013885498047,42.7391662597656],[22.5,42.7411022263749],[22.5,42.8614121214695],[22.5249977111816,42.8786087036133],[22.7455520629883,42.8936080932617],[22.7908325195312,42.9852752685547],[22.9663887023926,43.1016616821289],[23.0072212219238,43.1961059570312],[22.9044418334961,43.230827331543],[22.7666664123535,43.3858261108398],[22.5433311462402,43.4724960327148],[22.5,43.5611717964218],[22.5,44.0327578254807],[22.6224975585938,44.0708312988281],[22.6166648864746,44.1727752685547],[22.6814346313477,44.2247009277344],[22.6874961853027,44.2777709960938],[22.5497207641602,44.3230514526367],[22.5,44.404480264299],[22.5,44.4806719091841],[22.5461082458496,44.4874954223633],[22.590274810791,44.5491638183594],[22.6995849609375,44.5225219726562],[22.764892578125,44.5590057373047],[22.5,44.6992429845473],[22.5,47.7918108434364],[22.6536102294922,47.7763824462891],[22.7744407653809,47.8363876342773],[22.7708320617676,47.8794403076172],[22.8948040008545,47.9545402526855],[22.8505554199219,47.980827331543],[22.882495880127,48.0469436645508],[22.7974967956543,48.1147155761719],[22.621150970459,48.1016387939453],[22.5752754211426,48.1944351196289],[22.5044441223145,48.2474899291992],[22.5,48.2474212202417],[22.5,48.9864990650949],[22.5372200012207,48.9955444335938],[22.5580520629883,49.0794372558594],[22.5980529785156,49.0911026000977],[22.6741638183594,49.0441589355469],[22.7691650390625,49.0533218383789],[22.8860740661621,49.0029144287109],[22.876106262207,49.0899887084961],[22.7347183227539,49.1772155761719],[22.7002716064453,49.1655426025391],[22.7602767944336,49.2952728271484],[22.7383270263672,49.3902740478516],[22.6922187805176,49.4233245849609],[22.6561050415039,49.5197143554688],[22.6860675811768,49.5770950317383],[23.1461067199707,49.9830474853516],[23.6769409179688,50.3244400024414],[23.7038841247559,50.3783264160156],[23.9916610717773,50.4072113037109],[24.0261077880859,50.4938774108887],[24.1327743530273,50.5444412231445],[24.079719543457,50.7049942016602],[23.9524955749512,50.7947158813477],[23.972770690918,50.8280487060547],[24.1147193908691,50.8313827514648],[24.144718170166,50.8580474853516],[23.9663848876953,50.9488754272461],[23.8627738952637,51.0983276367188],[23.8669395446777,51.1486053466797],[23.6361083984375,51.3011016845703],[23.6930503845215,51.4047088623047],[23.6046333312988,51.5276947021484],[23.5613861083984,51.5424957275391],[23.5349922180176,51.6535949707031],[23.5555534362793,51.7494354248047],[23.6294403076172,51.8047103881836],[23.5947189331055,51.8336029052734],[23.6117362976074,51.9139709472656],[23.6727714538574,51.9913787841797],[23.6386070251465,52.0794372558594],[23.514720916748,52.1236038208008],[23.493049621582,52.1741638183594],[23.2063827514648,52.2252655029297],[23.1653995513916,52.2822761535645],[23.3827960661706,52.5],[31.5933147317348,52.5],[31.60888671875,52.4913787841797],[31.6016616821289,52.4060974121094],[31.6297187805176,52.3705444335938],[31.5866622924805,52.3188858032227],[31.7169380187988,52.2616653442383],[31.7038841247559,52.198600769043],[31.7824974060059,52.1658248901367],[31.7838859558105,52.1080474853516],[31.8977737426758,52.0960998535156],[31.926383972168,52.0366592407227],[32.1244354248047,52.0438842773438],[32.2249908447266,52.0794372558594],[32.3355484008789,52.1572113037109],[32.3405456542969,52.2213745117188],[32.3863830566406,52.2547149658203],[32.3583297729492,52.3099899291992],[32.394157409668,52.3352661132812],[32.9236068725586,52.2472152709961],[33.2047119140625,52.3797149658203],[33.4488754272461,52.3436050415039],[33.4977722167969,52.3666610717773],[33.535270690918,52.293327331543],[33.6963806152344,52.3616638183594],[33.8305511474609,52.3647155761719],[34.097770690918,52.1519317626953],[34.0730514526367,52.0602722167969],[34.128044128418,51.9897155761719],[34.1094360351562,51.959716796875],[34.1694412231445,51.9599914550781],[34.2577743530273,51.8794326782227],[34.3808212280273,51.8449935913086],[34.440544128418,51.7672119140625],[34.4055480957031,51.7185974121094],[34.1027755737305,51.6744384765625],[34.1011047363281,51.6474914550781],[34.1597137451172,51.6286010742188],[34.2341613769531,51.5466613769531],[34.2391586303711,51.4277725219727],[34.2036056518555,51.4066543579102],[34.3149948120117,51.3511047363281],[34.2738800048828,51.2855529785156],[34.2089157104492,51.2591934204102],[34.3052673339844,51.2308197021484],[34.382209777832,51.2636108398438],[34.6336059570312,51.2422180175781],[34.6699905395508,51.1794357299805],[34.734992980957,51.172492980957],[35.0738067626953,51.2214813232422],[35.118522644043,51.2048187255859],[35.1707534790039,51.054801940918],[35.3718872070312,51.0414352416992],[35.3585586547852,51.0108795166016],[35.2971649169922,50.9997863769531],[35.3057708740234,50.960334777832],[35.3613357543945,50.9261474609375],[35.3605041503906,50.8722610473633],[35.3977279663086,50.8030853271484],[35.4566268920898,50.7727890014648],[35.4582901000977,50.6941757202148],[35.4885711669922,50.6758499145508],[35.3935546875,50.6380844116211],[35.4410552978516,50.5119705200195],[35.5671997070312,50.4530563354492],[35.5830459594727,50.3830490112305],[35.6447143554688,50.3541641235352],[35.728874206543,50.3533248901367],[35.7391586303711,50.3833312988281],[35.8502731323242,50.4286041259766],[36.13916015625,50.4252700805664],[36.297492980957,50.2844390869141],[36.4127655029297,50.321662902832],[36.5633239746094,50.2763824462891],[36.5624923706055,50.2224884033203],[36.6402740478516,50.2124938964844],[36.7011032104492,50.2669372558594],[36.8844375610352,50.335823059082],[37.1305465698242,50.3483276367188],[37.3158264160156,50.4280471801758],[37.4586029052734,50.4397125244141],[37.4944381713867,50.3513870239258],[37.5,50.3494011258769],[37.5,46.541318757267],[36.6740455627441,45.4180221557617],[36.5450668334961,45.1794128417969],[36.5386199951172,44.908561706543],[36.5541038513184,41.2856597900391],[36.6183319091797,41.3749847412109],[36.85693359375,41.3472137451172],[37.0233306884766,41.2674865722656],[37.0433197021484,41.1755447387695],[37.1522827148438,41.1449127197266],[37.2949905395508,41.1438827514648],[37.5,41.0458400830133],[37.5,37.5],[35.9405517578125,37.5],[30.8588180541992,37.5],],
			},
			"327" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,1",
				"p" => [[37.5,48.013053894043],[37.5,41.0458400830133],[37.2949905395508,41.1438827514648],[37.1522827148438,41.1449127197266],[37.0433197021484,41.1755447387695],[37.0233306884766,41.2674865722656],[36.85693359375,41.3472137451172],[36.6183319091797,41.3749847412109],[36.5541038513184,41.2856597900391],[36.5386199951172,44.908561706543],[36.5450668334961,45.1794128417969],[36.6740455627441,45.4180221557617],[37.5,46.541318757267],[37.5,50.3494011258769],[37.4944381713867,50.3513870239258],[37.4586029052734,50.4397125244141],[37.3158264160156,50.4280471801758],[37.1305465698242,50.3483276367188],[36.8844375610352,50.335823059082],[36.7011032104492,50.2669372558594],[36.6402740478516,50.2124938964844],[36.5624923706055,50.2224884033203],[36.5633239746094,50.2763824462891],[36.4127655029297,50.321662902832],[36.297492980957,50.2844390869141],[36.13916015625,50.4252700805664],[35.8502731323242,50.4286041259766],[35.7391586303711,50.3833312988281],[35.728874206543,50.3533248901367],[35.6447143554688,50.3541641235352],[35.5830459594727,50.3830490112305],[35.5671997070312,50.4530563354492],[35.4410552978516,50.5119705200195],[35.3935546875,50.6380844116211],[35.4885711669922,50.6758499145508],[35.4582901000977,50.6941757202148],[35.4566268920898,50.7727890014648],[35.3977279663086,50.8030853271484],[35.3605041503906,50.8722610473633],[35.3613357543945,50.9261474609375],[35.3057708740234,50.960334777832],[35.2971649169922,50.9997863769531],[35.3585586547852,51.0108795166016],[35.3718872070312,51.0414352416992],[35.1707534790039,51.054801940918],[35.118522644043,51.2048187255859],[35.0738067626953,51.2214813232422],[34.734992980957,51.172492980957],[34.6699905395508,51.1794357299805],[34.6336059570312,51.2422180175781],[34.382209777832,51.2636108398438],[34.3052673339844,51.2308197021484],[34.2089157104492,51.2591934204102],[34.2738800048828,51.2855529785156],[34.3149948120117,51.3511047363281],[34.2036056518555,51.4066543579102],[34.2391586303711,51.4277725219727],[34.2341613769531,51.5466613769531],[34.1597137451172,51.6286010742188],[34.1011047363281,51.6474914550781],[34.1027755737305,51.6744384765625],[34.4055480957031,51.7185974121094],[34.440544128418,51.7672119140625],[34.3808212280273,51.8449935913086],[34.2577743530273,51.8794326782227],[34.1694412231445,51.9599914550781],[34.1094360351562,51.959716796875],[34.128044128418,51.9897155761719],[34.0730514526367,52.0602722167969],[34.097770690918,52.1519317626953],[33.8305511474609,52.3647155761719],[33.6963806152344,52.3616638183594],[33.535270690918,52.293327331543],[33.4977722167969,52.3666610717773],[33.4488754272461,52.3436050415039],[33.2047119140625,52.3797149658203],[32.9236068725586,52.2472152709961],[32.394157409668,52.3352661132812],[32.3583297729492,52.3099899291992],[32.3863830566406,52.2547149658203],[32.3405456542969,52.2213745117188],[32.3355484008789,52.1572113037109],[32.2249908447266,52.0794372558594],[32.1244354248047,52.0438842773438],[31.926383972168,52.0366592407227],[31.8977737426758,52.0960998535156],[31.7838859558105,52.1080474853516],[31.7824974060059,52.1658248901367],[31.7038841247559,52.198600769043],[31.7169380187988,52.2616653442383],[31.5866622924805,52.3188858032227],[31.6297187805176,52.3705444335938],[31.6016616821289,52.4060974121094],[31.60888671875,52.4913787841797],[31.5933147317348,52.5],[37.5,52.5],[37.5,51.2086029052734],[37.5,48.013053894043],],
			},
			"510" => {
				"z" => "Etc/GMT+1",
				"c" => "ESRI",
				"s" => "34,1",
				"p" => [[27.4580535888672,37.5],[22.5,37.5],[22.5,52.5],[23.3827960661706,52.5],[23.1653995513916,52.2822761535645],[23.2063827514648,52.2252655029297],[23.493049621582,52.1741638183594],[23.514720916748,52.1236038208008],[23.6386070251465,52.0794372558594],[23.6727714538574,51.9913787841797],[23.6117362976074,51.9139709472656],[23.5947189331055,51.8336029052734],[23.6294403076172,51.8047103881836],[23.5555534362793,51.7494354248047],[23.5349922180176,51.6535949707031],[23.5613861083984,51.5424957275391],[23.6046333312988,51.5276947021484],[23.6930503845215,51.4047088623047],[23.6361083984375,51.3011016845703],[23.8669395446777,51.1486053466797],[23.8627738952637,51.0983276367188],[23.9663848876953,50.9488754272461],[24.144718170166,50.8580474853516],[24.1147193908691,50.8313827514648],[23.972770690918,50.8280487060547],[23.9524955749512,50.7947158813477],[24.079719543457,50.7049942016602],[24.1327743530273,50.5444412231445],[24.0261077880859,50.4938774108887],[23.9916610717773,50.4072113037109],[23.7038841247559,50.3783264160156],[23.6769409179688,50.3244400024414],[23.1461067199707,49.9830474853516],[22.6860675811768,49.5770950317383],[22.6561050415039,49.5197143554688],[22.6922187805176,49.4233245849609],[22.7383270263672,49.3902740478516],[22.7602767944336,49.2952728271484],[22.7002716064453,49.1655426025391],[22.7347183227539,49.1772155761719],[22.876106262207,49.0899887084961],[22.8860740661621,49.0029144287109],[22.7691650390625,49.0533218383789],[22.6741638183594,49.0441589355469],[22.5980529785156,49.0911026000977],[22.5580520629883,49.0794372558594],[22.5372200012207,48.9955444335938],[22.5,48.9864990650949],[22.5,48.2474212202417],[22.5044441223145,48.2474899291992],[22.5752754211426,48.1944351196289],[22.621150970459,48.1016387939453],[22.7974967956543,48.1147155761719],[22.882495880127,48.0469436645508],[22.8505554199219,47.980827331543],[22.8948040008545,47.9545402526855],[22.7708320617676,47.8794403076172],[22.7744407653809,47.8363876342773],[22.6536102294922,47.7763824462891],[22.5,47.7918108434364],[22.5,44.6992429845473],[22.764892578125,44.5590057373047],[22.6995849609375,44.5225219726562],[22.590274810791,44.5491638183594],[22.5461082458496,44.4874954223633],[22.5,44.4806719091841],[22.5,44.404480264299],[22.5497207641602,44.3230514526367],[22.6874961853027,44.2777709960938],[22.6814346313477,44.2247009277344],[22.6166648864746,44.1727752685547],[22.6224975585938,44.0708312988281],[22.5,44.0327578254807],[22.5,43.5611717964218],[22.5433311462402,43.4724960327148],[22.7666664123535,43.3858261108398],[22.9044418334961,43.230827331543],[23.0072212219238,43.1961059570312],[22.9663887023926,43.1016616821289],[22.7908325195312,42.9852752685547],[22.7455520629883,42.8936080932617],[22.5249977111816,42.8786087036133],[22.5,42.8614121214695],[22.5,42.7411022263749],[22.5013885498047,42.7391662597656],[22.5,42.7375574409087],[22.5,42.5256042906882],[22.5580520629883,42.4791641235352],[22.5,42.3998546937425],[22.5,42.1723498534708],[22.521110534668,42.1486053466797],[22.6752777099609,42.067497253418],[22.8644409179688,42.0272216796875],[22.8958320617676,41.8852767944336],[22.9619407653809,41.7786102294922],[23.0327758789062,41.7283325195312],[22.9524993896484,41.6344375610352],[22.9608306884766,41.3586044311523],[22.7722206115723,41.3244400024414],[22.7291641235352,41.1447219848633],[22.6724967956543,41.1877746582031],[22.5855522155762,41.1194381713867],[22.5,41.1220865252528],[22.5,37.5],[23.4486083984375,37.5],[27.4580535888672,37.5],],
			},
		},
		# Grid 2:4 ; 3 records
		"4" => {
			"def_z" => "Asia/Kamchatka",
			"111" => {
				"z1" => "24.9341667,60.1755556,Europe/Helsinki",
				"z0" => "25.3166667,54.6833333,Europe/Vilnius",
				"z2" => "24.1,56.95,Europe/Riga",
				"z3" => "24.7280556,59.4338889,Europe/Tallinn",
				"c" => "ESRI",
				"s" => "10,2",
				"p" => [[30.8588180541992,52.5],[23.3827960661706,52.5],[23.397216796875,52.5144424438477],[23.5972175598145,52.5963821411133],[23.7538871765137,52.6158294677734],[23.9408302307129,52.7322082519531],[23.9152717590332,52.9188842773438],[23.9330520629883,53.01416015625],[23.8780517578125,53.075553894043],[23.9105529785156,53.1672134399414],[23.8147201538086,53.2544403076172],[23.6747169494629,53.4911041259766],[23.5040397644043,53.9470443725586],[23.4752731323242,53.9911041259766],[23.5177764892578,54.0302734375],[23.4844398498535,54.1383285522461],[23.3502731323242,54.238883972168],[23.1424942016602,54.310546875],[23.0661087036133,54.3080444335938],[23.0616645812988,54.3516616821289],[22.9874954223633,54.38916015625],[22.8561058044434,54.4085998535156],[22.7858848571777,54.3638381958008],[22.6944389343262,54.4733200073242],[22.6983299255371,54.5894317626953],[22.740550994873,54.7277679443359],[22.8424949645996,54.7774887084961],[22.8691635131836,54.8233261108398],[22.8349952697754,54.9016571044922],[22.7555541992188,54.9205474853516],[22.7705535888672,54.9388809204102],[22.7322158813477,54.9624938964844],[22.6408309936523,54.9663848876953],[22.5992012023926,55.0711288452148],[22.5,55.0687923292026],[22.5,64.6138310518545],[24.1660079956055,65.8115005493164],[23.9486083984375,66.1013793945312],[23.9124984741211,66.1483306884766],[23.7222213745117,66.2002716064453],[23.6391639709473,66.4305419921875],[23.7252769470215,66.5008239746094],[23.8786087036133,66.5572204589844],[23.8899993896484,66.7430419921875],[24.0077743530273,66.8005523681641],[23.571662902832,67.1566619873047],[23.6102752685547,67.20166015625],[23.5844421386719,67.223876953125],[23.6055526733398,67.2594299316406],[23.7733306884766,67.3144378662109],[23.7447204589844,67.3683319091797],[23.7677764892578,67.4161071777344],[23.5491638183594,67.4533233642578],[23.4869422912598,67.4380493164062],[23.4288864135742,67.475830078125],[23.4418058068401,67.5],[29.9063727121068,67.5],[29.5461082458496,67.310546875],[29.0830535888672,66.9586029052734],[29.0933303833008,66.8513793945312],[29.3502769470215,66.6824951171875],[29.4205551147461,66.5849914550781],[29.5483322143555,66.4955444335938],[29.5679244995117,66.4285736083984],[29.6386108398438,66.3224945068359],[29.9102745056152,66.1269378662109],[29.9769439697266,65.9811096191406],[30.0966644287109,65.8333282470703],[30.1352767944336,65.7035980224609],[30.1238861083984,65.6649932861328],[30.0244407653809,65.6911010742188],[29.7219429016113,65.6380462646484],[29.8597221374512,65.5661010742188],[29.7461090087891,65.5144348144531],[29.7474975585938,65.3419342041016],[29.5963859558105,65.2488861083984],[29.8536109924316,65.2161102294922],[29.8702774047852,65.1874847412109],[29.8233299255371,65.1488800048828],[29.8738861083984,65.1208190917969],[29.6288871765137,65.0630493164062],[29.6066665649414,65.0016632080078],[29.6366653442383,64.9280548095703],[29.8047218322754,64.7938842773438],[30.1408309936523,64.7741546630859],[30.1205520629883,64.7305450439453],[30.1971321105957,64.6862182617188],[30.1991653442383,64.6502685546875],[29.9749984741211,64.5811004638672],[30.0096702575684,64.5128631591797],[30.0872192382812,64.4830474853516],[30.0522193908691,64.4047088623047],[30.1561088562012,64.3541564941406],[30.389720916748,64.3094329833984],[30.4541664123535,64.2569427490234],[30.5608329772949,64.2444305419922],[30.577220916748,64.2158203125],[30.5480537414551,64.1747131347656],[30.6144409179688,64.0866546630859],[30.5952758789062,64.0469360351562],[30.3449974060059,63.9097213745117],[30.2558326721191,63.8177719116211],[29.996711730957,63.7480239868164],[30.4816665649414,63.4786071777344],[30.79638671875,63.4019393920898],[30.9624977111816,63.3097152709961],[31.2197189331055,63.2230529785156],[31.2822189331055,63.1091613769531],[31.5149993896484,62.9869384765625],[31.5889282226562,62.9144134521484],[31.4674987792969,62.8063888549805],[31.2597198486328,62.5077743530273],[30.9477767944336,62.3113861083984],[30.6497192382812,62.1949996948242],[29.9913864135742,61.7294387817383],[29.8322219848633,61.6530532836914],[29.8091659545898,61.6083297729492],[29.5255546569824,61.4827728271484],[29.486385345459,61.4261093139648],[29.2136077880859,61.2533264160156],[28.8127746582031,61.1033325195312],[28.6388854980469,60.9661102294922],[28.5291633605957,60.9549942016602],[28.3888854980469,60.8866653442383],[27.8078308105469,60.5464019775391],[28.0158309936523,59.4785995483398],[28.1938858032227,59.3758239746094],[28.1703586578369,59.3097801208496],[27.9125366210938,59.2718200683594],[27.7249946594238,58.9877700805664],[27.4936065673828,58.8819351196289],[27.4261054992676,58.813606262207],[27.5424957275391,58.4138793945312],[27.5391654968262,58.3616638183594],[27.4647178649902,58.2977752685547],[27.4741630554199,58.2138824462891],[27.5541648864746,58.1327667236328],[27.6772193908691,58.0741653442383],[27.642219543457,58.0208282470703],[27.6972160339355,58.0008316040039],[27.6838836669922,57.926383972168],[27.8230514526367,57.8738784790039],[27.7530517578125,57.8391571044922],[27.5458297729492,57.8177719116211],[27.5727729797363,57.8027725219727],[27.5163879394531,57.773323059082],[27.5266647338867,57.7227630615234],[27.4130516052246,57.690544128418],[27.4058303833008,57.6136093139648],[27.3480529785156,57.5955429077148],[27.3720588684082,57.5356369018555],[27.5472183227539,57.5363845825195],[27.5272216796875,57.4385986328125],[27.8611068725586,57.3022155761719],[27.8408317565918,57.1636047363281],[27.7013854980469,57.1191558837891],[27.7774963378906,57.0658264160156],[27.6399955749512,56.8480453491211],[27.8155517578125,56.8783264160156],[27.9352722167969,56.8272171020508],[27.8861083984375,56.7472152709961],[28.004997253418,56.6913757324219],[28.0363845825195,56.5905456542969],[28.1524963378906,56.5544357299805],[28.1130523681641,56.5055541992188],[28.1897163391113,56.440544128418],[28.184440612793,56.3747100830078],[28.2377738952637,56.2711029052734],[28.1680107116699,56.1501541137695],[28.3124961853027,56.0499954223633],[28.3874969482422,56.0960998535156],[28.6461067199707,56.0936050415039],[28.7541656494141,55.9538803100586],[28.8469429016113,55.9424896240234],[28.869441986084,55.9805450439453],[29.059440612793,56.0327682495117],[29.4122161865234,55.9577713012695],[29.4644393920898,55.9111022949219],[29.4069404602051,55.8958282470703],[29.3591613769531,55.789436340332],[29.4938850402832,55.6888809204102],[29.7191619873047,55.7824935913086],[29.8230514526367,55.7752685546875],[29.9283294677734,55.8516616821289],[30.140552520752,55.8280487060547],[30.2261047363281,55.8661041259766],[30.4897155761719,55.7999954223633],[30.4941596984863,55.7638854980469],[30.6124954223633,55.7202682495117],[30.60888671875,55.6813812255859],[30.7269401550293,55.656379699707],[30.756664276123,55.5966567993164],[30.9188842773438,55.6083297729492],[30.9399948120117,55.4958267211914],[30.9005508422852,55.4591598510742],[30.9394378662109,55.3994369506836],[30.8136100769043,55.293327331543],[31.0047187805176,55.1433258056641],[30.9872169494629,55.1116638183594],[31.0297203063965,55.043327331543],[30.9249954223633,55.033332824707],[30.9474945068359,54.9691543579102],[30.8338851928711,54.9441528320312],[30.8449974060059,54.881103515625],[30.7799987792969,54.7969436645508],[31.004997253418,54.7116622924805],[31.0247192382812,54.652214050293],[31.1852722167969,54.642219543457],[31.184440612793,54.6061019897461],[31.0824966430664,54.5055541992188],[31.198600769043,54.4609375],[31.2319374084473,54.456657409668],[31.3116645812988,54.350830078125],[31.3316650390625,54.2374954223633],[31.5441627502441,54.1433258056641],[31.7616653442383,54.1033248901367],[31.7933311462402,54.0530471801758],[31.8441619873047,54.0644378662109],[31.8608283996582,53.9633255004883],[31.7642250061035,53.802619934082],[31.9022178649902,53.7777709960938],[32.1197128295898,53.8199920654297],[32.3294372558594,53.7622146606445],[32.3769378662109,53.718879699707],[32.45166015625,53.7263793945312],[32.5105514526367,53.6836013793945],[32.4147109985352,53.6463851928711],[32.4438781738281,53.5719375610352],[32.5974884033203,53.4911041259766],[32.6705474853516,53.4972152709961],[32.6608200073242,53.4666595458984],[32.7411041259766,53.4630508422852],[32.7369384765625,53.3424911499023],[32.4624938964844,53.3083267211914],[32.4983291625977,53.2783279418945],[32.4399871826172,53.2088851928711],[32.2988815307617,53.1319351196289],[32.2255477905273,53.1333312988281],[32.2233200073242,53.1055526733398],[31.930549621582,53.0955429077148],[31.8011093139648,53.1258239746094],[31.7755546569824,53.1941528320312],[31.6161079406738,53.2183227539062],[31.4224967956543,53.2088851928711],[31.374828338623,53.1219329833984],[31.3863830566406,53.0991592407227],[31.2663879394531,53.0219345092773],[31.3563842773438,52.9780426025391],[31.4152717590332,52.8930511474609],[31.5369415283203,52.8561019897461],[31.5808296203613,52.8030471801758],[31.5949974060059,52.7380447387695],[31.5,52.6899871826172],[31.6533279418945,52.5530471801758],[31.5816650390625,52.5508270263672],[31.5952758789062,52.5322113037109],[31.5647201538086,52.5158309936523],[31.5933147317348,52.5],[35.9405517578125,52.5],[30.8588180541992,52.5],],
			},
			"511" => {
				"z" => "Etc/GMT+1",
				"c" => "ESRI",
				"s" => "34,1",
				"p" => [[27.4580535888672,52.5],[22.5,52.5],[22.5,67.5],[23.4418058068401,67.5],[23.4288864135742,67.475830078125],[23.4869422912598,67.4380493164062],[23.5491638183594,67.4533233642578],[23.7677764892578,67.4161071777344],[23.7447204589844,67.3683319091797],[23.7733306884766,67.3144378662109],[23.6055526733398,67.2594299316406],[23.5844421386719,67.223876953125],[23.6102752685547,67.20166015625],[23.571662902832,67.1566619873047],[24.0077743530273,66.8005523681641],[23.8899993896484,66.7430419921875],[23.8786087036133,66.5572204589844],[23.7252769470215,66.5008239746094],[23.6391639709473,66.4305419921875],[23.7222213745117,66.2002716064453],[23.9124984741211,66.1483306884766],[23.9486083984375,66.1013793945312],[24.1660079956055,65.8115005493164],[22.5,64.6138310518545],[22.5,55.0687923292026],[22.5992012023926,55.0711288452148],[22.6408309936523,54.9663848876953],[22.7322158813477,54.9624938964844],[22.7705535888672,54.9388809204102],[22.7555541992188,54.9205474853516],[22.8349952697754,54.9016571044922],[22.8691635131836,54.8233261108398],[22.8424949645996,54.7774887084961],[22.740550994873,54.7277679443359],[22.6983299255371,54.5894317626953],[22.6944389343262,54.4733200073242],[22.7858848571777,54.3638381958008],[22.8561058044434,54.4085998535156],[22.9874954223633,54.38916015625],[23.0616645812988,54.3516616821289],[23.0661087036133,54.3080444335938],[23.1424942016602,54.310546875],[23.3502731323242,54.238883972168],[23.4844398498535,54.1383285522461],[23.5177764892578,54.0302734375],[23.4752731323242,53.9911041259766],[23.5040397644043,53.9470443725586],[23.6747169494629,53.4911041259766],[23.8147201538086,53.2544403076172],[23.9105529785156,53.1672134399414],[23.8780517578125,53.075553894043],[23.9330520629883,53.01416015625],[23.9152717590332,52.9188842773438],[23.9408302307129,52.7322082519531],[23.7538871765137,52.6158294677734],[23.5972175598145,52.5963821411133],[23.397216796875,52.5144424438477],[23.3827960661706,52.5],[23.4486083984375,52.5],[27.4580535888672,52.5],],
			},
		},
		# Grid 2:5 ; 2 records
		"5" => {
			"def_z" => "Etc/GMT+1",
			"329" => {
				"z" => "Etc/GMT+3",
				"c" => "ESRI",
				"s" => "20,1",
				"p" => [[37.5,69.3593521118164],[37.5,67.5],[29.9063727121068,67.5],[29.9327774047852,67.5138854980469],[29.9777755737305,67.5724945068359],[29.9897193908691,67.6719360351562],[30.0286102294922,67.6947174072266],[29.6916656494141,67.8152770996094],[29.3569412231445,68.0824890136719],[28.6933326721191,68.1974945068359],[28.4574966430664,68.5319366455078],[28.7386093139648,68.7341613769531],[28.8205528259277,68.8444366455078],[28.7377777099609,68.8758239746094],[28.4791641235352,68.8735961914062],[28.431941986084,68.8969421386719],[28.9573402404785,69.0516204833984],[29.0633316040039,69.0291595458984],[29.2391662597656,69.1074981689453],[29.321662902832,69.2455444335938],[29.3099975585938,69.3152770996094],[29.9449996948242,69.4305419921875],[30.0977745056152,69.5033264160156],[30.1849975585938,69.582763671875],[30.1427764892578,69.6283264160156],[30.0727767944336,69.631103515625],[30.1033325195312,69.6630554199219],[30.2036094665527,69.6638793945312],[30.5291633605957,69.5460968017578],[30.9099998474121,69.5488739013672],[30.9458312988281,69.5822143554688],[30.954719543457,69.6813812255859],[30.8980522155762,69.7055511474609],[30.8548393249512,69.7923126220703],[31.1744289398193,70.3625564575195],[31.92258644104,70.0184326171875],[32.2851409912109,69.9238586425781],[33.1363563537598,69.7741088867188],[33.4831466674805,69.490364074707],[35.3195648193359,69.3090896606445],[36.2338333129883,69.1593399047852],[37.1638641357422,68.8913650512695],[37.5,68.8712287984285],[37.5,78.7119979858398],[35.867618560791,78.7119979858398],[35.867618560791,81.4749374389648],[37.5,81.4749374389648],[37.5,70.8352661132812],[37.5,69.3593521118164],],
			},
		},
		# Grid 2:6 ; 1 records
		"6" => {
			"513" => {
				"z" => "Etc/GMT+1",
				"c" => "ESRI",
				"s" => "34,1",
				"p" => [[27.4580535888672,82.5],[22.5,82.5],[22.5,90],[22.5466079711914,90],[22.5466079711914,82.5],[23.4486083984375,82.5],[27.4580535888672,82.5],],
			},
		},
	},
};

# Used by Class::Singleton
sub _new_instance
{
	return shift->_init( @_, data => $data );
}

1;
