package API::MailboxOrg::API::Mailinglist;

# ABSTRACT: MailboxOrg::API::Mailinglist

# ---
# This class is auto-generated by bin/get_mailbox_api.pl
# ---

use v5.24;

use strict;
use warnings;

use Moo;
use Types::Standard qw(Enum Str Int InstanceOf ArrayRef);
use API::MailboxOrg::Types qw(HashRefRestricted Boolean);
use Params::ValidationCompiler qw(validation_for);

extends 'API::MailboxOrg::APIBase';

with 'MooX::Singleton';

use feature 'signatures';
no warnings 'experimental::signatures';

our $VERSION = '1.0.2'; # VERSION

my %validators = (
    'add' => validation_for(
        params => {
            mailinglist => { type => Str, optional => 0 },
            password    => { type => Str, optional => 0 },
            account     => { type => Str, optional => 0 },
            adminmail   => { type => Str, optional => 1 },

        },
    ),
    'del' => validation_for(
        params => {
            mailinglist => { type => Str, optional => 0 },
            account     => { type => Str, optional => 0 },

        },
    ),
    'get' => validation_for(
        params => {
            mailinglist => { type => Str, optional => 0 },
            account     => { type => Str, optional => 0 },

        },
    ),
    'list' => validation_for(
        params => {
            account => { type => Str, optional => 0 },

        },
    ),
    'set' => validation_for(
        params => {
            mailinglist => { type => Str, optional => 0 },
            account     => { type => Str, optional => 0 },
            password    => { type => Str, optional => 1 },
            adminmail   => { type => Str, optional => 1 },

        },
    ),

);


sub add ($self, %params) {
    my $validator = $validators{'add'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'mailinglist.add', \%params, \%opt );
}

sub del ($self, %params) {
    my $validator = $validators{'del'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'mailinglist.del', \%params, \%opt );
}

sub get ($self, %params) {
    my $validator = $validators{'get'};
    %params       = $validator->(%params) if $validator;

    my %opt = ();

    return $self->_request( 'mailinglist.get', \%params, \%opt );
}

sub list ($self, %params) {
    my $validator = $validators{'list'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'mailinglist.list', \%params, \%opt );
}

sub set ($self, %params) {
    my $validator = $validators{'set'};
    %params       = $validator->(%params) if $validator;

    my %opt = (needs_auth => 1);

    return $self->_request( 'mailinglist.set', \%params, \%opt );
}


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

API::MailboxOrg::API::Mailinglist - MailboxOrg::API::Mailinglist

=head1 VERSION

version 1.0.2

=head1 SYNOPSIS

    use API::MailboxOrg;

    my $user     = '1234abc';
    my $password = '1234abc';

    my $api      = API::MailboxOrg->new(
        user     => $user,
        password => $password,
    );

=head1 METHODS

=head2 add

Adds a mailing list

Available for admin, account

Parameters:

=over 4

=item * mailinglist

=item * password

=item * account

=item * adminmail

=back

returns: boolean

    $api->mailinglist->add(%params);

=head2 del

Deletes a mailing list

Available for admin, account

Parameters:

=over 4

=item * mailinglist

=item * account

=back

returns: boolean

    $api->mailinglist->del(%params);

=head2 get

###short###

Parameters:

=over 4

=item * mailinglist

=item * account

=back

returns: array

    $api->mailinglist->get(%params);

=head2 list

Returns all lists of the account

Available for admin, account

Parameters:

=over 4

=item * account

=back

returns: array

    $api->mailinglist->list(%params);

=head2 set

Edits a mailing list

Available for admin, account

Parameters:

=over 4

=item * mailinglist

=item * account

=item * password

=item * adminmail

=back

returns: boolean

    $api->mailinglist->set(%params);

=head1 AUTHOR

Renee Baecker <reneeb@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is Copyright (c) 2022 by Renee Baecker.

This is free software, licensed under:

  The Artistic License 2.0 (GPL Compatible)

=cut
