package Shipment::FedEx::WSDL::TrackTypes::SignatureProofOfDeliveryFaxReply;
$Shipment::FedEx::WSDL::TrackTypes::SignatureProofOfDeliveryFaxReply::VERSION = '2.03';
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns {'http://fedex.com/ws/track/v9'}

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(SOAP::WSDL::XSD::Typelib::ComplexType);

Class::Std::initialize();

{    # BLOCK to scope variables

    my %HighestSeverity_of : ATTR(:get<HighestSeverity>);
    my %Notifications_of : ATTR(:get<Notifications>);
    my %TransactionDetail_of : ATTR(:get<TransactionDetail>);
    my %Version_of : ATTR(:get<Version>);
    my %FaxConfirmationNumber_of : ATTR(:get<FaxConfirmationNumber>);

    __PACKAGE__->_factory(
        [   qw(        HighestSeverity
              Notifications
              TransactionDetail
              Version
              FaxConfirmationNumber

              )
        ],
        {   'HighestSeverity'       => \%HighestSeverity_of,
            'Notifications'         => \%Notifications_of,
            'TransactionDetail'     => \%TransactionDetail_of,
            'Version'               => \%Version_of,
            'FaxConfirmationNumber' => \%FaxConfirmationNumber_of,
        },
        {   'HighestSeverity' =>
              'Shipment::FedEx::WSDL::TrackTypes::NotificationSeverityType',
            'Notifications' =>
              'Shipment::FedEx::WSDL::TrackTypes::Notification',
            'TransactionDetail' =>
              'Shipment::FedEx::WSDL::TrackTypes::TransactionDetail',
            'Version' => 'Shipment::FedEx::WSDL::TrackTypes::VersionId',
            'FaxConfirmationNumber' =>
              'SOAP::WSDL::XSD::Typelib::Builtin::string',
        },
        {

            'HighestSeverity'       => 'HighestSeverity',
            'Notifications'         => 'Notifications',
            'TransactionDetail'     => 'TransactionDetail',
            'Version'               => 'Version',
            'FaxConfirmationNumber' => 'FaxConfirmationNumber',
        }
    );

}    # end BLOCK


1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::SignatureProofOfDeliveryFaxReply

=head1 VERSION

version 2.03

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
SignatureProofOfDeliveryFaxReply from the namespace http://fedex.com/ws/track/v9.

FedEx Signature Proof Of Delivery Fax reply.

=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * HighestSeverity

=item * Notifications

=item * TransactionDetail

=item * Version

=item * FaxConfirmationNumber

=back

=head1 NAME

Shipment::FedEx::WSDL::TrackTypes::SignatureProofOfDeliveryFaxReply

=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { # Shipment::FedEx::WSDL::TrackTypes::SignatureProofOfDeliveryFaxReply
   HighestSeverity => $some_value, # NotificationSeverityType
   Notifications =>  { # Shipment::FedEx::WSDL::TrackTypes::Notification
     Severity => $some_value, # NotificationSeverityType
     Source =>  $some_value, # string
     Code =>  $some_value, # string
     Message =>  $some_value, # string
     LocalizedMessage =>  $some_value, # string
     MessageParameters =>  { # Shipment::FedEx::WSDL::TrackTypes::NotificationParameter
       Id =>  $some_value, # string
       Value =>  $some_value, # string
     },
   },
   TransactionDetail =>  { # Shipment::FedEx::WSDL::TrackTypes::TransactionDetail
     CustomerTransactionId =>  $some_value, # string
     Localization =>  { # Shipment::FedEx::WSDL::TrackTypes::Localization
       LanguageCode =>  $some_value, # string
       LocaleCode =>  $some_value, # string
     },
   },
   Version =>  { # Shipment::FedEx::WSDL::TrackTypes::VersionId
     ServiceId =>  $some_value, # string
     Major =>  $some_value, # int
     Intermediate =>  $some_value, # int
     Minor =>  $some_value, # int
   },
   FaxConfirmationNumber =>  $some_value, # string
 },

=head1 AUTHOR

Generated by SOAP::WSDL

=head1 AUTHOR

Andrew Baerg <baergaj@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Andrew Baerg.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
