# Generated by default/object.tt
package Paws::GuardDuty::BlockPublicAccess;
  use Moose;
  has BlockPublicAcls => (is => 'ro', isa => 'Bool', request_name => 'blockPublicAcls', traits => ['NameInRequest']);
  has BlockPublicPolicy => (is => 'ro', isa => 'Bool', request_name => 'blockPublicPolicy', traits => ['NameInRequest']);
  has IgnorePublicAcls => (is => 'ro', isa => 'Bool', request_name => 'ignorePublicAcls', traits => ['NameInRequest']);
  has RestrictPublicBuckets => (is => 'ro', isa => 'Bool', request_name => 'restrictPublicBuckets', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GuardDuty::BlockPublicAccess

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GuardDuty::BlockPublicAccess object:

  $service_obj->Method(Att1 => { BlockPublicAcls => $value, ..., RestrictPublicBuckets => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GuardDuty::BlockPublicAccess object:

  $result = $service_obj->Method(...);
  $result->Att1->BlockPublicAcls

=head1 DESCRIPTION

Contains information on how the bucker owner's S3 Block Public Access
settings are being applied to the S3 bucket. See S3 Block Public Access
(https://docs.aws.amazon.com/AmazonS3/latest/dev/access-control-block-public-access.html)
for more information.

=head1 ATTRIBUTES


=head2 BlockPublicAcls => Bool

Indicates if S3 Block Public Access is set to C<BlockPublicAcls>.


=head2 BlockPublicPolicy => Bool

Indicates if S3 Block Public Access is set to C<BlockPublicPolicy>.


=head2 IgnorePublicAcls => Bool

Indicates if S3 Block Public Access is set to C<IgnorePublicAcls>.


=head2 RestrictPublicBuckets => Bool

Indicates if S3 Block Public Access is set to C<RestrictPublicBuckets>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GuardDuty>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

