#!/usr/bin/env perl

use strict;
use warnings;

use Test::More tests => 126;

BEGIN {use_ok('Finance::AMEX::Transaction')}

use lib '.';
use t::lib::CompareFile;

my $file = 't/data/AMEX/SAMPLE.GRRCN Delimited (US) v2.01.txt';

my $counts = {
  HEADER      => {want => 1, have => 0},
  TRAILER     => {want => 1, have => 0},
  SUMMARY     => {want => 1, have => 0},
  TAXRECORD   => {want => 0, have => 0},
  SUBMISSION  => {want => 1, have => 0},
  TRANSACTION => {want => 1, have => 0},
  TXNPRICING  => {want => 1, have => 0},
  CHARGEBACK  => {want => 0, have => 0},
  ADJUSTMENT  => {want => 0, have => 0},
  FEEREVENUE  => {want => 0, have => 0},
};

my $data = do {local $/ = undef; <DATA>};

t::lib::CompareFile::compare('GRRCN', $file, $data, $counts);

done_testing();

__DATA__
{
  "HEADER": [
    {"FILE_CREATION_DATE": "20210711", "FILE_CREATION_TIME": "113207", "FILE_ID": "GRRCN", "FILE_NAME": "SAMPLES.COM", "FILE_VERSION_NUMBER": "2.01", "RECORD_TYPE": "HEADER", "SEQUENTIAL_NUMBER": "0000000026"}
  ],
  "TRAILER": [
    {"RECORD_TYPE": "TRAILER", "SEQUENTIAL_NUMBER": "0000000026", "TOTAL_RECORD_COUNT": "0000000155"}
  ],
  "SUMMARY": [
    {"AMERICAN_EXPRESS_PAYMENT_NUMBER": "9211234550", "BANK_ACCOUNT_NUMBER": "", "BANK_IDENTIFIER_CODE": "CRXXXXXXX0A    ", "INTERNATIONAL_BANK_ACCOUNT_NUMBER": "H70XXXXXXXXXXXXXX002", "OPENING_DEBIT_BALANCE_AMOUNT": " 000000000000000", "PAYEE_DIRECT_DEPOSIT_NUMBER": "", "PAYEE_MERCHANT_ID": "4737483941", "PAYMENT_ADJUSTMENT_AMOUNT": " 000000000000000", "PAYMENT_CURRENCY": "EUR", "PAYMENT_DATE": "20210714", "PAYMENT_DISCOUNT_AMOUNT": " 000000000000081", "PAYMENT_GROSS_AMOUNT": " 000000000002756", "PAYMENT_NET_AMOUNT": " 000000000002675", "PAYMENT_SERVICE_FEE_AMOUNT": " 000000000000000", "PAYMENT_TAX_AMOUNT": " 000000000000000", "RECORD_TYPE": "SUMMARY", "SETTLEMENT_ACCOUNT_TYPE_CODE": "002", "UNIQUE_PAYMENT_REFERENCE_NUMBER": ""}
  ],
  "TAXRECORD": [
  ],
  "SUBMISSION": [
    {"ACCELERATION_DATE": "", "ACCELERATION_NUMBER": "", "AMERICAN_EXPRESS_PAYMENT_NUMBER": "9211234550", "AMERICAN_EXPRESS_PROCESSING_DATE": "20210707", "BUSINESS_SUBMISSION_DATE": "20210707", "INSTALLMENT_NUMBER": "", "NUMBER_OF_DAYS_IN_ADVANCE": "", "ORIGINAL_SETTLEMENT_DATE": "", "PAYEE_MERCHANT_ID": "4737483941", "PAYMENT_CURRENCY": "EUR", "PAYMENT_DATE": "20210714", "RECORD_TYPE": "SUBMISSION", "SETTLEMENT_ACCOUNT_TYPE_CODE": "002", "SUBMISSION_ACCELERATION_FEE_AMOUNT": "", "SUBMISSION_ACCELERATION_FEE_NET_AMOUNT": "", "SUBMISSION_CREDIT_GROSS_AMOUNT": " 000000000000000", "SUBMISSION_CURRENCY": "EUR", "SUBMISSION_DEBIT_GROSS_AMOUNT": " 000000000002756", "SUBMISSION_DISCOUNT_AMOUNT": " 000000000000081", "SUBMISSION_DISCOUNT_RATE": "", "SUBMISSION_EXCHANGE_RATE": "", "SUBMISSION_GROSS_AMOUNT_IN_PAYMENT_CURRENCY": " 000000000002756", "SUBMISSION_GROSS_AMOUNT_IN_SUBMISSION_CURRENCY": " 000000000002756", "SUBMISSION_INVOICE_NUMBER": "000000000000000", "SUBMISSION_MERCHANT_ID": "4737483941", "SUBMISSION_NET_AMOUNT": " 000000000002675", "SUBMISSION_SERVICE_FEE_AMOUNT": " 000000000000000", "SUBMISSION_TAX_AMOUNT": " 000000000000000", "SUBMISSION_TAX_RATE": "", "TRACKING_ID": "", "TRANSACTION_COUNT": "0000001"}
  ],
  "TRANSACTION": [
    {"ACCELERATION_AMOUNT": "", "ACQUIRER_REFERENCE_NUMBER": "P60LG7C3734Z7G000000NWX", "AMERICAN_EXPRESS_PAYMENT_NUMBER": "9211234550", "AMERICAN_EXPRESS_PROCESSING_DATE": "20210707", "APPROVAL_CODE": "168208", "BUSINESS_SUBMISSION_DATE": "20210707", "CARDMEMBER_ACCOUNT_NUMBER": "375310XXXXX4009", "CARDMEMBER_REFERENCE_NUMBER": "", "DATA_QUALITY_NON_COMPLIANT_ERROR_CODE_1": "", "DATA_QUALITY_NON_COMPLIANT_ERROR_CODE_2": "", "DATA_QUALITY_NON_COMPLIANT_ERROR_CODE_3": "", "DATA_QUALITY_NON_COMPLIANT_ERROR_CODE_4": "", "DATA_QUALITY_NON_COMPLIANT_INDICATOR": "", "FIRST_INSTALLMENT_AMOUNT": "", "INDUSTRY_SPECIFIC_REFERENCE_NUMBER": "", "INSTALLMENT_NUMBER": "", "INVOICE_REFERENCE_NUMBER": "60482",  "MERCHANT_CATEGORY_CODE": "8398", "MERCHANT_LOCATION_ID": "", "NON_SWIPED_INDICATOR": "", "NUMBER_OF_INSTALLMENTS": "", "PAYEE_MERCHANT_ID": "4737483941", "PAYMENT_CURRENCY": "EUR", "PAYMENT_DATE": "20210714", "RECORD_TYPE": "TRANSACTN", "SELLER_ID": "1176391", "SERVICE_FEE_AMOUNT": "", "SETTLEMENT_ACCOUNT_TYPE_CODE": "002", "SUBMISSION_CURRENCY": "EUR", "SUBMISSION_GROSS_AMOUNT": " 000000000002756", "SUBMISSION_INVOICE_NUMBER": "000000000000000", "SUBMISSION_MERCHANT_ID": "4737483941", "SUBSEQUENT_INSTALLMENT_AMOUNT": "", "TERMINAL_ID": "", "TRANSACTION_AMOUNT": " 000000000002756", "TRANSACTION_DATE": "20210707", "TRANSACTION_ID": "002391206015076", "TRANSACTION_REJECTED_INDICATOR": "   ", "TRANSACTION_TIME": "171512"}
  ],
  "TXNPRICING": [
    {"AMERICAN_EXPRESS_PAYMENT_NUMBER": "9211234550", "CARDMEMBER_ACCOUNT_NUMBER": "375310XXXXX4009", "DISCOUNT_AMOUNT": " 000000000000000813020", "DISCOUNT_RATE": " 002950", "FEE_AMOUNT": " 000000000000000000000", "FEE_CODE": "1A", "INVOICE_REFERENCE_NUMBER": "60482", "MERCHANT_LOCATION_ID": "", "PAYEE_MERCHANT_ID": "4737483941", "PAYMENT_CURRENCY": "EUR", "PAYMENT_DATE": "20210714", "RECORD_TYPE": "TXNPRICING", "SELLER_ID": "1176391",  "SETTLEMENT_ACCOUNT_TYPE_CODE": "002", "SUBMISSION_MERCHANT_ID": "4737483941", "TRANSACTION_AMOUNT": " 000000000002756", "TRANSACTION_DATE": "20210707"}
  ],
  "CHARGEBACK": [
  ],
  "ADJUSTMENT": [
  ],
  "FEEREVENUE": [
  ]
}
