package RDF::Crypt::Role::StandardSignatureMarkers;

use 5.010;
use Any::Moose 'Role';

use RDF::TrineX::Functions -shortcuts;

use namespace::clean;

BEGIN {
	$RDF::Crypt::Role::StandardSignatureMarkers::AUTHORITY = 'cpan:TOBYINK';
	$RDF::Crypt::Role::StandardSignatureMarkers::VERSION   = '0.002';
}

use constant SIG_MARK => 'CANONICAL_SIGNATURE';

1;

__END__

=head1 NAME

RDF::Crypt::Role::StandardSignatureMarkers - provides SIG_MARK method

=head1 DESCRIPTION

This method is needed by L<RDF::Crypt::Signer> and L<RDF::Crypt::Verifier>
so that the verifier can find the signatures generated by the signer.

=head2 Constant

=over

=item C<< SIG_MARK >>

String marker for the signature.

=back

=head1 SEE ALSO

L<RDF::Crypt>,
L<RDF::Crypt::Role::DoesSign>,
L<RDF::Crypt::Role::DoesVerify>,
L<RDF::Crypt::Signer>,
L<RDF::Crypt::Verifier>.

=head1 BUGS

Please report any bugs to L<http://rt.cpan.org/>.

=head1 AUTHOR

Toby Inkster E<lt>tobyink@cpan.orgE<gt>.

=head1 COPYRIGHT

Copyright 2010, 2012 Toby Inkster

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 DISCLAIMER OF WARRANTIES

THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED
WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

