package Sorter::from_sortkey;

use 5.010001;
use strict 'subs', 'vars';
use warnings;

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2024-01-24'; # DATE
our $DIST = 'Sorter-from_sortkey'; # DIST
our $VERSION = '0.001'; # VERSION

sub meta {
    return +{
        v => 1,
        args => {
            sortkey => {schema=>'perl::sortkey::modname_with_optional_args*', req=>1},
            reverse => {schema => 'bool*'},
            ci => {schema => 'bool*'},
        },
    };
}

sub gen_sorter {
    my %args = @_;

    my $sortkey = $args{sortkey} or die "Please specify sortkey";
    my $reverse = $args{reverse};
    my $ci = $args{ci};

    require Module::Load::Util;

    my ($mod, $args) = Module::Load::Util::_normalize_module_with_optional_args($sortkey);
    $mod = Module::Load::Util::_load_module({ns_prefix=>"SortKey"}, $mod);
    my $is_num = $mod =~ /\ASortKey::Num::/ ? 1:0;
    my $keygen = &{"$mod\::gen_keygen"}(@$args);

    sub {
        my @records = map {
            my $key = $args{ci} ? lc($keygen->($_)) : $keygen->($_);
            [$_, $key];
        } @_;

        map { $_->[0] } sort { ($is_num ? ($a->[1] <=> $b->[1]) : ($a->[1] cmp $b->[1])) * ($reverse ? -1:1) } @records;
    };
}

1;
# ABSTRACT: Sort by keys generated by a SortKey:: module

__END__

=pod

=encoding UTF-8

=head1 NAME

Sorter::from_sortkey - Sort by keys generated by a SortKey:: module

=head1 VERSION

This document describes version 0.001 of Sorter::from_sortkey (from Perl distribution Sorter-from_sortkey), released on 2024-01-24.

=head1 SYNOPSIS

 use Sorter::from_sortkey;

 my $sorter = Sorter::from_sortkey::gen_sorter(sortkey => "Num::similarity,string,foo");
 my @sorted = $sorter->("food", "foolish", "foo", "bar");
 # => ("foo","food","bar","foolish")

=head1 DESCRIPTION

=for Pod::Coverage ^(meta|gen_sorter)$

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Sorter-from_sortkey>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Sorter-from_sortkey>.

=head1 SEE ALSO

L<SortKey>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2024 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Sorter-from_sortkey>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
