/* -*- buffer-read-only: t -*-
 *
 *    opnames.h
 *
 *    Copyright (C) 1999, 2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007,
 *    2008 by Larry Wall and others
 *
 *    You may distribute under the terms of either the GNU General Public
 *    License or the Artistic License, as specified in the README file.
 *
 * !!!!!!!   DO NOT EDIT THIS FILE   !!!!!!!
 * This file is built by regen/opcode.pl from its data.
 * Any changes made here will be lost!
 */

typedef enum opcode {
	OP_NULL		 = 0,
	OP_STUB		 = 1,
	OP_SCALAR	 = 2,
	OP_PUSHMARK	 = 3,
	OP_WANTARRAY	 = 4,
	OP_CONST	 = 5,
	OP_GVSV		 = 6,
	OP_GV		 = 7,
	OP_GELEM	 = 8,
	OP_PADSV	 = 9,
	OP_PADAV	 = 10,
	OP_PADHV	 = 11,
	OP_PADANY	 = 12,
	OP_RV2GV	 = 13,
	OP_RV2SV	 = 14,
	OP_AV2ARYLEN	 = 15,
	OP_RV2CV	 = 16,
	OP_ANONCODE	 = 17,
	OP_PROTOTYPE	 = 18,
	OP_REFGEN	 = 19,
	OP_SREFGEN	 = 20,
	OP_REF		 = 21,
	OP_BLESS	 = 22,
	OP_BACKTICK	 = 23,
	OP_GLOB		 = 24,
	OP_READLINE	 = 25,
	OP_RCATLINE	 = 26,
	OP_REGCMAYBE	 = 27,
	OP_REGCRESET	 = 28,
	OP_REGCOMP	 = 29,
	OP_MATCH	 = 30,
	OP_QR		 = 31,
	OP_SUBST	 = 32,
	OP_SUBSTCONT	 = 33,
	OP_TRANS	 = 34,
	OP_TRANSR	 = 35,
	OP_SASSIGN	 = 36,
	OP_AASSIGN	 = 37,
	OP_CHOP		 = 38,
	OP_SCHOP	 = 39,
	OP_CHOMP	 = 40,
	OP_SCHOMP	 = 41,
	OP_DEFINED	 = 42,
	OP_UNDEF	 = 43,
	OP_STUDY	 = 44,
	OP_POS		 = 45,
	OP_PREINC	 = 46,
	OP_I_PREINC	 = 47,
	OP_PREDEC	 = 48,
	OP_I_PREDEC	 = 49,
	OP_POSTINC	 = 50,
	OP_I_POSTINC	 = 51,
	OP_POSTDEC	 = 52,
	OP_I_POSTDEC	 = 53,
	OP_POW		 = 54,
	OP_MULTIPLY	 = 55,
	OP_I_MULTIPLY	 = 56,
	OP_DIVIDE	 = 57,
	OP_I_DIVIDE	 = 58,
	OP_MODULO	 = 59,
	OP_I_MODULO	 = 60,
	OP_REPEAT	 = 61,
	OP_ADD		 = 62,
	OP_I_ADD	 = 63,
	OP_SUBTRACT	 = 64,
	OP_I_SUBTRACT	 = 65,
	OP_CONCAT	 = 66,
	OP_STRINGIFY	 = 67,
	OP_LEFT_SHIFT	 = 68,
	OP_RIGHT_SHIFT	 = 69,
	OP_LT		 = 70,
	OP_I_LT		 = 71,
	OP_GT		 = 72,
	OP_I_GT		 = 73,
	OP_LE		 = 74,
	OP_I_LE		 = 75,
	OP_GE		 = 76,
	OP_I_GE		 = 77,
	OP_EQ		 = 78,
	OP_I_EQ		 = 79,
	OP_NE		 = 80,
	OP_I_NE		 = 81,
	OP_NCMP		 = 82,
	OP_I_NCMP	 = 83,
	OP_SLT		 = 84,
	OP_SGT		 = 85,
	OP_SLE		 = 86,
	OP_SGE		 = 87,
	OP_SEQ		 = 88,
	OP_SNE		 = 89,
	OP_SCMP		 = 90,
	OP_BIT_AND	 = 91,
	OP_BIT_XOR	 = 92,
	OP_BIT_OR	 = 93,
	OP_NBIT_AND	 = 94,
	OP_NBIT_XOR	 = 95,
	OP_NBIT_OR	 = 96,
	OP_SBIT_AND	 = 97,
	OP_SBIT_XOR	 = 98,
	OP_SBIT_OR	 = 99,
	OP_NEGATE	 = 100,
	OP_I_NEGATE	 = 101,
	OP_NOT		 = 102,
	OP_COMPLEMENT	 = 103,
	OP_NCOMPLEMENT	 = 104,
	OP_SCOMPLEMENT	 = 105,
	OP_SMARTMATCH	 = 106,
	OP_ATAN2	 = 107,
	OP_SIN		 = 108,
	OP_COS		 = 109,
	OP_RAND		 = 110,
	OP_SRAND	 = 111,
	OP_EXP		 = 112,
	OP_LOG		 = 113,
	OP_SQRT		 = 114,
	OP_INT		 = 115,
	OP_HEX		 = 116,
	OP_OCT		 = 117,
	OP_ABS		 = 118,
	OP_LENGTH	 = 119,
	OP_SUBSTR	 = 120,
	OP_VEC		 = 121,
	OP_INDEX	 = 122,
	OP_RINDEX	 = 123,
	OP_SPRINTF	 = 124,
	OP_FORMLINE	 = 125,
	OP_ORD		 = 126,
	OP_CHR		 = 127,
	OP_CRYPT	 = 128,
	OP_UCFIRST	 = 129,
	OP_LCFIRST	 = 130,
	OP_UC		 = 131,
	OP_LC		 = 132,
	OP_QUOTEMETA	 = 133,
	OP_RV2AV	 = 134,
	OP_AELEMFAST	 = 135,
	OP_AELEMFAST_LEX = 136,
	OP_AELEM	 = 137,
	OP_ASLICE	 = 138,
	OP_KVASLICE	 = 139,
	OP_AEACH	 = 140,
	OP_AVALUES	 = 141,
	OP_AKEYS	 = 142,
	OP_EACH		 = 143,
	OP_VALUES	 = 144,
	OP_KEYS		 = 145,
	OP_DELETE	 = 146,
	OP_EXISTS	 = 147,
	OP_RV2HV	 = 148,
	OP_HELEM	 = 149,
	OP_HSLICE	 = 150,
	OP_KVHSLICE	 = 151,
	OP_MULTIDEREF	 = 152,
	OP_UNPACK	 = 153,
	OP_PACK		 = 154,
	OP_SPLIT	 = 155,
	OP_JOIN		 = 156,
	OP_LIST		 = 157,
	OP_LSLICE	 = 158,
	OP_ANONLIST	 = 159,
	OP_ANONHASH	 = 160,
	OP_SPLICE	 = 161,
	OP_PUSH		 = 162,
	OP_POP		 = 163,
	OP_SHIFT	 = 164,
	OP_UNSHIFT	 = 165,
	OP_SORT		 = 166,
	OP_REVERSE	 = 167,
	OP_GREPSTART	 = 168,
	OP_GREPWHILE	 = 169,
	OP_MAPSTART	 = 170,
	OP_MAPWHILE	 = 171,
	OP_RANGE	 = 172,
	OP_FLIP		 = 173,
	OP_FLOP		 = 174,
	OP_AND		 = 175,
	OP_OR		 = 176,
	OP_XOR		 = 177,
	OP_DOR		 = 178,
	OP_COND_EXPR	 = 179,
	OP_ANDASSIGN	 = 180,
	OP_ORASSIGN	 = 181,
	OP_DORASSIGN	 = 182,
	OP_ENTERSUB	 = 183,
	OP_LEAVESUB	 = 184,
	OP_LEAVESUBLV	 = 185,
	OP_ARGCHECK	 = 186,
	OP_ARGELEM	 = 187,
	OP_ARGDEFELEM	 = 188,
	OP_CALLER	 = 189,
	OP_WARN		 = 190,
	OP_DIE		 = 191,
	OP_RESET	 = 192,
	OP_LINESEQ	 = 193,
	OP_NEXTSTATE	 = 194,
	OP_DBSTATE	 = 195,
	OP_UNSTACK	 = 196,
	OP_ENTER	 = 197,
	OP_LEAVE	 = 198,
	OP_SCOPE	 = 199,
	OP_ENTERITER	 = 200,
	OP_ITER		 = 201,
	OP_ENTERLOOP	 = 202,
	OP_LEAVELOOP	 = 203,
	OP_RETURN	 = 204,
	OP_LAST		 = 205,
	OP_NEXT		 = 206,
	OP_REDO		 = 207,
	OP_DUMP		 = 208,
	OP_GOTO		 = 209,
	OP_EXIT		 = 210,
	OP_METHOD	 = 211,
	OP_METHOD_NAMED	 = 212,
	OP_METHOD_SUPER	 = 213,
	OP_METHOD_REDIR	 = 214,
	OP_METHOD_REDIR_SUPER = 215,
	OP_ENTERGIVEN	 = 216,
	OP_LEAVEGIVEN	 = 217,
	OP_ENTERWHEN	 = 218,
	OP_LEAVEWHEN	 = 219,
	OP_BREAK	 = 220,
	OP_CONTINUE	 = 221,
	OP_OPEN		 = 222,
	OP_CLOSE	 = 223,
	OP_PIPE_OP	 = 224,
	OP_FILENO	 = 225,
	OP_UMASK	 = 226,
	OP_BINMODE	 = 227,
	OP_TIE		 = 228,
	OP_UNTIE	 = 229,
	OP_TIED		 = 230,
	OP_DBMOPEN	 = 231,
	OP_DBMCLOSE	 = 232,
	OP_SSELECT	 = 233,
	OP_SELECT	 = 234,
	OP_GETC		 = 235,
	OP_READ		 = 236,
	OP_ENTERWRITE	 = 237,
	OP_LEAVEWRITE	 = 238,
	OP_PRTF		 = 239,
	OP_PRINT	 = 240,
	OP_SAY		 = 241,
	OP_SYSOPEN	 = 242,
	OP_SYSSEEK	 = 243,
	OP_SYSREAD	 = 244,
	OP_SYSWRITE	 = 245,
	OP_EOF		 = 246,
	OP_TELL		 = 247,
	OP_SEEK		 = 248,
	OP_TRUNCATE	 = 249,
	OP_FCNTL	 = 250,
	OP_IOCTL	 = 251,
	OP_FLOCK	 = 252,
	OP_SEND		 = 253,
	OP_RECV		 = 254,
	OP_SOCKET	 = 255,
	OP_SOCKPAIR	 = 256,
	OP_BIND		 = 257,
	OP_CONNECT	 = 258,
	OP_LISTEN	 = 259,
	OP_ACCEPT	 = 260,
	OP_SHUTDOWN	 = 261,
	OP_GSOCKOPT	 = 262,
	OP_SSOCKOPT	 = 263,
	OP_GETSOCKNAME	 = 264,
	OP_GETPEERNAME	 = 265,
	OP_LSTAT	 = 266,
	OP_STAT		 = 267,
	OP_FTRREAD	 = 268,
	OP_FTRWRITE	 = 269,
	OP_FTREXEC	 = 270,
	OP_FTEREAD	 = 271,
	OP_FTEWRITE	 = 272,
	OP_FTEEXEC	 = 273,
	OP_FTIS		 = 274,
	OP_FTSIZE	 = 275,
	OP_FTMTIME	 = 276,
	OP_FTATIME	 = 277,
	OP_FTCTIME	 = 278,
	OP_FTROWNED	 = 279,
	OP_FTEOWNED	 = 280,
	OP_FTZERO	 = 281,
	OP_FTSOCK	 = 282,
	OP_FTCHR	 = 283,
	OP_FTBLK	 = 284,
	OP_FTFILE	 = 285,
	OP_FTDIR	 = 286,
	OP_FTPIPE	 = 287,
	OP_FTSUID	 = 288,
	OP_FTSGID	 = 289,
	OP_FTSVTX	 = 290,
	OP_FTLINK	 = 291,
	OP_FTTTY	 = 292,
	OP_FTTEXT	 = 293,
	OP_FTBINARY	 = 294,
	OP_CHDIR	 = 295,
	OP_CHOWN	 = 296,
	OP_CHROOT	 = 297,
	OP_UNLINK	 = 298,
	OP_CHMOD	 = 299,
	OP_UTIME	 = 300,
	OP_RENAME	 = 301,
	OP_LINK		 = 302,
	OP_SYMLINK	 = 303,
	OP_READLINK	 = 304,
	OP_MKDIR	 = 305,
	OP_RMDIR	 = 306,
	OP_OPEN_DIR	 = 307,
	OP_READDIR	 = 308,
	OP_TELLDIR	 = 309,
	OP_SEEKDIR	 = 310,
	OP_REWINDDIR	 = 311,
	OP_CLOSEDIR	 = 312,
	OP_FORK		 = 313,
	OP_WAIT		 = 314,
	OP_WAITPID	 = 315,
	OP_SYSTEM	 = 316,
	OP_EXEC		 = 317,
	OP_KILL		 = 318,
	OP_GETPPID	 = 319,
	OP_GETPGRP	 = 320,
	OP_SETPGRP	 = 321,
	OP_GETPRIORITY	 = 322,
	OP_SETPRIORITY	 = 323,
	OP_TIME		 = 324,
	OP_TMS		 = 325,
	OP_LOCALTIME	 = 326,
	OP_GMTIME	 = 327,
	OP_ALARM	 = 328,
	OP_SLEEP	 = 329,
	OP_SHMGET	 = 330,
	OP_SHMCTL	 = 331,
	OP_SHMREAD	 = 332,
	OP_SHMWRITE	 = 333,
	OP_MSGGET	 = 334,
	OP_MSGCTL	 = 335,
	OP_MSGSND	 = 336,
	OP_MSGRCV	 = 337,
	OP_SEMOP	 = 338,
	OP_SEMGET	 = 339,
	OP_SEMCTL	 = 340,
	OP_REQUIRE	 = 341,
	OP_DOFILE	 = 342,
	OP_HINTSEVAL	 = 343,
	OP_ENTEREVAL	 = 344,
	OP_LEAVEEVAL	 = 345,
	OP_ENTERTRY	 = 346,
	OP_LEAVETRY	 = 347,
	OP_GHBYNAME	 = 348,
	OP_GHBYADDR	 = 349,
	OP_GHOSTENT	 = 350,
	OP_GNBYNAME	 = 351,
	OP_GNBYADDR	 = 352,
	OP_GNETENT	 = 353,
	OP_GPBYNAME	 = 354,
	OP_GPBYNUMBER	 = 355,
	OP_GPROTOENT	 = 356,
	OP_GSBYNAME	 = 357,
	OP_GSBYPORT	 = 358,
	OP_GSERVENT	 = 359,
	OP_SHOSTENT	 = 360,
	OP_SNETENT	 = 361,
	OP_SPROTOENT	 = 362,
	OP_SSERVENT	 = 363,
	OP_EHOSTENT	 = 364,
	OP_ENETENT	 = 365,
	OP_EPROTOENT	 = 366,
	OP_ESERVENT	 = 367,
	OP_GPWNAM	 = 368,
	OP_GPWUID	 = 369,
	OP_GPWENT	 = 370,
	OP_SPWENT	 = 371,
	OP_EPWENT	 = 372,
	OP_GGRNAM	 = 373,
	OP_GGRGID	 = 374,
	OP_GGRENT	 = 375,
	OP_SGRENT	 = 376,
	OP_EGRENT	 = 377,
	OP_GETLOGIN	 = 378,
	OP_SYSCALL	 = 379,
	OP_LOCK		 = 380,
	OP_ONCE		 = 381,
	OP_CUSTOM	 = 382,
	OP_COREARGS	 = 383,
	OP_AVHVSWITCH	 = 384,
	OP_RUNCV	 = 385,
	OP_FC		 = 386,
	OP_PADCV	 = 387,
	OP_INTROCV	 = 388,
	OP_CLONECV	 = 389,
	OP_PADRANGE	 = 390,
	OP_REFASSIGN	 = 391,
	OP_LVREF	 = 392,
	OP_LVREFSLICE	 = 393,
	OP_LVAVREF	 = 394,
	OP_ANONCONST	 = 395,
	OP_max		
} opcode;

#define MAXO 396
#define OP_FREED MAXO

/* the OP_IS_* macros are optimized to a simple range check because
    all the member OPs are contiguous in regen/opcodes table.
    opcode.pl verifies the range contiguity, or generates an OR-equals
    expression */

#define OP_IS_SOCKET(op)	\
	((op) >= OP_SEND && (op) <= OP_GETPEERNAME)

#define OP_IS_FILETEST(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTBINARY)

#define OP_IS_FILETEST_ACCESS(op)	\
	((op) >= OP_FTRREAD && (op) <= OP_FTEEXEC)

#define OP_IS_NUMCOMPARE(op)	\
	((op) >= OP_LT && (op) <= OP_I_NCMP)

#define OP_IS_DIRHOP(op)	\
	((op) >= OP_READDIR && (op) <= OP_CLOSEDIR)

#define OP_IS_INFIX_BIT(op)	\
	((op) >= OP_BIT_AND && (op) <= OP_SBIT_OR)

/* ex: set ro: */
