/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeAbstract;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.collection.GribCdmIndex;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.GribIosp;
import ucar.nc2.grib.collection.PartitionCollectionProto;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Misc;
import ucar.nc2.util.cache.FileCache;
import ucar.nc2.util.cache.FileCacheIF;
import ucar.nc2.util.cache.FileCacheable;
import ucar.nc2.util.cache.FileFactory;
import ucar.nc2.util.cache.SmartArrayInt;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.StringUtil2;

public abstract class PartitionCollection
extends GribCollection {
    private static FileCacheIF partitionCache;
    private static final FileFactory collectionFactory;
    protected final Logger logger;
    protected List<Partition> partitions;
    protected boolean isPartitionOfPartitions;
    int[] run2part;
    public static int countPC;

    public static void initPartitionCache(int minElementsInMemory, int maxElementsInMemory, int period) {
        partitionCache = new FileCache("TimePartitionCache", minElementsInMemory, maxElementsInMemory, -1, period);
    }

    public static void initPartitionCache(int minElementsInMemory, int softLimit, int hardLimit, int period) {
        partitionCache = new FileCache("TimePartitionCache", minElementsInMemory, softLimit, hardLimit, period);
    }

    public static FileCacheIF getPartitionCache() {
        return partitionCache;
    }

    public static void disablePartitionCache() {
        if (null != partitionCache) {
            partitionCache.disable();
        }
        partitionCache = null;
    }

    public boolean isPartitionOfPartitions() {
        return this.isPartitionOfPartitions;
    }

    protected PartitionCollection(String name, File directory, FeatureCollectionConfig config, boolean isGrib1, Logger logger) {
        super(name, directory, config, isGrib1);
        this.logger = logger;
        this.partitions = new ArrayList<Partition>();
        this.datasets = new ArrayList();
        ++countPC;
    }

    public GribCollection.VariableIndex getVariable2DByHash(GribCollection.HorizCoordSys hcs, int cdmHash) {
        GribCollection.Dataset ds2d = this.getDataset2D();
        if (ds2d == null) {
            return null;
        }
        for (GribCollection.GroupGC groupHcs : ds2d.getGroups()) {
            if (groupHcs.horizCoordSys != hcs) continue;
            return groupHcs.findVariableByHash(cdmHash);
        }
        return null;
    }

    private GribCollection.Dataset getDataset2D() {
        for (GribCollection.Dataset ds : this.datasets) {
            if (!ds.isTwoD()) continue;
            return ds;
        }
        return null;
    }

    @Override
    public List<String> getFilenames() {
        ArrayList<String> result = new ArrayList<String>();
        for (Partition p : this.getPartitions()) {
            if (p.isBad()) continue;
            result.add(p.getIndexFilenameInCache());
        }
        return result;
    }

    public Partition addPartition(String name, String filename, long lastModified, String directory) {
        Partition partition = new Partition(name, filename, lastModified, directory);
        this.partitions.add(partition);
        return partition;
    }

    public void addPartition(MCollection dcm) {
        Partition partition = new Partition(dcm);
        this.partitions.add(partition);
    }

    public void sortPartitions() {
        Collections.sort(this.partitions);
        this.partitions = Collections.unmodifiableList(this.partitions);
    }

    public VariableIndexPartitioned makeVariableIndexPartitioned(GribCollection.GroupGC group, GribCollection.VariableIndex from, int nparts) {
        VariableIndexPartitioned vip = new VariableIndexPartitioned(group, from, nparts);
        group.addVariable(vip);
        if (from instanceof VariableIndexPartitioned && !this.isPartitionOfPartitions) {
            VariableIndexPartitioned vipFrom = (VariableIndexPartitioned)from;
            for (int i = 0; i < vipFrom.nparts; ++i) {
                vip.addPartition(vipFrom.partnoSA.get(i), vipFrom.groupnoSA.get(i), vipFrom.varnoSA.get(i));
            }
        }
        return vip;
    }

    public Iterable<Partition> getPartitions() {
        return this.partitions;
    }

    public Partition getPartition(int idx) {
        return this.partitions.get(idx);
    }

    public Partition getPartitionByName(String name) {
        for (Partition p : this.partitions) {
            if (!p.name.equalsIgnoreCase(name)) continue;
            return p;
        }
        return null;
    }

    public int getPartitionSize() {
        return this.partitions.size();
    }

    public List<Partition> getPartitionsSorted() {
        ArrayList<Partition> c = new ArrayList<Partition>(this.partitions);
        Collections.sort(c);
        if (!this.config.gribConfig.filesSortIncreasing.booleanValue()) {
            Collections.reverse(c);
        }
        return c;
    }

    public void removePartition(Partition p) {
        this.partitions.remove(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GribCollection getLatestGribCollection(List<String> paths) throws IOException {
        Partition last = this.partitions.get(this.partitions.size() - 1);
        paths.add(last.getName());
        GribCollection gc = last.getGribCollection();
        if (gc instanceof PartitionCollection) {
            try {
                GribCollection result;
                PartitionCollection pc = (PartitionCollection)gc;
                GribCollection gribCollection = result = pc.getLatestGribCollection(paths);
                return gribCollection;
            }
            finally {
                gc.close();
            }
        }
        return gc;
    }

    @Override
    public void showIndex(Formatter f) {
        super.showIndex(f);
        int count = 0;
        f.format("isPartitionOfPartitions=%s%n", this.isPartitionOfPartitions);
        f.format("Partitions%n", new Object[0]);
        for (Partition p : this.getPartitions()) {
            f.format("%d:  %s%n", count++, p);
        }
        f.format("%n", new Object[0]);
        if (this.run2part == null) {
            f.format("run2part null%n", new Object[0]);
        } else {
            f.format(" master runtime -> partition %n", new Object[0]);
            count = 0;
            for (CalendarDate cd : this.masterRuntime.getRuntimesSorted()) {
                int partno = this.run2part[count];
                Partition part = this.getPartition(partno);
                f.format(" %d:  %s -> part %3d %s%n", count, cd, this.run2part[count], part);
                ++count;
            }
            f.format("%n", new Object[0]);
        }
    }

    public RandomAccessFile getRaf(int partno, int fileno) throws IOException {
        Partition part = this.getPartition(partno);
        try (GribCollection gc = part.getGribCollection();){
            RandomAccessFile randomAccessFile = gc.getDataRaf(fileno);
            return randomAccessFile;
        }
    }

    public String getFilename(int partno, int fileno) throws IOException {
        Partition part = this.getPartition(partno);
        try (GribCollection gc = part.getGribCollection();){
            String string = gc.getFilename(fileno);
            return string;
        }
    }

    static {
        collectionFactory = new FileFactory(){

            @Override
            public FileCacheable open(String location, int buffer_size, CancelTask cancelTask, Object iospMessage) throws IOException {
                RandomAccessFile raf = null;
                try {
                    raf = new RandomAccessFile(location, "r");
                    Partition p = (Partition)iospMessage;
                    return GribCdmIndex.openGribCollectionFromIndexFile(raf, p.getConfig(), true, p.getLogger());
                }
                catch (Throwable t) {
                    if (raf != null) {
                        raf.close();
                    }
                    throw t;
                }
            }
        };
    }

    public class Partition
    implements Comparable<Partition> {
        private final String name;
        private final String directory;
        private final String filename;
        private long lastModified;
        private boolean isBad;
        private MCollection dcm;

        public Partition(String name, String filename, long lastModified, String directory) {
            this.name = name;
            this.filename = filename;
            this.lastModified = lastModified;
            this.directory = directory;
        }

        public String getName() {
            return this.name;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getDirectory() {
            return this.directory;
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public boolean isBad() {
            return this.isBad;
        }

        public void setBad(boolean isBad) {
            this.isBad = isBad;
        }

        public boolean isGrib1() {
            return PartitionCollection.this.isGrib1;
        }

        public FeatureCollectionConfig getConfig() {
            return PartitionCollection.this.config;
        }

        public Logger getLogger() {
            return PartitionCollection.this.logger;
        }

        public MCollection getDcm() {
            return this.dcm;
        }

        public String getIndexFilenameInCache() {
            File file = new File(this.directory, this.filename);
            File existingFile = GribCollection.getExistingFileOrCache(file.getPath());
            if (existingFile == null) {
                File parent = PartitionCollection.this.getIndexParentFile();
                if (parent == null) {
                    return null;
                }
                existingFile = new File(parent, this.filename);
                if (!existingFile.exists()) {
                    return null;
                }
            }
            return existingFile.getPath();
        }

        public GribCollection getGribCollection() throws IOException {
            String path = this.getIndexFilenameInCache();
            if (path == null) {
                if (GribIosp.debugIndexOnly) {
                    File orgParentDir = new File(this.directory);
                    File currentFile = new File(PartitionCollection.this.indexFilename);
                    File currentParent = currentFile.getParentFile();
                    File currentParentWithDir = new File(currentParent, orgParentDir.getName());
                    File nestedIndex = PartitionCollection.this.isPartitionOfPartitions ? new File(currentParentWithDir, this.filename) : new File(currentParent, this.filename);
                    path = nestedIndex.getPath();
                } else {
                    throw new FileNotFoundException("No index filename for partition= " + this.toString());
                }
            }
            GribCollection result = partitionCache != null ? (GribCollection)partitionCache.acquire(collectionFactory, path, path, -1, null, this) : (GribCollection)collectionFactory.open(path, -1, null, this);
            return result;
        }

        @Override
        public int compareTo(Partition o) {
            return this.name.compareTo(o.name);
        }

        public String toString() {
            return "Partition{dcm=" + this.dcm + ", name='" + this.name + '\'' + ", directory='" + this.directory + '\'' + ", filename='" + this.filename + '\'' + ", lastModified='" + CalendarDate.of(this.lastModified) + '\'' + ", isBad=" + this.isBad + '}';
        }

        public Partition(MCollection dcm) {
            this.dcm = dcm;
            this.name = dcm.getCollectionName();
            this.lastModified = dcm.getLastModified();
            this.directory = StringUtil2.replace(dcm.getRoot(), '\\', "/");
            String indexFilename = StringUtil2.replace(dcm.getIndexFilename(), '\\', "/");
            if (indexFilename.startsWith(this.directory) && (indexFilename = indexFilename.substring(this.directory.length())).startsWith("/")) {
                indexFilename = indexFilename.substring(1);
            }
            this.filename = indexFilename;
            FeatureCollectionConfig config = (FeatureCollectionConfig)dcm.getAuxInfo("fcConfig");
            if (config == null) {
                PartitionCollection.this.logger.warn("HEY Partition missing a FeatureCollectionConfig {}", (Object)dcm);
            }
        }

        public GribCollection makeGribCollection(CollectionUpdateType force) throws IOException {
            return GribCdmIndex.openGribCollectionFromMCollection(PartitionCollection.this.isGrib1, this.dcm, force, null, PartitionCollection.this.logger);
        }
    }

    class DataRecord
    extends GribIosp.DataRecord {
        PartitionCollection usePartition;
        int partno;

        DataRecord(PartitionCollection usePartition, int partno, GdsHorizCoordSys hcs, int fileno, long drsPos, long bmsPos, int scanMode) {
            super(-1, fileno, drsPos, bmsPos, scanMode, hcs);
            this.usePartition = usePartition;
            this.partno = partno;
        }

        @Override
        public int compareTo(GribIosp.DataRecord o) {
            DataRecord op = (DataRecord)o;
            int rp = this.usePartition.getName().compareTo(op.usePartition.getName());
            if (rp != 0) {
                return rp;
            }
            int r = Misc.compare(this.partno, op.partno);
            if (r != 0) {
                return r;
            }
            r = Misc.compare(this.fileno, o.fileno);
            if (r != 0) {
                return r;
            }
            return Misc.compare(this.dataPos, o.dataPos);
        }

        public boolean usesSameFile(DataRecord o) {
            if (o == null) {
                return false;
            }
            int rp = this.usePartition.getName().compareTo(o.usePartition.getName());
            if (rp != 0) {
                return false;
            }
            int r = Misc.compare(this.partno, o.partno);
            if (r != 0) {
                return false;
            }
            r = Misc.compare(this.fileno, o.fileno);
            return r == 0;
        }

        public void show() throws IOException {
            String dataFilename = this.usePartition.getFilename(this.partno, this.fileno);
            System.out.printf(" **DataReader partno=%d fileno=%d filename=%s datapos=%d%n", this.partno, this.fileno, dataFilename, this.dataPos);
        }
    }

    public class VariableIndexPartitioned
    extends GribCollection.VariableIndex {
        int nparts;
        SmartArrayInt partnoSA;
        SmartArrayInt groupnoSA;
        SmartArrayInt varnoSA;
        private List<PartitionForVariable2D> partList;

        VariableIndexPartitioned(GribCollection.GroupGC g, GribCollection.VariableIndex other, int nparts) {
            super(g, other);
            this.nparts = nparts;
        }

        public void setPartitions(List<PartitionCollectionProto.PartitionVariable> pvList) {
            int[] partno = new int[this.nparts];
            int[] groupno = new int[this.nparts];
            int[] varno = new int[this.nparts];
            int count = 0;
            for (PartitionCollectionProto.PartitionVariable part : pvList) {
                partno[count] = part.getPartno();
                groupno[count] = part.getGroupno();
                varno[count] = part.getVarno();
                ++count;
            }
            this.partnoSA = new SmartArrayInt(partno);
            this.groupnoSA = new SmartArrayInt(groupno);
            this.varnoSA = new SmartArrayInt(varno);
            this.partList = null;
        }

        public void finish() {
            if (this.partList == null) {
                return;
            }
            int[] partno = new int[this.nparts];
            int[] groupno = new int[this.nparts];
            int[] varno = new int[this.nparts];
            int count = 0;
            for (PartitionForVariable2D part : this.partList) {
                partno[count] = part.partno;
                groupno[count] = part.groupno;
                varno[count] = part.varno;
                ++count;
            }
            this.partnoSA = new SmartArrayInt(partno);
            this.groupnoSA = new SmartArrayInt(groupno);
            this.varnoSA = new SmartArrayInt(varno);
            this.partList = null;
        }

        public void addPartition(int partno, int groupno, int varno) {
            if (this.partList == null) {
                this.partList = new ArrayList<PartitionForVariable2D>(this.nparts);
            }
            this.partList.add(new PartitionForVariable2D(partno, groupno, varno));
        }

        public PartitionForVariable2D getPartitionForVariable2D(int idx) {
            return new PartitionForVariable2D(this.partnoSA.get(idx), this.groupnoSA.get(idx), this.varnoSA.get(idx));
        }

        @Override
        public String toStringComplete() {
            Formatter sb = new Formatter();
            sb.format("VariableIndexPartitioned%n", new Object[0]);
            sb.format(" partno=", new Object[0]);
            this.partnoSA.show(sb);
            sb.format("%n groupno=", new Object[0]);
            this.groupnoSA.show(sb);
            sb.format("%n varno=", new Object[0]);
            this.varnoSA.show(sb);
            sb.format("%n", new Object[0]);
            int count = 0;
            sb.format("     %7s %3s %3s %6s %3s%n", "N", "dups", "Miss", "density", "partition");
            for (int i = 0; i < this.nparts; ++i) {
                int partWant = this.partnoSA.get(i);
                Partition part = PartitionCollection.this.partitions.get(partWant);
                sb.format("   %2d: %7d %s%n", count++, partWant, part.getFilename());
            }
            sb.format("%n", new Object[0]);
            sb.format("totalSize = %4d density=%6.2f%n", this.totalSize, Float.valueOf(this.density));
            sb.format(super.toStringComplete(), new Object[0]);
            return sb.toString();
        }

        public void show(Formatter f) {
            if (this.twot != null) {
                this.twot.showMissing(f);
            }
            if (this.time2runtime != null) {
                Coordinate run = this.getCoordinate(Coordinate.Type.runtime);
                Coordinate tcoord = this.getCoordinate(Coordinate.Type.time);
                if (tcoord == null) {
                    tcoord = this.getCoordinate(Coordinate.Type.timeIntv);
                }
                CoordinateTimeAbstract time = (CoordinateTimeAbstract)tcoord;
                CalendarDate ref = time.getRefDate();
                CalendarPeriod.Field unit = time.getTimeUnit().getField();
                f.format("time2runtime: %n", new Object[0]);
                int count = 0;
                for (int idx : this.time2runtime) {
                    if (idx == 0) {
                        f.format(" %2d: MISSING%n", count);
                        ++count;
                        continue;
                    }
                    Object val = time.getValue(count);
                    f.format(" %2d: %s -> %2d (%s)", count, val, idx - 1, run.getValue(idx - 1));
                    if (val instanceof Integer) {
                        int valI = (Integer)val;
                        f.format(" == %s ", ref.add(valI, unit));
                    }
                    f.format(" %n", new Object[0]);
                    ++count;
                }
                f.format("%n", new Object[0]);
            }
        }

        public void cleanup() throws IOException {
        }

        DataRecord getDataRecord(int[] indexWanted) throws IOException {
            int[] sourceIndex;
            int runIdx;
            if (GribIosp.debugRead) {
                System.out.printf("%nPartitionCollection.getDataRecord index wanted = (%s) on %s isTwod=%s%n", Misc.showInts(indexWanted), PartitionCollection.this.indexFilename, this.group.isTwod);
            }
            int firstIndex = indexWanted[0];
            int n = runIdx = this.group.isTwod ? firstIndex : this.time2runtime[firstIndex] - 1;
            if (GribIosp.debugRead && !this.group.isTwod) {
                System.out.printf("  firstIndex = %d time2runtime[firstIndex]=%d %n", firstIndex, runIdx);
            }
            if (runIdx < 0) {
                return null;
            }
            CoordinateRuntime runtime = (CoordinateRuntime)this.getCoordinate(Coordinate.Type.runtime);
            Object val = runtime.getValue(runIdx);
            int masterIdx = PartitionCollection.this.masterRuntime.getIndex(val);
            int partno = PartitionCollection.this.run2part[masterIdx];
            if (GribIosp.debugRead) {
                System.out.printf("  runCoord = %s masterRuntime.getIndex(runCoord)=%d partition=%d %n", val, masterIdx, partno);
            }
            if (partno < 0) {
                return null;
            }
            GribCollection.VariableIndex compVindex2D = this.getVindex2D(partno);
            if (compVindex2D == null) {
                return null;
            }
            if (GribIosp.debugRead) {
                System.out.printf("  compVindex2D = %s%n", compVindex2D.toStringFrom());
            }
            if (PartitionCollection.this.isPartitionOfPartitions) {
                VariableIndexPartitioned compVindex2Dp = (VariableIndexPartitioned)compVindex2D;
                return this.getDataRecordPofP(indexWanted, compVindex2Dp);
            }
            int[] nArray = sourceIndex = this.group.isTwod ? this.translateIndex2D(indexWanted, compVindex2D) : this.translateIndex1D(indexWanted, compVindex2D);
            if (sourceIndex == null) {
                return null;
            }
            GribCollection.Record record = compVindex2D.getSparseArray().getContent(sourceIndex);
            if (record == null) {
                return null;
            }
            if (GribIosp.debugRead) {
                System.out.printf("  result success: partno=%d fileno=%d %n", partno, record.fileno);
            }
            return new DataRecord(PartitionCollection.this, partno, compVindex2D.group.getGdsHorizCoordSys(), record.fileno, record.pos, record.bmsPos, record.scanMode);
        }

        private DataRecord getDataRecordPofP(int[] indexWanted, VariableIndexPartitioned compVindex2Dp) throws IOException {
            if (this.group.isTwod) {
                int[] indexWantedP = this.translateIndex2D(indexWanted, compVindex2Dp);
                if (GribIosp.debugRead) {
                    System.out.printf("  (2D) getDataRecordPofP= %s %n", Misc.showInts(indexWantedP));
                }
                return compVindex2Dp.getDataRecord(indexWantedP);
            }
            int[] indexWantedP = this.translateIndex1D(indexWanted, compVindex2Dp);
            if (GribIosp.debugRead) {
                System.out.printf("  (1D) getDataRecordPofP= %s %n", Misc.showInts(indexWantedP));
            }
            if (indexWantedP == null) {
                return null;
            }
            return compVindex2Dp.getDataRecord(indexWantedP);
        }

        private GribCollection.VariableIndex getVindex2D(int partno) throws IOException {
            VariableIndexPartitioned vip = PartitionCollection.this.isPartitionOfPartitions ? (VariableIndexPartitioned)PartitionCollection.this.getVariable2DByHash(this.group.horizCoordSys, this.cdmHash) : this;
            int idx = vip.partnoSA.findIdx(partno);
            if (idx < 0 || idx >= vip.nparts) {
                if (GribIosp.debugRead) {
                    System.out.printf("  cant find partition=%d in vip=%s%n", partno, vip);
                }
                return null;
            }
            PartitionForVariable2D partVar = vip.getPartitionForVariable2D(idx);
            Partition p = PartitionCollection.this.getPartition(partno);
            try (GribCollection gc = p.getGribCollection();){
                GribCollection.Dataset ds = gc.getDatasetCanonical();
                GribCollection.GroupGC g = ds.groups.get(partVar.groupno);
                GribCollection.VariableIndex vindex = g.variList.get(partVar.varno);
                vindex.readRecords();
                GribCollection.VariableIndex variableIndex = vindex;
                return variableIndex;
            }
        }

        private int[] translateIndex1D(int[] wholeIndex, GribCollection.VariableIndex compVindex2D) {
            int[] result = new int[wholeIndex.length + 1];
            int timeIdx = wholeIndex[0];
            int runtimeIdxWhole = this.time2runtime[timeIdx] - 1;
            int runtimeIdxPart = this.matchCoordinate(this.getCoordinate(0), runtimeIdxWhole, compVindex2D.getCoordinate(0));
            if (runtimeIdxPart < 0) {
                return null;
            }
            result[0] = runtimeIdxPart;
            for (int countDim = 0; countDim < wholeIndex.length; ++countDim) {
                int resultIdx;
                int idx = wholeIndex[countDim];
                Coordinate compCoord = compVindex2D.getCoordinate(countDim + 1);
                Coordinate wholeCoord1D = this.getCoordinate(countDim + 1);
                if (compCoord.getType() == Coordinate.Type.time2D) {
                    CoordinateTime2D compCoord2D = (CoordinateTime2D)compCoord;
                    CoordinateTimeAbstract wholeCoord1Dtime = (CoordinateTimeAbstract)wholeCoord1D;
                    Object wholeVal = wholeCoord1D.getValue(idx);
                    resultIdx = compCoord2D.matchTimeCoordinate(runtimeIdxPart, wholeVal, wholeCoord1Dtime.getRefDate());
                    if (resultIdx < 0) {
                        resultIdx = compCoord2D.matchTimeCoordinate(runtimeIdxPart, wholeVal, wholeCoord1Dtime.getRefDate());
                    }
                } else {
                    resultIdx = this.matchCoordinate(wholeCoord1D, idx, compCoord);
                    if (resultIdx < 0) {
                        resultIdx = this.matchCoordinate(wholeCoord1D, idx, compCoord);
                    }
                }
                if (resultIdx < 0) {
                    PartitionCollection.this.logger.info("Couldnt match coordinates ({}) for variable {}", (Object)Misc.showInts(wholeIndex), (Object)compVindex2D.toStringShort());
                    return null;
                }
                result[countDim + 1] = resultIdx;
            }
            return result;
        }

        private int[] translateIndex2D(int[] wholeIndex, GribCollection.VariableIndex compVindex2D) {
            int[] result = new int[wholeIndex.length];
            int countDim = 0;
            CoordinateTime2D compTime2D = (CoordinateTime2D)compVindex2D.getCoordinate(Coordinate.Type.time2D);
            if (compTime2D != null) {
                CoordinateTime2D time2D = (CoordinateTime2D)this.getCoordinate(Coordinate.Type.time2D);
                CoordinateTime2D.Time2D want = time2D.getOrgValue(wholeIndex[0], wholeIndex[1], GribIosp.debugRead);
                if (GribIosp.debugRead) {
                    System.out.printf("  translateIndex2D[runIdx=%d, timeIdx=%d] in componentVar coords = (%s,%s) %n", wholeIndex[0], wholeIndex[1], want == null ? "null" : want.getRun(), want);
                }
                if (want == null) {
                    return null;
                }
                if (!compTime2D.getIndex(want, result)) {
                    return null;
                }
                countDim = 2;
            }
            while (countDim < wholeIndex.length) {
                int idx = wholeIndex[countDim];
                int resultIdx = this.matchCoordinate(this.getCoordinate(countDim), idx, compVindex2D.getCoordinate(countDim));
                if (GribIosp.debugRead) {
                    System.out.printf("  translateIndex2D[idx=%d] resultIdx= %d %n", idx, resultIdx);
                }
                if (resultIdx < 0) {
                    return null;
                }
                result[countDim] = resultIdx;
                ++countDim;
            }
            return result;
        }

        private int matchCoordinate(Coordinate whole, int wholeIdx, Coordinate part) {
            Object val = whole.getValue(wholeIdx);
            if (val == null) {
                return -1;
            }
            return part.getIndex(val);
        }
    }

    static class PartitionForVariable2D {
        int partno;
        int groupno;
        int varno;

        PartitionForVariable2D(int partno, int groupno, int varno) {
            this.partno = partno;
            this.groupno = groupno;
            this.varno = varno;
        }
    }
}

