#!/usr/bin/perl

package eBay::API::XML::Call::GetBidderList::GetBidderListResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetBidderListResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetBidderList::GetBidderListResponseType

=head1 DESCRIPTION

Response to a GetBidderList call, which retrieves all items the user is currently bidding on, or
has won or purchased.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetBidderList::GetBidderListResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::ItemArrayType;
use eBay::API::XML::DataType::UserType;


my @gaProperties = ( [ 'BidItemArray', 'ns:ItemArrayType', ''
	     ,'eBay::API::XML::DataType::ItemArrayType', '1' ]
	, [ 'Bidder', 'ns:UserType', ''
	     ,'eBay::API::XML::DataType::UserType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setBidItemArray()

Array of items the bidder has bid on, has won or has lost.

#    Argument: 'ns:ItemArrayType'

=cut

sub setBidItemArray {
  my $self = shift;
  $self->{'BidItemArray'} = shift
}

=head2 getBidItemArray()

  Returned: Always
#    Returns: 'ns:ItemArrayType'

=cut

sub getBidItemArray {
  my $self = shift;
  return $self->_getDataTypeInstance( 'BidItemArray'
		,'eBay::API::XML::DataType::ItemArrayType');
}


=head2 setBidder()

Data for one eBay bidder.

#    Argument: 'ns:UserType'

=cut

sub setBidder {
  my $self = shift;
  $self->{'Bidder'} = shift
}

=head2 getBidder()

  Returned: Always
#    Returns: 'ns:UserType'

=cut

sub getBidder {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Bidder'
		,'eBay::API::XML::DataType::UserType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
