# for developers:
#   "cpanm < author/requires.cpanm" will install all the modules required
#   "make test_with_env" does all the extra tests (with pure Perl, Moose, etc.)
use strict;
use warnings;
BEGIN {
    unshift @INC, 'inc';
	# author requires, or bundled modules
    my @devmods = qw(
        inc::Module::Install             1.06
        Module::Install::XSUtil          0.45
        Module::Install::TestTarget      0.19
        Module::Install::AuthorTests     0.002
    );
    my @not_available;
	while(my($mod, $ver) = splice @devmods, 0, 2) {
        eval qq{use $mod $ver (); 1} or push @not_available, $mod;
    }
    if(@not_available) {
        print qq{# The following modules are not available.\n};
        print qq{# `perl $0 | cpanm` will install them:\n};
        print $_, "\n" for @not_available;
		exit 1;
     }

    $INC{'Module/Install/ExtraTests.pm'} = 1;# considered harmful!
}
use inc::Module::Install;

all_from 'lib/Text/Xslate.pm';

requires 'Mouse'                => 'v2.4.5';
requires 'Data::MessagePack'    => '0.38';
requires 'parent'               => '0.221';
requires 'Scalar::Util'         => '1.14';

test_requires 'Test::More' => 0.88; # done_testing()
test_requires 'Test::Requires';
test_requires 'File::Copy::Recursive';
test_requires 'File::Path' => '2.07';
#test_requires 'Test::LeakTrace';

install_script 'xslate';

tests_recursive;
author_tests 'xt';

my $want_xs = want_xs();
if($want_xs) {
    use_xshelper;
    cc_warnings;

    cc_src_paths qw(src);
}

resources
    homepage    => 'http://xslate.org/',
    bugtracker  => 'https://github.com/xslate/p5-Text-Xslate/issues',
    repository  => 'https://github.com/xslate/p5-Text-Xslate',
    ProjectHome => 'https://github.com/xslate',
    MailingList => 'http://groups.google.com/group/xslate',
;


system "$^X tool/opcode.PL        src/xslate_opcode.inc >xslate_ops.h";
system "$^X tool/opcode_for_pp.PL src/xslate_opcode.inc > lib/Text/Xslate/PP/Const.pm";

postamble <<'M';
src/Text-Xslate.xs :: src/xslate_opcode.inc

# xslate_ops.h is automatically generated by src/Text-Xslate.xs
xslate_ops.h :: src/xslate_opcode.inc tool/opcode.PL
	$(PERLRUNINST) tool/opcode.PL src/xslate_opcode.inc >xslate_ops.h

lib/Text/Xslate/PP/Const.pm :: src/xslate_opcode.inc tool/opcode_for_pp.PL
	$(PERLRUNINST) tool/opcode_for_pp.PL src/xslate_opcode.inc > lib/Text/Xslate/PP/Const.pm
M

my @testall;
if($Module::Install::AUTHOR) {
    @testall = (alias => 'test');
}

if($want_xs) {
    test_target test_pp => (
        env    => { PERL_ONLY => 1 },
        @testall,
    );
}

clean_files qw(
    Text-Xslate-*
    nytprof *.out
    cover_db
    .xslate_cache
);

WriteAll(check_nmake => 0);
