/*
 * Decompiled with CFR 0.152.
 */
package net.sf.json.regexp;

import net.sf.json.regexp.JdkRegexpMatcher;
import net.sf.json.regexp.Perl5RegexpMatcher;
import net.sf.json.regexp.RegexpMatcher;

public class RegexpUtils {
    private static String javaVersion = "1.3.1";

    public static RegexpMatcher getMatcher(String pattern) {
        if (RegexpUtils.isJDK13()) {
            return new Perl5RegexpMatcher(pattern);
        }
        return new JdkRegexpMatcher(pattern);
    }

    public static RegexpMatcher getMatcher(String pattern, boolean multiline) {
        if (RegexpUtils.isJDK13()) {
            return new Perl5RegexpMatcher(pattern, true);
        }
        return new JdkRegexpMatcher(pattern, true);
    }

    public static boolean isJDK13() {
        return javaVersion.indexOf("1.3") != -1;
    }

    private RegexpUtils() {
    }

    static {
        javaVersion = System.getProperty("java.version");
    }
}

