/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.commands.State;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.groups.RepositoryGroup;
import org.eclipse.egit.ui.internal.groups.RepositoryGroups;
import org.eclipse.egit.ui.internal.repository.FilterCache;
import org.eclipse.egit.ui.internal.repository.RefCache;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefNode;
import org.eclipse.egit.ui.internal.repository.tree.AdditionalRefsNode;
import org.eclipse.egit.ui.internal.repository.tree.BranchHierarchyNode;
import org.eclipse.egit.ui.internal.repository.tree.BranchesNode;
import org.eclipse.egit.ui.internal.repository.tree.ErrorNode;
import org.eclipse.egit.ui.internal.repository.tree.FetchNode;
import org.eclipse.egit.ui.internal.repository.tree.FileNode;
import org.eclipse.egit.ui.internal.repository.tree.FolderNode;
import org.eclipse.egit.ui.internal.repository.tree.LocalNode;
import org.eclipse.egit.ui.internal.repository.tree.PushNode;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.repository.tree.RemoteNode;
import org.eclipse.egit.ui.internal.repository.tree.RemoteTrackingNode;
import org.eclipse.egit.ui.internal.repository.tree.RemotesNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryGroupNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryTreeNode;
import org.eclipse.egit.ui.internal.repository.tree.StashNode;
import org.eclipse.egit.ui.internal.repository.tree.StashedCommitNode;
import org.eclipse.egit.ui.internal.repository.tree.SubmodulesNode;
import org.eclipse.egit.ui.internal.repository.tree.TagNode;
import org.eclipse.egit.ui.internal.repository.tree.TagsNode;
import org.eclipse.egit.ui.internal.repository.tree.WorkingDirNode;
import org.eclipse.egit.ui.internal.repository.tree.filter.NodesByCommitTimeFilter;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevTag;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.dialogs.SearchPattern;

public class RepositoriesViewContentProvider
implements ITreeContentProvider {
    private static final Object[] NO_CHILDREN = new Object[0];
    private final State branchHierarchy;
    private boolean showUnbornHead = false;
    private boolean showRepositoryGroups = false;
    private RefCache.Cache refCache = RefCache.get();
    private FilterCache filters;

    public RepositoriesViewContentProvider() {
        this(false);
    }

    public RepositoriesViewContentProvider(boolean showUnbornHead) {
        this.showUnbornHead = showUnbornHead;
        ICommandService srv = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        this.branchHierarchy = srv.getCommand("org.eclipse.egit.ui.RepositoriesToggleBranchHierarchy").getState("org.eclipse.ui.commands.toggleState");
    }

    public RepositoriesViewContentProvider showingRepositoryGroups(boolean showGroups) {
        this.showRepositoryGroups = showGroups;
        return this;
    }

    public Object[] getElements(Object inputElement) {
        ArrayList<RepositoryTreeNode> nodes = new ArrayList<RepositoryTreeNode>();
        ArrayList<File> directories = new ArrayList<File>();
        if (inputElement instanceof Collection) {
            for (Object next : (Collection)inputElement) {
                if (next instanceof RepositoryTreeNode) {
                    nodes.add((RepositoryTreeNode)next);
                    continue;
                }
                if (!(next instanceof String)) continue;
                directories.add(new File((String)next));
            }
        } else if (inputElement instanceof IWorkspaceRoot) {
            directories.addAll(RepositoryUtil.INSTANCE.getConfiguredRepositories().stream().map(File::new).collect(Collectors.toList()));
        }
        nodes.addAll(this.getRepositoryNodes(RepositoryGroups.INSTANCE, null, directories));
        if (this.showRepositoryGroups) {
            for (RepositoryGroup group : RepositoryGroups.INSTANCE.getGroups()) {
                nodes.add(new RepositoryGroupNode(group));
            }
        }
        Collections.sort(nodes);
        return nodes.toArray();
    }

    public void dispose() {
        this.refCache.dispose();
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public Object[] getChildren(Object parentElement) {
        RepositoryTreeNode node = (RepositoryTreeNode)parentElement;
        Repository repo = node.getRepository();
        switch (node.getType()) {
            case BRANCHES: {
                ArrayList<RepositoryTreeNode> nodes = new ArrayList<RepositoryTreeNode>();
                nodes.add(new LocalNode(node, repo));
                nodes.add(new RemoteTrackingNode(node, repo));
                return nodes.toArray();
            }
            case LOCAL: {
                return this.getBranchChildren(node, repo, "refs/heads/");
            }
            case REMOTETRACKING: {
                return this.getBranchChildren(node, repo, "refs/remotes/");
            }
            case BRANCHHIERARCHY: {
                return this.getBranchHierarchyChildren(node, repo, ((IPath)((BranchHierarchyNode)node).getObject()).toPortableString());
            }
            case TAGS: {
                return this.getTagsChildren((TagsNode)node, repo);
            }
            case ADDITIONALREFS: {
                ArrayList<AdditionalRefNode> refs = new ArrayList<AdditionalRefNode>();
                try {
                    Ref head;
                    for (Map.Entry<String, Ref> refEntry : this.getRefs(repo, "").entrySet()) {
                        String name = refEntry.getKey();
                        if (name.startsWith("refs/heads/") || name.startsWith("refs/tags/") || name.startsWith("refs/remotes/")) continue;
                        refs.add(new AdditionalRefNode(node, repo, refEntry.getValue()));
                    }
                    for (Ref r : this.refCache.additional(repo)) {
                        refs.add(new AdditionalRefNode(node, repo, r));
                    }
                    if (this.showUnbornHead && (head = repo.exactRef("HEAD")) != null && head.isSymbolic() && head.getObjectId() == null) {
                        refs.add(new AdditionalRefNode(node, repo, head));
                    }
                }
                catch (Exception e) {
                    return this.handleException(e, node);
                }
                return refs.toArray();
            }
            case REMOTES: {
                ArrayList<RemoteNode> remotes = new ArrayList<RemoteNode>();
                Repository rep = node.getRepository();
                Set configNames = rep.getConfig().getSubsections("remote");
                for (String configName : configNames) {
                    remotes.add(new RemoteNode(node, repo, configName));
                }
                return remotes.toArray();
            }
            case REPO: {
                ArrayList<RepositoryTreeNode> nodeList = new ArrayList<RepositoryTreeNode>();
                nodeList.add(new BranchesNode(node, repo));
                TagsNode tags = new TagsNode(node, repo);
                if (this.filters != null) {
                    tags.setFilter(this.filters.get(tags));
                }
                nodeList.add(tags);
                nodeList.add(new AdditionalRefsNode(node, repo));
                boolean bare = repo.isBare();
                if (!bare) {
                    nodeList.add(new WorkingDirNode(node, repo));
                }
                nodeList.add(new RemotesNode(node, repo));
                if (!bare && this.hasStashedCommits(repo)) {
                    nodeList.add(new StashNode(node, repo));
                }
                if (!bare && this.hasConfiguredSubmodules(repo)) {
                    nodeList.add(new SubmodulesNode(node, repo));
                }
                return nodeList.toArray();
            }
            case REPOGROUP: {
                List<File> repoDirs = ((RepositoryGroup)((RepositoryGroupNode)node).getObject()).getRepositoryDirectories();
                return this.getRepositoryNodes(null, node, repoDirs).toArray();
            }
            case WORKINGDIR: {
                if (repo.isBare()) {
                    return NO_CHILDREN;
                }
                return this.getDirectoryChildren(node, repo.getWorkTree());
            }
            case FOLDER: {
                return this.getDirectoryChildren(node, (File)node.getObject());
            }
            case REMOTE: {
                int uriCount;
                RemoteConfig rc;
                ArrayList<RepositoryTreeNode> children = new ArrayList<RepositoryTreeNode>();
                String remoteName = (String)node.getObject();
                try {
                    rc = new RemoteConfig((Config)node.getRepository().getConfig(), remoteName);
                }
                catch (URISyntaxException e) {
                    return this.handleException(e, node);
                }
                if (!rc.getURIs().isEmpty()) {
                    children.add(new FetchNode(node, node.getRepository(), ((URIish)rc.getURIs().get(0)).toPrivateString()));
                }
                if ((uriCount = rc.getPushURIs().size()) == 0 && !rc.getURIs().isEmpty()) {
                    ++uriCount;
                }
                if (uriCount > 0) {
                    URIish firstUri = !rc.getPushURIs().isEmpty() ? (URIish)rc.getPushURIs().get(0) : (URIish)rc.getURIs().get(0);
                    if (uriCount == 1) {
                        children.add(new PushNode(node, node.getRepository(), firstUri.toPrivateString()));
                    } else {
                        children.add(new PushNode(node, node.getRepository(), String.valueOf(firstUri.toPrivateString()) + "..."));
                    }
                }
                return children.toArray();
            }
            case SUBMODULES: {
                ArrayList<RepositoryNode> children = new ArrayList<RepositoryNode>();
                Repository repository = node.getRepository();
                try {
                    Throwable rc = null;
                    Object var7_32 = null;
                    try (SubmoduleWalk walk = SubmoduleWalk.forIndex((Repository)repository);){
                        walk.setBuilderFactory(() -> RepositoryCache.INSTANCE.getBuilder(false, false));
                        while (walk.next()) {
                            Repository submodule = walk.getRepository();
                            if (submodule == null) continue;
                            children.add(new RepositoryNode(node, submodule));
                        }
                    }
                    catch (Throwable throwable) {
                        if (rc == null) {
                            rc = throwable;
                        } else if (rc != throwable) {
                            rc.addSuppressed(throwable);
                        }
                        throw rc;
                    }
                }
                catch (IOException e) {
                    this.handleException(e, node);
                }
                return children.toArray();
            }
            case STASH: {
                ArrayList<StashedCommitNode> stashNodes = new ArrayList<StashedCommitNode>();
                int index = 0;
                try {
                    for (RevCommit commit : Git.wrap((Repository)repo).stashList().call()) {
                        stashNodes.add(new StashedCommitNode(node, repo, index++, commit));
                    }
                }
                catch (Exception e) {
                    this.handleException(e, node);
                }
                return stashNodes.toArray();
            }
            case REF: 
            case ADDITIONALREF: 
            case TAG: 
            case FILE: 
            case FETCH: 
            case PUSH: 
            case STASHED_COMMIT: 
            case ERROR: {
                return null;
            }
        }
        return null;
    }

    private List<RepositoryNode> getRepositoryNodes(RepositoryGroups groupsUtil, RepositoryTreeNode<?> parent, List<File> directories) {
        ArrayList<RepositoryNode> result = new ArrayList<RepositoryNode>();
        ArrayList<File> filtersToKeep = new ArrayList<File>();
        for (File gitDir : directories) {
            try {
                if (gitDir.exists()) {
                    boolean addRepo;
                    filtersToKeep.add(new Path(gitDir.getAbsolutePath()).toFile());
                    boolean bl = addRepo = groupsUtil == null || !this.showRepositoryGroups || !groupsUtil.belongsToGroup(gitDir);
                    if (!addRepo) continue;
                    RepositoryNode rNode = new RepositoryNode(parent, RepositoryCache.INSTANCE.lookupRepository(gitDir));
                    result.add(rNode);
                    continue;
                }
                RepositoryUtil.INSTANCE.removeDir(gitDir);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.filters != null) {
            this.filters.keepOnly(filtersToKeep);
        }
        return result;
    }

    private Object[] getBranchChildren(RepositoryTreeNode node, Repository repo, String prefix) {
        if (this.isHierarchical()) {
            return this.getBranchHierarchyChildren(node, repo, prefix);
        }
        try {
            return this.getRefs(repo, prefix).values().stream().filter(ref -> !ref.isSymbolic()).map(ref -> new RefNode(node, repo, (Ref)ref)).toArray();
        }
        catch (IOException e) {
            return this.handleException(e, node);
        }
    }

    private Object[] getBranchHierarchyChildren(RepositoryTreeNode node, Repository repo, String prefix) {
        try {
            HashSet folderChildren = new HashSet();
            return this.getRefs(repo, prefix).entrySet().stream().filter(e -> !((Ref)e.getValue()).isSymbolic()).map(e -> {
                int i = ((String)e.getKey()).indexOf(47, prefix.length());
                if (i < 0) {
                    return new RefNode(node, repo, (Ref)e.getValue());
                }
                String name = ((String)e.getKey()).substring(prefix.length(), i);
                if (folderChildren.add(name)) {
                    return new BranchHierarchyNode(node, repo, Path.fromPortableString((String)(String.valueOf(prefix) + name)));
                }
                return null;
            }).filter(Objects::nonNull).toArray();
        }
        catch (IOException e2) {
            return this.handleException(e2, node);
        }
    }

    private Object[] getDirectoryChildren(final RepositoryTreeNode parentNode, File parent) {
        final Repository repo = parentNode.getRepository();
        final ArrayList children = new ArrayList();
        try {
            Files.walkFileTree(parent.toPath(), EnumSet.noneOf(FileVisitOption.class), 1, (FileVisitor<? super java.nio.file.Path>)new SimpleFileVisitor<java.nio.file.Path>(){

                @Override
                public FileVisitResult visitFile(java.nio.file.Path file, BasicFileAttributes attrs) throws IOException {
                    if (attrs.isDirectory()) {
                        children.add(new FolderNode(parentNode, repo, file.toFile()));
                    } else {
                        children.add(new FileNode(parentNode, repo, file.toFile()));
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(java.nio.file.Path file, IOException exc) throws IOException {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return children.toArray();
    }

    private Object[] getTagsChildren(TagsNode parentNode, Repository repo) {
        ArrayList nodes = new ArrayList();
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (RevWalk walk = new RevWalk(repo);){
                walk.setRetainBody(true);
                String filterText = this.filters != null ? this.filters.get(parentNode) : null;
                NodesByCommitTimeFilter timeFilter = new NodesByCommitTimeFilter(filterText);
                Matcher nameFilter = RepositoriesViewContentProvider.matcher(filterText);
                for (Ref tagRef : this.getRefs(repo, "refs/tags/").values()) {
                    if (!timeFilter.isFilterActive() && !nameFilter.matches(Repository.shortenRefName((String)tagRef.getName()))) continue;
                    ObjectId objectId = tagRef.getLeaf().getObjectId();
                    RevObject revObject = walk.parseAny((AnyObjectId)objectId);
                    RevObject peeledObject = walk.peel(revObject);
                    TagNode tagNode = this.createTagNode(parentNode, repo, tagRef, revObject, peeledObject);
                    timeFilter.addNode(tagNode, peeledObject);
                }
                nodes.addAll(timeFilter.getFilteredNodes());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            return this.handleException(e, parentNode);
        }
        return nodes.toArray();
    }

    private static Matcher matcher(String filter) {
        boolean endAnchored;
        boolean frontAnchored;
        String pattern = filter;
        if (StringUtils.isEmptyOrNull((String)pattern)) {
            return s -> true;
        }
        boolean bl = frontAnchored = pattern.charAt(0) == '^';
        if (frontAnchored) {
            pattern = pattern.substring(1);
        }
        boolean bl2 = endAnchored = !pattern.isEmpty() && pattern.charAt(pattern.length() - 1) == '$';
        if (endAnchored) {
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        if (pattern.isEmpty()) {
            return s -> true;
        }
        if (!frontAnchored) {
            pattern = String.valueOf('*') + pattern;
        }
        pattern = RepositoriesViewContentProvider.fixTrailingBackslash(pattern);
        pattern = String.valueOf(pattern) + (endAnchored ? (char)' ' : '*');
        SearchPattern matcher = new SearchPattern(2);
        matcher.setPattern(pattern);
        return arg_0 -> ((SearchPattern)matcher).matches(arg_0);
    }

    private static String fixTrailingBackslash(String text) {
        int l;
        int i = l = text.length();
        while (i > 0) {
            if (text.charAt(i - 1) != '\\') break;
            --i;
        }
        if ((l - i) % 2 != 0) {
            return String.valueOf(text) + '\\';
        }
        return text;
    }

    private TagNode createTagNode(RepositoryTreeNode parentNode, Repository repo, Ref ref, RevObject revObject, RevObject peeledObject) {
        boolean annotated = revObject instanceof RevTag;
        if (peeledObject instanceof RevCommit) {
            RevCommit commit = (RevCommit)peeledObject;
            String id = commit.getId().name();
            String message = commit.getShortMessage();
            return new TagNode(parentNode, repo, ref, annotated, id, message);
        }
        if (annotated) {
            RevTag tag = (RevTag)revObject;
            String message = tag.getShortMessage();
            return new TagNode(parentNode, repo, ref, true, null, message);
        }
        return new TagNode(parentNode, repo, ref, false, null, "");
    }

    private Object[] handleException(Exception e, RepositoryTreeNode parentNode) {
        Activator.handleError(e.getMessage(), e, false);
        String message = e.getMessage();
        if (message == null) {
            return new Object[]{new ErrorNode(parentNode, parentNode.getRepository(), UIText.RepositoriesViewContentProvider_ExceptionNodeText)};
        }
        return new Object[]{new ErrorNode(parentNode, parentNode.getRepository(), message)};
    }

    public Object getParent(Object element) {
        if (element instanceof RepositoryTreeNode) {
            return ((RepositoryTreeNode)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        RepositoryTreeNode node = (RepositoryTreeNode)element;
        Repository repo = node.getRepository();
        switch (node.getType()) {
            case REPOGROUP: {
                return ((RepositoryGroupNode)element).hasChildren();
            }
            case REPO: 
            case BRANCHES: 
            case ADDITIONALREFS: 
            case SUBMODULES: {
                return true;
            }
            case TAGS: {
                return this.hasTagsChildren(repo);
            }
            case WORKINGDIR: {
                return !repo.isBare() && this.hasDirectoryChildren(repo.getWorkTree());
            }
            case FOLDER: {
                return !repo.isBare() && this.hasDirectoryChildren((File)node.getObject());
            }
            case FILE: {
                return false;
            }
        }
        Object[] children = this.getChildren(element);
        return children != null && children.length > 0;
    }

    private boolean hasDirectoryChildren(File file) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (DirectoryStream<java.nio.file.Path> dir = Files.newDirectoryStream(file.toPath());){
                return dir.iterator().hasNext();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | DirectoryIteratorException e) {
            return false;
        }
    }

    private boolean hasTagsChildren(final Repository repo) {
        block3: {
            try {
                if (this.refCache.isLoaded(repo)) break block3;
                WorkspaceJob job = new WorkspaceJob(UIText.RepositoriesViewContentProvider_ReadReferencesJob){

                    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                        try {
                            RepositoriesViewContentProvider.this.getRefs(repo, "refs/tags/");
                        }
                        catch (IOException e) {
                            return Status.CANCEL_STATUS;
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
                return true;
            }
            catch (IOException e) {
                return true;
            }
        }
        return !this.getRefs(repo, "refs/tags/").isEmpty();
    }

    private Map<String, Ref> getRefs(Repository repo, String prefix) throws IOException {
        return this.refCache.byPrefix(repo, prefix);
    }

    private boolean hasConfiguredSubmodules(Repository repository) {
        if (new File(repository.getWorkTree(), ".gitmodules").isFile()) {
            return true;
        }
        return !repository.getConfig().getSubsections("submodule").isEmpty();
    }

    private boolean hasStashedCommits(Repository repository) {
        try {
            return repository.exactRef("refs/stash") != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isHierarchical() {
        return (Boolean)this.branchHierarchy.getValue();
    }

    public RepositoriesViewContentProvider withFilterCache(FilterCache cache) {
        this.filters = cache;
        return this;
    }

    @FunctionalInterface
    private static interface Matcher {
        public boolean matches(String var1);
    }
}

