/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handles;

import java.util.List;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Locator;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.tools.FBNScrollingConnectionEndpointTracker;
import org.eclipse.fordiac.ide.application.tools.MultiFBNScrollingconnectionEndpointTracker;
import org.eclipse.fordiac.ide.gef.handles.ScrollingConnectionEndpointHandle;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.tools.ConnectionEndpointTracker;

public class FBNConnectionEndPointHandle
extends ScrollingConnectionEndpointHandle {
    public FBNConnectionEndPointHandle(ConnectionEditPart owner, int endPoint) {
        super(owner, endPoint);
        this.setLocator((Locator)new ConnectionLocator(this.getConnection(), endPoint){

            protected Point getLocation(PointList points) {
                Point p = super.getLocation(points);
                switch (this.getAlignment()) {
                    case 2: {
                        p.x += FBNConnectionEndPointHandle.this.getPreferredSize().width / 2 - 4;
                        break;
                    }
                    case 3: {
                        p.x += -FBNConnectionEndPointHandle.this.getPreferredSize().width / 2 + 4;
                        break;
                    }
                }
                return p;
            }
        });
    }

    protected void init() {
        super.init();
        this.setPreferredSize(17, 13);
    }

    protected void paintHandleCenter(Graphics g, Rectangle r) {
        int xbuf = r.x;
        int wbuf = r.width;
        int shrinkVal = this.getInnerShrinkVal();
        r.shrink(shrinkVal, shrinkVal + 1);
        switch (this.getEndPoint()) {
            case 2: {
                r.x = xbuf;
                break;
            }
            case 3: {
                r.x = xbuf + wbuf - r.width;
                break;
            }
        }
        g.fillRoundRectangle(r, r.height / 2, r.height / 2);
    }

    protected ConnectionEndpointTracker createConnectionEndPointTracker(List<ConnectionEditPart> coSelectedConnections) {
        if (coSelectedConnections.size() > 1) {
            return new MultiFBNScrollingconnectionEndpointTracker(coSelectedConnections);
        }
        return new FBNScrollingConnectionEndpointTracker(coSelectedConnections.get(0));
    }
}

