/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.policies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.editparts.IContainerEditPart;
import org.eclipse.fordiac.ide.application.policies.ContainerResizeTracker;
import org.eclipse.fordiac.ide.gef.policies.ModifiedMoveHandle;
import org.eclipse.fordiac.ide.gef.policies.ModifiedResizeablePolicy;
import org.eclipse.gef.tools.ResizeTracker;

public class ContainerResizePolicy
extends ModifiedResizeablePolicy {
    protected ResizeTracker getResizeTracker(int direction) {
        return new ContainerResizeTracker(this.getHost(), direction);
    }

    public IContainerEditPart getHost() {
        return (IContainerEditPart)super.getHost();
    }

    protected IFigure createSelectionFeedbackFigure() {
        RoundedRectangle figure = (RoundedRectangle)super.createSelectionFeedbackFigure();
        figure.setFill(false);
        figure.setOutline(true);
        figure.setLineWidth(10);
        figure.setLayoutManager((LayoutManager)new ToolbarLayout());
        figure.add(this.createCommentAreaFBFigure(figure));
        return figure;
    }

    private IFigure createCommentAreaFBFigure(final RoundedRectangle figure) {
        RectangleFigure commentArea = new RectangleFigure(){

            public void setBounds(Rectangle rect) {
                rect.translate(figure.getLineWidth(), figure.getLineWidth());
                rect.width -= 2 * figure.getLineWidth();
                super.setBounds(rect);
            }
        };
        commentArea.setAlpha(50);
        commentArea.setOutline(false);
        commentArea.setBounds(this.getCommentAreaBounds(figure));
        commentArea.setForegroundColor(ModifiedMoveHandle.getSelectionColor());
        commentArea.setBackgroundColor(ModifiedMoveHandle.getSelectionColor());
        return commentArea;
    }

    private Rectangle getCommentAreaBounds(RoundedRectangle figure) {
        Rectangle bounds = this.getHost().getFigure().getBounds().getCopy();
        Rectangle contentBounds = this.getHost().getContentEP().getFigure().getBounds();
        bounds.height = contentBounds.y - bounds.y - figure.getLineWidth();
        return bounds;
    }
}

