/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.change;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.ConnectionLayoutTagger;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.change.MapToCommand;
import org.eclipse.fordiac.ide.model.commands.change.UnmapCommand;
import org.eclipse.fordiac.ide.model.commands.create.AbstractConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.AdapterConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.DataConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.create.EventConnectionCreateCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteErrorMarkerCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.EventType;
import org.eclipse.fordiac.ide.model.datatype.helper.InternalAttributeDeclarations;
import org.eclipse.fordiac.ide.model.errormarker.FordiacErrorMarkerInterfaceHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerFBNElement;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.MappingTarget;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.impl.ConfigurableFBManagement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public abstract class AbstractUpdateFBNElementCommand
extends Command
implements ConnectionLayoutTagger,
ScopedCommand {
    protected final CompoundCommand reconnCmds = new CompoundCommand();
    protected final CompoundCommand resourceConnCreateCmds = new CompoundCommand();
    protected Command mapCmd = null;
    protected UnmapCommand unmapCmd = null;
    protected FBNetworkElement newElement;
    protected FBNetworkElement oldElement;
    protected int oldIndex;
    protected FBNetwork network;
    protected TypeEntry entry;

    protected AbstractUpdateFBNElementCommand(FBNetworkElement oldElement) {
        this.oldElement = Objects.requireNonNull(oldElement);
        this.network = Objects.requireNonNull(this.oldElement.getFbNetwork(), "Element not in a network");
    }

    public void execute() {
        Resource resource = null;
        List<ConnData> resourceConns = null;
        if (this.oldElement.isMapped()) {
            if (this.network.equals(this.oldElement.getResource().getFBNetwork())) {
                this.oldElement = this.oldElement.getOpposite();
                this.network = this.oldElement.getFbNetwork();
            }
            resource = this.oldElement.getResource();
            resourceConns = this.getResourceCons();
            this.unmapCmd = new UnmapCommand(this.oldElement);
            this.unmapCmd.execute();
        }
        this.createNewFB();
        AbstractUpdateFBNElementCommand.checkGroup(this.oldElement, this.newElement);
        if (this.network != null) {
            this.oldIndex = this.network.getNetworkElements().indexOf((Object)this.oldElement);
            this.network.getNetworkElements().add(this.oldIndex, (Object)this.newElement);
        }
        this.handleErrorMarker();
        this.handleParameters();
        this.handleConnections();
        this.reconnCmds.execute();
        if (this.newElement.getType() != null) {
            this.transferVisibleAndVarConfigAttributes((EList<VarDeclaration>)this.newElement.getType().getInterfaceList().getInputVars());
            this.transferVisibleAndVarConfigAttributes((EList<VarDeclaration>)this.newElement.getType().getInterfaceList().getOutputVars());
        }
        this.transferVisibleAndVarConfigAttributes((EList<VarDeclaration>)this.oldElement.getInterface().getInputVars());
        this.transferVisibleAndVarConfigAttributes((EList<VarDeclaration>)this.oldElement.getInterface().getOutputVars());
        if (this.network != null) {
            this.network.getNetworkElements().remove((Object)this.oldElement);
        }
        this.newElement.setName(this.oldElement.getName());
        if (resource != null) {
            this.mapCmd = MapToCommand.createMapToCommand(this.newElement, (MappingTarget)resource);
            Command command = this.mapCmd;
            if (command instanceof MapToCommand) {
                MapToCommand mapToCommand = (MapToCommand)command;
                mapToCommand.setElementIndex(this.unmapCmd.getElementIndex());
            }
            if (this.mapCmd.canExecute()) {
                this.mapCmd.execute();
                this.recreateResourceConns(resourceConns);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void handleConfigurableFB() {
        FBNetworkElement fBNetworkElement = this.newElement;
        if (!(fBNetworkElement instanceof ConfigurableFB)) return;
        ConfigurableFB configFb = (ConfigurableFB)fBNetworkElement;
        FBNetworkElement fBNetworkElement2 = this.oldElement;
        if (!(fBNetworkElement2 instanceof ConfigurableFB)) return;
        ConfigurableFB oldConfigFb = (ConfigurableFB)fBNetworkElement2;
        configFb.setDataType(oldConfigFb.getDataType());
        if (configFb instanceof Demultiplexer) {
            Demultiplexer oldDemux;
            Demultiplexer newDemux = (Demultiplexer)configFb;
            if (oldConfigFb instanceof Demultiplexer && (oldDemux = (Demultiplexer)oldConfigFb).isIsConfigured()) {
                newDemux.loadConfiguration("VisibleChildren", ConfigurableFBManagement.buildVisibleChildrenString((EList)oldDemux.getMemberVars()));
                return;
            }
        }
        configFb.updateConfiguration();
    }

    public void redo() {
        if (this.unmapCmd != null) {
            this.unmapCmd.redo();
        }
        AbstractUpdateFBNElementCommand.checkGroup(this.oldElement, this.newElement);
        this.network.getNetworkElements().add(this.oldIndex, (Object)this.newElement);
        this.reconnCmds.redo();
        this.network.getNetworkElements().remove((Object)this.oldElement);
        if (this.mapCmd != null) {
            this.mapCmd.redo();
            this.resourceConnCreateCmds.redo();
        }
    }

    public void undo() {
        if (this.mapCmd != null) {
            this.resourceConnCreateCmds.undo();
            this.mapCmd.undo();
        }
        this.network.getNetworkElements().add(this.oldIndex, (Object)this.oldElement);
        this.reconnCmds.undo();
        this.network.getNetworkElements().remove((Object)this.newElement);
        AbstractUpdateFBNElementCommand.checkGroup(this.newElement, this.oldElement);
        if (this.unmapCmd != null) {
            this.unmapCmd.undo();
        }
    }

    private static void checkGroup(FBNetworkElement oldElem, FBNetworkElement newElem) {
        if (oldElem.isInGroup()) {
            newElem.setGroup(oldElem.getGroup());
            oldElem.setGroup(null);
        }
    }

    protected void setInterface() {
        this.newElement.setInterface(this.newElement.getType().getInterfaceList().copy());
    }

    private void transferVisibleAndVarConfigAttributes(EList<VarDeclaration> varDeclList) {
        varDeclList.forEach(varDecl -> {
            IInterfaceElement iInterfaceElement = this.newElement.getInterfaceElement(varDecl.getName());
            if (iInterfaceElement instanceof VarDeclaration) {
                VarDeclaration newDecl = (VarDeclaration)iInterfaceElement;
                if (newDecl.isIsInput() && newDecl.getInputConnections().isEmpty() || !newDecl.isIsInput() && newDecl.getOutputConnections().isEmpty()) {
                    newDecl.setVisible(varDecl.isVisible());
                }
                newDecl.setVarConfig(varDecl.isVarConfig());
            }
        });
    }

    protected void recreateResourceConns(List<ConnData> resourceConns) {
        FBNetworkElement orgMappedElement = this.unmapCmd.getMappedFBNetworkElement();
        FBNetworkElement copiedMappedElement = this.newElement.getOpposite();
        for (ConnData connData : resourceConns) {
            IInterfaceElement source = AbstractUpdateFBNElementCommand.findUpdatedInterfaceElement(copiedMappedElement, orgMappedElement, connData.source);
            IInterfaceElement dest = AbstractUpdateFBNElementCommand.findUpdatedInterfaceElement(copiedMappedElement, orgMappedElement, connData.dest);
            if (source == null || dest == null) continue;
            AbstractConnectionCreateCommand dccc = this.createConnectionCreateCommand(copiedMappedElement.getFbNetwork(), source.getType());
            dccc.setSource(source);
            dccc.setDestination(dest);
            if (!dccc.canExecute()) continue;
            dccc.execute();
            this.resourceConnCreateCmds.add((Command)dccc);
        }
    }

    protected static IInterfaceElement findUpdatedInterfaceElement(FBNetworkElement newElement, FBNetworkElement oldElement, IInterfaceElement oldInterface) {
        if (oldInterface != null && oldInterface.getFBNetworkElement() == oldElement) {
            return AbstractUpdateFBNElementCommand.updateSelectedInterface(oldInterface, newElement);
        }
        return oldInterface;
    }

    protected static List<Connection> getAllConnections(FBNetworkElement element) {
        return element.getInterface().getAllInterfaceElements().stream().map(ifEle -> {
            if (ifEle.isIsInput()) {
                return ifEle.getInputConnections();
            }
            return ifEle.getOutputConnections();
        }).flatMap(Collection::stream).toList();
    }

    protected void createValues() {
        this.newElement.getInterface().getInputVars().stream().forEach(inVar -> {
            inVar.setValue(LibraryElementFactory.eINSTANCE.createValue());
            this.checkSourceParam((VarDeclaration)inVar);
        });
    }

    protected void transferInstanceComments() {
        this.oldElement.getInterface().getAllInterfaceElements().stream().filter(ie -> !ie.getComment().isBlank()).forEach(ie -> {
            IInterfaceElement newIE = this.newElement.getInterfaceElement(ie.getName());
            if (newIE != null) {
                newIE.setComment(ie.getComment());
            }
        });
    }

    private void checkSourceParam(VarDeclaration variable) {
        VarDeclaration srcVar = this.oldElement.getInterface().getVariable(variable.getName());
        if (srcVar != null && srcVar.getValue() != null) {
            variable.getValue().setValue(srcVar.getValue().getValue());
        }
    }

    protected List<ConnData> getResourceCons() {
        ArrayList<ConnData> retVal = new ArrayList<ConnData>();
        FBNetworkElement resElement = this.oldElement.getOpposite();
        for (Connection conn : AbstractUpdateFBNElementCommand.getAllConnections(resElement)) {
            IInterfaceElement source = conn.getSource();
            IInterfaceElement dest = conn.getDestination();
            if (!source.getFBNetworkElement().isMapped() || !dest.getFBNetworkElement().isMapped()) {
                retVal.add(new ConnData(conn.getSource(), conn.getDestination()));
                continue;
            }
            if ((source.getFBNetworkElement() != resElement || dest.getFBNetworkElement().getOpposite().getFbNetwork() == this.oldElement.getFbNetwork()) && (dest.getFBNetworkElement() != resElement || source.getFBNetworkElement().getOpposite().getFbNetwork() == this.oldElement.getFbNetwork())) continue;
            retVal.add(new ConnData(conn.getSource(), conn.getDestination()));
        }
        return retVal;
    }

    private void handleErrorMarker() {
        if (this.oldElement instanceof ErrorMarkerFBNElement && this.newElement instanceof ErrorMarkerFBNElement) {
            this.copyErrorMarkerRef();
        }
    }

    protected void handleParameters() {
        this.processVars(this.oldElement.getInterface());
        this.processEvents(this.oldElement.getInterface());
        this.checkErrorMarkerPinParameters();
    }

    private void processEvents(InterfaceList interfaceList) {
        for (Event input : interfaceList.getEventInputs()) {
            if (!input.getInputConnections().isEmpty() && input.getAttributes().isEmpty()) continue;
            AbstractUpdateFBNElementCommand.updateSelectedInterface((IInterfaceElement)input, this.newElement);
        }
        for (Event output : interfaceList.getEventOutputs()) {
            if (!output.getOutputConnections().isEmpty() && output.getAttributes().isEmpty()) continue;
            AbstractUpdateFBNElementCommand.updateSelectedInterface((IInterfaceElement)output, this.newElement);
        }
    }

    private void processVars(InterfaceList interfaceList) {
        ArrayList inputs = new ArrayList();
        inputs.addAll(interfaceList.getInputVars());
        inputs.addAll(interfaceList.getInOutVars());
        ArrayList outputs = new ArrayList();
        inputs.addAll(interfaceList.getOutputVars());
        inputs.addAll(interfaceList.getOutMappedInOutVars());
        for (VarDeclaration input : inputs) {
            if (!input.getInputConnections().isEmpty() || !AbstractUpdateFBNElementCommand.hasValue(input.getValue()) && (input.getAttributes().isEmpty() || !AbstractUpdateFBNElementCommand.varDeclHasNonInternalAttr(input))) continue;
            AbstractUpdateFBNElementCommand.updateSelectedInterface((IInterfaceElement)input, this.newElement);
        }
        for (VarDeclaration output : outputs) {
            if (!output.getOutputConnections().isEmpty() || !AbstractUpdateFBNElementCommand.hasValue(output.getValue()) && (output.getAttributes().isEmpty() || !AbstractUpdateFBNElementCommand.varDeclHasNonInternalAttr(output))) continue;
            AbstractUpdateFBNElementCommand.updateSelectedInterface((IInterfaceElement)output, this.newElement);
        }
    }

    private static boolean varDeclHasNonInternalAttr(VarDeclaration vd) {
        return !vd.getAttributes().stream().filter(attr -> !InternalAttributeDeclarations.isInternalAttribute((Attribute)attr)).toList().isEmpty();
    }

    private void checkErrorMarkerPinParameters() {
        for (ErrorMarkerInterface erroMarker : this.oldElement.getInterface().getErrorMarker()) {
            if (!AbstractUpdateFBNElementCommand.hasValue(erroMarker.getValue())) continue;
            IInterfaceElement iInterfaceElement = this.newElement.getInterfaceElement(erroMarker.getName());
            if (iInterfaceElement instanceof VarDeclaration) {
                VarDeclaration varDeclaration = (VarDeclaration)iInterfaceElement;
                Value value = LibraryElementFactory.eINSTANCE.createValue();
                value.setValue(erroMarker.getValue().getValue());
                varDeclaration.setValue(value);
                if (!erroMarker.isIsInput() || !erroMarker.getInputConnections().isEmpty()) continue;
                this.reconnCmds.add((Command)new DeleteErrorMarkerCommand(erroMarker, this.oldElement));
                continue;
            }
            if ((!erroMarker.isIsInput() || !erroMarker.getInputConnections().isEmpty()) && (erroMarker.isIsInput() || !erroMarker.getOutputConnections().isEmpty())) continue;
            AbstractUpdateFBNElementCommand.updateSelectedInterface((IInterfaceElement)erroMarker, this.newElement);
        }
    }

    private static boolean hasValue(Value value) {
        return value != null && value.getValue() != null && !value.getValue().isBlank();
    }

    private void copyErrorMarkerRef() {
        FBNetworkElement repairedElement = ((ErrorMarkerFBNElement)this.oldElement).getRepairedElement();
        if (repairedElement != null) {
            ((ErrorMarkerFBNElement)this.newElement).setRepairedElement(repairedElement);
        }
    }

    private static ErrorMarkerInterface createMissingMarker(IInterfaceElement oldInterface, FBNetworkElement element) {
        VarDeclaration oldVarDecl;
        ErrorMarkerInterface interfaceElement = FordiacErrorMarkerInterfaceHelper.createErrorMarkerInterface((DataType)oldInterface.getType(), (String)oldInterface.getName(), (boolean)oldInterface.isIsInput(), (InterfaceList)element.getInterface());
        if (oldInterface instanceof VarDeclaration && (oldVarDecl = (VarDeclaration)oldInterface).getValue() != null && !oldVarDecl.getValue().getValue().isBlank()) {
            Value value = LibraryElementFactory.eINSTANCE.createValue();
            value.setValue(oldVarDecl.getValue().getValue());
            interfaceElement.setValue(value);
        }
        for (Attribute attribute : oldInterface.getAttributes()) {
            if (InternalAttributeDeclarations.isInternalAttribute((Attribute)attribute)) continue;
            interfaceElement.setAttribute(attribute.getName(), attribute.getType(), attribute.getValue(), attribute.getComment());
        }
        interfaceElement.setComment(oldInterface.getComment());
        return interfaceElement;
    }

    private static IInterfaceElement updateSelectedInterface(IInterfaceElement oldInterface, FBNetworkElement newElement) {
        IInterfaceElement updatedSelected;
        IInterfaceElement iInterfaceElement = updatedSelected = oldInterface.isIsInput() ? newElement.getInput(oldInterface.getName()) : newElement.getOutput(oldInterface.getName());
        if (updatedSelected == null || updatedSelected.isIsInput() != oldInterface.isIsInput()) {
            updatedSelected = AbstractUpdateFBNElementCommand.createMissingMarker(oldInterface, newElement);
        }
        return updatedSelected;
    }

    protected void handleConnections() {
        AbstractUpdateFBNElementCommand.getAllConnections(this.oldElement).forEach(this::handleConnection);
    }

    private void handleConnection(Connection connection) {
        IInterfaceElement source = connection.getSource();
        IInterfaceElement destination = connection.getDestination();
        if (connection.getSourceElement() == this.oldElement) {
            source = AbstractUpdateFBNElementCommand.updateSelectedInterface(source, this.newElement);
        }
        if (connection.getDestinationElement() == this.oldElement) {
            destination = AbstractUpdateFBNElementCommand.updateSelectedInterface(destination, this.newElement);
        }
        this.replaceConnection(connection, source, destination);
    }

    protected void replaceConnection(Connection oldConn, IInterfaceElement source, IInterfaceElement dest) {
        if (!this.isConnectionInList(oldConn)) {
            this.reconnCmds.add((Command)new DeleteConnectionCommand(oldConn, true));
        }
        if (!this.isConnectionToBeCreated(source, dest)) {
            FBNetwork fbn = oldConn.getFBNetwork();
            AbstractConnectionCreateCommand cmd = this.createConnectionCreateCommand(fbn, source.getType());
            cmd.setSource(source);
            cmd.setDestination(dest);
            cmd.setVisible(oldConn.isVisible());
            cmd.setArrangementConstraints(oldConn.getRoutingData());
            cmd.setElementIndex(fbn.getConnectionIndex(oldConn));
            this.reconnCmds.add((Command)cmd);
        }
    }

    protected boolean isConnectionInList(Connection conn) {
        for (Object cmd : this.reconnCmds.getCommands()) {
            DeleteConnectionCommand deleteConnectionCommand;
            if (!(cmd instanceof DeleteConnectionCommand) || !(deleteConnectionCommand = (DeleteConnectionCommand)cmd).getConnection().equals(conn)) continue;
            return true;
        }
        return false;
    }

    protected boolean isConnectionToBeCreated(IInterfaceElement source, IInterfaceElement dest) {
        for (Object cmd : this.reconnCmds.getCommands()) {
            AbstractConnectionCreateCommand abstractConnectionCreateCommand;
            if (!(cmd instanceof AbstractConnectionCreateCommand) || (abstractConnectionCreateCommand = (AbstractConnectionCreateCommand)cmd).getSource() != source || abstractConnectionCreateCommand.getDestination() != dest) continue;
            return true;
        }
        return false;
    }

    protected AbstractConnectionCreateCommand createConnectionCreateCommand(FBNetwork fbn, DataType type) {
        if (type instanceof EventType) {
            return new EventConnectionCreateCommand(fbn);
        }
        if (type instanceof AdapterType) {
            return new AdapterConnectionCreateCommand(fbn);
        }
        return new DataConnectionCreateCommand(fbn);
    }

    protected void createNewFB() {
        this.newElement = this.createCopiedFBEntry(this.oldElement);
        this.setInterface();
        this.handleConfigurableFB();
        this.newElement.setName(this.oldElement.getName());
        this.newElement.setPosition((Position)EcoreUtil.copy((EObject)this.oldElement.getPosition()));
        this.copyAttributes();
        this.createValues();
        this.transferInstanceComments();
    }

    private void copyAttributes() {
        this.newElement.getAttributes().addAll(EcoreUtil.copyAll((Collection)this.oldElement.getAttributes()));
        this.oldElement.getInterface().getAllInterfaceElements().stream().filter(ie -> !ie.getAttributes().isEmpty()).forEach(ie -> {
            IInterfaceElement newIE = this.newElement.getInterfaceElement(ie.getName());
            if (newIE != null) {
                newIE.getAttributes().addAll(EcoreUtil.copyAll((Collection)ie.getAttributes()));
            }
        });
    }

    protected abstract FBNetworkElement createCopiedFBEntry(FBNetworkElement var1);

    public FBNetworkElement getOldElement() {
        return this.oldElement;
    }

    public FBNetworkElement getNewElement() {
        return this.newElement;
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        return Set.of(this.network);
    }

    protected static class ConnData {
        private final IInterfaceElement source;
        private final IInterfaceElement dest;

        public ConnData(IInterfaceElement source, IInterfaceElement dest) {
            this.source = source;
            this.dest = dest;
        }
    }
}

