/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.Subrange;
import org.eclipse.fordiac.ide.model.eval.value.AnyDerivedValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.ArrayVariable;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;

public final class ArrayValue
implements AnyDerivedValue,
Iterable<Value> {
    private static final int COLLAPSE_ELEMENTS_SIZE = 100;
    private final ArrayType type;
    private final DataType elementType;
    private final int start;
    private final int end;
    private final List<Variable<?>> elements;

    public ArrayValue(ArrayType type) {
        this.type = ArrayValue.checkType(type);
        this.elementType = ArrayValue.getElementType(type);
        this.start = ((Subrange)type.getSubranges().get(0)).getLowerLimit();
        this.end = ((Subrange)type.getSubranges().get(0)).getUpperLimit();
        this.elements = IntStream.rangeClosed(this.start, this.end).mapToObj(this::initializeElement).toList();
    }

    public ArrayValue(ArrayType type, List<?> values) {
        this.type = ArrayValue.checkType(type);
        this.elementType = ArrayValue.getElementType(type);
        this.start = ((Subrange)type.getSubranges().get(0)).getLowerLimit();
        this.end = ((Subrange)type.getSubranges().get(0)).getUpperLimit();
        this.elements = IntStream.rangeClosed(this.start, this.end).mapToObj(index -> this.initializeElement(index, values)).toList();
    }

    public ArrayValue(ArrayValue value) {
        this.type = value.getType();
        this.elementType = value.getElementType();
        this.start = value.getStart();
        this.end = value.getEnd();
        this.elements = value.getElements().stream().map(VariableOperations::newVariable).toList();
    }

    protected static ArrayType checkType(ArrayType type) {
        if (type.getSubranges().isEmpty() || type.getSubranges().stream().anyMatch(subrange -> !subrange.isSetLowerLimit() || !subrange.isSetUpperLimit())) {
            throw new IllegalArgumentException("Cannot instantiate array value with unknown bounds");
        }
        return type;
    }

    protected static DataType getElementType(ArrayType type) {
        if (type.getSubranges().size() > 1) {
            return ArrayVariable.newArrayType(type.getBaseType(), type.getSubranges().stream().skip(1L).map(EcoreUtil::copy).toList());
        }
        return type.getBaseType();
    }

    protected Variable<?> initializeElement(int index) {
        return VariableOperations.newVariable(Integer.toString(index), (INamedElement)this.elementType);
    }

    protected Variable<?> initializeElement(int index, Object value) {
        return VariableOperations.newVariable(Integer.toString(index), (INamedElement)this.elementType, ValueOperations.wrapValue(value, (INamedElement)this.elementType));
    }

    protected Variable<?> initializeElement(int index, List<?> values) {
        return index - this.start < values.size() ? this.initializeElement(index, values.get(index - this.start)) : this.initializeElement(index);
    }

    public Variable<?> get(int index) {
        return this.elements.get(index - this.start);
    }

    public List<Variable<?>> subList(int fromIndex, int toIndex) {
        return this.elements.subList(fromIndex - this.start, toIndex - this.start);
    }

    public Variable<?> get(List<Integer> indices) {
        if (indices.size() > 1) {
            return ((ArrayVariable)this.get(indices.get(0))).getValue().get(indices.subList(1, indices.size()));
        }
        return this.get(indices.get(0));
    }

    public Variable<?> getRaw(int index) {
        return this.elements.get(index);
    }

    public int hashCode() {
        return this.elements.stream().map(Variable::getValue).mapToInt(Objects::hashCode).sum();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ArrayValue other = (ArrayValue)obj;
        return this.start == other.start && this.end == other.end && IntStream.rangeClosed(this.start, this.end).allMatch(index -> Objects.equals(this.get(index).getValue(), other.get(index).getValue()));
    }

    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean pretty) {
        if (this.elements.size() > this.getCollapseElementsSize()) {
            return this.toCollapsedString(pretty);
        }
        return this.elements.stream().map(element -> element.toString(pretty)).collect(Collectors.joining(pretty ? ", " : ",", "[", "]"));
    }

    public String toCollapsedString() {
        return this.toCollapsedString(true);
    }

    public String toCollapsedString(boolean pretty) {
        StringJoiner result = new StringJoiner(pretty ? ", " : ",", "[", "]");
        int count = 0;
        Value lastValue = null;
        for (Variable<?> element : this.elements) {
            if (lastValue != null && !Objects.equals(lastValue, element.getValue())) {
                result.add(ArrayValue.toElementString(lastValue, count, pretty));
                count = 0;
            }
            lastValue = (Value)element.getValue();
            ++count;
        }
        if (lastValue != null) {
            result.add(ArrayValue.toElementString(lastValue, count, pretty));
        }
        return result.toString();
    }

    protected static CharSequence toElementString(Value value, int count, boolean pretty) {
        if (count > 1) {
            StringBuilder builder = new StringBuilder();
            builder.append(count);
            builder.append("(");
            builder.append(value.toString(pretty));
            builder.append(")");
            return builder;
        }
        return value.toString(pretty);
    }

    public int getCollapseElementsSize() {
        return 100;
    }

    @Override
    public Iterator<Value> iterator() {
        return this.elements.stream().map(Variable::getValue).iterator();
    }

    public ArrayType getType() {
        return this.type;
    }

    public DataType getElementType() {
        return this.elementType;
    }

    public List<Variable<?>> getElements() {
        return this.elements;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int size() {
        return this.elements.size();
    }
}

