/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.nodes;

import com.google.common.collect.Lists;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.eclipse.milo.opcua.sdk.client.AddressSpace;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.core.QualifiedProperty;
import org.eclipse.milo.opcua.sdk.core.nodes.Node;
import org.eclipse.milo.opcua.sdk.core.util.StreamUtil;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.UaEnumeration;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UShort;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseDirection;
import org.eclipse.milo.opcua.stack.core.types.enumerated.BrowseResultMask;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePath;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowsePathResult;
import org.eclipse.milo.opcua.stack.core.types.structured.BrowseResult;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.ReferenceDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePath;
import org.eclipse.milo.opcua.stack.core.types.structured.RelativePathElement;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.WriteValue;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;

public abstract class UaNode
implements Node {
    private NodeId nodeId;
    private NodeClass nodeClass;
    private QualifiedName browseName;
    private LocalizedText displayName;
    private LocalizedText description;
    private UInteger writeMask;
    private UInteger userWriteMask;
    protected final OpcUaClient client;

    public UaNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask) {
        this.client = client;
        this.nodeId = nodeId;
        this.nodeClass = nodeClass;
        this.browseName = browseName;
        this.displayName = displayName;
        this.description = description;
        this.writeMask = writeMask;
        this.userWriteMask = userWriteMask;
    }

    public synchronized NodeId getNodeId() {
        return this.nodeId;
    }

    public synchronized NodeClass getNodeClass() {
        return this.nodeClass;
    }

    public synchronized QualifiedName getBrowseName() {
        return this.browseName;
    }

    public synchronized LocalizedText getDisplayName() {
        return this.displayName;
    }

    public synchronized LocalizedText getDescription() {
        return this.description;
    }

    public synchronized UInteger getWriteMask() {
        return this.writeMask;
    }

    public synchronized UInteger getUserWriteMask() {
        return this.userWriteMask;
    }

    public synchronized void setNodeId(NodeId nodeId) {
        this.nodeId = nodeId;
    }

    public synchronized void setNodeClass(NodeClass nodeClass) {
        this.nodeClass = nodeClass;
    }

    public synchronized void setBrowseName(QualifiedName browseName) {
        this.browseName = browseName;
    }

    public synchronized void setDisplayName(LocalizedText displayName) {
        this.displayName = displayName;
    }

    public synchronized void setDescription(LocalizedText description) {
        this.description = description;
    }

    public synchronized void setWriteMask(UInteger writeMask) {
        this.writeMask = writeMask;
    }

    public synchronized void setUserWriteMask(UInteger userWriteMask) {
        this.userWriteMask = userWriteMask;
    }

    public NodeId readNodeId() throws UaException {
        DataValue value = this.readAttribute(AttributeId.NodeId);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read NodeId failed");
        }
        NodeId nodeId = (NodeId)value.getValue().getValue();
        this.setNodeId(nodeId);
        return nodeId;
    }

    public NodeClass readNodeClass() throws UaException {
        DataValue value = this.readAttribute(AttributeId.NodeClass);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read NodeClass failed");
        }
        Integer i = (Integer)value.getValue().getValue();
        NodeClass nodeClass = NodeClass.from((int)i);
        this.setNodeClass(nodeClass);
        return nodeClass;
    }

    public QualifiedName readBrowseName() throws UaException {
        DataValue value = this.readAttribute(AttributeId.BrowseName);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read BrowseName failed");
        }
        QualifiedName browseName = (QualifiedName)value.getValue().getValue();
        this.setBrowseName(browseName);
        return browseName;
    }

    public LocalizedText readDisplayName() throws UaException {
        DataValue value = this.readAttribute(AttributeId.DisplayName);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read DisplayName failed");
        }
        LocalizedText displayName = (LocalizedText)value.getValue().getValue();
        this.setDisplayName(displayName);
        return displayName;
    }

    public LocalizedText readDescription() throws UaException {
        DataValue value = this.readAttribute(AttributeId.Description);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read Description failed");
        }
        LocalizedText description = (LocalizedText)value.getValue().getValue();
        this.setDescription(description);
        return description;
    }

    public UInteger readWriteMask() throws UaException {
        DataValue value = this.readAttribute(AttributeId.UserWriteMask);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read WriteMask failed");
        }
        UInteger writeMask = (UInteger)value.getValue().getValue();
        this.setWriteMask(writeMask);
        return writeMask;
    }

    public UInteger readUserWriteMask() throws UaException {
        DataValue value = this.readAttribute(AttributeId.UserWriteMask);
        StatusCode statusCode = value.getStatusCode();
        if (statusCode != null && statusCode.isBad()) {
            throw new UaException(statusCode, "read UserWriteMask failed");
        }
        UInteger userWriteMask = (UInteger)value.getValue().getValue();
        this.setUserWriteMask(userWriteMask);
        return userWriteMask;
    }

    public void writeNodeId(NodeId nodeId) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)nodeId));
        StatusCode statusCode = this.writeAttribute(AttributeId.NodeId, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write NodeId failed");
        }
        this.setNodeId(nodeId);
    }

    public void writeNodeClass(NodeClass nodeClass) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)nodeClass));
        StatusCode statusCode = this.writeAttribute(AttributeId.NodeClass, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write NodeClass failed");
        }
        this.setNodeClass(nodeClass);
    }

    public void writeBrowseName(QualifiedName browseName) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)browseName));
        StatusCode statusCode = this.writeAttribute(AttributeId.BrowseName, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write BrowseName failed");
        }
        this.setBrowseName(browseName);
    }

    public void writeDisplayName(LocalizedText displayName) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)displayName));
        StatusCode statusCode = this.writeAttribute(AttributeId.DisplayName, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write DisplayName failed");
        }
        this.setDisplayName(displayName);
    }

    public void writeDescription(LocalizedText description) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)description));
        StatusCode statusCode = this.writeAttribute(AttributeId.Description, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write Description failed");
        }
        this.setDescription(description);
    }

    public void writeWriteMask(UInteger writeMask) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)writeMask));
        StatusCode statusCode = this.writeAttribute(AttributeId.WriteMask, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write WriteMask failed");
        }
        this.setWriteMask(writeMask);
    }

    public void writeUserWriteMask(UInteger userWriteMask) throws UaException {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)userWriteMask));
        StatusCode statusCode = this.writeAttribute(AttributeId.UserWriteMask, value);
        if (statusCode != null && !statusCode.isGood()) {
            throw new UaException(statusCode, "write UserWriteMask failed");
        }
        this.setUserWriteMask(userWriteMask);
    }

    public DataValue readAttribute(AttributeId attributeId) throws UaException {
        try {
            return this.readAttributeAsync(attributeId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public StatusCode writeAttribute(AttributeId attributeId, DataValue value) throws UaException {
        try {
            return this.writeAttributeAsync(attributeId, value).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<DataValue> readAttributeAsync(AttributeId attributeId) {
        ReadValueId readValueId = new ReadValueId(this.getNodeId(), attributeId.uid(), null, QualifiedName.NULL_VALUE);
        CompletableFuture<ReadResponse> future = this.client.read(0.0, TimestampsToReturn.Both, Lists.newArrayList((Object[])new ReadValueId[]{readValueId}));
        return future.thenApply(response -> response.getResults()[0]);
    }

    public CompletableFuture<StatusCode> writeAttributeAsync(AttributeId attributeId, DataValue value) {
        WriteValue writeValue = new WriteValue(this.getNodeId(), attributeId.uid(), null, value);
        CompletableFuture<WriteResponse> future = this.client.write(Lists.newArrayList((Object[])new WriteValue[]{writeValue}));
        return future.thenApply(response -> response.getResults()[0]);
    }

    public List<ReferenceDescription> browse() throws UaException {
        return this.browse(this.client.getAddressSpace().getBrowseOptions());
    }

    public List<ReferenceDescription> browse(AddressSpace.BrowseOptions browseOptions) throws UaException {
        return this.client.getAddressSpace().browse(this, browseOptions);
    }

    public CompletableFuture<List<ReferenceDescription>> browseAsync() {
        return this.browseAsync(this.client.getAddressSpace().getBrowseOptions());
    }

    public CompletableFuture<List<ReferenceDescription>> browseAsync(AddressSpace.BrowseOptions browseOptions) {
        return this.client.getAddressSpace().browseAsync(this, browseOptions);
    }

    public List<? extends UaNode> browseNodes() throws UaException {
        return this.browseNodes(this.client.getAddressSpace().getBrowseOptions());
    }

    public List<? extends UaNode> browseNodes(AddressSpace.BrowseOptions browseOptions) throws UaException {
        return this.client.getAddressSpace().browseNodes(this, browseOptions);
    }

    public CompletableFuture<List<? extends UaNode>> browseNodesAsync() {
        return this.browseNodesAsync(this.client.getAddressSpace().getBrowseOptions());
    }

    public CompletableFuture<List<? extends UaNode>> browseNodesAsync(AddressSpace.BrowseOptions browseOptions) {
        return this.client.getAddressSpace().browseNodesAsync(this, browseOptions);
    }

    public List<DataValue> refresh(Set<AttributeId> attributeIds) throws UaException {
        try {
            return this.refreshAsync(attributeIds).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<List<DataValue>> refreshAsync(Set<AttributeId> attributeIds) {
        List<ReadValueId> readValueIds = attributeIds.stream().map(id -> new ReadValueId(this.nodeId, id.uid(), null, QualifiedName.NULL_VALUE)).collect(Collectors.toList());
        CompletableFuture<ReadResponse> future = this.client.read(0.0, TimestampsToReturn.Neither, readValueIds);
        return future.thenApply(response -> {
            Object[] values = response.getResults();
            assert (attributeIds.size() == values.length);
            Iterator ai = attributeIds.iterator();
            Iterator vi = Arrays.stream(values).iterator();
            UaNode uaNode = this;
            synchronized (uaNode) {
                if (ai.hasNext() && vi.hasNext()) {
                    AttributeId attributeId = (AttributeId)ai.next();
                    DataValue value = (DataValue)vi.next();
                    StatusCode statusCode = value.getStatusCode();
                    if (statusCode == null || statusCode.isGood()) {
                        this.setAttributeValue(attributeId, value);
                    }
                }
            }
            return Lists.newArrayList((Object[])values);
        });
    }

    public List<StatusCode> synchronize(Set<AttributeId> attributeIds) throws UaException {
        try {
            return this.synchronizeAsync(attributeIds).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<List<StatusCode>> synchronizeAsync(Set<AttributeId> attributeIds) {
        List<WriteValue> writeValues;
        UaNode uaNode = this;
        synchronized (uaNode) {
            writeValues = attributeIds.stream().map(id -> new WriteValue(this.nodeId, id.uid(), null, this.getAttributeValue((AttributeId)id))).collect(Collectors.toList());
        }
        return this.client.write(writeValues).thenApply(response -> {
            Object[] results = response.getResults();
            return Lists.newArrayList((Object[])results);
        });
    }

    public UaNode canonicalize() {
        return this.client.getAddressSpace().getNodeCache().canonicalize(this);
    }

    public UaNode invalidate() {
        this.client.getAddressSpace().getNodeCache().invalidate(this.nodeId);
        return this;
    }

    protected DataValue getAttributeValue(AttributeId attributeId) {
        switch (attributeId) {
            case NodeId: {
                return DataValue.valueOnly((Variant)new Variant((Object)this.getNodeId()));
            }
            case NodeClass: {
                return DataValue.valueOnly((Variant)new Variant((Object)this.getNodeClass().getValue()));
            }
            case BrowseName: {
                return DataValue.valueOnly((Variant)new Variant((Object)this.getBrowseName()));
            }
            case DisplayName: {
                return DataValue.valueOnly((Variant)new Variant((Object)this.getDisplayName()));
            }
            case Description: {
                return DataValue.valueOnly((Variant)new Variant((Object)this.getDescription()));
            }
            case WriteMask: {
                return DataValue.valueOnly((Variant)new Variant((Object)this.getWriteMask()));
            }
            case UserWriteMask: {
                return DataValue.valueOnly((Variant)new Variant((Object)this.getUserWriteMask()));
            }
        }
        throw new IllegalArgumentException("attributeId: " + attributeId);
    }

    protected void setAttributeValue(AttributeId attributeId, DataValue value) {
        switch (attributeId) {
            case NodeId: {
                this.setNodeId((NodeId)value.getValue().getValue());
                break;
            }
            case NodeClass: {
                Integer i = (Integer)value.getValue().getValue();
                NodeClass nodeClass = NodeClass.from((int)i);
                this.setNodeClass(nodeClass);
                break;
            }
            case BrowseName: {
                this.setBrowseName((QualifiedName)value.getValue().getValue());
                break;
            }
            case DisplayName: {
                this.setDisplayName((LocalizedText)value.getValue().getValue());
                break;
            }
            case Description: {
                this.setDescription((LocalizedText)value.getValue().getValue());
                break;
            }
            case WriteMask: {
                this.setWriteMask((UInteger)value.getValue().getValue());
                break;
            }
            case UserWriteMask: {
                this.setUserWriteMask((UInteger)value.getValue().getValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("attributeId: " + attributeId);
            }
        }
    }

    protected CompletableFuture<UaNode> getMemberNodeAsync(String namespaceUri, String name, ExpandedNodeId referenceTypeId, boolean includeSubtypes) {
        return this.readNamespaceIndex(namespaceUri).thenCompose(index -> {
            QualifiedName qualifiedName = new QualifiedName(index, name);
            return this.findMemberNodeId(qualifiedName, referenceTypeId, includeSubtypes).thenCompose(nodeXni -> {
                AddressSpace addressSpace = this.client.getAddressSpace();
                return ((CompletableFuture)addressSpace.toNodeIdAsync((ExpandedNodeId)nodeXni).thenCompose(addressSpace::getNodeAsync)).thenApply(UaNode.class::cast);
            });
        });
    }

    protected CompletableFuture<ExpandedNodeId> findMemberNodeId(QualifiedName name, ExpandedNodeId referenceTypeId, boolean includeSubtypes) {
        ArrayList<BrowsePath> browsePaths = new ArrayList<BrowsePath>();
        try {
            browsePaths.add(new BrowsePath(this.getNodeId(), new RelativePath(new RelativePathElement[]{new RelativePathElement(referenceTypeId.toNodeIdOrThrow(this.client.getNamespaceTable()), Boolean.valueOf(false), Boolean.valueOf(includeSubtypes), name)})));
        }
        catch (Exception e) {
            return FutureUtils.failedFuture((Throwable)e);
        }
        return this.client.translateBrowsePaths(browsePaths).thenCompose(r -> {
            BrowsePathResult result = r.getResults()[0];
            if (result.getStatusCode().isGood()) {
                return CompletableFuture.completedFuture(result.getTargets()[0].getTargetId());
            }
            return FutureUtils.failedUaFuture((StatusCode)result.getStatusCode());
        });
    }

    protected CompletableFuture<UShort> readNamespaceIndex(String namespaceUri) {
        UShort namespaceIndex = this.client.getNamespaceTable().getIndex(namespaceUri);
        if (namespaceIndex != null) {
            return CompletableFuture.completedFuture(namespaceIndex);
        }
        return this.client.readNamespaceTableAsync().thenCompose(namespaceTable -> {
            UShort index = this.client.getNamespaceTable().getIndex(namespaceUri);
            if (index != null) {
                return CompletableFuture.completedFuture(index);
            }
            return FutureUtils.failedFuture((Throwable)new Exception("unknown namespace: " + namespaceUri));
        });
    }

    protected CompletableFuture<? extends UaNode> getComponentAsync(QualifiedName browseName, NodeClass nodeClass) {
        UInteger nodeClassMask = Unsigned.uint((int)nodeClass.getValue());
        UInteger resultMask = Unsigned.uint((int)BrowseResultMask.All.getValue());
        CompletableFuture<BrowseResult> future = this.client.browse(new BrowseDescription(this.getNodeId(), BrowseDirection.Forward, Identifiers.HasComponent, Boolean.valueOf(false), nodeClassMask, resultMask));
        return future.thenCompose(result -> {
            List references = ConversionUtil.l((Object[])result.getReferences());
            Optional node = references.stream().filter(r -> browseName.equals((Object)r.getBrowseName())).flatMap(r -> {
                Optional<CompletableFuture> opt = r.getNodeId().toNodeId(this.client.getNamespaceTable()).map(id -> this.client.getAddressSpace().getNodeAsync((NodeId)id));
                return StreamUtil.opt2stream(opt);
            }).findFirst();
            return node.orElse(FutureUtils.failedUaFuture((long)2151546880L));
        });
    }

    protected CompletableFuture<PropertyTypeNode> getPropertyNodeAsync(QualifiedProperty<?> property) {
        return property.getQualifiedName(this.client.getNamespaceTable()).map(this::getPropertyNodeAsync).orElse(FutureUtils.failedUaFuture((long)2151546880L));
    }

    protected CompletableFuture<PropertyTypeNode> getPropertyNodeAsync(QualifiedName browseName) {
        UInteger nodeClassMask = Unsigned.uint((int)NodeClass.Variable.getValue());
        UInteger resultMask = Unsigned.uint((int)BrowseResultMask.BrowseName.getValue());
        CompletableFuture<BrowseResult> future = this.client.browse(new BrowseDescription(this.getNodeId(), BrowseDirection.Forward, Identifiers.HasProperty, Boolean.valueOf(false), nodeClassMask, resultMask));
        return future.thenCompose(result -> {
            List references = ConversionUtil.l((Object[])result.getReferences());
            Optional node = references.stream().filter(r -> browseName.equals((Object)r.getBrowseName())).flatMap(r -> {
                Optional<CompletableFuture> opt = r.getNodeId().toNodeId(this.client.getNamespaceTable()).map(id -> this.client.getAddressSpace().getNodeAsync((NodeId)id).thenApply(n -> (PropertyTypeNode)n));
                return StreamUtil.opt2stream(opt);
            }).findFirst();
            return node.orElse(FutureUtils.failedUaFuture((long)2151546880L));
        });
    }

    public <T> CompletableFuture<T> getProperty(QualifiedProperty<T> property) {
        return ((CompletableFuture)this.getPropertyNodeAsync(property).thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(value -> this.cast(value.getValue().getValue(), property.getJavaType()));
    }

    protected <T> CompletableFuture<StatusCode> setProperty(QualifiedProperty<T> property, T value) {
        return this.getPropertyNodeAsync(property).thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, DataValue.valueOnly((Variant)new Variant(value))));
    }

    protected CompletableFuture<DataValue> readProperty(QualifiedProperty<?> property) {
        return this.getPropertyNodeAsync(property).thenCompose(node -> node.readAttributeAsync(AttributeId.Value));
    }

    protected CompletableFuture<StatusCode> writeProperty(QualifiedProperty<?> property, DataValue value) {
        return this.getPropertyNodeAsync(property).thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    protected <T> T cast(Object o, Class<T> clazz) {
        if (UaEnumeration.class.isAssignableFrom(clazz) && o instanceof Integer) {
            try {
                Object enumeration = clazz.getMethod("from", Integer.class).invoke(null, o);
                return clazz.cast(enumeration);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
        }
        if (o instanceof ExtensionObject) {
            ExtensionObject xo = (ExtensionObject)o;
            Object decoded = xo.decode(this.client.getStaticSerializationContext());
            return clazz.cast(decoded);
        }
        if (o instanceof ExtensionObject[]) {
            ExtensionObject[] xos = (ExtensionObject[])o;
            Class<?> componentType = clazz.getComponentType();
            Object array = Array.newInstance(componentType, xos.length);
            for (int i = 0; i < xos.length; ++i) {
                ExtensionObject xo = xos[i];
                Object decoded = xo.decode(this.client.getStaticSerializationContext());
                Array.set(array, i, componentType.cast(decoded));
            }
            return clazz.cast(array);
        }
        return clazz.cast(o);
    }
}

