/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.match.impl;

import org.eclipse.emf.compare.match.DefaultComparisonFactory;
import org.eclipse.emf.compare.match.DefaultEqualityHelperFactory;
import org.eclipse.emf.compare.match.DefaultMatchEngine;
import org.eclipse.emf.compare.match.IComparisonFactory;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.eobject.EqualityHelperExtensionProvider;
import org.eclipse.emf.compare.match.eobject.EqualityHelperExtensionProviderDescriptorRegistryImpl;
import org.eclipse.emf.compare.match.eobject.IEObjectMatcher;
import org.eclipse.emf.compare.match.eobject.WeightProvider;
import org.eclipse.emf.compare.match.eobject.WeightProviderDescriptorRegistryImpl;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.emf.compare.utils.UseIdentifiers;

public class MatchEngineFactoryImpl
implements IMatchEngine.Factory {
    protected IMatchEngine matchEngine;
    private int ranking;
    private WeightProvider.Descriptor.Registry weightProviderRegistry;
    private EqualityHelperExtensionProvider.Descriptor.Registry equalityHelperExtensionProviderRegistry;
    private UseIdentifiers shouldUseIdentifiers;

    public MatchEngineFactoryImpl() {
        this(UseIdentifiers.WHEN_AVAILABLE, WeightProviderDescriptorRegistryImpl.createStandaloneInstance(), EqualityHelperExtensionProviderDescriptorRegistryImpl.createStandaloneInstance());
    }

    public MatchEngineFactoryImpl(UseIdentifiers useIDs) {
        this(useIDs, WeightProviderDescriptorRegistryImpl.createStandaloneInstance(), EqualityHelperExtensionProviderDescriptorRegistryImpl.createStandaloneInstance());
    }

    public MatchEngineFactoryImpl(UseIdentifiers useIDs, WeightProvider.Descriptor.Registry weightProviderRegistry) {
        this(useIDs, weightProviderRegistry, EqualityHelperExtensionProviderDescriptorRegistryImpl.createStandaloneInstance());
    }

    public MatchEngineFactoryImpl(UseIdentifiers useIDs, WeightProvider.Descriptor.Registry weightProviderRegistry, EqualityHelperExtensionProvider.Descriptor.Registry equalityHelperExtensionProviderRegistry) {
        this.shouldUseIdentifiers = useIDs;
        this.weightProviderRegistry = weightProviderRegistry;
        this.equalityHelperExtensionProviderRegistry = equalityHelperExtensionProviderRegistry;
    }

    @Deprecated
    public MatchEngineFactoryImpl(IEObjectMatcher matcher, IComparisonFactory comparisonFactory) {
        this.matchEngine = new DefaultMatchEngine(matcher, comparisonFactory);
    }

    @Override
    public IMatchEngine getMatchEngine() {
        if (this.matchEngine == null) {
            DefaultComparisonFactory comparisonFactory = new DefaultComparisonFactory(new DefaultEqualityHelperFactory());
            IEObjectMatcher matcher = DefaultMatchEngine.createDefaultEObjectMatcher(this.shouldUseIdentifiers, this.weightProviderRegistry, this.equalityHelperExtensionProviderRegistry);
            this.matchEngine = new DefaultMatchEngine(matcher, comparisonFactory);
        }
        return this.matchEngine;
    }

    @Override
    public int getRanking() {
        return this.ranking;
    }

    @Override
    public void setRanking(int r) {
        this.ranking = r;
    }

    @Override
    public boolean isMatchEngineFactoryFor(IComparisonScope scope) {
        return true;
    }

    void setWeightProviderRegistry(WeightProvider.Descriptor.Registry registry) {
        this.weightProviderRegistry = registry;
        if (this.shouldUseIdentifiers != null) {
            this.matchEngine = null;
        }
    }

    public void setEqualityHelperExtensionProviderRegistry(EqualityHelperExtensionProvider.Descriptor.Registry equalityHelperExtensionProviderRegistry) {
        this.equalityHelperExtensionProviderRegistry = equalityHelperExtensionProviderRegistry;
        if (this.shouldUseIdentifiers != null) {
            this.matchEngine = null;
        }
    }
}

