/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentLaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.deployment.debug.breakpoint.DeploymentWatchpoint;
import org.eclipse.fordiac.ide.deployment.debug.ui.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class DeploymentLaunchWatchesTab
extends AbstractLaunchConfigurationTab {
    public static final String ID = "org.eclipse.fordiac.ide.deployment.debug.ui.watchesTab";
    private AutomationSystem system;
    private List<DeploymentLaunchConfigurationAttributes.DeploymentLaunchWatchpoint> watches;
    private TableViewer watchesTable;
    private Button addButton;
    private Button removeButton;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(comp);
        this.setControl((Control)comp);
        Control watchesControl = this.createWatchesTable(comp);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(watchesControl);
        Control buttonsControl = this.createTableButtons(comp);
        GridDataFactory.fillDefaults().grab(false, true).applyTo(buttonsControl);
    }

    protected Control createWatchesTable(Composite parent) {
        this.watchesTable = new TableViewer(parent, 68354);
        this.watchesTable.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.watchesTable.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new WatchesLabelProvider()));
        this.watchesTable.addSelectionChangedListener(this::handleTableSelectionChanged);
        this.watchesTable.setComparator(new ViewerComparator());
        return this.watchesTable.getTable();
    }

    protected void handleTableSelectionChanged(SelectionChangedEvent event) {
        IStructuredSelection selection = event.getStructuredSelection();
        this.removeButton.setEnabled(!selection.isEmpty());
    }

    private Control createTableButtons(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.addButton = new Button(comp, 8);
        this.addButton.setText(Messages.DeploymentLaunchWatchesTab_AddButton);
        this.addButton.setEnabled(false);
        this.addButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleAddButtonSelected()));
        this.removeButton = new Button(comp, 8);
        this.removeButton.setText(Messages.DeploymentLaunchWatchesTab_RemoveButton);
        this.removeButton.setEnabled(false);
        this.removeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleRemoveButtonSelected()));
        GridLayoutFactory.swtDefaults().generateLayout(comp);
        return comp;
    }

    private void handleAddButtonSelected() {
        List<DeploymentWatchpoint> watchpoints = this.getWatchpoints();
        if (watchpoints.isEmpty()) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.DeploymentLaunchWatchesTab_AddDialogTitle, (String)Messages.DeploymentLaunchWatchesTab_AddDialogEmptyListMessage);
            return;
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)DebugUITools.newDebugModelPresentation());
        dialog.setTitle(Messages.DeploymentLaunchWatchesTab_AddDialogTitle);
        dialog.setMessage(Messages.DeploymentLaunchWatchesTab_AddDialogMessage);
        dialog.setEmptyListMessage(Messages.DeploymentLaunchWatchesTab_AddDialogEmptyListMessage);
        dialog.setEmptySelectionMessage(Messages.DeploymentLaunchWatchesTab_AddDialogEmptySelectionMessage);
        dialog.setStatusLineAboveButtons(true);
        dialog.setMultipleSelection(true);
        dialog.setElements(watchpoints.toArray());
        if (dialog.open() == 0) {
            Stream.of(dialog.getResult()).map(DeploymentWatchpoint.class::cast).map(DeploymentLaunchConfigurationAttributes.DeploymentLaunchWatchpoint::new).forEachOrdered(this.watches::add);
            this.watchesTable.refresh(false);
            this.updateLaunchConfigurationDialog();
        }
    }

    protected List<DeploymentWatchpoint> getWatchpoints() {
        return Stream.of(DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.fordiac.ide.deployment.debug.model")).filter(DeploymentWatchpoint.class::isInstance).map(DeploymentWatchpoint.class::cast).filter(this::isRelevant).sorted(Comparator.comparing(DeploymentWatchpoint::getLocation)).toList();
    }

    protected boolean isRelevant(DeploymentWatchpoint watchpoint) {
        if (watchpoint.isRelevant(this.system)) {
            if (this.watches.stream().map(DeploymentLaunchConfigurationAttributes.DeploymentLaunchWatchpoint::targetName).noneMatch(watchpoint.getLocation()::equalsIgnoreCase)) {
                return true;
            }
        }
        return false;
    }

    private void handleRemoveButtonSelected() {
        this.watches.removeAll(this.watchesTable.getStructuredSelection().toList());
        this.watchesTable.refresh(false);
        this.updateLaunchConfigurationDialog();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        DeploymentLaunchConfigurationAttributes.setWatches((ILaunchConfigurationWorkingCopy)configuration, null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.system = DeploymentLaunchConfigurationAttributes.getSystem((ILaunchConfiguration)configuration);
            this.watches = new ArrayList<DeploymentLaunchConfigurationAttributes.DeploymentLaunchWatchpoint>(DeploymentLaunchConfigurationAttributes.getWatches((ILaunchConfiguration)configuration));
            this.watchesTable.setInput(this.watches);
            this.addButton.setEnabled(this.system != null);
        }
        catch (CoreException e) {
            FordiacLogHelper.logWarning((String)e.getMessage(), (Exception)((Object)e));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        DeploymentLaunchConfigurationAttributes.setWatches((ILaunchConfigurationWorkingCopy)configuration, this.watches);
    }

    public String getName() {
        return Messages.DeploymentLaunchWatchesTab_Name;
    }

    public Image getImage() {
        return DebugUITools.getImage((String)"IMG_OBJS_WATCHPOINT");
    }

    public String getId() {
        return ID;
    }

    private class WatchesLabelProvider
    extends LabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        private static final StyledString.Styler ERROR_STYLER = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.strikeout = true;
            }
        };

        private WatchesLabelProvider() {
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof DeploymentLaunchConfigurationAttributes.DeploymentLaunchWatchpoint) {
                DeploymentLaunchConfigurationAttributes.DeploymentLaunchWatchpoint watchpoint = (DeploymentLaunchConfigurationAttributes.DeploymentLaunchWatchpoint)element;
                return new StyledString(watchpoint.targetName(), (StyledString.Styler)(DeploymentLaunchWatchesTab.this.system == null || watchpoint.getTarget(DeploymentLaunchWatchesTab.this.system).isEmpty() ? ERROR_STYLER : null));
            }
            return null;
        }

        public Image getImage(Object element) {
            if (element instanceof DeploymentLaunchConfigurationAttributes.DeploymentLaunchWatchpoint) {
                DeploymentLaunchConfigurationAttributes.DeploymentLaunchWatchpoint watchpoint = (DeploymentLaunchConfigurationAttributes.DeploymentLaunchWatchpoint)element;
                if (!watchpoint.forceValue().isEmpty()) {
                    return DebugUITools.getImage((String)"IMG_OBJS_MODIFICATION_WATCHPOINT");
                }
                return DebugUITools.getImage((String)"IMG_OBJS_ACCESS_WATCHPOINT");
            }
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_ELEMENTS");
        }
    }
}

