/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client;

import com.google.common.collect.Maps;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.nodes.UaVariableNode;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;

public class VariableTypeManager {
    private final ConcurrentMap<NodeId, VariableTypeDefinition> typeDefinitions = Maps.newConcurrentMap();

    public void registerVariableType(NodeId typeDefinition, Class<? extends UaVariableNode> nodeClass, VariableNodeConstructor variableNodeConstructor) {
        this.typeDefinitions.put(typeDefinition, new VariableTypeDefinition(nodeClass, variableNodeConstructor));
    }

    public Optional<VariableNodeConstructor> getNodeConstructor(NodeId typeDefinition) {
        VariableTypeDefinition def = (VariableTypeDefinition)this.typeDefinitions.get(typeDefinition);
        return Optional.ofNullable(def).map(d -> d.nodeFactory);
    }

    @FunctionalInterface
    public static interface VariableNodeConstructor {
        public UaVariableNode apply(OpcUaClient var1, NodeId var2, NodeClass var3, QualifiedName var4, LocalizedText var5, LocalizedText var6, UInteger var7, UInteger var8, DataValue var9, NodeId var10, Integer var11, UInteger[] var12, UByte var13, UByte var14, Double var15, Boolean var16);
    }

    private static class VariableTypeDefinition {
        final Class<? extends UaVariableNode> nodeClass;
        final VariableNodeConstructor nodeFactory;

        private VariableTypeDefinition(Class<? extends UaVariableNode> nodeClass, VariableNodeConstructor nodeFactory) {
            this.nodeClass = nodeClass;
            this.nodeFactory = nodeFactory;
        }
    }
}

