/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.comgeneration.implementation.mediagenerators;

import org.eclipse.fordiac.ide.comgeneration.implementation.CommunicationMediaInfo;
import org.eclipse.fordiac.ide.comgeneration.implementation.mediagenerators.AbstractMediaSpecificGenerator;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public class EthernetPubSubGenerator
extends AbstractMediaSpecificGenerator {
    public static final String PROTOCOL_ID = "EthernetPubSub";
    private static final String DEFAULT_HOST = "225.0.0.1";
    private static final int DEFAULT_START_PORT = 61550;
    private final String host;
    private int startPort = 61550;
    private int currentPort;

    public EthernetPubSubGenerator(TypeLibrary typeLib) {
        super(typeLib);
        this.host = DEFAULT_HOST;
        this.reset();
    }

    @Override
    public String getMediaType() {
        return "Ethernet";
    }

    @Override
    public String getProtocolId() {
        return PROTOCOL_ID;
    }

    @Override
    public void configureFBs(FB sourceFB, FB destinationFB, CommunicationMediaInfo mediaInfo) {
        VarDeclaration destinationId;
        VarDeclaration destinationQI;
        VarDeclaration sourceId;
        VarDeclaration sourceQI;
        if (mediaInfo.getSourceLink().getDevice().equals(mediaInfo.getDestinationLink().getDevice())) {
            sourceQI = null;
            sourceId = (VarDeclaration)sourceFB.getInterface().getInputVars().get(0);
            destinationQI = null;
            destinationId = (VarDeclaration)destinationFB.getInterface().getInputVars().get(0);
        } else {
            sourceQI = (VarDeclaration)sourceFB.getInterface().getInputVars().get(0);
            sourceId = (VarDeclaration)sourceFB.getInterface().getInputVars().get(1);
            destinationQI = (VarDeclaration)destinationFB.getInterface().getInputVars().get(0);
            destinationId = (VarDeclaration)destinationFB.getInterface().getInputVars().get(1);
        }
        String sourceValue = sourceId.getValue().getValue();
        if (sourceValue.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("\"");
            sb.append(this.host);
            sb.append(":");
            sb.append(this.currentPort);
            ++this.currentPort;
            sb.append("\"");
            sourceValue = sb.toString();
            sourceId.getValue().setValue(sourceValue);
            if (sourceQI != null) {
                sourceQI.getValue().setValue("1");
            }
        }
        destinationId.getValue().setValue(sourceValue);
        if (destinationQI != null) {
            destinationQI.getValue().setValue("1");
        }
    }

    @Override
    public void reset() {
        this.currentPort = this.startPort;
    }

    public void reset(int startPort) {
        this.startPort = startPort;
        this.reset();
    }

    @Override
    public boolean isSeparatedSource() {
        return false;
    }
}

