/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.select;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.datatools.modelbase.sql.query.Grouping;
import org.eclipse.datatools.modelbase.sql.query.GroupingExpression;
import org.eclipse.datatools.modelbase.sql.query.GroupingSets;
import org.eclipse.datatools.modelbase.sql.query.GroupingSetsElementExpression;
import org.eclipse.datatools.modelbase.sql.query.GroupingSetsElementSublist;
import org.eclipse.datatools.modelbase.sql.query.GroupingSpecification;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryValueExpression;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.SuperGroup;
import org.eclipse.datatools.modelbase.sql.query.SuperGroupElementExpression;
import org.eclipse.datatools.modelbase.sql.query.SuperGroupElementSublist;
import org.eclipse.datatools.modelbase.sql.query.SuperGroupType;
import org.eclipse.datatools.modelbase.sql.query.ValueExpressionColumn;
import org.eclipse.datatools.sqltools.sqlbuilder.Messages;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderDialog;
import org.eclipse.datatools.sqltools.sqlbuilder.expressionbuilder.ExpressionBuilderWizard;
import org.eclipse.datatools.sqltools.sqlbuilder.model.ExpressionHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLBuilderConstants;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.VendorHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.LabelValuePair;
import org.eclipse.datatools.sqltools.sqlbuilder.util.StringUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.BuilderUtility;
import org.eclipse.datatools.sqltools.sqlbuilder.views.EditComboBoxCellEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.views.GridContentProvider;
import org.eclipse.datatools.sqltools.sqlbuilder.views.GridViewer;
import org.eclipse.datatools.sqltools.sqlbuilder.views.ObjectListHelper;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.help.WorkbenchHelp;

public class GroupByContentViewer
extends ContentViewer {
    protected static final String P_NONE = Messages._UI_NONE;
    protected static final String P_SIMPLE = Messages._UI_SIMPLE;
    protected static final String P_CUBE = Messages._UI_CUBE;
    protected static final String P_ROLLUP = Messages._UI_ROLLUP;
    protected static final String P_GROUPING = Messages._UI_GROUPING;
    protected static final String P_GROUPINGSETS = Messages._UI_GROUPINGSETS;
    protected static final String P_GROUPINGROOT = Messages._UI_COMBOBOXITEM_GROUPING_ROOT;
    protected static final String P_GROUPINGEXPRESSIONLIST = "GroupExpressionList";
    SQLDomainModel sqlDomainModel;
    protected List groupByClause = null;
    protected SQLQueryObject selectStatement = null;
    Composite canvas;
    org.eclipse.swt.widgets.List groupByContentList;
    Combo typeCombo;
    ObjectListHelper groupByContentHelper;
    GroupExpressionListGridViewer expressionGrid;
    Object currentListSelection = null;
    String currentType = "";
    int indent = 0;

    public GroupByContentViewer(SQLDomainModel model) {
        this.sqlDomainModel = model;
        this.setContentProvider((IContentProvider)model.createContentProvider());
    }

    public void setInput(Object input) {
        if (input instanceof QuerySelectStatement || input instanceof QuerySelect) {
            this.selectStatement = (SQLQueryObject)input;
            this.setGroupByClause();
            this.refreshListBox();
            this.currentListSelection = this.groupByClause;
            this.groupByContentHelper.select(this.groupByClause);
            this.expressionGrid.setInput(this.groupByClause);
            this.updateTypeCombo();
        }
        super.setInput(input);
    }

    protected void setGroupByClause() {
        QuerySelect qSelect = null;
        if (this.selectStatement instanceof QuerySelectStatement) {
            QuerySelectStatement selectStmt = (QuerySelectStatement)this.selectStatement;
            qSelect = SelectHelper.getQuerySelect(selectStmt);
            if (qSelect == null) {
                SelectHelper.initSelectStmt(selectStmt);
                qSelect = SelectHelper.getQuerySelect(selectStmt);
            }
        } else if (this.selectStatement instanceof QuerySelect) {
            qSelect = (QuerySelect)this.selectStatement;
        }
        if (qSelect != null) {
            this.groupByClause = qSelect.getGroupByClause();
        }
    }

    public Vector getGroupByContentList() {
        Vector items = new Vector();
        for (Object item : this.groupByClause) {
            if (item instanceof GroupingExpression) continue;
            items.add(item);
            if (item instanceof GroupingSets) {
                this.getGroupingSetList((GroupingSets)item, items);
                continue;
            }
            if (!(item instanceof SuperGroup)) continue;
            this.getSuperGroupList((SuperGroup)item, items);
        }
        return items;
    }

    public Control getControl() {
        return this.canvas;
    }

    protected void getGroupingSetList(GroupingSets groupingSet, Vector items) {
        for (Object item : groupingSet.getGroupingSetsElementList()) {
            if (item instanceof GroupingSetsElementExpression) {
                if (!((item = ((GroupingSetsElementExpression)item).getGrouping()) instanceof SuperGroup)) continue;
                items.add(item);
                this.getSuperGroupList((SuperGroup)item, items);
                continue;
            }
            if (!(item instanceof GroupingSetsElementSublist)) continue;
            items.add(item);
            for (Object groupingItem : ((GroupingSetsElementSublist)item).getGroupingSetsElementExprList()) {
                if (groupingItem instanceof GroupingSetsElementExpression) {
                    if (!((groupingItem = ((GroupingSetsElementExpression)groupingItem).getGrouping()) instanceof SuperGroup)) continue;
                    items.add(groupingItem);
                    this.getSuperGroupList((SuperGroup)groupingItem, items);
                    continue;
                }
                if (!(groupingItem instanceof GroupingSetsElementSublist)) continue;
                items.add(groupingItem);
                this.getExpressionList((GroupingSetsElementSublist)groupingItem, items);
            }
        }
    }

    protected void getSuperGroupList(SuperGroup superGroup, Vector items) {
        for (Object item : superGroup.getSuperGroupElementList()) {
            if (!(item instanceof SuperGroupElementSublist)) continue;
            items.add(item);
            this.getSuperGroupExpressionList((SuperGroupElementSublist)item, items);
        }
    }

    protected void getExpressionList(GroupingSetsElementSublist expressionList, Vector items) {
        for (Object item : expressionList.getGroupingSetsElementExprList()) {
            if (!(item instanceof GroupingSetsElementSublist)) continue;
            items.add(item);
            this.getExpressionList((GroupingSetsElementSublist)item, items);
        }
    }

    protected void getSuperGroupExpressionList(SuperGroupElementSublist expressionList, Vector items) {
        for (Object item : expressionList.getSuperGroupElementExprList()) {
            if (!(item instanceof SuperGroupElementSublist)) continue;
            items.add(item);
            this.getSuperGroupExpressionList((SuperGroupElementSublist)item, items);
        }
    }

    public void refreshListBox() {
        Vector listItems = this.getGroupByContentList();
        LabelValuePair[] items = new LabelValuePair[listItems.size() + 1];
        items[0] = new LabelValuePair(Messages._UI_COMBOBOXITEM_GROUPING_ROOT, this.groupByClause);
        int i = 1;
        while (i < items.length) {
            Object item = listItems.elementAt(i - 1);
            String label = item instanceof SQLQueryObject ? ((SQLQueryObject)item).getSQL() : (item != null ? item.toString() : "");
            items[i] = new LabelValuePair(this.convertForDisplay(label, (EObject)item), item);
            ++i;
        }
        this.groupByContentHelper.setItems(items);
        if (this.groupByContentHelper.indexOf(this.currentListSelection) == -1) {
            this.currentListSelection = this.groupByClause;
        } else if (this.currentListSelection instanceof GroupingSpecification && this.groupByContentHelper.indexOf(this.currentListSelection) != 0) {
            this.typeCombo.setEnabled(true);
        }
        this.groupByContentHelper.select(this.currentListSelection);
    }

    public String convertForDisplay(String label, EObject item) {
        String newLabel = StringUtility.stripNewLines(label);
        if (item instanceof GroupingExpression) {
            return newLabel;
        }
        EObject parent = item;
        while (!(parent instanceof QuerySelect) && parent != null) {
            if (!(parent instanceof GroupingSetsElementExpression)) {
                newLabel = "    " + newLabel;
            }
            parent = parent.eContainer();
        }
        return newLabel;
    }

    public void refresh() {
        if (this.getInput() != null) {
            this.refreshListBox();
            this.updateTypeCombo();
            this.expressionGrid.setInput(this.currentListSelection);
            this.setInput(this.getInput());
        }
    }

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }

    public Control createControl(Composite parent) {
        SashForm sashForm = new SashForm(parent, 256);
        this.canvas = sashForm;
        this.groupByContentList = ViewUtility.createListBox(this.canvas, 10, false);
        WorkbenchHelp.setHelp((Control)this.groupByContentList, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqds0050");
        this.groupByContentList.setData("layout ratio", (Object)new Long(19661L));
        this.groupByContentHelper = new ObjectListHelper(this.groupByContentList);
        this.groupByContentList.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                Object selectedObject = GroupByContentViewer.this.groupByContentHelper.getSelectedObject();
                GroupByContentViewer.this.expressionGrid.setInput(selectedObject);
                GroupByContentViewer.this.currentListSelection = selectedObject;
                if (selectedObject instanceof Grouping || selectedObject instanceof GroupingSets) {
                    GroupByContentViewer.this.typeCombo.setEnabled(true);
                    GroupByContentViewer.this.updateTypeCombo();
                } else {
                    GroupByContentViewer.this.typeCombo.setEnabled(false);
                }
            }
        });
        Composite typeGroup = ViewUtility.createComposite(this.canvas, 2, true);
        WorkbenchHelp.setHelp((Control)typeGroup, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqds0050");
        typeGroup.setData("layout ratio", (Object)new Long(45876L));
        Label label = new Label(typeGroup, 0);
        label.setText(Messages._UI_LABEL_GROUPS_TYPE);
        this.typeCombo = new Combo(typeGroup, 8);
        WorkbenchHelp.setHelp((Control)this.typeCombo, (String)"org.eclipse.datatools.sqltools.sqlbuilder.sqds0050");
        this.typeCombo.add(P_NONE);
        this.typeCombo.add(P_ROLLUP);
        this.typeCombo.add(P_CUBE);
        this.typeCombo.add(P_GROUPINGSETS);
        this.typeCombo.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                int index;
                if (GroupByContentViewer.this.getInput() != null && (index = GroupByContentViewer.this.typeCombo.getSelectionIndex()) != -1) {
                    String type = GroupByContentViewer.this.typeCombo.getItem(index);
                    GroupByContentViewer.this.replaceType(type);
                }
            }
        });
        this.expressionGrid = new GroupExpressionListGridViewer(this.sqlDomainModel, typeGroup);
        GridData gridData = ViewUtility.createFill();
        gridData.horizontalSpan = 2;
        this.expressionGrid.getTable().setLayoutData((Object)gridData);
        this.hookControl(this.getControl());
        return this.getControl();
    }

    public void updateTypeCombo() {
        this.currentType = P_NONE;
        if (this.currentListSelection != null) {
            this.currentType = this.currentListSelection instanceof SuperGroup ? (((SuperGroup)this.currentListSelection).getSuperGroupType().getValue() == 2 ? P_ROLLUP : P_CUBE) : (this.currentListSelection instanceof GroupingSets ? P_GROUPINGSETS : P_SIMPLE);
            this.typeCombo.setEnabled(this.currentListSelection != this.groupByClause);
        }
        this.typeCombo.select(this.typeCombo.indexOf(this.currentType));
    }

    public void replaceType(String type) {
        if (!this.currentType.equals(type)) {
            if (this.currentListSelection instanceof GroupingSets) {
                SuperGroup supGrp;
                int currIdx = this.groupByClause.indexOf(this.currentListSelection);
                this.groupByClause.remove(this.currentListSelection);
                if (type.equals(P_CUBE)) {
                    supGrp = SelectHelper.createSuperGroup(0);
                    if (currIdx > -1) {
                        this.groupByClause.add(currIdx, supGrp);
                    } else {
                        this.groupByClause.add(supGrp);
                    }
                }
                if (type.equals(P_ROLLUP)) {
                    supGrp = SelectHelper.createSuperGroup(2);
                    if (currIdx > -1) {
                        this.groupByClause.add(currIdx, supGrp);
                    } else {
                        this.groupByClause.add(supGrp);
                    }
                }
            } else if (this.currentListSelection instanceof SuperGroup) {
                int currIdx;
                if (type.equals(P_CUBE)) {
                    ((SuperGroup)this.currentListSelection).setSuperGroupType(SuperGroupType.get((int)0));
                } else if (type.equals(P_ROLLUP)) {
                    ((SuperGroup)this.currentListSelection).setSuperGroupType(SuperGroupType.get((int)2));
                } else if (type.equals(P_GROUPINGSETS) && (currIdx = this.groupByClause.indexOf(this.currentListSelection)) > -1) {
                    this.groupByClause.remove(this.currentListSelection);
                    GroupingSets grpSets = SelectHelper.createGroupingSets();
                    this.groupByClause.add(currIdx, grpSets);
                }
            }
            this.refresh();
        }
    }

    public QueryValueExpression showExpressionBuilder(Object obj, boolean isColumn, String action) {
        ExpressionBuilderWizard wizard = new ExpressionBuilderWizard(this.sqlDomainModel, (SQLQueryObject)this.sqlDomainModel.getSQLStatement());
        if (obj instanceof QueryValueExpression && action.equals(SQLBuilderConstants.P_EDIT_EXPRESSION)) {
            if (obj != null) {
                wizard.setInputExpression((QueryValueExpression)obj);
            } else {
                wizard.setInputExpression(null);
            }
        }
        wizard.setIsColumn(isColumn);
        ExpressionBuilderDialog dialog = new ExpressionBuilderDialog(Display.getDefault().getActiveShell(), wizard);
        dialog.create();
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            return wizard.getSQLExpression();
        }
        if (obj != null) {
            return (QueryValueExpression)obj;
        }
        return null;
    }

    public void setEnabled(boolean enable) {
        this.expressionGrid.setEnabled(enable);
        this.groupByContentList.setEnabled(enable);
        if (enable) {
            this.groupByContentList.setBackground(Display.getCurrent().getSystemColor(1));
        } else {
            this.groupByContentList.setBackground(this.canvas.getBackground());
        }
    }

    public class GroupByContentHolder
    extends Holder {
        public GroupByContentHolder(List grpSpecificationList, Object grpSpecification) {
            super(grpSpecificationList, grpSpecification);
        }

        public List getGroupByClause() {
            return (List)this.parent;
        }

        public GroupingSpecification getGroupByContent() {
            if (this.child != null) {
                return (GroupingSpecification)this.child;
            }
            return null;
        }

        @Override
        public QueryValueExpression getExpression() {
            if (this.child != null && this.child instanceof GroupingExpression) {
                return ((GroupingExpression)this.child).getValueExpr();
            }
            return null;
        }

        @Override
        public void setExpression(QueryValueExpression newExpression) {
            GroupingSpecification previousExpression = this.getGroupByContent();
            List groupByList = this.getGroupByClause();
            Object valExpr = null;
            valExpr = newExpression != null && newExpression instanceof ValueExpressionColumn ? ExpressionHelper.createValueExpressionColumn((ValueExpressionColumn)newExpression) : newExpression;
            if (previousExpression != null) {
                int previousIndex = groupByList.indexOf(previousExpression);
                if (previousIndex != -1) {
                    if (previousExpression instanceof GroupingExpression) {
                        GroupingExpression grpExpr = (GroupingExpression)previousExpression;
                        grpExpr.setValueExpr(valExpr);
                    } else {
                        groupByList.remove(previousIndex);
                        GroupingExpression grpExpr = SelectHelper.createGroupingExpression(valExpr);
                        groupByList.add(previousIndex, grpExpr);
                    }
                }
            } else {
                GroupingExpression grpExpr = SelectHelper.createGroupingExpression(valExpr);
                groupByList.add(grpExpr);
            }
        }

        public void createSuperGroup(String groupType) {
            int groupKind = groupType.equals(P_CUBE) ? 0 : 2;
            SuperGroup superGrp = SelectHelper.createSuperGroup(groupKind);
            List groupByList = this.getGroupByClause();
            groupByList.add(superGrp);
        }

        public void createGroupingSet() {
            GroupingSets grpSets = SelectHelper.createGroupingSets();
            List groupByList = this.getGroupByClause();
            groupByList.add(grpSets);
        }

        @Override
        public void empty() {
            int index = this.getGroupByClause().indexOf(this.child);
            if (index != -1) {
                this.getGroupByClause().remove(index);
            }
        }

        @Override
        public void create(String objectType) {
            if (objectType.equals(P_CUBE) || objectType.equals(P_ROLLUP)) {
                this.createSuperGroup(objectType);
            } else if (objectType.equals(P_GROUPINGSETS)) {
                this.createGroupingSet();
            }
        }
    }

    public class GroupByExpressionContentProvider
    extends GridContentProvider {
        public GroupByExpressionContentProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
        }

        public Object[] getElements(Object object) {
            this.adapterFactory.adapt(object, IStructuredItemContentProvider.class);
            if (GroupByContentViewer.this.groupByClause.size() > 0) {
                if (object instanceof SuperGroup) {
                    this.tableElements = new Vector();
                    SuperGroup superGroup = (SuperGroup)object;
                    Iterator iterator = superGroup.getSuperGroupElementList().iterator();
                    while (iterator.hasNext()) {
                        this.tableElements.add(new SuperGroupExpressionHolder(superGroup, iterator.next()));
                    }
                    this.tableElements.add(new SuperGroupExpressionHolder(superGroup, (Object)null));
                    return this.tableElements.toArray();
                }
                if (object instanceof GroupingSets) {
                    this.tableElements = new Vector();
                    GroupingSets groupingSet = (GroupingSets)object;
                    Iterator iterator = groupingSet.getGroupingSetsElementList().iterator();
                    while (iterator.hasNext()) {
                        this.tableElements.add(new GroupingSetContentHolder(groupingSet, iterator.next()));
                    }
                    this.tableElements.add(new GroupingSetContentHolder(groupingSet, (Object)null));
                    return this.tableElements.toArray();
                }
                if (object instanceof GroupingSetsElementSublist) {
                    this.tableElements = new Vector();
                    GroupingSetsElementSublist grpSetElSublist = (GroupingSetsElementSublist)object;
                    Iterator iterator = grpSetElSublist.getGroupingSetsElementExprList().iterator();
                    while (iterator.hasNext()) {
                        this.tableElements.add(new GroupingSetGroupContentHolder(grpSetElSublist, iterator.next()));
                    }
                    this.tableElements.add(new GroupingSetGroupContentHolder(grpSetElSublist, (Object)null));
                    return this.tableElements.toArray();
                }
                if (object instanceof SuperGroupElementSublist) {
                    this.tableElements = new Vector();
                    SuperGroupElementSublist superGrpElSublist = (SuperGroupElementSublist)object;
                    Iterator iterator = superGrpElSublist.getSuperGroupElementExprList().iterator();
                    while (iterator.hasNext()) {
                        this.tableElements.add(new SuperGroupExpressionSublistHolder(superGrpElSublist, iterator.next()));
                    }
                    this.tableElements.add(new SuperGroupExpressionSublistHolder(superGrpElSublist, (Object)null));
                    return this.tableElements.toArray();
                }
                if (!(object instanceof GroupingExpression)) {
                    this.tableElements.clear();
                    List expressionList = (List)object;
                    Iterator iterator = expressionList.iterator();
                    while (iterator.hasNext()) {
                        this.tableElements.add(new GroupByContentHolder(expressionList, iterator.next()));
                    }
                    this.tableElements.add(new GroupByContentHolder(expressionList, null));
                    return this.tableElements.toArray();
                }
            } else {
                this.tableElements.clear();
                this.tableElements.add(new GroupByContentHolder(GroupByContentViewer.this.groupByClause, null));
                return this.tableElements.toArray();
            }
            return null;
        }
    }

    class GroupByExpressionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        GroupByExpressionLabelProvider() {
        }

        public String getColumnText(Object object, int columnIndex) {
            if (columnIndex == 0) {
                return StringUtility.stripNewLines(object.toString());
            }
            return "";
        }

        public Image getColumnImage(Object object, int column) {
            return null;
        }
    }

    public class GroupByExpressionModifier
    implements ICellModifier {
        Object currentData;
        Object currentProperty;
        Object currentValue;

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            return element;
        }

        public void modify(Object element, String property, Object value) {
            Object data = ((TableItem)element).getData();
            if (value == null) {
                return;
            }
            this.currentData = data;
            this.currentProperty = property;
            this.currentValue = value;
            Display.getCurrent().asyncExec(new Runnable(){

                @Override
                public void run() {
                    QueryValueExpression previousExpression = ((Holder)GroupByExpressionModifier.this.currentData).getExpression();
                    String selectionString = "";
                    QueryValueExpression newExpression = null;
                    if (GroupByExpressionModifier.this.currentValue instanceof String) {
                        selectionString = (String)GroupByExpressionModifier.this.currentValue;
                        if (selectionString.equals(SQLBuilderConstants.P_BUILD_EXPRESSION)) {
                            newExpression = GroupByContentViewer.this.showExpressionBuilder(previousExpression, false, SQLBuilderConstants.P_BUILD_EXPRESSION);
                            if (newExpression == null) {
                                return;
                            }
                        } else if (selectionString.equals(SQLBuilderConstants.P_REPLACE_EXPRESSION)) {
                            newExpression = GroupByContentViewer.this.showExpressionBuilder(previousExpression, false, SQLBuilderConstants.P_REPLACE_EXPRESSION);
                            if (newExpression == null) {
                                return;
                            }
                        } else if (selectionString.equals(SQLBuilderConstants.P_EDIT_EXPRESSION)) {
                            newExpression = GroupByContentViewer.this.showExpressionBuilder(previousExpression, false, SQLBuilderConstants.P_EDIT_EXPRESSION);
                            if (newExpression == null) {
                                return;
                            }
                        } else if (selectionString.equals(P_CUBE) || selectionString.equals(P_ROLLUP) || selectionString.equals(P_GROUPING)) {
                            ((Holder)GroupByExpressionModifier.this.currentData).create(selectionString);
                        } else if (selectionString.equals(P_GROUPINGSETS) && GroupByExpressionModifier.this.currentData instanceof GroupByContentHolder) {
                            ((GroupByContentHolder)GroupByExpressionModifier.this.currentData).createGroupingSet();
                        }
                    } else if (GroupByExpressionModifier.this.currentValue instanceof QueryValueExpression) {
                        newExpression = ((QueryValueExpression)GroupByExpressionModifier.this.currentValue).toString().equals("") ? null : (QueryValueExpression)GroupByExpressionModifier.this.currentValue;
                    } else {
                        return;
                    }
                    GroupByExpressionModifier.this.updateValue(GroupByExpressionModifier.this.currentData, newExpression);
                    GroupByContentViewer.this.refreshListBox();
                    SelectHelper.refresh(((GroupByExpressionModifier)GroupByExpressionModifier.this).GroupByContentViewer.this.selectStatement);
                    GroupByContentViewer.this.setInput(((GroupByExpressionModifier)GroupByExpressionModifier.this).GroupByContentViewer.this.selectStatement);
                }
            });
        }

        protected void updateValue(Object data, QueryValueExpression newExpression) {
            if (newExpression == null) {
                ((Holder)data).empty();
            } else {
                ((Holder)data).setExpression(newExpression);
            }
        }
    }

    public class GroupExpressionListGridViewer
    extends GridViewer
    implements IMenuListener {
        GroupEditComboBoxCellEditor columnComboBoxCellEditor;

        public GroupExpressionListGridViewer(SQLDomainModel domainModel, Composite parent) {
            super(domainModel, parent);
            TableLayout layout = new TableLayout();
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, true));
            this.table.setLayout((Layout)layout);
            String[] columnProperties = new String[]{(String)SQLBuilderConstants.P_STATEMENT_COLUMN};
            this.setColumnProperties(columnProperties);
            this.columnComboBoxCellEditor = new GroupEditComboBoxCellEditor((Composite)this.table, null, this);
            CellEditor[] editors = new CellEditor[]{this.columnComboBoxCellEditor};
            this.setCellEditors(editors);
            this.setCellModifier(new GroupByExpressionModifier());
            this.setContentProvider((IContentProvider)new GroupByExpressionContentProvider(GroupByContentViewer.this.sqlDomainModel.getAdapterFactory()));
            this.setLabelProvider((IBaseLabelProvider)new GroupByExpressionLabelProvider());
        }

        public void menuAboutToShow(IMenuManager menu) {
            RemoveCurrentRowAction removeAction = new RemoveCurrentRowAction(this);
            menu.add((IAction)removeAction);
        }

        public void refreshCellEditor(int row) {
            boolean exprExists = this.expressionExists(row);
            this.updateMenuItems(super.getInput(), exprExists);
        }

        private boolean expressionExists(int row) {
            QueryValueExpression expr;
            Object obj = this.getElementAt(row);
            return obj instanceof Holder && (expr = ((Holder)obj).getExpression()) != null;
        }

        private void updateMenuItems(Object input, boolean exprExists) {
            if (input instanceof GroupingSets) {
                LabelValuePair[] extraItems = new LabelValuePair[]{new LabelValuePair(P_CUBE, P_CUBE), new LabelValuePair(P_ROLLUP, P_ROLLUP), new LabelValuePair(P_GROUPING, P_GROUPING)};
                this.addComboBoxItems(extraItems, exprExists);
            } else if (input instanceof GroupingSetsElementSublist) {
                LabelValuePair[] extraItems = new LabelValuePair[]{new LabelValuePair(P_CUBE, P_CUBE), new LabelValuePair(P_ROLLUP, P_ROLLUP)};
                this.addComboBoxItems(extraItems, exprExists);
            } else if (input instanceof SuperGroup) {
                LabelValuePair[] extraItems = new LabelValuePair[]{new LabelValuePair(P_GROUPING, P_GROUPING)};
                this.addComboBoxItems(extraItems, exprExists);
            } else if (input == GroupByContentViewer.this.groupByClause) {
                VendorHelper vendor = GroupByContentViewer.this.sqlDomainModel.getVendor();
                if (vendor.isDB2() && !vendor.isDB2UDBOS390_V6()) {
                    LabelValuePair[] extraItems = new LabelValuePair[]{new LabelValuePair(P_CUBE, P_CUBE), new LabelValuePair(P_ROLLUP, P_ROLLUP), new LabelValuePair(P_GROUPINGSETS, P_GROUPINGSETS)};
                    this.addComboBoxItems(extraItems, exprExists);
                } else if (vendor.isOracle()) {
                    LabelValuePair[] extraItems = new LabelValuePair[]{new LabelValuePair(P_CUBE, P_CUBE), new LabelValuePair(P_ROLLUP, P_ROLLUP)};
                    this.addComboBoxItems(extraItems, exprExists);
                } else {
                    LabelValuePair[] extraItems = new LabelValuePair[]{};
                    this.addComboBoxItems(extraItems, exprExists);
                }
            } else {
                LabelValuePair[] extraItems = new LabelValuePair[]{};
                this.addComboBoxItems(extraItems, exprExists);
            }
        }

        public void addComboBoxItems(LabelValuePair[] extraItems, boolean exprExists) {
            LabelValuePair[] items = (LabelValuePair[])BuilderUtility.getDistinctColumnItems(GroupByContentViewer.this.selectStatement, true, exprExists);
            LabelValuePair[] extendedItems = new LabelValuePair[items.length + extraItems.length];
            int i = 0;
            while (i < items.length - 1) {
                extendedItems[i] = items[i];
                ++i;
            }
            int j = 0;
            while (j < extraItems.length) {
                extendedItems[i++] = extraItems[j];
                ++j;
            }
            extendedItems[i] = items[items.length - 1];
            this.columnComboBoxCellEditor.createItems(extendedItems);
        }

        @Override
        public void refresh() {
            super.refresh();
            if (GroupByContentViewer.this.currentListSelection != null) {
                GroupByContentViewer.this.setGroupByClause();
            }
        }

        public void setEnabled(boolean enable) {
            this.table.setEnabled(enable);
        }

        class GroupEditComboBoxCellEditor
        extends EditComboBoxCellEditor {
            GroupExpressionListGridViewer tableViewer;

            public GroupEditComboBoxCellEditor(Composite parent, LabelValuePair[] items, GroupExpressionListGridViewer tv) {
                super(parent, items, false);
                this.tableViewer = null;
                this.tableViewer = tv;
            }

            @Override
            protected void doSetValue(Object value) {
                super.doSetValue(value);
            }

            @Override
            protected LabelValuePair createComboBoxItem(String newValue) {
                return new LabelValuePair(newValue, ExpressionHelper.createExpression(newValue));
            }

            @Override
            protected void refreshComboItems() {
                int row = this.tableViewer.getTable().getSelectionIndex();
                if (row >= 0) {
                    this.tableViewer.refreshCellEditor(row);
                }
            }
        }
    }

    public class GroupingSetContentHolder
    extends Holder {
        public GroupingSetContentHolder(GroupingSets grpSet, Object set) {
            super(grpSet, set);
        }

        public GroupingSets getGroupingSet() {
            return (GroupingSets)this.parent;
        }

        @Override
        public QueryValueExpression getExpression() {
            if (this.child != null && this.child instanceof GroupingSetsElementExpression && ((GroupingSetsElementExpression)this.child).getGrouping() instanceof GroupingExpression) {
                GroupingSetsElementExpression grpSetsExpr = (GroupingSetsElementExpression)this.child;
                return ((GroupingExpression)grpSetsExpr.getGrouping()).getValueExpr();
            }
            return null;
        }

        @Override
        public void setExpression(QueryValueExpression newExpression) {
            QueryValueExpression previousExpression = this.getExpression();
            GroupingSets grpSet = this.getGroupingSet();
            Object valExpr = newExpression instanceof ValueExpressionColumn ? ExpressionHelper.createValueExpressionColumn((ValueExpressionColumn)newExpression) : newExpression;
            if (previousExpression != null) {
                Object prevObject;
                int previousIndex = grpSet.getGroupingSetsElementList().indexOf(this.child);
                if (previousIndex != -1 && (prevObject = grpSet.getGroupingSetsElementList().get(previousIndex)) instanceof GroupingSetsElementExpression && ((GroupingSetsElementExpression)prevObject).getGrouping() instanceof GroupingExpression) {
                    GroupingSetsElementExpression grpSetsExpr = (GroupingSetsElementExpression)prevObject;
                    ((GroupingExpression)grpSetsExpr.getGrouping()).setValueExpr(valExpr);
                }
            } else {
                GroupingSetsElementExpression superGrpExpr = SelectHelper.createGroupingSetsElementExpression(valExpr);
                grpSet.getGroupingSetsElementList().add((Object)superGrpExpr);
            }
        }

        public void createSuperGroup(String groupType) {
            int groupKind = groupType.equals(P_CUBE) ? 0 : 2;
            SuperGroup superGrp = SelectHelper.createSuperGroup(groupKind);
            GroupingSetsElementExpression grpSetElementExpr = SelectHelper.createGroupingSetsElementExpression();
            grpSetElementExpr.setGrouping((Grouping)superGrp);
            GroupingSets grpSet = this.getGroupingSet();
            grpSet.getGroupingSetsElementList().add((Object)grpSetElementExpr);
        }

        public void createGrouping() {
            GroupingSetsElementSublist grpSetsElementSublist = SelectHelper.createGroupingSetsElementSublist();
            GroupingSets grpSet = this.getGroupingSet();
            grpSet.getGroupingSetsElementList().add((Object)grpSetsElementSublist);
        }

        @Override
        public void empty() {
            int index = this.getGroupingSet().getGroupingSetsElementList().indexOf(this.child);
            if (index != -1) {
                this.getGroupingSet().getGroupingSetsElementList().remove(index);
            }
        }

        @Override
        public void create(String objectType) {
            if (objectType.equals(P_CUBE) || objectType.equals(P_ROLLUP)) {
                this.createSuperGroup(objectType);
            } else if (objectType.equals(P_GROUPING)) {
                this.createGrouping();
            }
        }
    }

    public class GroupingSetGroupContentHolder
    extends Holder {
        public GroupingSetGroupContentHolder(GroupingSetsElementSublist grpSet, Object set) {
            super(grpSet, set);
        }

        public GroupingSetsElementSublist getGroupingSetGroup() {
            return (GroupingSetsElementSublist)this.parent;
        }

        public Grouping getGroupExpressionOrSuperGroup() {
            return null;
        }

        @Override
        public QueryValueExpression getExpression() {
            if (this.child != null && this.child instanceof GroupingSetsElementExpression && ((GroupingSetsElementExpression)this.child).getGrouping() instanceof GroupingExpression) {
                GroupingSetsElementExpression grpSetsExpr = (GroupingSetsElementExpression)this.child;
                return ((GroupingExpression)grpSetsExpr.getGrouping()).getValueExpr();
            }
            return null;
        }

        @Override
        public void setExpression(QueryValueExpression newExpression) {
            QueryValueExpression previousExpression = this.getExpression();
            GroupingSetsElementSublist grpSetSublist = this.getGroupingSetGroup();
            Object valExpr = newExpression instanceof ValueExpressionColumn ? ExpressionHelper.createValueExpressionColumn((ValueExpressionColumn)newExpression) : newExpression;
            if (previousExpression != null) {
                Object prevObject;
                int previousIndex = grpSetSublist.getGroupingSetsElementExprList().indexOf(this.child);
                if (previousIndex != -1 && (prevObject = grpSetSublist.getGroupingSetsElementExprList().get(previousIndex)) instanceof GroupingSetsElementExpression && ((GroupingSetsElementExpression)prevObject).getGrouping() instanceof GroupingExpression) {
                    GroupingSetsElementExpression grpSetsExpr = (GroupingSetsElementExpression)prevObject;
                    ((GroupingExpression)grpSetsExpr.getGrouping()).setValueExpr(valExpr);
                }
            } else {
                GroupingSetsElementExpression superGrpExpr = SelectHelper.createGroupingSetsElementExpression(valExpr);
                grpSetSublist.getGroupingSetsElementExprList().add((Object)superGrpExpr);
            }
        }

        public void createSuperGroup(String groupType) {
            int groupKind = groupType.equals(P_CUBE) ? 0 : 2;
            SuperGroup superGrp = SelectHelper.createSuperGroup(groupKind);
            GroupingSetsElementExpression grpSetElementExpr = SelectHelper.createGroupingSetsElementExpression();
            grpSetElementExpr.setGrouping((Grouping)superGrp);
            GroupingSetsElementSublist grpSetSublist = this.getGroupingSetGroup();
            grpSetSublist.getGroupingSetsElementExprList().add((Object)grpSetElementExpr);
        }

        @Override
        public void empty() {
            int index = this.getGroupingSetGroup().getGroupingSetsElementExprList().indexOf(this.child);
            if (index != -1) {
                this.getGroupingSetGroup().getGroupingSetsElementExprList().remove(index);
            }
        }

        @Override
        public void create(String objectType) {
            if (objectType.equals(P_CUBE) || objectType.equals(P_ROLLUP)) {
                this.createSuperGroup(objectType);
            }
        }
    }

    public abstract class Holder {
        Object parent;
        Object child;

        public Holder(Object parent, Object child) {
            this.parent = parent;
            this.child = child;
        }

        public String toString() {
            String label = "";
            if (this.child != null) {
                label = this.child instanceof SQLQueryObject ? ((SQLQueryObject)this.child).getSQL() : this.child.toString();
            }
            return label;
        }

        public abstract QueryValueExpression getExpression();

        public abstract void setExpression(QueryValueExpression var1);

        public abstract void empty();

        public abstract void create(String var1);
    }

    class RemoveCurrentRowAction
    extends Action {
        TableViewer gridViewer;

        public RemoveCurrentRowAction(TableViewer gridViewer) {
            super(Messages._UI_ACTION_REMOVE);
            this.gridViewer = gridViewer;
        }

        public void run() {
            ISelection selection = this.gridViewer.getSelection();
            if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection es = (IStructuredSelection)selection;
            Iterator elements = es.iterator();
            this.gridViewer.cancelEditing();
            while (elements.hasNext()) {
                Object item = elements.next();
                if (!(item instanceof Holder)) continue;
                ((Holder)item).empty();
            }
            SelectHelper.refresh(GroupByContentViewer.this.selectStatement);
            GroupByContentViewer.this.setInput(GroupByContentViewer.this.selectStatement);
        }
    }

    public class SuperGroupExpressionHolder
    extends Holder {
        public SuperGroupExpressionHolder(SuperGroup superGroup, Object expression) {
            super(superGroup, expression);
        }

        public SuperGroup getSuperGroup() {
            return (SuperGroup)this.parent;
        }

        @Override
        public QueryValueExpression getExpression() {
            if (this.child != null && this.child instanceof SuperGroupElementExpression) {
                SuperGroupElementExpression superGrpExpr = (SuperGroupElementExpression)this.child;
                return superGrpExpr.getGroupingExpr().getValueExpr();
            }
            return null;
        }

        @Override
        public void setExpression(QueryValueExpression newExpression) {
            QueryValueExpression previousExpression = this.getExpression();
            SuperGroup superGroup = this.getSuperGroup();
            Object valExpr = newExpression instanceof ValueExpressionColumn ? ExpressionHelper.createValueExpressionColumn((ValueExpressionColumn)newExpression) : newExpression;
            if (previousExpression != null) {
                Object prevObject;
                int previousIndex = superGroup.getSuperGroupElementList().indexOf(this.child);
                if (previousIndex != -1 && (prevObject = superGroup.getSuperGroupElementList().get(previousIndex)) instanceof SuperGroupElementExpression) {
                    SuperGroupElementExpression superGrpExpr = (SuperGroupElementExpression)prevObject;
                    superGrpExpr.getGroupingExpr().setValueExpr(valExpr);
                }
            } else {
                SuperGroupElementExpression superGrpExpr = SelectHelper.createSuperGroupElementExpression(valExpr);
                superGroup.getSuperGroupElementList().add((Object)superGrpExpr);
            }
        }

        @Override
        public void empty() {
            if (this.child != null) {
                this.getSuperGroup().getSuperGroupElementList().remove(this.child);
            }
        }

        @Override
        public void create(String objectType) {
            if (objectType.equals(P_GROUPING)) {
                SuperGroup superGroup = this.getSuperGroup();
                SuperGroupElementSublist superGrpElementList = SelectHelper.createSuperGroupElementSublist();
                superGroup.getSuperGroupElementList().add((Object)superGrpElementList);
            }
        }
    }

    public class SuperGroupExpressionSublistHolder
    extends Holder {
        public SuperGroupExpressionSublistHolder(SuperGroupElementSublist superGroupElSublist, Object expression) {
            super(superGroupElSublist, expression);
        }

        public SuperGroupElementSublist getSuperGroupSublist() {
            return (SuperGroupElementSublist)this.parent;
        }

        @Override
        public QueryValueExpression getExpression() {
            if (this.child != null && this.child instanceof SuperGroupElementExpression) {
                SuperGroupElementExpression superGrpExpr = (SuperGroupElementExpression)this.child;
                return superGrpExpr.getGroupingExpr().getValueExpr();
            }
            return null;
        }

        @Override
        public void setExpression(QueryValueExpression newExpression) {
            QueryValueExpression previousExpression = this.getExpression();
            SuperGroupElementSublist superGroupSublist = this.getSuperGroupSublist();
            Object valExpr = newExpression instanceof ValueExpressionColumn ? ExpressionHelper.createValueExpressionColumn((ValueExpressionColumn)newExpression) : newExpression;
            if (previousExpression != null) {
                Object prevObject;
                int previousIndex = superGroupSublist.getSuperGroupElementExprList().indexOf(this.child);
                if (previousIndex != -1 && (prevObject = superGroupSublist.getSuperGroupElementExprList().get(previousIndex)) instanceof SuperGroupElementExpression) {
                    SuperGroupElementExpression superGrpExpr = (SuperGroupElementExpression)prevObject;
                    superGrpExpr.getGroupingExpr().setValueExpr(valExpr);
                }
            } else {
                SuperGroupElementExpression superGrpExpr = SelectHelper.createSuperGroupElementExpression(valExpr);
                superGroupSublist.getSuperGroupElementExprList().add((Object)superGrpExpr);
            }
        }

        @Override
        public void empty() {
            if (this.child != null) {
                this.getSuperGroupSublist().getSuperGroupElementExprList().remove(this.child);
            }
        }

        @Override
        public void create(String objectType) {
            if (objectType.equals(P_GROUPING)) {
                SuperGroupElementSublist superGroupSublist = this.getSuperGroupSublist();
                SuperGroupElementSublist superGrpElementList = SelectHelper.createSuperGroupElementSublist();
                superGroupSublist.getSuperGroupElementExprList().add((Object)superGrpElementList);
            }
        }
    }
}

