/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.mysql.catalog.loaders;

import com.ibm.icu.text.MessageFormat;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.datatools.connectivity.sqm.core.rte.ICatalogObject;
import org.eclipse.datatools.connectivity.sqm.loader.JDBCTableLoader;
import org.eclipse.datatools.connectivity.sqm.loader.Messages;
import org.eclipse.datatools.enablement.mysql.catalog.MySqlCatalogTable;
import org.eclipse.datatools.modelbase.sql.tables.Table;

public class MySqlTableLoader
extends JDBCTableLoader {
    private static final String TYPES_TABLE = "TYPES";
    private static final String MySQLTYPE_TABLE = "TYPE";
    private static final String ENGINE_TABLE = "ENGINE";
    private static final String[] POSSIBLE_TABLE_TYPE_COL_NAMES = new String[]{"TYPES", "TABLE", "ENGINE"};
    private static final String COL_TABLE_NAME = "Name";

    public MySqlTableLoader() {
        super(null, null);
        this.registerTableFactory(TYPES_TABLE, (JDBCTableLoader.ITableFactory)new MySqlTableFactory());
        this.registerTableFactory(MySQLTYPE_TABLE, (JDBCTableLoader.ITableFactory)new MySqlTableFactory());
        this.registerTableFactory(ENGINE_TABLE, (JDBCTableLoader.ITableFactory)new MySqlTableFactory());
    }

    public void loadTables(List containmentList, Collection existingTables) throws SQLException {
        ResultSet rs = null;
        try {
            this.initActiveFilter();
            rs = this.createResultSet();
            if (!this.mSupportedColumnsInitialized) {
                TreeSet<String> supportedColumns = new TreeSet<String>();
                ResultSetMetaData rsmd = rs.getMetaData();
                int colNum = 1;
                int colCount = rsmd.getColumnCount();
                while (colNum <= colCount) {
                    supportedColumns.add(rsmd.getColumnName(colNum));
                    ++colNum;
                }
                Iterator it = this.mTableFactories.values().iterator();
                while (it.hasNext()) {
                    ((JDBCTableLoader.ITableFactory)it.next()).setSupportedColumns(supportedColumns);
                }
            }
            while (rs.next()) {
                JDBCTableLoader.ITableFactory tableFactory;
                String tableName = rs.getString(COL_TABLE_NAME);
                if (tableName == null || this.isFiltered(tableName)) continue;
                ResultSetMetaData rmd = rs.getMetaData();
                String typeStr = null;
                int columnCount = rmd.getColumnCount();
                HashSet<String> possibleTableTypeColNames = new HashSet<String>(Arrays.asList(POSSIBLE_TABLE_TYPE_COL_NAMES));
                int x = 1;
                while (x <= columnCount) {
                    String colName = rmd.getColumnName(x).trim();
                    if (possibleTableTypeColNames.contains(colName)) {
                        typeStr = colName;
                        break;
                    }
                    ++x;
                }
                Table table = (Table)this.getAndRemoveSQLObject(existingTables, tableName);
                if (table == null) {
                    table = this.processRow(rs);
                    if (table == null) continue;
                    containmentList.add(table);
                    continue;
                }
                if (typeStr != null && (tableFactory = this.getTableFactory(rs.getString(typeStr))) != null) {
                    tableFactory.initialize(table, rs);
                }
                containmentList.add(table);
                if (!(table instanceof ICatalogObject)) continue;
                ((ICatalogObject)table).refresh();
            }
        }
        finally {
            if (rs != null) {
                this.closeResultSet(rs);
            }
        }
    }

    protected ResultSet createResultSet() throws SQLException {
        try {
            String catalogName = this.getCatalogObject().getConnection().getCatalog();
            if (catalogName == null || catalogName.trim().length() == 0) {
                this.getCatalogObject().getConnection().setCatalog(this.getSchema().getCatalog().getName());
            }
            String query = "SHOW TABLE STATUS FROM `" + this.getCatalogObject().getConnection().getCatalog() + "`";
            if (this.getJDBCFilterPattern() != null && this.getJDBCFilterPattern().trim().length() > 0) {
                query = String.valueOf(query) + " where TABLE NAME LIKE '" + this.getJDBCFilterPattern() + "'";
            }
            Statement s = this.getCatalogObject().getConnection().createStatement();
            ResultSet r = s.executeQuery(query);
            return r;
        }
        catch (RuntimeException e) {
            SQLException error = new SQLException(MessageFormat.format((String)Messages.Error_Unsupported_DatabaseMetaData_Method, (Object[])new Object[]{"java.sql.DatabaseMetaData.getTables()"}));
            error.initCause(e);
            throw error;
        }
    }

    protected Table processRow(ResultSet rs) throws SQLException {
        ResultSetMetaData rmd = rs.getMetaData();
        String typeStr = null;
        int columnCount = rmd.getColumnCount();
        HashSet<String> possibleTableTypeColNames = new HashSet<String>(Arrays.asList(POSSIBLE_TABLE_TYPE_COL_NAMES));
        int x = 1;
        while (x <= columnCount) {
            String colName = rmd.getColumnName(x).trim();
            if (possibleTableTypeColNames.contains(colName)) {
                typeStr = colName;
                break;
            }
            ++x;
        }
        MySqlCatalogTable table = new MySqlCatalogTable();
        table.setName(rs.getString(COL_TABLE_NAME));
        if (typeStr != null) {
            table.setTableType(rs.getString(typeStr));
        }
        table.setAutoInc(rs.getBoolean("Auto_increment"));
        return table;
    }

    public static class MySqlTableFactory
    extends JDBCTableLoader.TableFactory {
        protected Table newTable() {
            return new MySqlCatalogTable();
        }

        public void initialize(Table table, ResultSet rs) throws SQLException {
            super.initialize(table, rs);
            ((MySqlCatalogTable)table).setAutoInc(rs.getBoolean("Auto_increment"));
        }
    }
}

