/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.modelbase.sql.query.SQLQueryObject;
import org.eclipse.datatools.modelbase.sql.query.helper.StatementHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.ISQLEditPart;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.RootViewXYLayout;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.RootViewXYLayoutEditPolicy;
import org.eclipse.datatools.sqltools.sqlbuilder.views.graph.editparts.TableEditPart;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;

public class SQLRootEditPart
extends AbstractGraphicalEditPart
implements ISQLEditPart {
    protected SQLDomainModel domainModel;

    public SQLRootEditPart(SQLDomainModel domainModel) {
        this.domainModel = domainModel;
    }

    protected IFigure createFigure() {
        Figure f = new Figure();
        f.setLayoutManager((LayoutManager)new RootViewXYLayout());
        f.setBackgroundColor(ColorConstants.white);
        f.setOpaque(true);
        return f;
    }

    protected void createEditPolicies() {
        RootViewXYLayoutEditPolicy policy = new RootViewXYLayoutEditPolicy();
        policy.setHost((EditPart)this);
        this.installEditPolicy("layout", (EditPolicy)policy);
    }

    protected EditPart createChild(Object model) {
        TableEditPart editPart = new TableEditPart(this.domainModel);
        editPart.setModel(model);
        return editPart;
    }

    public List getModelChildren() {
        Object model = this.getModel();
        ArrayList tableList = null;
        if (model instanceof QueryStatement) {
            QueryStatement stmt = (QueryStatement)model;
            tableList = StatementHelper.getTablesForStatement((QueryStatement)stmt);
        } else if (model instanceof QuerySelect) {
            QuerySelect qSelect = (QuerySelect)model;
            tableList = StatementHelper.getTableExpressionsInQuerySelect((QuerySelect)qSelect);
        }
        if (tableList == null) {
            tableList = new ArrayList();
        }
        return tableList;
    }

    public void update(Object parent, Object child) {
        List modelChildren = this.getChildren();
        int i = 0;
        while (i < modelChildren.size()) {
            TableEditPart editPart = (TableEditPart)modelChildren.get(i);
            editPart.update(child);
            ++i;
        }
        if (parent == null || parent instanceof QueryStatement) {
            this.refresh();
        }
    }

    @Override
    public SQLQueryObject getStatement() {
        QuerySelect retStmt = null;
        Object obj = this.getModel();
        if (obj instanceof QuerySelect) {
            retStmt = (QuerySelect)obj;
        } else if (obj instanceof QueryStatement) {
            retStmt = (QueryStatement)obj;
        }
        return retStmt;
    }

    protected IFigure getLayer(Object layer) {
        return super.getLayer(layer);
    }

    protected EditPartViewer getEditPartViewer() {
        return this.getRoot().getViewer();
    }

    public String toString() {
        return "SQLRootEditPart";
    }
}

