/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.viewer.views.actions;

import org.eclipse.dirigible.ide.db.viewer.views.ISQLConsole;
import org.eclipse.dirigible.ide.db.viewer.views.TableDefinition;
import org.eclipse.dirigible.ide.db.viewer.views.TreeObject;
import org.eclipse.dirigible.ide.db.viewer.views.actions.Messages;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class ViewTableContentAction
extends Action {
    private static final String DATABASE_VIEW = Messages.ViewTableContentAction_DATABASE_VIEW;
    private static final String SELECT_FROM = "SELECT * FROM ";
    private static final String CANNOT_OPEN_SQL_VIEW = Messages.ViewTableContentAction_CANNOT_OPEN_SQL_VIEW;
    private static final String WILL_SHOW_TABLE_CONTENT = Messages.ViewTableContentAction_WILL_SHOW_TABLE_CONTENT;
    private static final String SHOW_CONTENT = Messages.ViewTableContentAction_SHOW_CONTENT;
    private static final long serialVersionUID = 5194043886090203855L;
    private TreeViewer viewer;
    private String consoleId;

    public ViewTableContentAction(TreeViewer viewer, String consoleId) {
        this.viewer = viewer;
        this.consoleId = consoleId;
        this.setText(SHOW_CONTENT);
        this.setToolTipText(WILL_SHOW_TABLE_CONTENT);
    }

    public void run() {
        try {
            TableDefinition tableDefinition;
            ISelection selection = this.viewer.getSelection();
            Object obj = ((IStructuredSelection)selection).getFirstElement();
            if (TreeObject.class.isInstance(obj) && (tableDefinition = ((TreeObject)obj).getTableDefinition()) != null) {
                ISQLConsole view = (ISQLConsole)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView(this.consoleId);
                this.executeSelectStatement(tableDefinition, view);
            }
        }
        catch (PartInitException partInitException) {
            this.showMessage(CANNOT_OPEN_SQL_VIEW);
        }
    }

    protected void executeSelectStatement(TableDefinition tableDefinition, ISQLConsole view) {
        String name = tableDefinition.getFqn();
        view.setQuery(SELECT_FROM + name);
        view.executeStatement(true);
    }

    protected void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.viewer.getControl().getShell(), (String)DATABASE_VIEW, (String)message);
    }
}

