/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.scripts.publish;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.publish.AbstractPublisher;
import org.eclipse.dirigible.ide.publish.IPublisher;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.repository.api.ICollection;

public class TestCasesPublisher
extends AbstractPublisher
implements IPublisher {
    public void publish(IProject project) throws PublishException {
        try {
            ICollection targetContainer = this.getTargetProjectContainer(this.getRegistryLocation());
            IFolder sourceFolder = this.getSourceFolder(project, "TestCases");
            this.copyAllFromTo((IContainer)sourceFolder, targetContainer);
        }
        catch (Exception ex) {
            throw new PublishException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void activate(IProject project) throws PublishException {
        try {
            ICollection targetContainer = this.getTargetProjectContainer(CommonParameters.getTestingContentSandbox());
            IFolder sourceFolder = this.getSourceFolder(project, "TestCases");
            this.copyAllFromTo((IContainer)sourceFolder, targetContainer);
        }
        catch (Exception ex) {
            throw new PublishException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected String getSandboxLocation() {
        return CommonParameters.getTestingContentSandbox();
    }

    public String getFolderType() {
        return "TestCases";
    }

    public boolean recognizedFile(IFile file) {
        return this.checkFolderType(file) && ".js".equals("." + file.getFileExtension());
    }

    public String getPublishedContainerMapping(IFile file) {
        return "/test";
    }

    public String getActivatedContainerMapping(IFile file) {
        return "/test-sandbox";
    }

    public boolean isAutoActivationAllowed() {
        return true;
    }

    protected String getRegistryLocation() {
        return "/db/dirigible/registry/public/TestCases";
    }
}

