/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.html.wizard;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.common.TemplateUtils;
import org.eclipse.dirigible.ide.template.ui.html.wizard.HtmlForEntityTemplateModel;

public class HtmlForEntityTemplateGenerator
extends TemplateGenerator {
    private static final String REST_SERVICE_ROOT_JS = "../../js";
    private static final String LOG_TAG = "HTML_FOR_ENTITY_GENERATOR";
    private HtmlForEntityTemplateModel model;

    public HtmlForEntityTemplateGenerator(HtmlForEntityTemplateModel model) {
        this.model = model;
    }

    protected Map<String, Object> prepareParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("pageTitle", this.model.getPageTitle());
        parameters.put("tableName", this.model.getTableName());
        parameters.put("tableColumns", this.model.getTableColumns());
        parameters.put("fileName", this.model.getFileName());
        parameters.put("serviceFileName", this.generateServiceFileName());
        parameters.put("createDataModel", this.createDataModel());
        parameters.put("entityName", this.getEntityName());
        return parameters;
    }

    protected String getEntityName() {
        return "data";
    }

    protected String createDataModel() {
        return "tableModel = new sap.ui.model.json.JSONModel();\n\t\ttableModel.loadData(\"" + this.generateServiceFileName() + "\");";
    }

    protected Object generateServiceFileName() {
        IFile source = this.model.getSourceFile();
        String entityPath = source.getFullPath().toString();
        String result = "";
        int index = entityPath.indexOf("ScriptingServices");
        result = index >= 0 ? entityPath.substring(index + "ScriptingServices".length()) : entityPath;
        result = result.replace(source.getFileExtension(), "");
        result = String.valueOf(result) + "js";
        return REST_SERVICE_ROOT_JS + result;
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected String getLogTag() {
        return LOG_TAG;
    }

    protected byte[] afterGeneration(byte[] bytes) {
        byte[] result = TemplateUtils.normalizeEscapes((byte[])bytes);
        return result;
    }
}

