/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common;

import com.google.gson.Gson;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.ide.template.ui.common.TemplateMetadata;
import org.eclipse.dirigible.ide.template.ui.common.TemplateSourceMetadata;
import org.eclipse.dirigible.ide.template.ui.common.TemplateUtils;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.graphics.Image;

public class TemplateType {
    private static final String DOT = ".";
    private String name;
    private String[] sourceNames;
    private String[] sourceLocations;
    private boolean[] sourceGenerates;
    private String[] sourceRenamings;
    private Image image;
    private Set<String> validParameters = new HashSet<String>();
    private static Gson gson = new Gson();
    private static final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public static TemplateType createTemplateType(String type, String location) throws IOException {
        IRepository repository = RepositoryFacade.getInstance().getRepository();
        ICollection templateRoot = repository.getCollection(location);
        if (!templateRoot.exists()) {
            throw new IOException(String.format("Template location: %s is not valid", location));
        }
        IResource templateMetadataResource = templateRoot.getResource("template.json");
        if (!templateMetadataResource.exists()) {
            throw new IOException(String.format("Template metadata does not exist at: %s", location));
        }
        TemplateMetadata templateMetadata = (TemplateMetadata)gson.fromJson(new String(templateMetadataResource.getContent()), TemplateMetadata.class);
        Image image = TemplateUtils.createImageFromResource(templateRoot, templateMetadata.getImage());
        TemplateSourceMetadata[] sources = templateMetadata.getSources();
        String[] names = new String[sources.length];
        String[] locations = new String[sources.length];
        boolean[] generates = new boolean[sources.length];
        String[] renamings = new String[sources.length];
        int i = 0;
        while (i < sources.length) {
            IResource contentResource = templateRoot.getResource(sources[i].getName());
            if (!contentResource.exists()) {
                throw new IOException(String.format("Template source does not exist at: %s", contentResource.getPath()));
            }
            names[i] = sources[i].getName();
            locations[i] = contentResource.getPath();
            generates[i] = sources[i].isGenerate();
            renamings[i] = sources[i].getRename();
            ++i;
        }
        TemplateType templateType = new TemplateType(templateMetadata.getName(), names, locations, generates, renamings, image);
        return templateType;
    }

    private TemplateType(String name, String[] names, String[] locations, boolean[] generates, String[] renamings, Image image) {
        this.name = name;
        this.sourceNames = names;
        this.sourceLocations = locations;
        this.sourceGenerates = generates;
        this.sourceRenamings = renamings;
        this.image = image;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String[] getSourceNames() {
        return this.sourceNames;
    }

    public String[] getSourceLocations() {
        return this.sourceLocations;
    }

    public boolean[] getSourceGenerates() {
        return this.sourceGenerates;
    }

    public String[] getSourceRenamings() {
        return this.sourceRenamings;
    }

    public String getExtension() {
        return this.getExtensionFor(0);
    }

    public String getExtensionFor(int i) {
        int dotIndex = this.sourceLocations[i].lastIndexOf(DOT);
        if (dotIndex != -1) {
            return this.sourceLocations[i].substring(dotIndex + 1);
        }
        return "";
    }

    public void setLocations(String[] locations) {
        this.sourceLocations = locations;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
    }

    private static Image createImage(URL imageURL) {
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)imageURL);
        return resourceManager.createImage(imageDescriptor);
    }

    public Set<String> getValidParameters() {
        return this.validParameters;
    }

    public String getLocation() {
        return this.sourceLocations[0];
    }
}

